/*
 Navicat Premium Data Transfer

 Source Server         : localhost_3306
 Source Server Type    : MySQL
 Source Server Version : 50736
 Source Host           : localhost:3306
 Source Schema         : ry-vue

 Target Server Type    : MySQL
 Target Server Version : 50736
 File Encoding         : 65001

 Date: 18/11/2022 17:26:53
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for fnc_company
-- ----------------------------
DROP TABLE IF EXISTS `fnc_company`;
CREATE TABLE `fnc_company`  (
  `company_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记账公司id',
  `company_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记账公司名称',
  `license_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业执照号',
  `company_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司地址',
  `contact_information` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系方式',
  `bank_deposit` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行',
  `bank_account_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行账户名称',
  `bank_account` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行账户',
  `create_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`company_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '记账公司表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of fnc_company
-- ----------------------------
INSERT INTO `fnc_company` VALUES (1, '上海让雷智能科技有限公司', '91310115MA1H77UR33', '上海市青浦区诸光路1588弄虹桥世界中心 L2B-503	', '021-61833518', '招商银行上海分行上海浦东大道支行', '上海让雷智能科技有限公司', '121919257910601', NULL, '2022-11-16 13:06:32', NULL, '2022-11-16 13:30:20');
INSERT INTO `fnc_company` VALUES (2, '上海缔荣纺织科技有限公司', '913101165665512158', '上海市嘉定区菊园新区环城路2222号1幢JT10046室', '021-61833518', '招商银行股份有限公司上海金桥支行', '上海缔荣纺织品有限公司', '121910934210603', NULL, '2022-11-16 13:07:25', NULL, NULL);

-- ----------------------------
-- Table structure for fnc_invoice
-- ----------------------------
DROP TABLE IF EXISTS `fnc_invoice`;
CREATE TABLE `fnc_invoice`  (
  `invoice_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '发票id',
  `company_id` bigint(20) NULL DEFAULT NULL COMMENT '公司id',
  `compant_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `invoice_type` int(4) NOT NULL COMMENT '发票类型（0:普通发票，1:增值税专用发票）',
  `invoice_nature` int(4) NOT NULL COMMENT '发票性质  (0:进项，1:出项）',
  `dep_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '部门名称',
  `invoice_date` date NULL DEFAULT NULL COMMENT '发票日期',
  `buy_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方名称',
  `buy_taxpayer_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方纳税人识别号',
  `buy_address` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方地址',
  `buy_phone` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方电话',
  `buy_bank_deposit` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方开户行',
  `buy_bank_account` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '购买方银行账号',
  `applicant` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请人',
  `checker` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人',
  `project_or_invoice_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目编号/发票号码',
  `amount_sum` decimal(21, 6) NULL DEFAULT NULL COMMENT '合计金额',
  `tax_sum` decimal(21, 6) NULL DEFAULT NULL COMMENT '合计税额',
  `amount_tax_capital` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '价税合计（大写）',
  `amount_tax_lower` decimal(21, 6) NULL DEFAULT NULL COMMENT '价税合计（小写）',
  `sale_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方名称',
  `sale_taxpayer_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方纳税人识别号',
  `sale_address` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方地址',
  `sale_phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方电话',
  `sale_bank_deposit` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方开户行',
  `sale_bank_account` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售方银行账号',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `payee` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收款人',
  `reviewer` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '复核人',
  `drawer` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票人',
  `create_by` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`invoice_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发票' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of fnc_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for fnc_invoice_item
-- ----------------------------
DROP TABLE IF EXISTS `fnc_invoice_item`;
CREATE TABLE `fnc_invoice_item`  (
  `invoice_item_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '发票项id',
  `invoice_id` bigint(20) NOT NULL COMMENT '发票id',
  `object_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货物或应税劳务、服务名称',
  `specs` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格型号',
  `unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `quantity` decimal(21, 6) NULL DEFAULT NULL COMMENT '数量',
  `unit_price_tax` decimal(21, 6) NULL DEFAULT NULL COMMENT '单价(含税)',
  `amount_no_tax` decimal(21, 6) NULL DEFAULT NULL COMMENT '金额(不含税)',
  `tax_rate` decimal(5, 3) NULL DEFAULT NULL COMMENT '税率',
  `tax_amount` decimal(21, 6) NULL DEFAULT NULL COMMENT '税额',
  `create_by` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`invoice_item_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发票项' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of fnc_invoice_item
-- ----------------------------

-- ----------------------------
-- Table structure for fnc_ledger
-- ----------------------------
DROP TABLE IF EXISTS `fnc_ledger`;
CREATE TABLE `fnc_ledger`  (
  `ledger_id` bigint(50) NOT NULL AUTO_INCREMENT COMMENT '项目台账id',
  `project_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类',
  `date` date NULL DEFAULT NULL COMMENT '日期',
  `project_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目中/英文名称',
  `charge` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目负责人',
  `charge_phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '负责人电话',
  `inquiry_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '询单编号',
  `customer_manager` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户经理',
  `customer_company` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户单位',
  `business_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务性质',
  `sale_evaluation` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售额评估',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`ledger_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16760 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '项目台账' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of fnc_ledger
-- ----------------------------
INSERT INTO `fnc_ledger` VALUES (14477, '全系列', '2021-12-29', '金旭环保水刺全自动棉柔巾智能工厂项目', '余敏', '13902957449', '20211229', '李小龙', '金旭环保制品（深圳）有限公司', '内贸', '240万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14478, '全系列', '2022-03-18', '华成纺织水刺智能工厂项目', '杨金明', '18069820155', '20220318', '李小龙', '海宁市华成纺织有限公司', '内贸', '300万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14479, '全系列', '2022-03-21', '福建龙美水刺智能工厂项目', '刘森美', '13799098200', '20220321', '李小龙', '福建龙美医疗器械有限公司', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14480, '全系列', '2022-03-25', '同高纺织化纤（深圳）有限公司智能工厂项目', '余敏', '13902957449', '20220325', '李小龙', '同高纺织化纤（深圳）有限公司', '内贸', '160万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14481, '纤维', '2022-02-27', '半消光短纤', '张海明', '15857192851 ', '20220227', '张怡静', '湖州嘉丝新材料科技有限公司', '内贸', '2', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14482, '纤维', '2022-05-12', '富威尔 低熔点 2D*51mm     FWE-LM FIBER  2D*51mm,white', ' Harrison', '-', '20220512', '张怡静', 'Clo Insulation', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14483, '纤维', '2022-06-18', '不定岛纤维', '崔跃辉', '13937332511', '20220618', '张怡静', '河南科润康非织造布有限公司', '内贸', '2', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14484, '纤维', '2022-06-29', '短纤维', '佘世豪', '18251378806', '20220629', '张怡静', '南通荣荟新材料科技有限公司', '内贸', '2', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14485, '纤维', '2022-03-31', 'PE/PET 无锑纤维PE/PET SB FREE FIBER  ', '郑静/李时泳', '82-51-796-367 ', '20220331', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14486, '纤维', '2022-03-31', 'PE/PET 无锑纤维PE/PET SB FREE FIBER  ', '李时咏', '82-51-796-367 ', '20220331', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14487, '纤维', '2022-04-27', '再生涤纶短纤，2D*51mm,本白；Recycled Pet Fiber，2D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14488, '纤维', '2022-04-27', '再生涤纶短纤，3D*51mm,本白；Recycled Pet Fiber，3D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14489, '纤维', '2022-04-27', '再生涤纶短纤，4D*51mm,本白；Recycled Pet Fiber，4D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14490, '纤维', '2022-04-27', '再生涤纶短纤，6D*51mm,本白；Recycled Pet Fiber，6D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14491, '纤维', '2022-04-27', '再生涤纶短纤，2D*51mm,本白；Recycled Pet Fiber，2D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14492, '纤维', '2022-04-27', '再生涤纶短纤，3D*51mm,本白；Recycled Pet Fiber，3D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14493, '纤维', '2022-04-27', '再生涤纶短纤，4D*51mm,本白；Recycled Pet Fiber，4D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14494, '纤维', '2022-04-27', '再生涤纶短纤，6D*51mm,本白；Recycled Pet Fiber，6D*51mm，white', '郑静/成一', '82-70-4667-3351', '20220427', '张怡静', 'DKNB CO.,LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14495, '纤维', '2022-04-27', '再生涤纶短纤，2D*51mm,本白；Recycled Pet Fiber，2D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14496, '纤维', '2022-04-27', '再生涤纶短纤，3D*51mm,本白；Recycled Pet Fiber，3D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14497, '纤维', '2022-04-27', '再生涤纶短纤，4D*51mm,本白；Recycled Pet Fiber，4D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14498, '纤维', '2022-04-27', '再生涤纶短纤，6D*51mm,本白；Recycled Pet Fiber，6D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14499, '纤维', '2022-04-27', '再生涤纶短纤，2D*51mm,本白；Recycled Pet Fiber，2D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14500, '纤维', '2022-04-27', '再生涤纶短纤，3D*51mm,本白；Recycled Pet Fiber，3D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14501, '纤维', '2022-04-27', '再生涤纶短纤，4D*51mm,本白；Recycled Pet Fiber，4D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14502, '纤维', '2022-04-27', '再生涤纶短纤，6D*51mm,本白；Recycled Pet Fiber，6D*51mm，white', '成一', '82-70-4667-3351', '20220427', '郑静', 'DKNB CO.,LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14503, '全系列', '2022-05-12', '山东昌诺科技新材料有限公司水刺智能工厂', '唐富勋', '18353996163', '20220512', '李小龙', '山东昌诺科技新材料有限公司', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14504, '纤维', '2022-05-12', '富威尔 低熔点 4D*51mm     FWE-LM FIBER  4D*51mm,white', ' Harrison', '无', '20220512', '郑静', 'Clo InsulatioK5:V18n', '出口', '5000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14505, '纤维', '2022-05-31', '富威尔 低熔点 2D*51mm     FWE-LM FIBER  2D*51mm,white', '李时咏', '82-51-796-367 ', '20220531', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14506, '无纺布', '2022-06-07', '无胶棉', '乐克才', '051088267932 ', '20220607', '顾怡青', '无锡市布凡纺织品有限公司', '内贸', '10', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14507, '无纺设备', '2022-06-10', '开松机 Pins Chopper 3 Phase, 480V/60hz, 1 Phase\n110V/60hz', 'Rino Baldecchi', '973-89-03873', '20220610', '郑静', 'Precision Textiles LLC', '出口', '8400', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14508, '无纺设备', '2022-06-10', '卧室车床 Lathe Machine, Type CA6161-2000', 'Rino Baldecchi', '973-89-03873', '20220610', '郑静', 'Precision Textiles LLC', '出口', '14500', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14509, '无纺', '2022-06-13', 'LG-圆形拖地布15cm LG-circular Wet wipes 15cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', '韩国LG客户', '出口', '12400', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14510, '无纺', '2022-06-13', '1.LG-圆形拖地布15cm LG-circular Wet wipes 15cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', 'TS Global.co.,Ltd  ', '出口', '12400', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14511, '无纺布', '2022-06-15', '黑色水刺布', '汪建荣', '057786905879 ', '20220615', '顾怡青', '浙江乾丰汽车零部件有限公司', '内贸', '26.5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14512, '纤维', '2022-06-30', '   ES纤维(PE/PP)', '李时泳', '82-51-796-367 ', '20220630', '郑静', 'SBSAMBO VINA CO., LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14513, '纤维', '2022-07-01', ' ES短纤,普白单亲（SDDH），2D*38mm     ES Fiber ,WHITE, 2D*38mm ', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14514, '纤维', '2022-07-01', '  ES短纤， 普白单亲 （SDDH）6D*51mm              ES Fiber ,WHITE,6D*51mm', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14515, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14516, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH） 5D*40mm   ES Fiber ,WHITE, 5D*40mm', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14517, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH）6D*40mm               ES Fiber ,WHITE,6D*40mm', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14518, '纤维', '2022-07-01', ' ES短纤,普白单亲（SDDH），2D*38mm     ES Fiber ,WHITE, 2D*38mm ', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14519, '纤维', '2022-07-01', '  ES短纤， 普白单亲 （SDDH）6D*51mm              ES Fiber ,WHITE,6D*51mm', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14520, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14521, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH） 5D*40mm   ES Fiber ,WHITE, 5D*40mm', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14522, '纤维', '2022-07-01', '  ES短纤，普白单亲（SDDH）6D*40mm               ES Fiber ,WHITE,6D*40mm', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14523, '纤维', '2022-07-01', '黑色涤纶10D*38mm Black polyester fibre10D*38mm', 'wonder吴', '15-88215783', '20220701', '郑静', 'FOCUS', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14524, '纤维', '2022-07-04', '富威尔 低熔点 4D*51mm     FWE-LM FIBER  4D*51mm,white', '李时咏', '82-51-796-367 ', '20220704', '郑静', '韩国SAMBO', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14525, '纤维', '2022-07-04', '富威尔 低熔点 4D*51mm     FWE-LM FIBER  4D*51mm,white', '李时泳', '82-51-796-367 ', '20220704', '郑静', 'SBSAMBO VINA CO., LTD.', '出口', '11000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14526, '无纺', '2022-07-05', '无纺布Non-woven fabric ', 'Chris Routhan', '无', '20220705', '郑静', '澳大利亚', '出口', '0', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14527, '无纺', '2022-07-06', 'LG-方形拖地布21cm LG-square Wet wipes 21cm', '朴新彦', '82-2-2-93-6616', '20220706', '郑静', '韩国LG客户', '出口', '12400', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14528, '纤维', '2022-07-14', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14529, '纤维', '2022-07-14', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14530, '纤维', '2022-07-15', '  ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14531, '纤维', '2022-07-15', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14532, '纤维', '2022-07-15', '  ES短纤(PE/PP)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14533, '纤维', '2022-07-15', '  ES短纤(PP/PET)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14534, '纤维', '2022-07-15', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14535, '纤维', '2022-07-15', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (CXFY)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14536, '纤维', '2022-07-15', 'ES短纤（PP/PE)， 普白单亲 （SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14537, '纤维', '2022-07-15', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14538, '纤维', '2022-07-15', 'ES短纤,普白单亲，（SDDH）拒水 2D*40mm                ES Fiber ,WHITE, ,Hydrophobic 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14539, '纤维', '2022-07-15', 'ES短纤（PP/PE)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14540, '纤维', '2022-07-15', 'ES短纤（PP/PET)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14541, '纤维', '2022-07-15', '富威尔 低熔点涤纶（PET/COPET） 4D*51mm    LM FIBER  4D*51mm,white (FEW)', '郑静/李时泳', '82-51-796-367 ', '20220701', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14542, '纤维', '2022-07-15', '  ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14543, '纤维', '2022-07-15', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14544, '纤维', '2022-07-15', '  ES短纤(PE/PP)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14545, '纤维', '2022-07-15', '  ES短纤(PP/PET)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14546, '纤维', '2022-07-15', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14547, '纤维', '2022-07-15', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (CXFY)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14548, '纤维', '2022-07-15', 'ES短纤（PP/PE)， 普白单亲 （SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14549, '纤维', '2022-07-15', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14550, '纤维', '2022-07-15', 'ES短纤,普白单亲，（SDDH）拒水 2D*40mm                ES Fiber ,WHITE, ,Hydrophobic 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14551, '纤维', '2022-07-15', 'ES短纤（PP/PE)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14552, '纤维', '2022-07-15', 'ES短纤（PP/PET)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14553, '纤维', '2022-07-15', '富威尔 低熔点涤纶（PET/COPET） 4D*51mm    LM FIBER  4D*51mm,white (FEW)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14554, '全系列', '2022-07-25', '南通通州江华纺织有限公司智能工厂项目', '胡小龙', '13809085270', '20220725', '李小龙', '南通通州江华纺织有限公司', '内贸', '500万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14555, '无纺布', '2022-07-27', '水刺无纺布膏药', '程本华', '13805518155', '20220727', '顾怡青', '合肥华润非织造布制品厂', '内贸', '14.1', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14556, '无纺布制品', '2022-07-28', '鞋垫', '曹玲玲', '13712035519', '20220728', '顾怡青', '广东春夏新材料科技股份有限公司', '内贸', '5.1', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14557, '无纺布制品', '2022-07-28', '拖地布', '曹玲玲', '13712035519', '20220728', '顾怡青', '广东春夏新材料科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14558, '会员入驻', '2022-08-01', '无纺黄金会员', '陈朋军', '18905381679', '20220801', '郁新涛', '肥城市高新技术产业开发区', '服务', '0.3万元', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14559, '会员入驻', '2022-08-01', '化纤臻享会员', '杨利正', '13806641208', '20220801', '郁新涛', '慈溪市崇寿镇工业园区', '服务', '1.67万元', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14560, '会员入驻', '2022-08-01', '无纺黄金会员', '李栋', '13562528775', '20220801', '郁新涛', '山东省聊城市高新技术开发区上海路99号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14561, '广告', '2022-08-01', '首页主轮播广告', '宋卫民', '0512-58490086', '20220801', '郁新涛', '张家港市凤凰镇凤凰科技创业园D栋3楼', '服务', '0.6万元', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14562, '纤维', '2022-08-02', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14563, '纤维', '2022-08-02', '  ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14564, '纤维', '2022-08-02', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14565, '纤维', '2022-08-02', '  ES短纤(PE/PP)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14566, '纤维', '2022-08-02', '  ES短纤(PP/PET)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14567, '纤维', '2022-08-02', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14568, '纤维', '2022-08-02', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (CXFY)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14569, '纤维', '2022-08-02', 'ES短纤（PP/PE)， 普白单亲 （SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14570, '纤维', '2022-08-02', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14571, '纤维', '2022-08-02', 'ES短纤,普白单亲，（SDDH）拒水 2D*40mm                ES Fiber ,WHITE, ,Hydrophobic 2D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14572, '纤维', '2022-08-02', 'ES短纤（PP/PE)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14573, '纤维', '2022-08-02', 'ES短纤（PP/PET)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14574, '纤维', '2022-08-02', '富威尔 低熔点涤纶（PET/COPET） 4D*51mm    LM FIBER  4D*51mm,white (FEW)', '郑静/李时泳', '82-51-796-367 ', '20220802', '张怡静', '韩国SAMBO', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14575, '纤维', '2022-08-02', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14576, '纤维', '2022-08-02', '  ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14577, '纤维', '2022-08-02', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14578, '纤维', '2022-08-02', '  ES短纤(PE/PP)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14579, '纤维', '2022-08-02', '  ES短纤(PP/PET)，普白单亲（SDDH）6D*38mm                ES Fiber ,WHITE, 6D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14580, '纤维', '2022-08-02', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (XWS)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14581, '纤维', '2022-08-02', '  ES短纤(PE/PP)，增白单亲（FDDH）2D*38mm                ES Fiber ,WHITE, 2D*38mm (CXFY)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14582, '纤维', '2022-08-02', 'ES短纤（PP/PE)， 普白单亲 （SDDH）2D*40mm              ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14583, '纤维', '2022-08-02', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14584, '纤维', '2022-08-02', 'ES短纤,普白单亲，（SDDH）拒水 2D*40mm                ES Fiber ,WHITE, ,Hydrophobic 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14585, '纤维', '2022-08-02', 'ES短纤（PP/PE)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14586, '纤维', '2022-08-02', 'ES短纤（PP/PET)， 普白单亲 （SDDH）6D*40mm              ES Fiber ,WHITE, 6D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14587, '纤维', '2022-08-02', '富威尔 低熔点涤纶（PET/COPET） 4D*51mm    LM FIBER  4D*51mm,white (FEW)', '李时咏', '82-51-796-367 ', '20220802', '郑静', '韩国SAMBO', '出口', '12000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14588, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 910-蓝色、17-蓝色 19C)', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14589, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM  （30-深蓝色、12-深褐色、25-褐色 19C）', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14590, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （26-单色 19A）', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14591, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 910-蓝色、17-蓝色 20C)', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14592, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 930-深蓝色、12-深褐色、25-褐色 20C）', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14593, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 926-单色 20A)', '郑静/Ella', '0272-376-6597', '20220803', '张怡静', 'AN THINH YARNS JSC', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14594, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(01-红色、21-红色18B、29-红色)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14595, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(32-暗红色)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14596, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(20-红色18A 、浅粉红色BS047、粉红色、34-莲花粉、24-褐色)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14597, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(02-橙色)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14598, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(02-柠檬黄-BS147、13-绿色 18A、38-蓝色 BS113A)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14599, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(19-黄色 18B、黄色 BS146、31-深灰色、11-单橙色、27-单色18B)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14600, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(39-叶绿色#35、36-紫色、15-蓝色 18A、37-银灰色)', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14601, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM914-绿色 18B、08-绿色、33-BS110、16-蓝色 18B、23-褐色18A）', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14602, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （10-蓝色、17-蓝色 18C）', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14603, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM（30-深蓝色、12-深褐色、25-褐色 18C）', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14604, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （26-单色 18A）', 'Ella', '0272-376-6597', '20220803', '任海香', 'AN THINH YARNS JSC', '内贸', '25', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14605, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(01-红色、21-红色18B、29-红色)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14606, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(32-暗红色)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14607, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(20-红色18A 、浅粉红色BS047、粉红色、34-莲花粉、24-褐色)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14608, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(02-橙色)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14609, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(02-柠檬黄-BS147、13-绿色 18A、38-蓝色 BS113A)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14610, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(19-黄色 18B、黄色 BS146、31-深灰色、11-单橙色、27-单色18B)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14611, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM(39-叶绿色#35、36-紫色、15-蓝色 18A、37-银灰色)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14612, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM914-绿色 18B、08-绿色、33-BS110、16-蓝色 18B、23-褐色18A）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14613, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （10-蓝色、17-蓝色 18C）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14614, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM（30-深蓝色、12-深褐色、25-褐色 18C）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14615, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （26-单色 18A）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14616, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 910-蓝色、17-蓝色 19C)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14617, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM  （30-深蓝色、12-深褐色、25-褐色 19C）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14618, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM （26-单色 19A）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14619, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 910-蓝色、17-蓝色 20C)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14620, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 930-深蓝色、12-深褐色、25-褐色 20C）', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14621, '纤维', '2022-08-03', ' 再生彩色涤纶纤维3D*64MM  RECYCLED COLOUR FIBERS 3DX64MM 926-单色 20A)', 'Ella', '0272-376-6597', '20220803', '郑静', 'AN THINH YARNS JSC', '出口', '14000', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14622, '纤维', '2022-08-04', '化纤选品1版', '景美华', '13912660066', '20220804', '任海香', '昆山胜昱无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14623, '纤维', '2022-08-04', '化纤选品1版', '郁明旻', '18952437896', '20220804', '任海香', '苏州美森无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14624, '纤维', '2022-08-04', '化纤选品1版', '边经理', '15902236650', '20220804', '任海香', '宜昌欣龙无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14625, '纤维', '2022-08-04', '化纤选品1版', '柴文强', '18767236357', '20220804', '任海香', '吉安三江超纤无纺有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14626, '纤维', '2022-08-04', '化纤选品1版', '万洪山', '13954807599', '20220804', '任海香', '称道新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14627, '全系列', '2022-08-08', '浙江富瑞森水刺无纺布有限公司', '赵雪明', '13705736895', '20220808', '李小龙', '浙江富瑞森水刺无纺布有限公司', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14628, 'SAAS', '2022-08-08', '杭州四茂无纺布有限公司', '徐子品', '13867131096', '20220808', '李小龙', '杭州四茂无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14629, 'SAAS', '2022-08-08', '嘉兴申新无纺布股份有限公司', '曹牮峰', '13906733840', '20220808', '李小龙', '嘉兴申新无纺布股份有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14630, '无纺布制品', '2022-08-08', '湿巾', '庄勤辉', '021-64976497', '20220808', '顾怡青', '上海优生婴儿用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14631, '无纺布制品', '2022-08-08', '湿巾', '殷贤富', '021-39966920', '20220808', '顾怡青', '上海三君生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14632, '无纺布制品', '2022-08-08', '湿巾', '蔡可章', '13918288763', '20220808', '顾怡青', '上海精美湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14633, '纤维', '2022-08-08', '黑色ES纤维', '黄智昌', '18067921188', '20220808', '张怡静', '上海洁丝纺织科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14634, '纤维', '2022-08-08', '黑色阻燃纤维', '李文艳', '18664085689', '20220808', '张怡静', ' 东莞市帕克氏汽车纤维材料有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14635, '纤维', '2022-08-08', '黑色ES纤维', '王亚第', '13006013500', '20220809', '张怡静', '海南欣龙无纺股份有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14636, '纤维', '2022-08-08', '黑色阻燃纤维', '成斐君', '13967310839', '20220809', '张怡静', ' 嘉兴南华无纺材料有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14637, '纤维', '2022-08-08', '黑色ES纤维', '庞新财', '13817398578', '20220810', '张怡静', '洁馨（上海）无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14638, '纤维', '2022-08-08', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220805', '张怡静', '韩国SAMBO', '内贸', '8.1', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14639, '纤维', '2022-08-08', '化纤选品1版', '胡根松', '13957590270', '20220808', '任海香', '浙江宝仁和中科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14640, '纤维', '2022-08-08', '化纤选品1版', '朱欢欢', '15868275182', '20220808', '任海香', '苏州多瑈新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14641, '纤维', '2022-08-08', '化纤选品1版', '蔡雪', '13472355177', '20220808', '任海香', '东纶科技实业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14642, '纤维', '2022-08-08', '化纤选品1版', '庄海祥', '13901505710', '20220808', '任海香', '常州华纳非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14643, '纤维', '2022-08-08', '化纤选品1版', '郝景标', '13858072975', '20220808', '任海香', '诺斯贝尔化妆品股份有限公司', '内贸', '33', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14644, '纤维', '2022-08-08', '  ES短纤（PP/PE),增白单亲（FDDH），2D*40mm                ES Fiber ,WHITE, 2D*40mm (YZSH)', '李时咏', '82-51-796-367 ', '20220805', '郑静', '韩国SAMBO', '出口', '34400', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14645, 'SAAS', '2022-08-09', '江阴市广银无纺制品有限公司', '薛秋琴', '15961513230', '20220809', '李小龙', '江阴市广银无纺制品有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14646, 'SAAS', '2022-08-09', '上海欣洁无纺布制品有限公司', '陈天纯', '021-60566354', '20220809', '李小龙', '上海欣洁无纺布制品有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14647, '全系列', '2022-08-09', '江阴市达越无纺布有限公司', '严建锋', '13812159527', '20220809', '李小龙', '江阴市达越无纺布有限公司', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14648, '无纺布制品', '2022-08-09', '湿巾', '钟励', '021-68016511', '20220809', '顾怡青', '银京医疗科技（上海）股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14649, '无纺布制品', '2022-08-09', '湿巾', '李慈雄', '021-53026795', '20220809', '顾怡青', '上海东冠健康用品股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14650, '无纺布制品', '2022-08-09', '湿巾', '吴鑫梅', '021-68308606', '20220809', '顾怡青', '上海雅臣纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14651, '无纺布制品', '2022-08-09', '湿巾', '雷文', '13918499652', '20220809', '顾怡青', '上海紫羲服饰有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14652, '无纺布', '2022-08-09', '白色纯涤纶针刺无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14653, '无纺布', '2022-08-09', '白色纯涤纶针刺无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '4', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14654, '无纺布', '2022-08-09', '白色芝麻点纯丙纶纺粘无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14655, '无纺布', '2022-08-09', '白色芝麻点柔软纯丙纶纺粘无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14656, '无纺布', '2022-08-09', '白色芝麻点纯丙纶纺粘无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14657, '无纺布', '2022-08-09', '白色水驻极平纹熔喷无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14658, '无纺布', '2022-08-09', '白色电驻极平纹熔喷无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14659, '无纺布', '2022-08-09', '白色水驻极平纹熔喷无纺布', '郑静', '15000347958', '20220809', '顾怡青', '上海德特进出口有限公司 ', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14660, '纤维', '2022-08-09', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm    ES Fiber ,WHITE, 2D*38mm (CXFY)', '李时咏', '82-51-796-367 ', '20220809', '张怡静', '韩国SAMBO', '内贸', '8.1', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14661, '纤维', '2022-08-09', '水刺专用PP纤维', '施国章', '13921296168', '20220809', '张怡静', '无锡优佳无纺科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14662, '纤维', '2022-08-09', '水刺专用PP纤维', '潘全志', '15905261976', '20220809', '张怡静', '江阴市华思诚无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14663, '纤维', '2022-08-09', '水刺专用PP纤维', '陈越', '13615246456', '20220809', '张怡静', '仪征天越达无纺制品有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14664, '纤维', '2022-08-09', '水刺专用PP纤维', '汪学勤', '15371233498', '20220809', '张怡静', ' 江苏海卓无纺科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14665, '纤维', '2022-08-09', '化纤选品1版', '汪德海', '13216813893', '20220809', '任海香', '惠千都（杭州）无纺布科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14666, '纤维', '2022-08-09', '化纤选品1版', '李洋', '15964155598', '20220809', '任海香', '山东德润新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14667, '纤维', '2022-08-09', '化纤选品1版', '吴新斌', '15268218389', '20220809', '任海香', '湖州欧丽卫生材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14668, '纤维', '2022-08-09', '化纤选品1版', '潘振磊', '15964899555', '20220809', '任海香', '山东和悦非织造材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14669, '纤维', '2022-08-09', '化纤选品1版', '严满新', '18961644461', '20220809', '任海香', '江阴双源水刺布专家', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14670, '纤维', '2022-08-09', '   ES短纤(PE/PP)，普白单亲（SDDH）2D*38mm    ES Fiber ,WHITE, 2D*38mm (CXFY)', '李时咏', '82-51-796-367 ', '20220701', '郑静', '韩国SAMBO', '出口', '16200', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14671, 'SAAS', '2022-08-10', '上海龙湾无纺布有限公司', '严信尧', '13901996212', '20220810', '李小龙', '上海龙湾无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14672, 'SAAS', '2022-08-10', '上海博什无纺布业有限公司', '严什香', '13916048085', '20220810', '李小龙', '上海博什无纺布业有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14673, '全系列', '2022-08-10', '上海清雅无纺布有限公司', '李玉洁', '15216676796', '20220810', '李小龙', '上海清雅无纺布有限公司', '内贸', '160万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14674, '无纺布制品', '2022-08-10', '湿巾', '董志超', '021-60571066', '20220810', '顾怡青', '上海华新生物高技术有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14675, '无纺布制品', '2022-08-10', '湿巾', '何天发', '13916408218', '20220810', '顾怡青', '上海布敏物资材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14676, '无纺布制品', '2022-08-10', '湿巾', '张芝萍', '021-58591247', '20220810', '顾怡青', '上海久融塑料制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14677, '无纺布制品', '2022-08-10', '湿巾', '陈宏俊', '021-80100100', '20220810', '顾怡青', '金红叶纸业集团有限公司上海分公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14678, '无纺布', '2022-08-10', '覆膜无纺布', '陈军丽', '13663838327', '20220810', '顾怡青', '河南熙润医疗器械有限公司', '内贸', '12', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14679, '纤维', '2022-08-10', '化纤选品1版', '肖春燕', '13921398011', '20220810', '任海香', '无锡盈尔纺织品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14680, '纤维', '2022-08-10', '化纤选品1版', '刘伟', '13705816740', '20220810', '任海香', '杭州自道实业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14681, '纤维', '2022-08-10', '化纤选品1版', '朱凯', '13869325720', '20220810', '任海香', '山东华业无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14682, '纤维', '2022-08-10', '化纤选品1版', '吴嘉祺', '13646238166', '20220810', '任海香', '常熟市森拓非织造布有限公司', '内贸', '33', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14683, '纤维', '2022-08-10', '化纤选品1版', '连艳纳', '138 27265830', '20220810', '任海香', '东莞市帕克氏汽车纤维材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14684, 'SAAS', '2022-08-11', '上海见好无纺布有限公司', '吴大弟 ', '13918438512', '20220811', '李小龙', '上海见好无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14685, 'SAAS', '2022-08-11', '上海意东无纺布制造有限公司', '刘红国 ', '13917753535', '20220811', '李小龙', '上海意东无纺布制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14686, 'SAAS', '2022-08-11', '上海一东无纺布有限公司', '刘红国 ', '18930565089', '20220811', '李小龙', '上海一东无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14687, '无纺布制品', '2022-08-11', '湿巾', '刘喜明', '021-63852688', '20220811', '顾怡青', '康贝（上海）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14688, '无纺布制品', '2022-08-11', '湿巾', '陆婉英', '021-58994611', '20220811', '顾怡青', '上海高科联合生物技术研发有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14689, '无纺布制品', '2022-08-11', '湿巾', '张跃建', '021-61178754', '20220811', '顾怡青', '上海星耀医学科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14690, '无纺布制品', '2022-08-11', '湿巾', '李慈雄', '021-57276565', '20220811', '顾怡青', '上海东冠纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14691, '无纺布制品', '2022-08-11', '湿巾', '刘丛贵', '021-67627409', '20220811', '顾怡青', '上海万鑫湿毛巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14692, '无纺布制品', '2022-08-11', '湿巾', '潘万方', '13706736636', '20220811', '顾怡青', '上海三天印刷有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14693, '纤维', '2022-08-11', '化纤选品2版', '陶庆丰', '13732292727', '20220811', '任海香', '阳光卫生医疗科技江阴有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14694, '纤维', '2022-08-11', '化纤选品2版', '陈明军', '18905381679', '20220811', '任海香', '山东泰鹏新材料有限公司', '内贸', '120', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14695, '纤维', '2022-08-11', '化纤选品2版', '焦维', '13982019119', '20220811', '任海香', '四川力王无纺制品科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14696, '纤维', '2022-08-11', '化纤选品2版', '平惠芳', '15336899694', '20220811', '任海香', '杭州萧山凤凰纺织有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14697, '纤维', '2022-08-11', '化纤选品2版', '汪敏辉', '13588169365', '20220811', '任海香', '杭州兴农纺织有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14698, '全系列', '2022-08-12', '上海凯通无纺布制造有限公司', '高剑峰 ', '13311725569', '20220812', '李小龙', '上海凯通无纺布制造有限公司', '内贸', '160万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14699, 'SAAS', '2022-08-12', '上海歆升无纺布有限公司', '朱丽萍', '18321508169', '20220812', '李小龙', '上海歆升无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14700, 'SAAS', '2022-08-12', '上海志祥无纺布有限公司', '范峰', '13564626886', '20220812', '李小龙', '上海志祥无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14701, '无纺布制品', '2022-08-12', '湿巾', '罗开全', '021-59790555', '20220812', '顾怡青', '上海亚大塑料制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14702, '无纺布制品', '2022-08-12', '湿巾', '韩立君', '021-62214008', '20220812', '顾怡青', '上海皇宇科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14703, '无纺布制品', '2022-08-12', '湿巾', '王仙见', '021-57578886', '20220812', '顾怡青', '上海尚央塑业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14704, '无纺布制品', '2022-08-12', '湿巾', '王冰峰', '021-59341070', '20220812', '顾怡青', '上海碧丽化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14705, '纤维', '2022-08-12', '化纤选品2版', '胡海豹', '15318466601', '20220812', '任海香', '山东锦腾弘达水刺无纺布', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14706, '纤维', '2022-08-12', '化纤选品2版', '王宇', '18366590113', '20220812', '任海香', '潍坊鑫丰纺织有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14707, '纤维', '2022-08-12', '化纤选品2版', '谷超立', '15660886777', '20220812', '任海香', '华美医疗科技（河南）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14708, '纤维', '2022-08-12', '化纤选品2版', '王浩宇', '18366590113', '20220812', '任海香', '潍坊广富非织造材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14709, '纤维', '2022-08-12', '化纤选品2版', '储永伟', '13805705352', '20220812', '任海香', '杭州临安咔咔玛科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14710, '无纺', '2022-08-12', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:902128866060                                  Fax:902128866070', '20220812', '郑静', 'TEKSIS TEKSTIL URUNLERI PAZARLAMA A.S.', '出口', '0', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14711, '无纺', '2022-08-12', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TEL:92423577041115              FAX:924285770408', '20220812', '郑静', 'IHSAN SONS(PVT)LTD.', '出口', '0', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14712, '无纺', '2022-08-12', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL：492241255850      FAX:4922412558570', '20220812', '郑静', 'INNOVATEC MICROFIBRE TECHNOLOGY GMBH Co.KG', '出口', '0', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14713, '无纺', '2022-08-12', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:416127023110     Fax:41612702319', '20220812', '郑静', 'JACOB HOLM GROUP', '出口', '0', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14714, 'SAAS', '2022-08-15', '上海赢达无纺布有限公司', '孟关寿', '13901639737', '20220815', '李小龙', '上海赢达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14715, 'SAAS', '2022-08-15', '上海姝馨无纺布有限公司', '周伯满', '13023149284', '20220815', '李小龙', '上海姝馨无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14716, 'SAAS', '2022-08-15', '上海拾丰无纺布有限公司', '陆晓江', '13918066004', '20220815', '李小龙', '上海拾丰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14717, '无纺布制品', '2022-08-15', '湿巾', '胡宣化', '021-64909090', '20220815', '顾怡青', '上海爱妮梦纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14718, '无纺布制品', '2022-08-15', '湿巾', '何思伟', '021-56874660', '20220815', '顾怡青', '上海海拉斯实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14719, '无纺布制品', '2022-08-15', '湿巾', '孙守红', '021-59950915', '20220815', '顾怡青', '上海凯红工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14720, '纤维', '2022-08-15', '化纤选品3版', 'Vincy', '15868317773', '20220815', '任海香', '嘉兴南华无纺材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14721, '纤维', '2022-08-15', '化纤选品3版', '林玉报', '15868011128', '20220815', '任海香', '浙江华昊新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14722, '纤维', '2022-08-15', '化纤选品3版', '林海', '15178492776', '20220815', '任海香', '安徽金春无纺布股份有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14723, '纤维', '2022-08-15', '化纤选品3版', '张书凡', '18616567273', '20220815', '任海香', '浙江华基环保科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14724, '纤维', '2022-08-15', '化纤选品3版', '李涛', '13957320531', '20220815', '任海香', '浙江中超新材料股份有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14725, 'SAAS', '2022-08-16', '上海赢达无纺布有限公司', '孟关寿', '13901639737', '20220816', '李小龙', '上海赢达无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14726, '全系列', '2022-08-16', '绍兴县庄洁无纺材料有限公司', '高海根', '13754337718', '20220816', '李小龙', '绍兴县庄洁无纺材料有限公司', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14727, '全系列', '2022-08-16', '扬州荣伟无纺布有限公司', '陈凤珠 ', '13852799756', '20220816', '李小龙', '扬州荣伟无纺布有限公司', '内贸', '180万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14728, '无纺布制品', '2022-08-16', '湿巾', '傅启才', '0571-88587813', '20220816', '顾怡青', '杭州国光旅游用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14729, '无纺布制品', '2022-08-16', '湿巾', '沈艳', '0571-63925910', '20220816', '顾怡青', '浙江华顺科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14730, '无纺布制品', '2022-08-16', '湿巾', '严南鹏', '0571-88583799', '20220816', '顾怡青', '杭州华信电子科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14731, '无纺布制品', '2022-08-16', '湿巾', '项宗生', '0571-63872768', '20220816', '顾怡青', '杭州永芳实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14732, '无纺布制品', '2022-08-16', '湿巾', '吴益斌', '0571-63408985', '20220816', '顾怡青', '浙江绿飞诗日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14733, '纤维', '2022-08-16', '化纤选品4版', '张国炎', '0571-89170009', '20220816', '任海香', '杭州诺邦无纺股份有限公司', '内贸', '130', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14734, '纤维', '2022-08-16', '化纤选品4版', '郑平', '13355970861', '20220816', '任海香', '宁波格创无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14735, '纤维', '2022-08-16', '化纤选品4版', '方军', '18956909808', '20220816', '任海香', '安徽瑞杭新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14736, '纤维', '2022-08-16', '化纤选品4版', '何世明', '13705753705', '20220816', '任海香', '绍兴比伦纺织有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14737, '纤维', '2022-08-16', '化纤选品4版', '沈海明 ', '15824305806', '20220816', '任海香', '绍兴纤蓝纺织科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14738, '全系列', '2022-08-17', '合亿无纺布（昆山）有限公司', '陈敬德', '18662275391', '20220817', '李小龙', '合亿无纺布（昆山）有限公司', '内贸', '360万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14739, '全系列', '2022-08-17', '常熟市雪英无纺布厂', ' 孙雪歧', '13806236432', '20220817', '李小龙', '常熟市雪英无纺布厂', '内贸', '80万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14740, '全系列', '2022-08-17', '江阴天佳无纺布制品有限公司', '费澄', '13915245385', '20220817', '李小龙', '江阴天佳无纺布制品有限公司', '内贸', '240万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14741, '无纺布制品', '2022-08-17', '湿巾', '李国康', '0571-56923156', '20220817', '顾怡青', '杭州中波实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14742, '无纺布制品', '2022-08-17', '湿巾', '王一', '0571-88302272', '20220817', '顾怡青', '杭州大通电子有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14743, '无纺布制品', '2022-08-17', '湿巾', '任建华', '0571-89176112', '20220817', '顾怡青', '杭州诺邦无纺股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14744, '无纺布制品', '2022-08-17', '湿巾', '林成华', '0571-56126088', '20220817', '顾怡青', '杭州妙洁旅游用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14745, '无纺布制品', '2022-08-17', '湿巾', '汤永良', '13906719333', '20220817', '顾怡青', '杭州宝马链传动有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14746, '无纺布制品', '2022-08-17', '湿巾', '陈冠群', '0571-63493917', '20220817', '顾怡青', '杭州高琦香精化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14747, '无纺布', '2022-08-17', '起毛布', '郑静', '15000347958', '20220817', '顾怡青', '上海德特进出口有限公司 ', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14748, '纤维', '2022-08-17', '化纤选品4版', '蔡春妮', '0512-57808888', '20220817', '任海香', '江苏盛纺纳米材料科技股份有限公司', '内贸', '195', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14749, '纤维', '2022-08-17', '化纤选品4版', '陈燕红', '13819545875', '20220817', '任海香', '浙江赛弘纺织科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14750, '纤维', '2022-08-17', '化纤选品4版', '刘红贺', '13598706730', '20220817', '任海香', '河南省润玉无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14751, '纤维', '2022-08-17', '化纤选品4版', '赵聪', '15988176288', '20220817', '任海香', '杭州萧山航民非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14752, '纤维', '2022-08-17', '化纤选品4版', '任双全', '18161339201', '20220817', '任海香', '浙江弘扬无纺新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14753, 'SAAS', '2022-08-18', '无锡市利华无纺布有限公司', '张正华', '13861808911', '20220818', '李小龙', '无锡市利华无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14754, 'SAAS', '2022-08-18', '常熟市依威无纺布制品有限公司', '顾雪峰', '13962311391', '20220818', '李小龙', '常熟市依威无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14755, 'SAAS', '2022-08-18', '苏州市羽洋无纺布有限公司', '郑建均', '13812802787', '20220818', '李小龙', '苏州市羽洋无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14756, '无纺布制品', '2022-08-18', '湿巾', '沈伟芳', '0571-82270558', '20220818', '顾怡青', '杭州华诚机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14757, '无纺布制品', '2022-08-18', '湿巾', '王剑亮', '0571-82995783', '20220818', '顾怡青', '杭州科达非织造布有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14758, '无纺布制品', '2022-08-18', '湿巾', '忻峰锴', '0571-63469666', '20220818', '顾怡青', '杭州富阳黎明实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14759, '无纺布制品', '2022-08-18', '湿巾', '邵伟荣', '0571-82251008', '20220818', '顾怡青', '杭州辉煌卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14760, '无纺布制品', '2022-08-18', '湿巾', '周晓波', '0571-63408815', '20220818', '顾怡青', '浙江豪普电子有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14761, '纤维', '2022-08-18', '化纤选品4版', '沈刚', '13812119538', '20220818', '任海香', '江阴市顺浩新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14762, '纤维', '2022-08-18', '化纤选品4版', '张兴顺', '13933714528', '20220818', '任海香', '南宫市顺鑫毡业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14763, '纤维', '2022-08-18', '化纤选品4版', '蔡浩文', '020 61164206', '20220818', '任海香', '广州市贝玉无纺布制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14764, '纤维', '2022-08-18', '化纤选品4版', '王华锋', '17715387217', '20220818', '任海香', '苏州圣菲尔新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14765, '纤维', '2022-08-18', '化纤选品4版', '李栋', '13940938873', '20220818', '任海香', '山东宏盛非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14766, '全系列', '2022-08-19', '无锡市鸿庆无纺布有限公司', '谈正杰', '13961547721', '20220819', '李小龙', '无锡市鸿庆无纺布有限公司', '内贸', '100万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14767, '全系列', '2022-08-19', '常熟市雪利银无纺布有限公司', '方银妹', '13338727338', '20220819', '李小龙', '常熟市雪利银无纺布有限公司', '内贸', '160万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14768, 'SAAS', '2022-08-19', '扬州市格林无纺布有限公司', '唐红星', '13852703893', '20220819', '李小龙', '扬州市格林无纺布有限公司', '内贸', '28万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14769, '无纺布制品', '2022-08-19', '湿巾', '余忠法', '0571-86339816', '20220819', '顾怡青', '杭州方圆布业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14770, '无纺布制品', '2022-08-19', '湿巾', '李琦', '0571-89891066', '20220819', '顾怡青', '杭州瑞德设计股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14771, '无纺布制品', '2022-08-19', '湿巾', '金利伟', '0571-63820997', '20220819', '顾怡青', '杭州可靠护理用品股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14772, '无纺布制品', '2022-08-19', '湿巾', '方能斌', '0571-82231019', '20220819', '顾怡青', '浙江大胜达包装股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14773, '无纺布制品', '2022-08-19', '湿巾', '贺静伟', '0574-86108699', '20220819', '顾怡青', '宁波市北仑佳达电子有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14774, '无纺布制品', '2022-08-19', '湿巾', '陈国龙', '0574-88453247', '20220819', '顾怡青', '宁波市鄞州姜山利民卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14775, '无纺布', '2022-08-19', '面膜布', '乐克才', '051088267932 ', '20220819', '顾怡青', '无锡市布凡纺织品有限公司', '内贸', '10', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14776, '全系列', '2022-08-22', '上海金昂无纺布制品有限公司', '吕秀绍', '13045672388', '20220822', '李小龙', '上海金昂无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14777, '全系列', '2022-08-22', '上海创然无纺布科技有限公司', '于兵', '18602134485', '20220822', '李小龙', '上海创然无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14778, '全系列', '2022-08-22', '上海沈惠无纺布制品有限公司', '沈贤冬', '18918029898', '20220822', '李小龙', '上海沈惠无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14779, '全系列', '2022-08-22', '上海青阳无纺布制品有限公司', '赵民', '13818699940', '20220822', '李小龙', '上海青阳无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14780, '全系列', '2022-08-22', '上海念羽无纺布制品有限公司', '张玉兵', '13621764123', '20220822', '李小龙', '上海念羽无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14781, '全系列', '2022-08-22', '上海冉旗无纺布制品有限公司', '张鹏', '13162921767', '20220822', '李小龙', '上海冉旗无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14782, '无纺布制品', '2022-08-22', '湿巾', '张技央', '0574-58962288', '20220822', '顾怡青', '宁波兰花电器制造有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14783, '无纺布制品', '2022-08-22', '湿巾', '项乐宏', '0574-55005647', '20220822', '顾怡青', '乐歌人体工学科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14784, '无纺布制品', '2022-08-22', '湿巾', '袁国森', '0577-65561032', '20220822', '顾怡青', '瑞安市三环机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14785, '纤维', '2022-08-22', '化纤选品5版', '刘永涛', '16605465158', '20220822', '任海香', '山东荣泰新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14786, '纤维', '2022-08-22', '化纤选品5版', '刘宝中', '18307078555', '20220822', '任海香', '缇镨（上海）新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14787, '纤维', '2022-08-22', '化纤选品5版', '柯志良', '15080125310', '20220822', '任海香', '莆田市华明化妆用具有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14788, '纤维', '2022-08-22', '化纤选品5版', '韩涛', '13360008114', '20220822', '任海香', '佛山奇棉科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14789, '纤维', '2022-08-22', '化纤选品5版', '张宝根', '13809056538', '20220822', '任海香', '龙帛生物科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14790, '全系列', '2022-08-23', '上海欣树无纺布制品有限公司', '项世英', '13601986263', '20220823', '李小龙', '上海欣树无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14791, '全系列', '2022-08-23', '上海国城无纺布制品有限公司', '郭智亮', '13917872067', '20220823', '李小龙', '上海国城无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14792, '全系列', '2022-08-23', '上海纯绅无纺布制品有限公司', '朱亚军', '13701903443', '20220823', '李小龙', '上海纯绅无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14793, '全系列', '2022-08-23', '茸昕无纺布制品（上海）有限公司', '陆秀根', '15800359535', '20220823', '李小龙', '茸昕无纺布制品（上海）有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14794, '全系列', '2022-08-23', '上海鹫发无纺布有限公司', '朱建华', '13918453322', '20220823', '李小龙', '上海鹫发无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14795, '全系列', '2022-08-23', '苏州鑫茂无纺材料有限公司', '范东明', '13806237218', '20220823', '李小龙', '苏州鑫茂无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14796, '无纺布制品', '2022-08-23', '湿巾', '朱乃形', '13967778350', '20220823', '顾怡青', '瑞安市华源包装机械厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14797, '无纺布制品', '2022-08-23', '湿巾', '邱光和', '0577-88089999', '20220823', '顾怡青', '浙江森马服饰股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14798, '无纺布制品', '2022-08-23', '湿巾', '黄清山', '0573-85136616', '20220823', '顾怡青', '南六企业（平湖）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14799, '无纺布制品', '2022-08-23', '湿巾', '吴秀英', '0573-83588555', '20220823', '顾怡青', '嘉兴市恒悦纺织股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14800, '无纺布制品', '2022-08-23', '湿巾', '褚文婷', '0573-87076086', '20220823', '顾怡青', '海宁市海昌亲亲卫生洁品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14801, '纤维', '2022-08-23', '化纤选品5版', '黄莹', '13212710872', '20220823', '任海香', '浙江好材好非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14802, '纤维', '2022-08-23', '化纤选品5版', '王增涛', '15257959789', '20220823', '任海香', '东阳市九丽日用品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14803, '纤维', '2022-08-23', '化纤选品5版', '夏司花', '13431413841', '20220823', '任海香', '东莞市威骏不织布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14804, '纤维', '2022-08-23', '化纤选品5版', '汪锐', '15221071970', '20220823', '任海香', '上海芒格生物科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14805, '纤维', '2022-08-23', '化纤选品5版', '李欣悦', '15378752568', '20220823', '任海香', '河南萱悦无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14806, '全系列', '2022-08-24', '仪征市荣鑫无纺布有限公司', '邱月兵', '13179796442', '20220824', '李小龙', '仪征市荣鑫无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14807, '全系列', '2022-08-24', '盐城申安无纺布工贸有限公司', '周付衍', '13770043861', '20220824', '李小龙', '盐城申安无纺布工贸有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14808, '全系列', '2022-08-24', '常熟市银桂无纺布厂', '李桂元', '13606233628', '20220824', '李小龙', '常熟市银桂无纺布厂', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14809, '全系列', '2022-08-24', '江阴市光大无纺布业有限公司', '承惠兴', '13901524253', '20220824', '李小龙', '江阴市光大无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14810, '全系列', '2022-08-24', '徐州拓宇无纺布有限公司', '李明真', '18118551999', '20220824', '李小龙', '徐州拓宇无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14811, '全系列', '2022-08-24', '江阴市金建无纺布制品有限公司', '陆进良', '13812160626', '20220824', '李小龙', '江阴市金建无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14812, '无纺布制品', '2022-08-24', '湿巾', '朱清', '0573-87082388', '20220824', '顾怡青', '海宁市百合洁品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14813, '无纺布制品', '2022-08-24', '湿巾', '赵雪明', '0573-83128089', '20220824', '顾怡青', '浙江富瑞森水刺无纺布股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14814, '无纺布制品', '2022-08-24', '湿巾', '严华荣', '0572-6230888', '20220824', '顾怡青', '浙江金三发集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14815, '无纺布制品', '2022-08-24', '湿巾', '李旸', '0572-6129077', '20220824', '顾怡青', '湖州欧丽卫生材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14816, '无纺布制品', '2022-08-24', '湿巾', '严华荣', '0572-6680166', '20220824', '顾怡青', '浙江金三发卫生材料科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14817, '无纺布制品', '2022-08-24', '湿巾', '俞永法', '0572-8402239', '20220824', '顾怡青', '浙江彩汇包装科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14818, '无纺布', '2022-08-24', '波浪纹水刺布', '蔡小姐', '13822021935', '20220824', '顾怡青', '深圳市富创意科技实业有限公司', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14819, '无纺布', '2022-08-24', '格纹热风布', '蔡小姐', '13822021935', '20220824', '顾怡青', '深圳市富创意科技实业有限公司', '内贸', '3', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14820, '纤维', '2022-08-24', '化纤选品5版', '孟玲花', '18758507806', '20220824', '任海香', '绍舒洁雅无纺材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14821, '纤维', '2022-08-24', '化纤选品5版', '孙敏', '15629130969', '20220824', '任海香', '威斯顿（武汉）新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14822, '纤维', '2022-08-24', '化纤选品5版', '张红玉', '15382392869', '20220824', '任海香', '浙江绿芳洲无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14823, '纤维', '2022-08-24', '化纤选品5版', '谭志勇', '13530025219', '20220824', '任海香', '联丰医用卫生材料（始兴）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14824, '纤维', '2022-08-24', '化纤选品5版', '黄智昌', '18067921188', '20220824', '任海香', '上海洁丝纺织科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14825, '无纺布制品', '2022-08-26', '湿巾', '何吉华', '0575-87320008', '20220826', '顾怡青', '浙江商林科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14826, '无纺布制品', '2022-08-26', '湿巾', '朱加林', '0575-82770338', '20220826', '顾怡青', '浙江三友包装有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14827, '无纺布制品', '2022-08-26', '湿巾', '包林江', '13806751643', '20220826', '顾怡青', '绍兴医疗器械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14828, '无纺布制品', '2022-08-26', '湿巾', '鲁建国', '0575-88082530', '20220826', '顾怡青', '振德医疗用品股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14829, '无纺布制品', '2022-08-26', '湿巾', '李光军', '0579-85816285', '20220826', '顾怡青', '义乌市安柔卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14830, '无纺布制品', '2022-08-26', '湿巾', '张发文', '0579-89178288', '20220826', '顾怡青', '金华长弓清洁用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14831, '纤维', '2022-08-26', '化纤选品5版', '郭晓龙', '15868011128', '20220826', '任海香', '北京苏纳可科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14832, '纤维', '2022-08-26', '化纤选品5版', '张立锋', '18668377822', '20220826', '任海香', '浙江腾亚科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14833, '纤维', '2022-08-26', '化纤选品5版', '李东哲', '13624271883', '20220826', '任海香', '盘锦禹王无纺布有限责任公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14834, '纤维', '2022-08-26', '化纤选品5版', '黄生', '18026327514', '20220826', '任海香', '广州市科纶实业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14835, '纤维', '2022-08-26', '化纤选品5版', '赵晓玉', '15640870699', '20220826', '任海香', '大连蓝赛斯无纺布制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14836, '全系列', '2022-08-29', '无锡奥金纳特无纺布有限公司', '陈忠蔚', '13914118308', '20220829', '李小龙', '无锡奥金纳特无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14837, '全系列', '2022-08-29', '宜兴市新联无纺布有限公司', '潘培年', '18915382156', '20220829', '李小龙', '宜兴市新联无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14838, '全系列', '2022-08-29', '常熟市富鸿无纺布有限公司', '蒋金荣', '13812808298', '20220829', '李小龙', '常熟市富鸿无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14839, '全系列', '2022-08-29', '张家港市海洲无纺布制品有限公司', '徐丹', '13801567667', '20220829', '李小龙', '张家港市海洲无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14840, '全系列', '2022-08-29', '常州市友恒无纺布有限公司', '丁震', '13901508447', '20220829', '李小龙', '常州市友恒无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14841, '全系列', '2022-08-29', '泰州市金盛无纺布厂', '张圣来', '13809154803', '20220829', '李小龙', '泰州市金盛无纺布厂', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14842, '无纺布制品', '2022-08-29', '湿巾', '', '13506766888', '20220829', '顾怡青', '浙江省仙居县仙康药剂厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14843, '无纺布制品', '2022-08-29', '湿巾', '苏圣源', '028-87804139', '20220829', '顾怡青', '成都市豪盛华达纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14844, '无纺布制品', '2022-08-29', '湿巾', '龚静', '028-85009802', '20220829', '顾怡青', '成都凯茜生物制品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14845, '无纺布制品', '2022-08-29', '湿巾', '张代发', '13981911099', '20220829', '顾怡青', '成都发利纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14846, '无纺布制品', '2022-08-29', '湿巾', '梁宗贵', '028-84192199', '20220829', '顾怡青', '成都顺发消洗科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14847, '无纺布制品', '2022-08-29', '湿巾', '张通', '028-85187282', '20220829', '顾怡青', '成都市岷江工业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14848, '全系列', '2022-08-30', '扬州市邗江金春无纺布厂', '皮金春', '13773590699', '20220830', '李小龙', '扬州市邗江金春无纺布厂', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14849, '全系列', '2022-08-30', '启东清雅无纺布有限公司', '李玉洁', '18616863096', '20220830', '李小龙', '启东清雅无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14850, '全系列', '2022-08-30', '南通大进发无纺布有限公司', '胡桂红', '13861952262', '20220830', '李小龙', '南通大进发无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14851, '全系列', '2022-08-30', '常熟市宝鼎无纺布有限公司', '方月琴', '13601551568', '20220830', '李小龙', '常熟市宝鼎无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14852, '全系列', '2022-08-30', '广同（仪征）无纺布工业有限公司', '钱生林', '15252533188', '20220830', '李小龙', '广同（仪征）无纺布工业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14853, '全系列', '2022-08-30', '扬州市锦程无纺布厂', '龚小兵', '13626118048', '20220830', '李小龙', '扬州市锦程无纺布厂', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14854, '无纺布制品', '2022-08-30', '湿巾', '张浩', '13568312560', '20220830', '顾怡青', '攀枝花市仁和区木棉纸品加工厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14855, '无纺布制品', '2022-08-30', '湿巾', '张健', '0838-2906311', '20220830', '顾怡青', '维达纸业（四川）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14856, '无纺布制品', '2022-08-30', '湿巾', '高尚荣', '0838-5400686', '20220830', '顾怡青', '四川友邦企业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14857, '无纺布制品', '2022-08-30', '湿巾', '布廷现', '0531-86139948', '20220830', '顾怡青', '山东统一银座商业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14858, '无纺布制品', '2022-08-30', '湿巾', '王晶', '0531-86916826', '20220830', '顾怡青', '山东省纺织机械器材有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14859, '无纺布制品', '2022-08-30', '湿巾', '史成玉', '0531-83328202', '20220830', '顾怡青', '山东省永信非织造材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14860, '无纺布制品', '2022-08-30', '湿巾', '沈文立', '0531-86400400', '20220830', '顾怡青', '济南博利医药生物工程有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14861, '纤维', '2022-08-30', '化纤选品6版', '蒋敏', '13668285976', '20220830', '任海香', '浙江永光无纺布股份有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14862, '纤维', '2022-08-30', '化纤选品6版', '王根林', '18905734628', '20220830', '任海香', '江西德乐智能科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14863, '纤维', '2022-08-30', '化纤选品6版', '王珺', '18120391555', '20220830', '任海香', '潜江市江赫医用材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14864, '纤维', '2022-08-30', '化纤选品6版', '马杰', '13868039034', '20220830', '任海香', '杭州临安腾美日用品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14865, '纤维', '2022-08-30', '化纤选品6版', '刘祥捷', '15831979333', '20220830', '任海香', '南宫市罗康毛毡有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14866, 'SAAS', '2022-08-31', '常熟市越亿无纺布有限公司', '程龙明', '13706235328', '20220831', '李小龙', '常熟市越亿无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14867, 'SAAS', '2022-08-31', '沭阳县振韩无纺布制品有限公司', '陆佳昌', '13851220235', '20220831', '李小龙', '沭阳县振韩无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14868, 'SAAS', '2022-08-31', '靖江市盛尔无纺布有限公司', '顾振兴', '13852850029', '20220831', '李小龙', '靖江市盛尔无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14869, '无纺布制品', '2022-08-31', '湿巾', '胡三元', '0531-82969995', '20220831', '顾怡青', '山东省千佛山医院（山东省牙病防治指导中心）', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14870, '无纺布制品', '2022-08-31', '湿巾', '康文韬', '0532-84846630', '20220831', '顾怡青', '青岛红星化工集团自力实业公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14871, '无纺布制品', '2022-08-31', '湿巾', '李育强', '0532-58717217', '20220831', '顾怡青', '青岛明药堂医疗股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14872, '无纺布制品', '2022-08-31', '湿巾', '李雪梅', '0532-87209029', '20220831', '顾怡青', '青岛明宇卫生制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14873, '纤维', '2022-08-31', '化纤选品6版', '谷贤群', '18857721230', '20220831', '任海香', '浙江广鸿无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14874, '纤维', '2022-08-31', '化纤选品6版', '冯延涛', '15995611561', '20220831', '任海香', '江苏思博特纺织科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14875, '纤维', '2022-08-31', '化纤选品6版', '余磊', '15927627389', '20220831', '任海香', '武汉金发科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14876, '纤维', '2022-08-31', '化纤选品6版', '徐永明', '13901524790', '20220831', '任海香', '江阴市永新无纺布', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14877, '纤维', '2022-08-31', '化纤选品6版', '胡炳年', '15988189328', '20220831', '任海香', '杭州思进无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14878, 'SAAS', '2022-09-01', '常熟市紫艳无纺制品有限公司', '孙永红', '13806231619', '20220901', '李小龙', '常熟市紫艳无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14879, 'SAAS', '2022-09-01', '常州市金一翔无纺制品有限公司', '沈亿', '18651960164', '20220901', '李小龙', '常州市金一翔无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14880, 'SAAS', '2022-09-01', '常熟市耀华无纺制品有限公司', '张耀明', '13806238991', '20220901', '李小龙', '常熟市耀华无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14881, 'SAAS', '2022-09-02', '常熟市金兔无纺制品有限公司', '张毅', '13773066680', '20220902', '李小龙', '常熟市金兔无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14882, 'SAAS', '2022-09-02', '常熟市言诺无纺制品有限公司', '陈双', '13812835615', '20220902', '李小龙', '常熟市言诺无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14883, 'SAAS', '2022-09-02', '仪征盛宇无纺制品有限公司', '杜仁发', '15952595115', '20220902', '李小龙', '仪征市龙诚无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14884, '无纺布制品', '2022-09-02', '湿巾', '赵帅', '0532-87730688', '20220902', '顾怡青', '青岛波斯特生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14885, '无纺布制品', '2022-09-02', '湿巾', '王俊罡', '0532-88802877', '20220902', '顾怡青', '青岛天鹅新材料织造有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14886, '无纺布制品', '2022-09-02', '湿巾', '方方', '0532-80668722', '20220902', '顾怡青', '青岛理智源商务有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14887, '无纺布制品', '2022-09-02', '湿巾', '贾莉', '0533-7975596', '20220902', '顾怡青', '山东赛特新材料股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14888, '无纺布制品', '2022-09-02', '湿巾', '徐茂元', '0533-3223986', '20220902', '顾怡青', '山东益母妇女用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14889, '无纺布制品', '2022-09-02', '湿巾', '郑青', '13706436105', '20220902', '顾怡青', '淄博市周村旭日纸品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14890, '纤维', '2022-09-02', '化纤选品6版', '周光勇', '13656607266', '20220902', '任海香', '嘉兴市雅盛莱无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14891, '纤维', '2022-09-02', '化纤选品6版', '陈福坚', '13929912276', '20220902', '任海香', '广东强的卫材科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14892, '纤维', '2022-09-02', '化纤选品6版', '王如义', '13761134036', '20220902', '任海香', '大连华阳新材料科技股份有限公司上海分公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14893, '纤维', '2022-09-02', '化纤选品6版', '徐旭泽', '13901968518', '20220902', '任海香', '嘉兴尚誉无纺布科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14894, '纤维', '2022-09-02', '化纤选品6版', '赵民忠', '13967348118', '20220902', '任海香', '嘉兴纤思无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14895, '全系列', '2022-09-05', '江苏凯盾新材料有限公司', '雷三军', '13981943452', '20220905', '李小龙', '江苏凯盾新材料有限公司', '内贸', '30万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14896, '全系列', '2022-09-05', '仪征市志方无纺材料有限公司', '刘翔', '18905253555', '20220905', '李小龙', '仪征市志方无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14897, '全系列', '2022-09-05', '长垣虎泰无纺布有限公司 ', '王有虎', '13503736409', '20220905', '李小龙', '长垣虎泰无纺布有限公司 ', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14898, '无纺布制品', '2022-09-05', '湿巾', '王玉全', '0533-3587767', '20220905', '顾怡青', '山东新华医疗器械股份有限公司', '内贸', '6', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14899, '无纺布制品', '2022-09-05', '湿巾', '杜念华', '0535-8220919', '20220905', '顾怡青', '招远市利普生医疗器械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14900, '无纺布制品', '2022-09-05', '湿巾', '邹立远', '13176315188', '20220905', '顾怡青', '牟平区华宇纸制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14901, '无纺布', '2022-09-05', '白棉毡', '陈毅', '15381000007', '20220905', '顾怡青', '浙江富豪达纺织股份有限公司', '内贸', '7', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14902, '无纺布', '2022-09-05', '硬质棉毡', '陈毅', '15381000007', '20220905', '顾怡青', '浙江富豪达纺织股份有限公司', '内贸', '7', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14903, '无纺布', '2022-09-05', '硬质棉', '陈毅', '15381000007', '20220905', '顾怡青', '浙江富豪达纺织股份有限公司', '内贸', '7', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14904, '无纺布', '2022-09-05', '硬质棉毡', '陈毅', '15381000007', '20220905', '顾怡青', '浙江富豪达纺织股份有限公司', '内贸', '7', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14905, '无纺布', '2022-09-05', '硬质棉毡', '陈毅', '15381000007', '20220905', '顾怡青', '浙江富豪达纺织股份有限公司', '内贸', '7', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14906, '纤维', '2022-09-05', '化纤选品7版', '郭鸣', '13966818777', '20220905', '任海香', '安徽奥美非纺织布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14907, '纤维', '2022-09-05', '化纤选品7版', '程学伟', '13906244209', '20220905', '任海香', '常熟市永得利水刺无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14908, '纤维', '2022-09-05', '化纤选品7版', '钱耀新', '13506234987', '20220905', '任海香', '常熟市长江无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14909, '纤维', '2022-09-05', '化纤选品7版', '周围', '13906815729', '20220905', '任海香', '常州欧美亚无纺布', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14910, '纤维', '2022-09-05', '化纤选品7版', '冯惠强', '1316152518', '20220905', '任海香', '德沃尔无纺布（杭州）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14911, '全系列', '2022-09-06', '江阴市海月无纺布业有限公司', '顾林虎', '13656196298', '20220906', '李小龙', '江阴市海月无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14912, '全系列', '2022-09-06', '扬州博大无纺布有限公司', '杨海涛', '13921931200', '20220906', '李小龙', '扬州博大无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14913, '全系列', '2022-09-06', '上海剑良无纺布制品有限公司', '黄春平', '15300663768', '20220906', '李小龙', '上海剑良无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14914, '全系列', '2022-09-06', '上海硕特无纺布有限公司', '应陆群', '17316325520', '20220906', '李小龙', '上海硕特无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14915, '无纺布制品', '2022-09-06', '湿巾', '钟娟', '13465720628', '20220906', '顾怡青', '高密市瑞雪卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14916, '无纺布制品', '2022-09-06', '湿巾', '林海', '13906468200', '20220906', '顾怡青', '潍坊红阳药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14917, '无纺布制品', '2022-09-06', '湿巾', '王彬', '0536-6063817', '20220906', '顾怡青', '诸城富维食品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14918, '无纺布制品', '2022-09-06', '湿巾', '王维友', '0536-7689088', '20220906', '顾怡青', '潍坊佳兴织业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14919, '无纺布制品', '2022-09-06', '湿巾', '李海员', '13930263787', '20220906', '顾怡青', '保定市金升纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14920, '无纺布制品', '2022-09-06', '湿巾', '张博', '13930202078', '20220906', '顾怡青', '保定市安信纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14921, '纤维', '2022-09-06', '化纤选品7版', '聂祖宝', '13799114542', '20220906', '任海香', '福建福能南纺卫生材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14922, '纤维', '2022-09-06', '化纤选品7版', '廖翶清', '1360221481', '20220906', '任海香', '广州三立无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14923, '纤维', '2022-09-06', '化纤选品7版', '顾庆书', '13926299110', '20220906', '任海香', '广州海鑫无纺布实业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:49', 'admin', '2022-11-16 22:14:49');
INSERT INTO `fnc_ledger` VALUES (14924, '纤维', '2022-09-06', '化纤选品7版', '李健', '13606509440', '20220906', '任海香', '杭州特艺非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14925, '纤维', '2022-09-06', '化纤选品7版', '孙武平', '13805729595', '20220906', '任海香', '杭州金百合非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14926, '纤维', '2022-09-06', '黑色ES纤维 2D*38MM', '张海明', '', '20220906', '郑静', '', '内贸', '180000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14927, '全系列', '2022-09-07', '希雅图（上海）无纺布有限公司', '许德跃', '13918616788', '20220907', '李小龙', '希雅图（上海）无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14928, '全系列', '2022-09-07', '上海林洁无纺布制品有限公司', '林雪燕', '13611733359', '20220907', '李小龙', '上海林洁无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14929, '全系列', '2022-09-07', '山东寿光东方无纺布有限公司', '王天利', '13806364718', '20220907', '李小龙', '山东寿光东方无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14930, '全系列', '2022-09-07', '山东莱芬无纺布有限公司', '荆雷', '13370675885', '20220907', '李小龙', '山东莱芬无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14931, '无纺布制品', '2022-09-07', '湿巾', '王煜兰', '0536-6065066', '20220907', '顾怡青', '诸城市伊丽斯经贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14932, '无纺布制品', '2022-09-07', '湿巾', '冀洪祥', '0536-3544555', '20220907', '顾怡青', '山东宏祥工贸集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14933, '无纺布制品', '2022-09-07', '湿巾', '丛菊香', '15806312975', '20220907', '顾怡青', '乳山市菊香药具店', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14934, '无纺布制品', '2022-09-07', '湿巾', '马宝英', '18669686610', '20220907', '顾怡青', '临沂市金绫纺织有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14935, '无纺布制品', '2022-09-07', '湿巾', '韩奎涛', '0539-7068179', '20220907', '顾怡青', '临沂市宝韵化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14936, '无纺布制品', '2022-09-07', '湿巾', '刘正涛', '13371279693', '20220907', '顾怡青', '临沂市华鲁彩印有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14937, '无纺布制品', '2022-09-07', '湿巾', '谢华', '15092876606', '20220907', '顾怡青', '临沂峰正纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14938, '无纺布制品', '2022-09-07', '湿巾', '朱汉泉', '0534-2556700', '20220907', '顾怡青', '山东利尔康医疗科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14939, '无纺布制品', '2022-09-07', '湿巾', '李敏', '13805340356', '20220907', '顾怡青', '德州海岩卫浴科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14940, '纤维', '2022-09-07', '化纤选品7版', '石中秋', '13799851882', '20220907', '任海香', '晋江兴泰无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14941, '纤维', '2022-09-07', '化纤选品7版', '顾友国', '15050501485', '20220907', '任海香', '泰州市高新非织布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14942, '纤维', '2022-09-07', '化纤选品7版', '杨洪忠', '13301528718', '20220907', '任海香', '江苏朵拉无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14943, '纤维', '2022-09-07', '化纤选品7版', '薛成双', '13506111219', '20220907', '任海香', '江苏思佳瑞非织造科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14944, '纤维', '2022-09-07', '化纤选品7版', '张磊', '17712891988', '20220907', '任海香', '江苏华龙无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14945, '全系列', '2022-09-08', '上海理彬无纺布有限公司', '庄天方', '18901805882', '20220908', '李小龙', '上海理彬无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14946, '全系列', '2022-09-08', '上海宝创无纺布科技有限公司', '沈伟云', '18916056668', '20220908', '李小龙', '上海宝创无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14947, '全系列', '2022-09-08', '洁馨（上海）无纺布有限公司', '庞新财', '13817398578', '20220908', '李小龙', '洁馨（上海）无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14948, '全系列', '2022-09-08', '上海独韵无纺布有限公司', '汪国荣', '13524963411', '20220908', '李小龙', '上海独韵无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14949, '全系列', '2022-09-08', '上海合洪无纺布制品有限公司', '邹开成', '18930813666', '20220908', '李小龙', '上海合洪无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14950, '全系列', '2022-09-08', '上海鼎瑞无纺布制造有限公司', '李建华', '13801724957', '20220908', '李小龙', '上海鼎瑞无纺布制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14951, '无纺布制品', '2022-09-08', '湿巾', '范兰青', '13313017696', '20220908', '顾怡青', '石家庄市圣兰彩印包装有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14952, '无纺布制品', '2022-09-08', '湿巾', '张正光', '0311-86586308', '20220908', '顾怡青', '石家庄市栾城区大华纺织有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14953, '无纺布制品', '2022-09-08', '湿巾', '赵顺成', '0312-7021881', '20220908', '顾怡青', '保定市满城前进造纸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14954, '无纺布制品', '2022-09-08', '湿巾', '谭春生', '13331280571', '20220908', '顾怡青', '保定市和信纸品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14955, '纤维', '2022-09-08', '化纤选品7版', '温明', '13961696096', '20220908', '任海香', '江阴市广银无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14956, '纤维', '2022-09-08', '化纤选品7版', '左明', '13396282003', '20220908', '任海香', '山东天风新材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14957, '纤维', '2022-09-08', '化纤选品7版', '高璟', '13405533538', '20220908', '任海香', '泰州万邦无纺业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14958, '纤维', '2022-09-08', '化纤选品7版', '王亚第', '13006013500', '20220908', '任海香', '海南欣龙无纺股份有限公司', '内贸', '56', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14959, '纤维', '2022-09-08', '化纤选品7版', '钱鸣东', '13862344320', '20220908', '任海香', '常熟市聚格纤维制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14960, '全系列', '2022-09-09', '滤清器项目管理系统（含可视化大屏）', '王总', '', '20220909', '李小龙', '上海华滤企业发展有限公司', '内贸', '12万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14961, '无纺布制品', '2022-09-09', '湿巾', '白红敏', '0312-5576932', '20220909', '顾怡青', '河北义厚成日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14962, '无纺布制品', '2022-09-09', '湿巾', '石俊杰', '13903365778', '20220909', '顾怡青', '保定洁中洁卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14963, '无纺布制品', '2022-09-09', '湿巾', '赵喜安', '13931266516', '20220909', '顾怡青', '满城县三利卫生巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14964, '纤维', '2022-09-09', '化纤选品7版', '张令先', '15954229988', '20220909', '任海香', '青岛国恩科技股份有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14965, '纤维', '2022-09-09', '化纤选品7版', '王瑞金', '18660667007', '20220909', '任海香', '潍坊青栀新材料科技有限公司', '内贸', '45', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14966, '纤维', '2022-09-09', '化纤选品7版', '李江昕', '13918013954', '20220909', '任海香', '希纺（实业）上海有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14967, '纤维', '2022-09-09', '化纤选品7版', '胡道广', '13795358685', '20220909', '任海香', '宣城广能非织造有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14968, '纤维', '2022-09-09', '化纤选品7版', '梁晓燕', '15157701395', '20220909', '任海香', '浙江钜源无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14969, '纤维', '2022-09-09', '化纤选品7版', '梁晓燕', '15157701395', '20220909', '任海香', '浙江钜源无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14970, '无纺布制品', '2022-09-10', '湿巾', '张志武', '0312-5578866', '20220910', '顾怡青', '保定市东升卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14971, '无纺布制品', '2022-09-11', '湿巾', '崔铭宇', '0312-7075876', '20220911', '顾怡青', '河北聚润卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14972, '无纺布', '2022-06-09', '阻燃布   ', '程景丽', '15900302919', '20220622', '顾怡青', '天津齐邦新材料有限公司', '内贸', '6', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14973, '纤维', '2022-06-18', '不定岛纤维', '崔跃辉', '13937332511', '20220618', '张怡静', '河南科润康非织造布有限公司', '内贸', '2', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14974, '无纺布', '2022-06-22', 'pe阻燃膜', '肖鹏远', '13602048027', '20220622', '顾怡青', '天津齐邦新材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14975, '纤维', '2022-06-29', '短纤维', '佘世豪', '18251378806', '20220629', '张怡静', '南通荣荟新材料科技有限公司', '内贸', '2', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14976, '纤维', '2022-06-30', '  ES纤维(PE/PP)', '李时泳', '82-10-4660-5534', '20220630', '张怡静', 'SBSAMBO VINA CO., LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14977, '纤维', '2022-07-01', '黑色涤纶10D*38mm Black polyester fibre10D*38mm', 'WONGER', '15088215783', '20220701', '张怡静', 'FOCUS', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14978, '无纺布', '2022-07-04', '化妆棉', '戚义学', '18576021758', '20220704', '顾怡青', '拜科（广州）高新材料公司', '内贸', '10', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14979, '纤维', '2022-07-04', '富威尔 低熔点 4D*51mm     FWE-LM FIBER 4D*51mm,white', '李时泳', '82-10-4660-5534', '20220704', '张怡静', 'SBSAMBO VINA CO., LTD.', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14980, '无纺布', '2022-07-05', '金箔面膜布', '黎景豪 ', '18998347570', '20220705', '顾怡青', '广州无添加主义化妆品有限公司', '内贸', '11', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14981, '无纺布', '2022-07-05', '金箔面膜布', '宋桃清', '18127911396', '20220705', '顾怡青', '广州无添加主义化妆品有限公司', '内贸', '11', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14982, '纤维', '2022-07-05', '荧光增白纤维', '王亚第', '13006013500', '20220705', '张怡静', '海南欣龙无纺股份有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14983, '无纺布', '2022-07-11', '55g针刺或热风压花 ', '张海明', '15857192851 ', '20220711', '顾怡青', '湖州嘉丝新材料科技有限公司', '内贸', '20', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14984, '无纺布', '2022-07-11', '短纤热风复合', '张海明', '15857192851 ', '20220711', '顾怡青', '湖州嘉丝新材料科技有限公司', '内贸', '18', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14985, '纤维', '2022-07-12', '超吸水纤维', '丁小棠', '0086 18515978655', '20220712', '张怡静', 'TAL公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14986, '无纺布制品', '2022-07-20', '拖地布', '赵晓芹', '18941331010', '20220720', '顾怡青', '大连蓝赛斯无纺布制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14987, '无纺', '2022-07-25', '2.LG-圆形拖地布15cm LG-circular Wet wipes 16cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', 'TS Global.co.,Ltd  ', '出口', '12400', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14988, '无纺', '2022-07-25', '3.LG-圆形拖地布15cm LG-circular Wet wipes 17cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', 'TS Global.co.,Ltd  ', '出口', '12400', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14989, '无纺', '2022-07-25', '4.LG-圆形拖地布15cm LG-circular Wet wipes 18cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', 'TS Global.co.,Ltd  ', '出口', '12400', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14990, '无纺', '2022-07-25', '5.LG-圆形拖地布15cm LG-circular Wet wipes 19cm', '朴新彦', '82-2-2-93-6616', '20220613', '郑静', 'TS Global.co.,Ltd  ', '出口', '12400', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14991, '纤维', '2022-07-27', '荧光增白纤维', '王亚第', '13006013500', '20220705', '张怡静', '海南欣龙无纺股份有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14992, '纤维', '2022-07-27', '竹纤维', '王亚第', '13006013500', '20220705', '张怡静', '海南欣龙无纺股份有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14993, '纤维', '2022-07-29', '丙纶黑色纤维', '李斌', '13064008667', '20220729', '张怡静', '济南德宝瑞新材料有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14994, '会员入驻', '2022-08-02', '无纺普通会员', '陈成', '13980651397', '20220802', '郁新涛', '四川省宜宾市屏山镇工场产业区5号块地', '服务', '0.17万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14995, '会员入驻', '2022-08-02', '无纺臻享会员', '宋卫民', '0512-58490086', '20220802', '郁新涛', '张家港市凤凰镇凤凰科技创业园D栋3楼', '服务', '0.56万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14996, '会员入驻', '2022-08-02', '无纺黄金会员', '蔡雪', '0316-6086146', '20220802', '郁新涛', '河北廊坊经济技术开发区汇源路8号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14997, '会员入驻', '2022-08-02', '无纺臻享会员', '刘小姐', '0512-82608888', '20220802', '郁新涛', '巴城镇正仪通澄南路2号2、3号房', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14998, '会员入驻', '2022-08-05', '无纺会员', '施国章', '13921296168', '20220805', '郁新涛', '无锡市锡山区锡北镇工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (14999, '会员入驻', '2022-08-05', '无纺会员', '潘全志', '15905261976', '20220805', '郁新涛', '江阴市周庄镇澄杨路1108号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15000, '会员入驻', '2022-08-05', '无纺会员', 'ITOH SHINJI（伊藤绅司）', '17751171503', '20220805', '郁新涛', '常熟经济技术开发区兴达路9号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15001, '广告', '2022-08-05', '无纺广告', '孙提兵', '13812827390', '20220805', '郁新涛', '常熟市支塘镇枫塘村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15002, '广告', '2022-08-05', '无纺广告', '周亚刚', '13901578793', '20220805', '郁新涛', '常熟市支塘镇徐政村东陆泾100号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15003, '广告', '2022-08-05', '无纺广告', '谢锡华', '13861527301', '20220805', '郁新涛', '宜兴市芳桥街道工业园', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15004, '纤维', '2022-08-08', '灰色阻燃丙纶', '杨阳', '15371059176', '20220808', '张怡静', '无锡市汉仑纤网新材料有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15005, '无纺', '2022-08-08', '扫地机器人湿巾Wet wipes', '待确认', 'Tel:903423373030,FAX:903423373035', '20220808', '郑静', 'BAYTEKS TEKSTIL SAN VE TIC.A.S.', '出口', '12000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15006, '无纺', '2022-08-08', '扫地机器人湿巾Wet wipes', '待确认', 'Tel:.4170469751000,Fax:417046975116', '20220808', '郑静', 'BERRY PLASTICS CORPORATION', '出口', '12000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15007, '无纺', '2022-08-08', '扫地机器人湿巾Wet wipes', '待确认', 'Tel-43905589511019,Fax:81390558953159', '20220808', '郑静', 'DELLORCO VILLANI SRL', '出口', '12000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15008, '无纺', '2022-08-08', '扫地机器人湿巾Wet wipes', '待确认', 'Te:44413074522000Fax1441307452300', '20220808', '郑静', 'DON LOW LTD.', '出口', '12000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15009, '会员入驻', '2022-08-08', '无纺会员', '陈越', '13615246456', '20220808', '郁新涛', '仪征市真州镇浦西路168号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15010, '会员入驻', '2022-08-08', '无纺会员', '倪若昕', '13390830171', '20220808', '郁新涛', '常州市金坛区金城镇工业集中区西城路127号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15011, '会员入驻', '2022-08-08', '无纺会员', '汪学勤', '15371233498', '20220808', '郁新涛', '江苏滨海经济开发区工业园南区人民南路延伸段南绿丰公司西侧', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15012, '广告', '2022-08-08', '无纺广告', '薛秋琴', '15961513230', '20220808', '郁新涛', '江阴市青阳镇西庄路26号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15013, '广告', '2022-08-08', '无纺广告', '刘尊良', '13270360766', '20220808', '郁新涛', '沛县经济开发区汉康路西侧', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15014, '广告', '2022-08-08', '无纺广告', '薛海翔', '18260663568', '20220808', '郁新涛', '仪征市新城镇工业集中区', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15015, '无纺', '2022-08-09', '扫地机器人湿巾Wet wipes', '待确认', 'TEL:9032239444700 FAX:4903223944473', '20220809', '郑静', 'APEKS DOKUSUZ ORGUSUZ TEKNIK TEKSTIL DESTEK HIZMETLERI SANA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15016, '无纺', '2022-08-09', '扫地机器人湿巾Wet wipes', '待确认', 'Tel.4412784285000    Fax:4441278429499', '20220809', '郑静', 'BFF TECHNICAL FABRICS', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15017, '无纺', '2022-08-09', '扫地机器人湿巾Wet wipes', '待确认', 'Tel.926124046456', '20220809', '郑静', 'BONAR NATPET CO.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15018, '会员入驻', '2022-08-09', '无纺会员', '史张华', '18796503909', '20220809', '郁新涛', '东台市通榆北路188号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15019, '会员入驻', '2022-08-09', '无纺会员', '龙生', '13906233480', '20220809', '郁新涛', '常熟市支塘镇任阳常盛工业园', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15020, '会员入驻', '2022-08-09', '无纺会员', '张兴华', '13773779898', '20220809', '郁新涛', '如皋市如城镇惠政东路58号', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15021, '广告', '2022-08-09', '无纺广告', '葛亮', '13605276420', '20220809', '郁新涛', '仪征市新城镇工业集中区81号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15022, '广告', '2022-08-09', '无纺广告', '何继文', '17312802849', '20220809', '郁新涛', '涟水县徐集乡政府办公楼二楼208室', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15023, '广告', '2022-08-09', '无纺广告', '邬海滨', '15250138005', '20220809', '郁新涛', '江苏省昆山市淀山湖镇淀兴路南侧', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15024, '广告', '2022-08-09', '无纺广告', '李建立', '13968088345', '20220809', '郁新涛', '浙江省杭州市余杭区东湖街道东湖北路488-1号12幢101、201、301、401、501室', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15025, '纤维', '2022-08-10', '针刺涤纶2D*51mm', '相总', '18261566276', '20220810', '张怡静', '莱德尔工业纺织品有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15026, '纤维', '2022-08-10', '灰色阻燃丙纶', '杨阳', '15371059176', '20220810', '张怡静', '无锡市汉仑纤网新材料有限公司', '内贸', '12.5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15027, '纤维', '2022-08-10', '黑色ES纤维', '黄智昌', '18067921188', '20220810', '张怡静', '上海洁丝纺织科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15028, '纤维', '2022-08-10', '针刺涤纶2D*51mm', '相总', '18261566276', '20220810', '张怡静', '莱德尔工业纺织品有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15029, '无纺', '2022-08-10', '拖地布Wet wipes', '待确认', 'TEL:390295307005·                       FAX：390295307120', '20220810', '郑静', 'DEATEX SRL', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15030, '无纺', '2022-08-10', '拖地布Wet wipes', '待确认', 'Tel:861060211816  FXA:861060218876', '20220810', '郑静', 'D-TEX (BEIJING)NONWOVENS CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15031, '无纺', '2022-08-10', '拖地布Wet wipes', '待确认', 'TEL:903423570720  FAX:903423570723', '20220810', '郑静', 'ERUSLU TEKSTIL SANAYI VE TICARET A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15032, '无纺', '2022-08-10', '拖地布Wet wipes', '待确认', 'TeL:3905734455010    FAX:3906579534440', '20220810', '郑静', 'FA-MA JERSEY SPA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15033, '无纺', '2022-08-10', '拖地布Wet Wipes,ML SSAK-01,21CM，大浅蓝', '订货中', 'TEL: +032-577-4541', '20220810', '郑静', 'MAILIVING', '出口', '3800', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15034, '无纺', '2022-08-10', '拖地布Wet Wipes,ML SSAK-01,21CM，大浅蓝', '订货中', 'TEL: +032-577-4541', '20220810', '郑静', 'MAILIVING', '出口', '3000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15035, '无纺', '2022-08-10', '拖地布Wet Wipes,ML SSAK-02,16.5CM，大浅绿', '订货中', 'TEL: +032-577-4541', '20220810', '郑静', 'MAILIVING', '出口', '1200', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15036, '无纺', '2022-08-10', '拖地布Wet Wipes,ML SSAK-02,16.5CM，大浅绿', '订货中', 'TEL: +032-577-4541', '20220810', '郑静', 'MAILIVING', '出口', '1900', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15037, '无纺', '2022-08-10', '拖地布Wet Wipes,ML SSAK-01,15CM，大浅蓝', '订货中', 'TEL: +032-577-4541', '20220810', '郑静', 'MAILIVING', '出口', '2000', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15038, '会员入驻', '2022-08-10', '无纺会员', '刘海兵', '18651388566', '20220810', '郁新涛', '如皋市城北街道友谊路10号', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15039, '会员入驻', '2022-08-10', '无纺会员', '孙福文', '15862878506', '20220810', '郁新涛', '高邮市卸甲镇伯勤村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15040, '会员入驻', '2022-08-10', '无纺会员', '陈凤珠', '13952530205', '20220810', '郁新涛', '扬州市江都区仙女镇张纲工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15041, '广告', '2022-08-10', '无纺广告', '张维荣', '13301581958', '20220810', '郁新涛', '南京市溧水经济开发区秀山中路9号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15042, '广告', '2022-08-10', '无纺广告', '陆陈凌', '13962418013', '20220810', '郁新涛', '城厢镇工业园弇山西路', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15043, '广告', '2022-08-10', '无纺广告', '王慧', '18896608550', '20220810', '郁新涛', '常熟市支塘镇任阳蒋巷村', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15044, '纤维', '2022-08-11', '水刺专用PP纤维', '张圣来', '13809154803', '20220811', '张怡静', ' 泰州市金盛无纺布厂', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15045, '纤维', '2022-08-11', '水刺专用PP纤维', '承惠兴', '13901524253', '20220811', '张怡静', ' 江阴市光大无纺布业有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15046, '无纺', '2022-08-11', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:18649675600       fax:18649675621', '20220811', '郑静', 'FITESA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15047, '无纺', '2022-08-11', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel.44925511400·Fax:4492551140140', '20220811', '郑静', 'GEORGIA-PACIFIC STEINFURT GMBH', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15048, '无纺', '2022-08-11', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel：49938986690                                             .FAX:44903398669212121', '20220811', '郑静', 'GLATFELTER ADVANCED MATERIALS N.A.LLC', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15049, '无纺', '2022-08-11', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:85227930373        Fax:185227933141', '20220811', '郑静', 'GOLDEN STARRY,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15050, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '19121530040', '20220811', '郁新涛', '中国（上海）自由贸易试验区碧波路888号1幢1层103室-166', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15051, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '18166892191', '20220811', '郁新涛', '杭州经济技术开发区20号大街552号', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15052, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '13916446967', '20220811', '郁新涛', '上海市松江区洞泾镇莘砖公路3366号3幢6层606、607室', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15053, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '15380010909', '20220811', '郁新涛', '常州市金坛区恒泰路2号', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15054, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '13912231798', '20220811', '郁新涛', '南通市海门区四甲镇富强路86号', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15055, '会员入驻', '2022-08-11', '无纺会员', '0.67万元', '15618033876', '20220811', '郁新涛', '上海市嘉定区真南路4268号2幢J15372室', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15056, '纤维', '2022-08-12', '水刺专用PP纤维', '高明东', '1895575785', '20220812', '张怡静', ' 安徽德邦无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15057, '纤维', '2022-08-12', '针刺涤纶2D*51mm', '相总', '18261566276', '20220812', '张怡静', '江苏艾文德莱无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15058, '纤维', '2022-08-12', '水刺专用PP纤维', '张兴华', '13773779898', '20220812', '张怡静', '南通豪杰无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15059, '会员入驻', '2022-08-12', '无纺会员', '王华峰', '17715387217', '20220812', '郁新涛', '常熟市支塘镇任阳晋阳西街125号', '服务', '1.2万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15060, '会员入驻', '2022-08-12', '无纺会员', '程学伟', '13906244209', '20220812', '郁新涛', '江苏省苏州市常熟市支塘镇任阳常盛工业园', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15061, '会员入驻', '2022-08-12', '无纺会员', '钱耀新', '13506234987', '20220812', '郁新涛', '常熟市支塘镇任阳环镇南路', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15062, '会员入驻', '2022-08-12', '无纺会员', '庄朔', '15751798857', '20220812', '郁新涛', '武进区遥观镇洪庄村', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15063, '会员入驻', '2022-08-12', '无纺会员', '周围', '13906815729', '20220812', '郁新涛', '常州市武进区遥观镇', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15064, '会员入驻', '2022-08-12', '无纺会员', '李仲连', '13605845139', '20220812', '郁新涛', '浙江省慈溪市宗汉工业区（兴园路65号）', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15065, '会员入驻', '2022-08-12', '无纺会员', '孙立', '13136149680', '20220812', '郁新涛', '浙江省杭州市富阳区新登镇过河滩', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15066, '纤维', '2022-08-15', '水刺专用PP纤维', '赵民忠', '13967348118', '20220815', '张怡静', ' 嘉兴纤思无纺科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15067, '纤维', '2022-08-15', '水刺专用PP纤维', '马显斌', '15885286888', '20220815', '张怡静', ' 江苏博盾环保无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15068, '纤维', '2022-08-15', '水刺专用PP纤维', '李忠辉', '18952586718', '20220815', '张怡静', '仪征市辉腾无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15069, '无纺', '2022-08-15', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:865223823033339      Fax:8652382303316', '20220815', '郑静', 'JIANGSU RUIYU HOSPITAL PRODUCTS CO,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15070, '无纺', '2022-08-15', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:48343515600  FAX:48343515602', '20220815', '郑静', 'LENTEX SA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15071, '无纺', '2022-08-15', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:862139908327. Fax:862139908325', '20220815', '郑静', 'MASCOT NONWOVEN GROP', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15072, '无纺', '2022-08-15', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:9034233714999                                    Fax:903423371413', '20220815', '郑静', 'MOGUL NONWOVENS COMPOSITES TEKSTIL SAN.VE TIC.LTD STI.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15073, '无纺', '2022-08-15', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:88676116616                          Fax:+88676110231', '20220815', '郑静', 'NAN LIU ENTERPRISE CO.LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15074, '无纺', '2022-08-16', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:486845612159 Fax:448684561230', '20220816', '郑静', 'NOVITA SA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15075, '无纺', '2022-08-16', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:3752342949720                         Fax:+375234270270', '20220816', '郑静', 'OJSC \"SVETLOGORSK KHIMVOLOKNO\"', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15076, '无纺', '2022-08-16', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:902124483410                               Fax:902124451999', '20220816', '郑静', 'RENKSAN PLASTIK SUNGER SAN.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15077, '无纺', '2022-08-16', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:9021278927900   Fax:902127892793', '20220816', '郑静', 'SALTEKS TEKSTIL SANAYI VE TICARET AS', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15078, '会员入驻', '2022-08-16', '无纺会员', '吴岳', '18268068123', '20220816', '郁新涛', '吉安市高新区京九大道与火炬大道东交叉处', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15079, '会员入驻', '2022-08-16', '无纺会员', '张磊', '17712891988', '20220816', '郁新涛', '洪泽县工业园区东三街东侧', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15080, '会员入驻', '2022-08-16', '无纺会员', '聂祖宝', '13799114542', '20220816', '郁新涛', '福建省南平市延平区安丰路63号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15081, '会员入驻', '2022-08-16', '无纺会员', '廖翱清', '1360221481', '20220816', '郁新涛', '广州市从化城郊街大夫田工业区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15082, '广告', '2022-08-16', '官网广告', '温明', '13961696096', '20220816', '郁新涛', '江阴市青阳镇西庄路26号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15083, '广告', '2022-08-16', '官网广告', '石中秋', '13799851882', '20220816', '郁新涛', '晋江市五里工业园区', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15084, '纤维', '2022-08-16', '无纺专用涤纶', '孙福文', '15862878506', '20220816', '张怡静', '扬州市联合无纺布材料厂', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15085, '纤维', '2022-08-16', '无纺专用涤纶', '薛永来', '15968715577', '20220816', '张怡静', '浙江广得利无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15086, '纤维', '2022-08-16', '无纺专用涤纶', '李荣法', '13928285227', '20220816', '张怡静', ' 宜兴市利隆无纺材料制品有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15087, '纤维', '2022-08-17', '无纺专用涤纶', '陈凤珠', '13952530205', '20220817', '张怡静', '扬州荣伟无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15088, '纤维', '2022-08-17', '无纺专用涤纶', '郭东元', '18749178378', '20220817', '张怡静', '新乡市昌源无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15089, '纤维', '2022-08-17', '无纺专用涤纶', '方萝成', '13588122467', '20220817', '张怡静', '杭州保舒康无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15090, '无纺', '2022-08-17', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:927246947856                    Fax:97246949728', '20220817', '郑静', 'SHALAG INDUSTRIES LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15091, '无纺', '2022-08-17', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:358290074370', '20220817', '郑静', 'SHARPCELL OY', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15092, '无纺', '2022-08-17', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:.273153887000  Fax:27315023157', '20220817', '郑静', 'SPUNCHEM INTERNATIONAL', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15093, '无纺', '2022-08-17', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:13363309003 Fax:13363309019', '20220817', '郑静', 'N.R.SPUNTECH INDUSTRIES,INC.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15094, '会员入驻', '2022-08-17', '无纺会员', '马青燕', '13505731370', '20220817', '郁新涛', '浙江省嘉兴市平湖市新仓镇仓东路1168号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15095, '会员入驻', '2022-08-17', '无纺会员', '梁晓燕', '15157701395', '20220817', '郁新涛', '浙江省温州市瑞安市南滨街道阁巷新区东三路155号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15096, '会员入驻', '2022-08-17', '无纺会员', '高璟', '13405533538', '20220817', '郁新涛', '江苏省泰州经济开发区滨江工业园', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15097, '会员入驻', '2022-08-17', '无纺会员', '胡俊杰', '13611946969', '20220817', '郁新涛', '上海市金山区枫泾镇建贡路88号3幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15098, '会员入驻', '2022-08-17', '无纺会员', '王俊', '13901766668', '20220817', '郁新涛', '嘉定区华江路720号4幢2区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15099, '会员入驻', '2022-08-17', '无纺会员', '廖自余', '13761504972', '20220817', '郁新涛', '上海市嘉定区徐行镇嘉行公路1308号3幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15100, '无纺', '2022-08-18', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:8651252588861·Fax:8651252588865', '20220818', '郑静', 'SUZHOU MESON NONWOVEN TECHNOLOGY CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15101, '无纺', '2022-08-18', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:886225925928                    fax:886225954788', '20220818', '郑静', 'TAIWAN SPUNLACE (GROUP)CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15102, '无纺', '2022-08-18', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:82317988261                             fax+82317988264', '20220818', '郑静', 'TEXKOR INDUSTRIES', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15103, '无纺', '2022-08-18', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:34969590412  fax:434969592403', '20220818', '郑静', 'TEXTISOL S.L.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15104, '会员入驻', '2022-08-18', '无纺会员', '石中秋', '13799851882', '20220818', '郁新涛', '晋江五里工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15105, '会员入驻', '2022-08-18', '无纺会员', '温明', '13961696096', '20220818', '郁新涛', '江阴市青阳西庄路26号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15106, '会员入驻', '2022-08-18', '无纺会员', '张磊', '17712891988', '20220818', '郁新涛', '洪泽工业园区东三街东侧', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15107, '会员入驻', '2022-08-18', '无纺会员', '杨洪忠', '13301528718', '20220818', '郁新涛', '江阴市镇澄路1499号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15108, '会员入驻', '2022-08-18', '无纺会员', '吴岳', '18268068123', '20220818', '郁新涛', '吉安高新区京九大道与火炬大道东交叉处', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15109, '会员入驻', '2022-08-18', '无纺会员', '马文渊', '13706711552', '20220818', '郁新涛', '浙江省杭州市临安区太湖源镇南庄村南庄351号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15110, '纤维', '2022-08-18', '无纺专用涤纶', '王怀孝', '13815495505', '20220818', '张怡静', ' 江苏怀静无纺布包装袋有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15111, '纤维', '2022-08-18', '无纺专用涤纶', '黄建威', '13912660077', '20220818', '张怡静', ' 昆山胜昱无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15112, '纤维', '2022-08-18', '无纺专用涤纶', '陈立江', '13588223556', '20220818', '张怡静', '     杭州四茂无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15113, '纤维', '2022-08-19', '无纺专用涤纶', '严云龙', '13567806786', '20220819', '张怡静', '宁波泉兴无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15114, '纤维', '2022-08-19', '无纺专用涤纶', '徐旭泽', '13901968518', '20220819', '张怡静', '嘉兴尚誉无纺布科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15115, '纤维', '2022-08-19', '无纺专用涤纶', '徐香农', '13868062151', '20220819', '张怡静', '杭州超友无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15116, '无纺', '2022-08-19', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:302109875042. Fax3022106875040', '20220819', '郑静', 'THRACE NONWOVENS GEOSYNTHETICS S.A.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15117, '无纺', '2022-08-19', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:82232791233 fax:82232791415', '20220819', '郑静', 'TORAY ADVANCED MATERIALS KOREA INC.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15118, '无纺', '2022-08-19', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:88673553611                          fax:88673582091', '20220819', '郑静', 'WEB-PRO CORPORATION', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15119, '无纺', '2022-08-19', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:912266136000.  Fax:912224908020', '20220819', '郑静', 'WELSPUN INDIA LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15120, '会员入驻', '2022-08-19', '无纺会员', '薛永来', '15968715577', '20220819', '郁新涛', '浙江青田县船寮镇赤岩工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15121, '会员入驻', '2022-08-19', '无纺会员', '邵', '13575462211', '20220819', '郁新涛', '浙江省杭州市富阳区春江街道八一村八一工业区5号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15122, '会员入驻', '2022-08-19', '无纺会员', '赵民忠', '13967348118', '20220819', '郁新涛', '浙江省嘉兴市南湖区新丰镇新禾路177号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15123, '广告', '2022-08-19', '制品广告', '朱国涛', '18852439101', '20220819', '郁新涛', '常熟市支塘镇枫塘村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15124, '广告', '2022-08-19', '制品广告', '柏春林', '13852400039', '20220819', '郁新涛', '淮安市淮安区上河镇工业园区', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15125, '广告', '2022-08-19', '制品广告', '卢子峻', '18675597791', '20220819', '郁新涛', '金湖县陈桥镇工业集中区金桥路南侧1号、2号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15126, '纤维', '2022-08-22', '无纺专用涤纶', '王志昆', '18553327308', '20220822', '张怡静', '山东久和无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15127, '纤维', '2022-08-22', '无纺专用涤纶', '施上海', '13799581773', '20220822', '张怡静', '泉州市三胜无纺科技有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15128, '纤维', '2022-08-22', '无纺专用涤纶', '李熹', '15957327366', '20220822', '张怡静', '浙江富瑞森水刺无纺布有限公司', '内贸', '8', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15129, '无纺', '2022-08-22', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:903423373030     FAX:903423373035', '20220822', '郑静', 'BAYTEKS TEKSTIL SAN VE TIC.A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15130, '无纺', '2022-08-22', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:8672826296660 Fax:867282622202', '20220822', '郑静', 'CHTC JIAHUA NONWOVEN CO.,LTD', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15131, '无纺', '2022-08-22', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:441307452200   Fax441307452300', '20220822', '郑静', 'DON&LOW LTD', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15132, '无纺', '2022-08-22', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:903423570720. FX4903423570723', '20220822', '郑静', 'ERUSLU TEKSTIL SANAYI VE TICARET A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15133, '无纺', '2022-08-23', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:488676116616·Fax:488676110231', '20220823', '郑静', 'NAN LIU ENTERPRISE CO.LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15134, '无纺', '2022-08-23', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:8675528016860.    Fax:8675528016996', '20220823', '郑静', 'NATIONAL BRIDGE INDUSTRIAL (S.Z.)CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15135, '无纺', '2022-08-23', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:903423295060·FAX:903423290970', '20220823', '郑静', 'RITAS KIMYA VE TEKSTIL SAN.TIC.A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15136, '无纺', '2022-08-23', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:14147606232                                   .Fax:9414147602841', '20220823', '郑静', 'SELLARS NONWOVENS', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15137, '会员入驻', '2022-08-23', '无纺会员', '朱家裕', '13773257502', '20220823', '郁新涛', '张家港市杨舍镇双鹿村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15138, '会员入驻', '2022-08-23', '无纺会员', '马显斌', '15885286888', '20220823', '郁新涛', '常熟市虞山镇燕巷村工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15139, '会员入驻', '2022-08-23', '无纺会员', '李忠辉', '18952586718', '20220823', '郁新涛', '仪征市马集镇工业集中区三号路九号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15140, '会员入驻', '2022-08-23', '无纺会员', '刘欢', '18668052266', '20220823', '郁新涛', '浙江省杭州市富阳区春江街道八一村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15141, '会员入驻', '2022-08-23', '无纺会员', '倪乐绵', '13587444567', '20220823', '郁新涛', '苍南县括山乡尤家园村18-22号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15142, '会员入驻', '2022-08-23', '无纺会员', '蔡省卫', '13429670299', '20220823', '郁新涛', '浙江省湖州市德清县禹越镇星河路23号2号厂房2楼', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15143, '广告', '2022-08-23', '制品广告', '宋光超', '18071697092', '20220823', '郁新涛', '泗阳县卢集镇成子湖路全民创业园', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15144, '广告', '2022-08-23', '制品广告', '袁明祥', '13806519819', '20220823', '郁新涛', '杭州富阳区富春街道青云桥村高畈131号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15145, '广告', '2022-08-23', '制品广告', '蔡鹏', '15868813248', '20220823', '郁新涛', '浙江省杭州市临安区太湖源镇金岫村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15146, '广告', '2022-08-23', '制品广告', '褚伟新', '13600567391', '20220823', '郁新涛', '浙江省嘉兴市海宁市周王庙镇之江路22号3号车间', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15147, '广告', '2022-08-23', '制品广告', '俞冬仙', '13906753222', '20220823', '郁新涛', '浙江省绍兴市越城区迪荡街道国茂大厦1701室-9(承诺申报)', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15148, '广告', '2022-08-23', '制品广告', '丁小勇', '15312241228', '20220823', '郁新涛', '无锡市新吴区梅村金城东路493号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15149, '无纺', '2022-08-24', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:45963535350                             Fax:+4598158555', '20220824', '郑静', 'FIBERTEX NONWOVENS A/S', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15150, '无纺', '2022-08-24', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TEL:4487740463409 FAX:48775430235', '20220824', '郑静', 'MARCHEM SP.ZO.O', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15151, '无纺', '2022-08-24', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TEL:88634861317    FAX:88634638346', '20220824', '郑静', 'MYTREX HEALTH TECHNOLOGIES,INC.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15152, '无纺', '2022-08-24', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:497289920444                            Fax:497289920164', '20220824', '郑静', 'NOAM URIM ENTERPRISES LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15153, '会员入驻', '2022-08-24', '无纺会员', '李熹', '15957327366', '20220824', '郁新涛', '浙江省嘉兴市新丰工业园', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15154, '会员入驻', '2022-08-24', '无纺会员', '黄建威', '13912660077', '20220824', '郁新涛', '江苏省昆山市陆家镇合丰村陆丰西路134号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15155, '会员入驻', '2022-08-24', '无纺会员', '陈立江', '13588223556', '20220824', '郁新涛', '杭州萧山区党山镇工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15156, '广告', '2022-08-24', '制品广告', '张雪峰', '15366246192', '20220824', '郁新涛', '常熟市支塘镇任阳工业园迎阳大道115号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15157, '广告', '2022-08-24', '制品广告', '王卫中', '13506242869', '20220824', '郁新涛', '常熟市支塘镇任阳常盛工业区', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15158, '广告', '2022-08-24', '制品广告', '王雪平', '13067972433', '20220824', '郁新涛', '浙江省嘉兴市桐乡市洲泉镇鞋业特色园区1、2幢', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15159, '会员入驻', '2022-08-25', '无纺会员', '陈海华', '13973088378', '20220825', '郁新涛', '浙江嘉兴新丰镇万丰路口', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15160, '会员入驻', '2022-08-25', '无纺会员', '徐旭泽', '13901968518', '20220825', '郁新涛', '浙江省嘉兴市嘉善县姚庄镇桃源路115号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15161, '会员入驻', '2022-08-25', '无纺会员', '徐香农', '13868062151', '20220825', '郁新涛', '杭州市余杭区于河街道圣塘河村3-4幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15162, '广告', '2022-08-25', '制品广告', '姚永', '17712691066', '20220825', '郁新涛', '太仓市开发区太胜工业区', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15163, '广告', '2022-08-25', '制品广告', '翁子翔', '13906231755', '20220825', '郁新涛', '常熟市支塘镇任阳徐政村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15164, '广告', '2022-08-25', '制品广告', '易元满', '13301568981', '20220825', '郁新涛', '张家港保税区北京西路龙港厂房二楼', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15165, '无纺', '2022-08-26', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:39083160911219 Fax:1390331604646', '20220826', '郑静', 'ORSA N.W.SRL', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15166, '无纺', '2022-08-26', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:34937706060 fax:34487706062', '20220826', '郑静', 'TEFISA-TELAS Y FABRICADOS NO TEJIDOS SA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15167, '无纺', '2022-08-26', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:349955904129 Fax:34965592409', '20220826', '郑静', 'TEXTISOL S.L.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15168, '无纺', '2022-08-26', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:33477608222', '20220826', '郑静', 'ADDEV MATERIALS (FRANCE DECOUPE)', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15169, '会员入驻', '2022-08-26', '无纺会员', '刘正顺', '13816575425', '20220826', '郁新涛', '上海市青浦区金泽镇西岑社区莲西公路4432号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15170, '会员入驻', '2022-08-26', '无纺会员', '严信尧', '\n13901996212', '20220826', '郁新涛', '上海市松江科技园区青云街58号A区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15171, '会员入驻', '2022-08-26', '无纺会员', '严什香', '\n13916048085', '20220826', '郁新涛', '上海市金山区兴塔镇工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15172, '广告', '2022-08-26', '制品广告', '曹秀珍', '15251032998', '20220826', '郁新涛', '阜宁经济开发区顾庄居委会五组', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15173, '广告', '2022-08-26', '制品广告', '罗京亚', '13813122099', '20220826', '郁新涛', '仪征市大连路88号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15174, '广告', '2022-08-26', '制品广告', '蒋小萍', '13868172237', '20220826', '郁新涛', '浙江省杭州市富阳区场口镇创业路10号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15175, '无纺', '2022-08-29', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:33477608222', '20220829', '郑静', 'ADDEV MATERIALS (FRANCE DECOUPE)', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15176, '无纺', '2022-08-29', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:359626115159 Fax:435962611556', '20220829', '郑静', 'EXTRAPACK OOD', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15177, '无纺', '2022-08-29', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:39058321409 Fax:390283299061', '20220829', '郑静', 'LUCART SPA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15178, '无纺', '2022-08-29', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:85227246078. fax:85223698779', '20220829', '郑静', 'US.PACIFIC NONWOVENS INDUSTRY LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15179, '会员入驻', '2022-08-29', '无纺会员', '王锦涛', '\n13901959177', '20220829', '郁新涛', '上海市松江区车墩镇车亭公路59号-3', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15180, '会员入驻', '2022-08-29', '无纺会员', '李玉洁', '\n15216676796', '20220829', '郁新涛', '上海市青浦区白鹤镇外青松公路3560号4号楼2层东裙楼A区2474室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15181, '会员入驻', '2022-08-29', '无纺会员', '吴大弟', '\n15067362913', '20220829', '郁新涛', '上海市金山区枫泾镇环东一路65弄3号1789室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15182, '广告', '2022-08-29', '制品广告', '马奇洪', '18668067083', '20220829', '郁新涛', '浙江省杭州市临安区青山湖街道安村村姜家2号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15183, '广告', '2022-08-29', '制品广告', '王佐华', '13906665836', '20220829', '郁新涛', '平阳县鳌江镇包岙内村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15184, '广告', '2022-08-29', '制品广告', '薛祥林', '13952720587', '20220829', '郁新涛', '扬州市杭集工业园', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15185, '无纺', '2022-08-30', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:9202127710006  Fax:902127710908', '20220830', '郑静', 'KARYA KIMYA TEKSTIL SAN IC VE DIS TIC LTD STI', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15186, '无纺', '2022-08-30', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Te1.3256608071', '20220830', '郑静', 'BEWIMA N.V.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15187, '无纺', '2022-08-30', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:966133407202·Fax:966183407209', '20220830', '郑静', 'MADA NONWOVENS', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15188, '无纺', '2022-08-30', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:+886348613179                   Fax:+88634638346', '20220830', '郑静', 'MYTREX HEALTH TECHNOLOGIES,INC.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15189, '会员入驻', '2022-08-30', '无纺会员', '刘红国', '\n13917753535', '20220830', '郁新涛', '浦东新区浦星公路69号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15190, '会员入驻', '2022-08-30', '无纺会员', '高剑峰', '\n13311725569', '20220830', '郁新涛', '上海市金山区山阳镇红旗东路269号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15191, '会员入驻', '2022-08-30', '无纺会员', '朱丽萍', '\n18321508169', '20220830', '郁新涛', '上海市宝山区市一路169号4楼4006室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15192, '广告', '2022-08-30', '制品广告', '游景亮', '18020290955', '20220830', '郁新涛', '江阴市镇澄路2268号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15193, '广告', '2022-08-30', '制品广告', '王小虎', '13961472830', '20220830', '郁新涛', '武进区雪堰镇王允村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15194, '广告', '2022-08-30', '制品广告', '孙自永', '13914094101', '20220830', '郁新涛', '常熟市支塘镇任阳晋阳西街4号104', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15195, '无纺', '2022-08-31', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:496201805394', '20220831', '郑静', 'FREUDENBERG PERFORMANCE MATERIALS SE& CO.KG', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15196, '无纺', '2022-08-31', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:49463696660. Fax:4946969696660', '20220831', '郑静', 'TEUJIN FRONTIER EUROPE GMBH', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15197, '无纺', '2022-08-31', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:902166517640     Fax:902166517644', '20220831', '郑静', 'ATILIM ORME SANAYI VE DIS TIC.A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15198, '无纺', '2022-08-31', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TEL:135962611515  Fax:35962611556', '20220831', '郑静', 'EXTRAPACK OOD', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15199, '会员入驻', '2022-08-31', '无纺会员', '范峰', '\n13564626886', '20220831', '郁新涛', '上海市金山区枫泾镇潮枫路2516号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15200, '会员入驻', '2022-08-31', '无纺会员', '陆晓江', '\n13918066004', '20220831', '郁新涛', '上海市青浦区练东村泖口1号10幢2层P区204室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15201, '会员入驻', '2022-08-31', '无纺会员', '周伯满', '\n13023149284', '20220831', '郁新涛', '嘉定区南翔镇嘉美路1988号2幢2164室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15202, '广告', '2022-08-31', '制品广告', '何清', '13773053815', '20220831', '郁新涛', '常熟市沙家浜镇工业园区E区中天路', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15203, '广告', '2022-08-31', '制品广告', '蒋其彬', '13812834121', '20220831', '郁新涛', '常熟市支塘镇双黄路', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15204, '广告', '2022-08-31', '制品广告', '杨雪忠', '15062614051', '20220831', '郁新涛', '常熟市支塘镇开发区南园区4幢', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15205, '无纺', '2022-09-01', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:862036856298                             Fax:862036856398', '20220901', '郑静', 'GUANGDONG YIZHOU ADVANCED MATERIALS TECHNOLOGY CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15206, '无纺', '2022-09-01', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:8602086796140              FAX:8662086791649', '20220901', '郑静', 'GUANGZHOU JINSHENG HUIHUANG NON-WOVEN FABRIC INDUSTRIAL CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15207, '无纺', '2022-09-01', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:334422776244                             Fax:33442275472', '20220901', '郑静', 'JX NIPPON ANCI SAS', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15208, '无纺', '2022-09-01', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:903423374570                                  FaX:490342337.4579', '20220901', '郑静', 'KURT KUMAS SAN.VE TIC.A.S.-WOLFBOND', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15209, '会员入驻', '2022-09-01', '无纺会员', '方志祥', '\n13681948975', '20220901', '郁新涛', '上海市金山区枫泾镇潮枫路2516号4幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15210, '会员入驻', '2022-09-01', '无纺会员', '陈周', '\n13917538288', '20220901', '郁新涛', '沪太路1128号A4-33室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15211, '会员入驻', '2022-09-01', '无纺会员', '孟关寿', '\n13901639737', '20220901', '郁新涛', '上海市奉贤区庄行镇大叶公路2058弄35号第1幢1车间', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15212, '广告', '2022-09-01', '制品广告', '钱晓晨', '13196616779', '20220901', '郁新涛', '常熟市支塘镇任阳丰联村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15213, '广告', '2022-09-01', '制品广告', '李俊', '13295192981', '20220901', '郁新涛', '常熟市支塘镇任阳丰联村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15214, '广告', '2022-09-01', '制品广告', '杨超', '15805126366', '20220901', '郁新涛', '东海县经济开发区北区、顺发路北、兴辰路西侧', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15215, '无纺', '2022-09-02', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:48178506600·Fax:48178506613', '20220902', '郑静', 'MARMA POLSKIE FOLIE SP.ZO.O.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15216, '无纺', '2022-09-02', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:+212522584076                     fax：+212522584076', '20220902', '郑静', 'MICAGRICOL', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15217, '无纺', '2022-09-02', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:8651385351190·fax:8651385106730', '20220902', '郑静', 'NANTONG GATHER EXCELLENCE-CLEANING MEDICAL MATERIAL CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15218, '无纺', '2022-09-02', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'tel:902124380242·fax:902124380248', '20220902', '郑静', 'NURTEKS TEKSTIL VE MEDICAL DIS.TIC.A.S.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15219, '会员入驻', '2022-09-02', '无纺会员', '唐守星', '13858499660', '20220902', '郁新涛', '浙江省绍兴县夏履镇工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15220, '会员入驻', '2022-09-02', '无纺会员', '陈凤珠', '13852799756', '20220902', '郁新涛', '江苏省扬州市江都区扬州市江都区仙女镇张纲工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15221, '会员入驻', '2022-09-02', '无纺会员', '陈敬德', '18662275391', '20220902', '郁新涛', '江苏省苏州市昆山市金阳路8号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15222, '广告', '2022-09-02', '制品广告', '余萍', '13801447051', '20220902', '郁新涛', '仪征市大连路88号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15223, '广告', '2022-09-02', '制品广告', '朱梅芳', '13606227695', '20220902', '郁新涛', '泗阳县众兴镇淮海路泗阳银泰汽摩配城1幢1-202号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15224, '广告', '2022-09-02', '制品广告', '温治森', '13588220637', '20220902', '郁新涛', '临安市青山湖街道安村村上安村88号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15225, '无纺', '2022-09-05', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'Tel:+8653285762302  FAX:8663285782302', '20220905', '郑静', 'QINGDAO FOCAL SOLUTIONS MACHINERY CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15226, '无纺', '2022-09-05', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TEL:865466927578  FAX:865466928898', '20220905', '郑静', 'SHANDONG HAIWEI HYGIENE NEW MATERIAL CO.LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15227, '无纺', '2022-09-05', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:39067248041    FAX:3905724804360', '20220905', '郑静', 'TEXSUS SPA', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15228, '无纺', '2022-09-05', '扫地机器人湿巾Wet wipes', '已发意向邮件', 'TeL:8657786197733.                         Fax:8657786197171', '20220905', '郑静', 'WENZHOU CHAOLONG TEXTILE MACHINERY CO.,LTD.', '出口', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15229, '会员入驻', '2022-09-05', '无纺会员', '杨阳', '15371059176', '20220905', '郁新涛', '无锡市新吴区鸿山街道东塘街村振发路(无锡保尔兴安全用品有限公司内)', '服务', '0.67万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15230, '会员入驻', '2022-09-05', '无纺会员', '孙雪岐', '13806236432', '20220905', '郁新涛', '江苏省苏州市常熟市常熟市任阳镇丰桥村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15231, '会员入驻', '2022-09-05', '无纺会员', '张正华', '13861808911', '20220905', '郁新涛', '江苏省无锡市惠山区无锡市惠山区玉祁街道黄泥坝村（工业集中区）', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15232, '会员入驻', '2022-09-05', '无纺会员', '李开平', '13338723338', '20220905', '郁新涛', '江苏省苏州市常熟市常熟东南开发区新安江路', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15233, '会员入驻', '2022-09-05', '无纺会员', '王琦', '15925886580', '20220905', '郁新涛', '成都市高新区府城大道399号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15234, '广告', '2022-09-05', '制品广告', '汤倩峰', '18767151441', '20220905', '郁新涛', '杭州富阳区春江街道新建村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15235, '广告', '2022-09-05', '制品广告', '吴联票', '18858815222', '20220905', '郁新涛', '浙江省温州市龙港市梧桥村31号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15236, '广告', '2022-09-05', '制品广告', '蒋卫国', '13867276999', '20220905', '郁新涛', '浙江省湖州市吴兴区八里店镇义山路117号5幢至8幢', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15237, '机械工厂', '2022-09-09', '智能工厂', '周国顺', '18961978666', '20220909', '郁新涛', '江苏盐城亭湖', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15238, '机械工厂', '2022-09-09', '智能工厂', '许志刚', '13972943509', '20220909', '郁新涛', '湖北省仙桃市', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15239, '无纺', '2022-09-06', '白色纯涤纶针刺无纺布', '深入沟通中', '18630252988', '20220906', '郑静', '雄县家进无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15240, '无纺', '2022-09-06', '白色纯涤纶针刺无纺布', '深入沟通中', '18955663632', '20220906', '郑静', '桐城市超然无纺布包装制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15241, '无纺', '2022-09-06', '白色纯涤纶针刺无纺布', '深入沟通中', '13812827390', '20220906', '郑静', '常熟市宏远无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15242, '无纺', '2022-09-06', '白色纯涤纶针刺无纺布', '深入沟通中', '15266936366', '20220906', '郑静', '德州成达无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15243, '会员入驻', '2022-09-06', '无纺会员', '郑建均', '13812802787', '20220906', '郁新涛', '江苏省苏州市常熟市常熟市碧溪镇李袁村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15244, '会员入驻', '2022-09-06', '无纺会员', '江明光', '13962379158', '20220906', '郁新涛', '江苏省苏州市常熟市常熟市古里镇康博村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15245, '会员入驻', '2022-09-06', '无纺会员', '谈正杰', '13961547721', '20220906', '郁新涛', '江苏省无锡市宜兴市江苏省无锡市宜兴市芳桥镇芳桥村内', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15246, '广告', '2022-09-06', '制品广告', '傅璐茜', '13967471111', '20220906', '郁新涛', '浙江省金华市金东区傅村镇常春东路727号一号楼第2层(自主申报)', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15247, '广告', '2022-09-06', '制品广告', '张雄伟', '18861653737', '20220906', '郁新涛', '江阴市徐霞客镇金凤村李巷上166号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15248, '广告', '2022-09-06', '制品广告', '郑小强', '13666517222', '20220906', '郁新涛', '湖州市织里镇中华西路368号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15249, '无纺', '2022-09-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13758859792', '20220907', '郑静', '温州中护实业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15250, '无纺', '2022-09-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13511388821', '20220907', '郑静', '义乌涂爱福贸易有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15251, '无纺', '2022-09-07', '白色纯涤纶针刺无纺布', '深入沟通中', '1506537010', '20220907', '郑静', '山东宝利新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15252, '无纺', '2022-09-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13868137153', '20220907', '郑静', '浙江华晨非织造布有限公', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15253, '广告', '2022-09-07', '制品广告', '薛豹', '13390820888', '20220907', '郁新涛', '常熟市辛庄镇嘉菱村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15254, '广告', '2022-09-07', '制品广告', '周晓刚', '13305158195', '20220907', '郁新涛', '南京市秦淮区集庆路123号703室', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15255, '广告', '2022-09-07', '制品广告', '刘叶', '13584173095', '20220907', '郁新涛', '江阴市华士镇工业集中区红苗园183号北门', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15256, '会员入驻', '2022-09-07', '无纺会员', '方银妹', '13338727338', '20220907', '郁新涛', '江苏省苏州市常熟市常熟市支塘镇任阳迎阳西大道18号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15257, '会员入驻', '2022-09-07', '无纺会员', '徐永明', '13901524790', '20220907', '郁新涛', '江苏省无锡市江阴市峭岐人民路152号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15258, '会员入驻', '2022-09-07', '无纺会员', '程雪荣', '13962439946', '20220907', '郁新涛', '江苏省苏州市常熟市常熟市支塘镇任阳任南村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15259, '无纺', '2022-09-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13968088345', '20220908', '郑静', '杭州余杭欣美无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15260, '无纺', '2022-09-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13959793782', '20220908', '郑静', '福建省创美无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15261, '无纺', '2022-09-08', '白色纯涤纶针刺无纺布', '深入沟通中', '18655184014', '20220908', '郑静', '合肥睿森无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15262, '无纺', '2022-09-08', '白色纯涤纶针刺无纺布', '深入沟通中', '18896608550', '20220908', '郑静', '常熟市飞创无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15263, '会员入驻', '2022-09-08', '无纺会员', '唐红星', '13852703893', '20220908', '郁新涛', '江苏省扬州市邗江区徐集村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15264, '会员入驻', '2022-09-08', '无纺会员', '张丽芳', '15606239125', '20220908', '郁新涛', '江苏省苏州市常熟市支塘镇任阳凤泾村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15265, '会员入驻', '2022-09-08', '无纺会员', '程龙明', '13706235328', '20220908', '郁新涛', '江苏省苏州市常熟市常熟市支塘镇任阳任南村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15266, '广告', '2022-09-08', '制品广告', '李美琴', '13776849379', '20220908', '郁新涛', '常州市天宁区青洋北路1号6-B-1', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15267, '广告', '2022-09-08', '制品广告', '张良', '18602106575', '20220908', '郁新涛', '常州市武进区横山桥镇西崦村十组', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15268, '广告', '2022-09-08', '制品广告', '单俊杰', '13093162811', '20220908', '郁新涛', '溧阳市昆仑街道金梧路68号', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15269, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '已发意向邮件', 'Tel：390332333601\nFax：390332335835', '20220909', '郑静', 'RCA BIGNAMI SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15270, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '已发意向邮件', 'Tel：499284600    Fax:49928460205', '20220909', '郑静', 'SANDLER AG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15271, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '已发意向邮件', 'Tel:441204855010', '20220909', '郑静', 'STERLING NONWOVENS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15272, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '深入沟通中', '13559055063', '20220909', '郑静', '福建省华韵无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15273, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '深入沟通中', '18272398883', '20220909', '郑静', '仙桃市远界无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15274, '无纺', '2022-09-09', '白色纯涤纶针刺无纺布', '深入沟通中', '18955667878', '20220909', '郑静', '桐城市创银无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15275, '广告', '2022-09-09', '制品广告', '严伟才', '13962375180', '20220909', '郁新涛', '常熟市支塘镇八字桥村新河33', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15276, '广告', '2022-09-09', '制品广告', '邹永刚', '13862302104', '20220909', '郁新涛', '常熟市支塘镇任南村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15277, '广告', '2022-09-09', '制品广告', '林本委', '13962629105', '20220909', '郁新涛', '太仓市沙溪镇胜利村45组', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15278, '会员入驻', '2022-09-09', '无纺会员', '石英伍', '13862323836', '20220909', '郁新涛', '江苏省苏州市常熟市村委会', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15279, '会员入驻', '2022-09-09', '无纺会员', '顾振兴', '13852850029', '20220909', '郁新涛', '江苏省泰州市靖江市靖江市西来镇郁家村', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15280, '会员入驻', '2022-09-09', '无纺会员', '王文瑛', '\n13601927179', '20220909', '郁新涛', '上海市松江区松汇西路1558号A-69号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15281, '纤维', '2022-09-13', '化纤选品8版', ' 许进', '18913241195', '20220913', '任海香', '江苏中迪新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15282, '纤维', '2022-09-13', '化纤选品8版', '朱家裕', '13773257502', '20220913', '任海香', '张家港市优洁无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15283, '纤维', '2022-09-13', '化纤选品8版', '李忠辉', '18952586718', '20220913', '任海香', '仪征市辉腾无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15284, '纤维', '2022-09-13', '化纤选品8版', 'Esther Guo', '15118206820', '20220913', '任海香', '东莞锦晨新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15285, '纤维', '2022-09-13', '化纤选品8版', '董飞', '18605721753', '20220913', '任海香', '齐格勒无纺新材(湖州)有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15286, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:420462519530   fax:420465543793', '20220913', '郑静', 'CONTIPRO A.S.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15287, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:4971193400 Fax:497119340297', '20220913', '郑静', 'INSTITUT FUR TEXTIL-&VERFAHRENSTECHNIK DENKENDORF-ITV', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15288, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:441472245205', '20220913', '郑静', 'TECHNICAL ABSORBENTS LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15289, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', '15155636782', '20220913', '郑静', '桐城市高瞻无纺布袋有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15290, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13629265207', '20220913', '郑静', '宝鸡美隆无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15291, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', '18673903305', '20220913', '郑静', '湖南省洁雅无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15292, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', '15312241228', '20220913', '郑静', '无锡华洁无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15293, '无纺', '2022-09-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13562600266', '20220913', '郑静', '诸城市俊帅无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15294, '广告', '2022-09-13', '制品广告', '张燕', '15262557582', '20220913', '郁新涛', '常熟市支塘镇枫塘村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15295, '会员入驻', '2022-09-13', '无纺会员', '刘翔', '18905253555', '20220913', '郁新涛', '江苏省扬州市仪征市真州镇工农北路2号502室', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15296, '会员入驻', '2022-09-13', '无纺会员', '陈铮珍', '13345947991', '20220913', '郁新涛', '浙江神浦江县白马镇金马路8号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15297, '会员入驻', '2022-09-13', '无纺会员', '杨海涛', '13921931200', '20220913', '郁新涛', '江苏扬州（仪征）汽车工业园宝昌路10号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15298, '全系列', '2022-09-13', '上海明叶无纺制品有限公司', '顾永康', '13564053636', '20220913', '李小龙', '上海明叶无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15299, '全系列', '2022-09-13', '上海丝艺无纺制品有限公司', '徐希龙', '18964009123', '20220913', '李小龙', '上海丝艺无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15300, '全系列', '2022-09-13', '上海景全无纺制品有限公司', '沈伟新', '13761655105', '20220913', '李小龙', '上海景全无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15301, '全系列', '2022-09-13', '浙江弘扬无纺新材料有限公司', '史延强', '13586445151', '20220913', '李小龙', '浙江弘扬无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15302, '全系列', '2022-09-13', '绍兴舒洁雅无纺材料有限公司', '戴永华', '13906756684', '20220913', '李小龙', '绍兴舒洁雅无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15303, '全系列', '2022-09-13', '嘉兴南华无纺材料有限公司', '成斐君', '13967310839', '20220913', '李小龙', '嘉兴南华无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15304, '无纺布制品', '2022-09-13', '湿巾', '孙良君', '0317-3073893', '20220913', '顾怡青', '沧州市君臣生物制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15305, '无纺布制品', '2022-09-13', '湿巾', '刘素芝', '0318-3822303', '20220913', '顾怡青', '河北省武强县北斗卫生保健用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15306, '无纺布制品', '2022-09-13', '湿巾', '肖秋生', '0318-5958116', '20220913', '顾怡青', '河北冀衡化学股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15307, '无纺布制品', '2022-09-13', '湿巾', '李国英', '18932801088', '20220913', '顾怡青', '河北省武强县迈特卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15308, '机械工厂', '2022-09-13', '智能工厂', '谢月冬', '15851084038', '20220913', '郁新涛', '盐城市盐都区大纵湖镇龙德路10号(M)', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15309, '机械工厂', '2022-09-13', '智能工厂', '申年忠', '13606233083', '20220913', '郁新涛', '常熟市支塘镇任阳工业园', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15310, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+912572210476                        Fax +912572210476', '20220914', '郑静', 'RUBY SURGICAL&ALLIED PRODUCTS PVT.LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15311, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+966135324000                            ·Fax +966135324004', '20220914', '郑静', 'ADVANCED FABRICS(SAAF)', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15312, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+4923888402306                         ·Fax +4923888402350', '20220914', '郑静', 'ADVANSA MARKETING GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15313, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', '17712691066', '20220914', '郑静', '太仓众奥无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15314, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13906231755', '20220914', '郑静', '常熟市宇翔无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15315, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13952720587', '20220914', '郑静', '扬州诚中成无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15316, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', '15366246192', '20220914', '郑静', '常熟市三佳无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15317, '无纺', '2022-09-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13961472830', '20220914', '郑静', '常州佐佑无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15318, '纤维', '2022-09-14', '化纤选品8版', '刘洁', '17605325300', '20220914', '任海香', '青岛百草新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15319, '纤维', '2022-09-14', '化纤选品8版', '高先生', '13305510790', '20220914', '任海香', '安徽乐康卫生材料有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15320, '纤维', '2022-09-14', '化纤选品8版', '黄俊', '13757061786', '20220914', '任海香', '湖州泰鑫无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15321, '纤维', '2022-09-14', '化纤选品8版', '陈海华', '13973088378', '20220914', '任海香', '嘉兴申新无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15322, '纤维', '2022-09-14', '化纤选品8版', '李熹', '15957327366', '20220914', '任海香', '浙江富瑞森水刺无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15323, '机械工厂', '2022-09-14', '智能工厂', '方德国', '18668750688', '20220914', '郁新涛', '浙江浙个纺织机械科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15324, '机械工厂', '2022-09-14', '智能工厂', '余德干', '13506533268', '20220914', '郁新涛', '浙江东跃机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15325, '广告', '2022-09-14', '制品广告', '熊寿福', '13913646698', '20220914', '郁新涛', '常熟市乔亚无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15326, '会员入驻', '2022-09-14', '无纺会员', '方小刚', '13582495396', '20220914', '郁新涛', '苏州中纺滤材无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15327, '会员入驻', '2022-09-14', '无纺会员', '胡磐', '13901682060', '20220914', '郁新涛', '普杰无纺布（中国）有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15328, '会员入驻', '2022-09-14', '无纺会员', '许德跃', '13918616788', '20220914', '郁新涛', '希雅图（上海）无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15329, '全系列', '2022-09-14', '常州市戚墅堰鑫源无纺布厂', '王红渊', '13815021979', '20220914', '李小龙', '常州市戚墅堰鑫源无纺布厂', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15330, '全系列', '2022-09-14', '常熟市益盛无纺制品有限公司', '杨德明', '13906233090', '20220914', '李小龙', '常熟市益盛无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15331, '全系列', '2022-09-14', '常州市中大无纺制品有限公司', '李雪良', '13706239070', '20220914', '李小龙', '常州市中大无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15332, '全系列', '2022-09-14', '常熟市中欣无纺制品有限公司', '陶建平', '13861060025', '20220914', '李小龙', '常熟市中欣无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15333, '全系列', '2022-09-14', '丹阳市金亿来无纺制品有限公司', '姚建中', '13906237432', '20220914', '李小龙', '丹阳市金亿来无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15334, '全系列', '2022-09-14', '南京有家无纺制品厂', '徐秋亮', '13774689986', '20220914', '李小龙', '南京有家无纺制品厂', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15335, '全系列', '2022-09-15', '常熟市时顺无纺制品有限公司', '费扣喜', '18015632898', '20220915', '李小龙', '常熟市时顺无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15336, '全系列', '2022-09-15', '徐州市尚诚无纺制品有限公司', '高广涛', '13685107337', '20220915', '李小龙', '徐州市尚诚无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15337, '全系列', '2022-09-15', '无锡市合众无纺制品有限公司', '闵宣东', '13961587585', '20220915', '李小龙', '无锡市合众无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15338, '全系列', '2022-09-15', '兰溪市华塑无纺布有限公司', '简德亮', '13575961295', '20220915', '李小龙', '兰溪市华塑无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15339, '全系列', '2022-09-15', '仪征市双星无纺制品有限公司', '张德全', '13905256159', '20220915', '李小龙', '仪征市双星无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15340, '全系列', '2022-09-15', '张家港骏马无纺布有限公司', '吉新建', '13812997527', '20220915', '李小龙', '张家港骏马无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15341, '机械工厂', '2022-09-15', '盐城市富昊机械制造有限公司', '秦悌林', '13813441676', '20220915', '郁新涛', '盐城市富昊机械制造有限公司', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15342, '机械工厂', '2022-09-15', '连云港静荣无纺布机械有限公司', '姜静荣', '18000176699', '20220915', '郁新涛', '连云港静荣无纺布机械有限公司', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15343, '广告', '2022-09-15', '常熟市帝华无纺制品有限公司', '杨丽娟', '13915633193', '20220915', '郁新涛', '常熟市帝华无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15344, '会员入驻', '2022-09-15', '上海硕特无纺布有限公司', '沈其荣', '13601865088', '20220915', '郁新涛', '上海硕特无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15345, '会员入驻', '2022-09-15', '浙江星瑞达无纺布有限公司', '张冬林', '13706899735', '20220915', '郁新涛', '浙江星瑞达无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15346, '会员入驻', '2022-09-15', '浙江弘扬无纺新材料有限公司', '史延强', '13586445151', '20220915', '郁新涛', '浙江弘扬无纺新材料有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15347, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+33555719200·                            Fax +33555027767', '20220915', '郑静', 'ALBANY INTERNATIONAL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15348, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+33476912500                               ·Fax +33476910776', '20220915', '郑静', 'ALLIMAND S.A.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15349, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel. +912030642609·Fax +912030642614', '20220915', '郑静', 'ALPHA FOAM LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15350, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', '13914094101', '20220915', '郑静', '苏州正义无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15351, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', '13196616779', '20220915', '郑静', '常熟市良鼎无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15352, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', '13295192981', '20220915', '郑静', '常熟市俊通无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15353, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', '15805126366', '20220915', '郑静', '东海县兴辰无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15354, '无纺', '2022-09-15', '白色纯涤纶针刺无纺布', '深入沟通中', '13801447051', '20220915', '郑静', '扬州嘉纬无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15355, '无纺布制品', '2022-09-15', '面膜布', '乐克才', '051088267932 ', '20220607', '顾怡青', '无锡市布凡纺织品有限公司', '内贸', '10', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15356, '无纺布制品', '2022-09-15', '湿巾', '董兆庆', '13838289690', '20220915', '顾怡青', '郑州承启科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15357, '无纺布制品', '2022-09-15', '湿巾', '林敏炼', '13903861667', '20220915', '顾怡青', '莱湾洁品（郑州）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15358, '无纺布制品', '2022-09-15', '湿巾', '梁法泉', '0373-5596211', '20220915', '顾怡青', '新乡市华信药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15359, '无纺布制品', '2022-09-15', '湿巾', '顾琦', '0395-5615519', '20220915', '顾怡青', '河南银鸽实业投资股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15360, '无纺布制品', '2022-09-16', '湿巾', '黄诚', '0376-3399679', '20220916', '顾怡青', '信阳核工业恒达实业公司干燥剂厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15361, '无纺布制品', '2022-09-16', '湿巾', '黄诚', '0376-6692839', '20220916', '顾怡青', '信阳核工业恒达实业公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15362, '无纺布制品', '2022-09-16', '湿巾', '黄志凌', '0591-88802591', '20220916', '顾怡青', '福州天茂贸易有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15363, '无纺布制品', '2022-09-16', '湿巾', '黄天赐', '0591-22620166', '20220916', '顾怡青', '福州黄氏药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15364, '纤维', '2022-09-16', '化纤选品8版', '刘欢', '18668052266', '20220916', '任海香', '杭州雷龙无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15365, '纤维', '2022-09-16', '化纤选品8版', '戴蓓蓓', '13958788613', '20220916', '任海香', '苍南润祥无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15366, '纤维', '2022-09-16', '化纤选品8版', '蔡省卫', '13429670299', '20220916', '任海香', '湖州耀锦无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15367, '纤维', '2022-09-16', '化纤选品8版', '王志昆', '18553327308', '20220916', '任海香', '山东久和无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15368, '纤维', '2022-09-16', '化纤选品8版', '赵闵', '15069617299', '20220916', '任海香', '潍坊志和无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15369, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+33232964242                            Fax +33232964243', '20220916', '郑静', 'ANDRITZ ASSELIN-THIBEAU SAS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15370, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:358207559110', '20220916', '郑静', 'ANPAP OY', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15371, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:39854476110                                    Fax:39854472982', '20220916', '郑静', 'AULONA MACHINERY SL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15372, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', '13606227695', '20220916', '郑静', '泗阳宽宏无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15373, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', '13588220637', '20220916', '郑静', '杭州欣顺无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15374, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', '18858815222', '20220916', '郑静', '龙港市方欣无纺布制袋有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15375, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', '13967471111', '20220916', '郑静', '金华市驰诚无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15376, '无纺', '2022-09-16', '白色纯涤纶针刺无纺布', '深入沟通中', '18861653737', '20220916', '郑静', '江阴市亿玺无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15377, '全系列', '2022-09-16', '东莞市信远无纺布有限公司', '董文杰', '13070939318', '20220916', '李小龙', '东莞市信远无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15378, '全系列', '2022-09-16', '昆山永安非织造无纺科技有限公司', '薛裕龙', '13806265010', '20220916', '李小龙', '昆山永安非织造无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15379, '全系列', '2022-09-16', '潍坊欣荣无纺布制品有限公司', '徐会存', '13606477140', '20220916', '李小龙', '潍坊欣荣无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15380, '全系列', '2022-09-16', '珠海市华纶无纺布有限公司', '林文强', '13326666610', '20220916', '李小龙', '珠海市华纶无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15381, '全系列', '2022-09-16', '盐城恒天无纺布科技有限公司', '许志元', '13906269169', '20220916', '李小龙', '盐城恒天无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15382, '全系列', '2022-09-16', '盘锦禹王无纺布有限责任公司', '李超', '13942777747', '20220916', '李小龙', '盘锦禹王无纺布有限责任公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15383, '机械工厂', '2022-09-16', '常州市锦益机械有限公司', '高忠林', '13961221082', '20220916', '郁新涛', '常州市锦益机械有限公司', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15384, '机械工厂', '2022-09-16', '青岛润发恒诚纺织机械有限公司', '赵文滨', '13708966756', '20220916', '郁新涛', '青岛润发恒诚纺织机械有限公司', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15385, '会员入驻', '2022-09-16', '绍兴舒洁雅无纺材料有限公司', '戴永华', '13906756684', '20220916', '郁新涛', '绍兴县漓渚镇工业园区', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15386, '会员入驻', '2022-09-16', '嘉兴南华无纺材料有限公司', '成斐君', '13967310839', '20220916', '郁新涛', '浙江平湖市曹桥街道景兴一路301号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15387, '会员入驻', '2022-09-16', '上海理彬无纺布有限公司', '庄天方', '\n18901805882', '20220916', '郁新涛', '上海市金山区金山卫镇卫清西路333号', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15388, '广告招商', '2022-09-16', '常熟市信德无纺制品有限公司', '曹雪坤', '13706232615', '20220916', '郁新涛', '常熟市支塘镇任阳凤泾村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15389, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+18777387527                          ·Fax+19802336602', '20220919', '郑静', 'INDORAMA VENTURES LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15390, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+4982126080                        Fax+498212608229', '20220919', '郑静', 'AUTEFA SOLUTIONS GERMANY GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15391, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel.+441788578300                      Fax+441788579700', '20220919', '郑静', 'AUTINS GROUP PLC', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15392, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13666517222', '20220919', '郑静', '湖州万工无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15393, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13819214505', '20220919', '郑静', '湖州织里鑫湖无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15394, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13865712318', '20220919', '郑静', '合肥嘉斯曼无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15395, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13390820888', '20220919', '郑静', '常熟市荣润无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15396, '无纺', '2022-09-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13305158195', '20220919', '郑静', '南京泽维昕无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15397, '全系列', '2022-09-19', '浙江润锦纺织品制造有限公司', '郑康强', '', '20220919', '李小龙', '浙江润锦纺织品制造有限公司', '内贸', '200万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15398, '全系列', '2022-09-19', '宝鸡格瑞诺无纺布有限公司', '史超飞', '18291766651', '20220919', '李小龙', '宝鸡格瑞诺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15399, '全系列', '2022-09-19', '吉安市三江超纤无纺有限公司', '赵孝龙', '18258117445', '20220919', '李小龙', '吉安市三江超纤无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15400, '全系列', '2022-09-19', '上海绿春无纺布有限公司', '陆春根', '13003188275', '20220919', '李小龙', '上海绿春无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15401, '全系列', '2022-09-19', '上海洁纳无纺布有限公司', '庞凤肖', '18918040385', '20220919', '李小龙', '上海洁纳无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15402, '全系列', '2022-09-19', '上海和玉无纺布制品厂', '唐应斌', '13701907550', '20220919', '李小龙', '上海和玉无纺布制品厂', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15403, '全系列', '2022-09-19', '上海腾斐无纺布有限公司', ' 区锦超', '13917364305', '20220919', '李小龙', '上海腾斐无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15404, '机械工厂', '2022-09-19', '常熟市峻熙无纺制品有限公司', '朱国涛', '18852439101', '20220919', '郁新涛', '常熟市支塘镇枫塘村', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15405, '机械工厂', '2022-09-19', '常熟市佳佰俪无纺制品有限公司', '孙先生', '13073322118', '20220919', '郁新涛', '常熟市支塘镇丰联村', '服务', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15406, '会员入驻', '2022-09-19', '上海宝创无纺布科技有限公司', '沈伟云', '\n18916056668', '20220920', '郁新涛', '上海市松江区泖港镇叶新公路3348号第1幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15407, '会员入驻', '2022-09-19', '洁馨（上海）无纺布有限公司', '庞新财', '\n13817398578', '20220921', '郁新涛', '青浦区大生路6号5幢、6幢', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15408, '会员入驻', '2022-09-19', '上海独韵无纺布有限公司', '汪国荣', '\n13524963411', '20220922', '郁新涛', '上海市宝山区顾北东路365号C区378', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15409, '广告', '2022-09-19', '常熟市喜丽无纺制品有限公司', '周丽芳', '13901573344', '20220923', '郁新涛', '常熟市支塘镇任阳徐政村', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15410, '无纺布制品', '2022-09-19', '湿巾', '林斌', '0591-85368198', '20220919', '顾怡青', '爹地宝贝股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15411, '无纺布制品', '2022-09-19', '湿巾', '石耀健', '0592-6362675', '20220919', '顾怡青', '厦门耀健纸品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15412, '无纺布制品', '2022-09-19', '湿巾', '姚亮', '15305926278', '20220919', '顾怡青', '厦门美商医药有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15413, '无纺布制品', '2022-09-19', '湿巾', '郑春树', '0594-3296896', '20220919', '顾怡青', '福建亿发集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15414, '纤维', '2022-09-19', '化纤选品9版', '刘北壬', '13396577338', '20220919', '任海香', '杭州路先非织造股份有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15415, '纤维', '2022-09-19', '化纤选品9版', '倪林根', '13957378133', '20220919', '任海香', '桐乡市荣创纺织品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15416, '纤维', '2022-09-19', '化纤选品9版', '张海明', '15857192851', '20220919', '任海香', '湖州嘉丝新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15417, '纤维', '2022-09-19', '化纤选品9版', '孙雪岐', '13806236432', '20220919', '任海香', '常熟市雪英无纺布', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15418, '纤维', '2022-09-19', '化纤选品9版', '方银妹', '13338727338', '20220919', '任海香', '常熟市雪利银无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15419, '全系列', '2022-09-20', '上海巽宜无纺布科技有限公司', '黄允如', '13918169933', '20220920', '李小龙', '上海巽宜无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15420, '全系列', '2022-09-20', '常州瑞美特无纺布有限公司', '沈国平', '13861271228', '20220920', '李小龙', '常州瑞美特无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15421, '全系列', '2022-09-20', '丹阳市华荣无纺布有限公司', '陈华芳', '13852961972', '20220920', '李小龙', '丹阳市华荣无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15422, '全系列', '2022-09-20', '金湖海之缘无纺布制品有限公司', '姜元兰', '13655238259', '20220920', '李小龙', '金湖海之缘无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15423, '全系列', '2022-09-20', '江阴市鑫茂无纺布有限公司', '顾晓萍', '18915227718', '20220920', '李小龙', '江阴市鑫茂无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15424, '全系列', '2022-09-20', '扬州市同创无纺布有限公司', '王祥林', '13813178610', '20220920', '李小龙', '扬州市同创无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15425, '会员入驻', '2022-09-20', '上海鹫发无纺布有限公司', '朱建华', '\n13918453322', '20220920', '郁新涛', '上海鹫发无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15426, '会员入驻', '2022-09-20', '苏州鑫茂无纺材料有限公司', '范东明', '13806237218', '20220920', '郁新涛', '苏州鑫茂无纺材料有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15427, '会员入驻', '2022-09-20', '仪征市荣鑫无纺布有限公司', '邱月兵', '13179796442', '20220920', '郁新涛', '仪征市荣鑫无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15428, '广告', '2022-09-20', '常熟市吉田无纺制品有限公司', '王巧中', '13328021799', '20220920', '郁新涛', '常熟市吉田无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15429, '机械工厂', '2022-09-20', '盐城市盛逸化纤机械有限公司', '马兆兵', '13401783222', '20220920', '郁新涛', '盐城市盛逸化纤机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15430, '机械工厂', '2022-09-20', '湖北佳粮机械股份有限公司', '李俊', '13972630212', '20220920', '郁新涛', '湖北佳粮机械股份有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15431, '无纺布制品', '2022-09-20', '湿巾', '吴秀英', '0594-3697690', '20220920', '顾怡青', '福建莆田佳通纸制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15432, '无纺布制品', '2022-09-20', '湿巾', '许建荣', '13706060211', '20220920', '顾怡青', '莆田市安美医疗器械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15433, '无纺布制品', '2022-09-20', '湿巾', '施文博', '0595-85708888', '20220920', '顾怡青', '福建恒安集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15434, '无纺布制品', '2022-09-20', '湿巾', '何德佳', '13506091035', '20220920', '顾怡青', '晋江市老君日化有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15435, '无纺布制品', '2022-09-20', '湿巾', '赖建国', '13808516966', '20220920', '顾怡青', '晋江市凤源卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15436, '无纺布制品', '2022-09-20', '湿巾', '许永添', '15959558345', '20220920', '顾怡青', '晋江市泓鑫达服装织造有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15437, '无纺布制品', '2022-09-20', '湿巾', '高绪聪', '0532-88492326', '20220920', '顾怡青', '青岛莱西市亨通滤清器厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15438, '无纺布制品', '2022-09-20', '湿巾', '李永华', '0533-3265555', '20220920', '顾怡青', '淄博永华滤清器制造有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15439, '无纺布制品', '2022-09-20', '湿巾', '黄海林', '18265457222', '20220920', '顾怡青', '蓬莱市塑料滤清器厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15440, '纤维', '2022-09-20', '化纤选品9版', '雷三军', '13981943452', '20220920', '任海香', '凯盾新材金湖有限公司', '内贸', '60', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15441, '纤维', '2022-09-20', '化纤选品9版', '杨超', '18713964703', '20220920', '任海香', '南宫市亿泽隆毛毡制品厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15442, '纤维', '2022-09-20', '化纤选品9版', '汪宇静', '13758170174', '20220920', '任海香', '浙江华晨非织造布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15443, '纤维', '2022-09-20', '化纤选品9版', '严新和', '13961152129', '20220920', '任海香', '荆州常松无纺布科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15444, '纤维', '2022-09-20', '化纤选品9版', '朱昭元', '13905574301', '20220920', '任海香', '宿州聚维无纺布科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15445, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+97239061555 Fax:+97239364376', '20220920', '郑静', 'AVGOL NONWOVEN INDUSTRIES', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15446, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4924157980                          Fax:+49241579827', '20220920', '郑静', 'BARNET EUROPE W.BARNET GMBN  &CO.KG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15447, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390574514293           Fax:+390574594004', '20220920', '郑静', 'BEMATIC-BETTAINI &SERAFINA SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15448, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13584173095', '20220920', '郑静', '江阴市凯利无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15449, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', '18602106575', '20220920', '郑静', '常州朵洁无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15450, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13093162811', '20220920', '郑静', '溧阳市经纬无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15451, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13962375180', '20220920', '郑静', '常熟市优源无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15452, '无纺', '2022-09-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13862302104', '20220920', '郑静', '常熟市永强无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15453, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+492651942940       Fax:+4926519429494', '20220921', '郑静', 'BICMA HYGIENE TECHNOLOGIE GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15454, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+92261957700701', '20220921', '郑静', 'GRASIM INDUSTRIES LTD.BIRLA CELLULOSE', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15455, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390558479351       Fax:+390558416402', '20220921', '郑静', 'BOMBI MECCANICA SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15456, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', '15262557582', '20220921', '郑静', '常熟市金霸无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15457, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13913646698', '20220921', '郑静', '常熟市乔亚无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15458, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13915633193', '20220921', '郑静', '常熟市帝华无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15459, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13328021799', '20220921', '郑静', '常熟市吉田无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15460, '无纺', '2022-09-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13913695777', '20220921', '郑静', '常熟市锦辉无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15461, '无纺布制品', '2022-09-21', '湿巾', '李世新', '021-54591301', '20220921', '顾怡青', '上海中卫消毒剂研究所', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15462, '无纺布制品', '2022-09-21', '湿巾', '陈琳', '13901764067', '20220921', '顾怡青', '上海展艺商贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15463, '无纺布制品', '2022-09-21', '湿巾', '徐炳根', '15298888583', '20220921', '顾怡青', '苏州市相城区东方之宝化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15464, '无纺布制品', '2022-09-21', '湿巾', '林文豪', '0512-62997567', '20220921', '顾怡青', '日上（苏州）轻化纺高科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15465, '无纺布制品', '2022-09-21', '湿巾', '周小申', '0512-82181692', '20220921', '顾怡青', '苏州恒星医用材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15466, '无纺布制品', '2022-09-21', '湿巾', '周星', '0512-52551649', '20220921', '顾怡青', '常熟一诺医疗用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15467, '无纺布制品', '2022-09-21', '湿巾', '席柏林', '15862389295', '20220921', '顾怡青', '苏州市锦新医用塑料容器厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15468, '无纺布制品', '2022-09-21', '湿巾', '沈季疆', '13901474096', '20220921', '顾怡青', '江苏通江科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15469, '无纺布制品', '2022-09-21', '湿巾', '李朝新', '0513-85676668', '20220921', '顾怡青', '南通市万利纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15470, '无纺布制品', '2022-09-21', '湿巾', '晁彬', '18951308066', '20220921', '顾怡青', '海安天健工艺品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15471, '会员入驻', '2022-09-21', '无纺会员', '周付衍', '13770043861', '20220921', '郁新涛', '盐城申安无纺布工贸有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15472, '会员入驻', '2022-09-21', '无纺会员', '李桂元', '13606233628', '20220921', '郁新涛', '常熟市银桂无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15473, '会员入驻', '2022-09-21', '无纺会员', '承惠兴', '13901524253', '20220921', '郁新涛', '江阴市光大无纺布业有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15474, '广告', '2022-09-21', '制品广告', '张良哲', '13913695777', '20220921', '郁新涛', '常熟市锦辉无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15475, '机械工厂', '2022-09-21', '智能工厂', '王开英', '13913651785', '20220921', '郁新涛', '常熟市利泓无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15476, '机械工厂', '2022-09-21', '智能工厂', '李五九', '15855649008', '20220921', '郁新涛', '安徽省久辰印染机械配件有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15477, '纤维', '2022-09-21', '再生涤纶纤维', '成一', '82-2-69316931', '20220921', '任海香', 'DK&D CO.,LTD', '外贸', '154', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15478, '纤维', '2022-09-21', '化纤选品9版', '程雪荣', '13962439946', '20220921', '任海香', '常熟市阳阳无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15479, '纤维', '2022-09-21', '化纤选品9版', '俞江', '18662220202', '20220921', '任海香', '常熟市金陵无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15480, '纤维', '2022-09-21', '化纤选品9版', '程龙明', '13706235328', '20220921', '任海香', '常熟市越亿无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15481, '纤维', '2022-09-21', '化纤选品9版', '董泽林', '13601577823', '20220921', '任海香', '常熟市缘盈无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15482, '全系列', '2022-09-21', '无锡市海洋无纺布有限公司', '晏仲武', '13815803078', '20220921', '李小龙', '无锡市海洋无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15483, '全系列', '2022-09-21', '盐城福天无纺布业有限公司', '李天晓', '13914659343', '20220921', '李小龙', '盐城福天无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15484, '全系列', '2022-09-21', '常熟市金丰无纺制品有限公司', '赵雪明', '13306234512', '20220921', '李小龙', '常熟市金丰无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15485, '全系列', '2022-09-21', '常熟市盛创无纺制品有限公司', '奚春芳', '18906237999', '20220921', '李小龙', '常熟市盛创无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15486, '全系列', '2022-09-21', '常熟市锦达无纺制品有限公司', '肖山', '13390826177', '20220921', '李小龙', '常熟市锦达无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15487, '全系列', '2022-09-21', '东台鸿瑞无纺布有限公司', '邱进鹤', '19826321828', '20220921', '李小龙', '东台鸿瑞无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15488, '机械工厂', '2022-09-22', '安徽贝克纺织机械设备有限公司', '周翠萍', '15955088677', '20220922', '郁新涛', '安徽贝克纺织机械设备有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15489, '机械工厂', '2022-09-22', '常熟市百利德无纺机械有限公司', '殷丽江', '13812803222', '20220922', '郁新涛', '常熟市百利德无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15490, '广告', '2022-09-22', '常熟市双盛无纺制品有限公司', '王志荣', '13815281968', '20220922', '郁新涛', '常熟市双盛无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15491, '会员入驻', '2022-09-22', '徐州拓宇无纺布有限公司', '李明真', '18118551999', '20220922', '郁新涛', '徐州拓宇无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15492, '会员入驻', '2022-09-22', '无锡奥金纳特无纺布有限公司', '陈忠蔚', '13914118308', '20220922', '郁新涛', '无锡奥金纳特无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15493, '会员入驻', '2022-09-22', '宜兴市新联无纺布有限公司', '潘培年', '18915382156', '20220922', '郁新涛', '宜兴市新联无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15494, '全系列', '2022-09-22', '温州超诚无纺科技有限公司', '陈智超', '13868837793', '20220922', '李小龙', '温州超诚无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15495, '全系列', '2022-09-22', '浙江永光无纺布股份有限公司', '张祖峰', '13758352188', '20220922', '李小龙', '浙江永光无纺布股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15496, '全系列', '2022-09-22', '上海曰得无纺布制造有限公司', '孙爱民', '13601626805', '20220922', '李小龙', '上海曰得无纺布制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15497, '全系列', '2022-09-22', '上海震霖无纺布用品有限公司', '汪海鹏', '18621881576', '20220922', '李小龙', '上海震霖无纺布用品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15498, '全系列', '2022-09-22', '上海林洁无纺布制品有限公司', '余波', '15900856829', '20220922', '李小龙', '上海林洁无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15499, '全系列', '2022-09-22', '深圳市奥美无纺布制品有限公司', '李新斌', '15901969548', '20220922', '李小龙', '深圳市奥美无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15500, '无纺布制品', '2022-09-22', '湿巾', '张银凤', '13228880066', '20220922', '顾怡青', '江苏康吉医疗科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15501, '无纺布制品', '2022-09-22', '湿巾', '徐跃', '0515-84135933', '20220922', '顾怡青', '盐城金昉首乌科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15502, '无纺布制品', '2022-09-22', '湿巾', '张文生', '0514-87499666', '20220922', '顾怡青', '扬州倍加洁日化有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15503, '无纺布制品', '2022-09-22', '湿巾', '翟德庆', '18952797582', '20220922', '顾怡青', '扬州市时新旅游用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15504, '无纺布制品', '2022-09-22', '湿巾', '张文生', '0514-87499666', '20220922', '顾怡青', '倍加洁集团股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15505, '无纺布制品', '2022-09-22', '湿巾', '陆新楠', '0514-87828998', '20220922', '顾怡青', '扬州科信包装印刷有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15506, '无纺布制品', '2022-09-22', '湿巾', '薛恩富', '13801455030', '20220922', '顾怡青', '扬州三达制刷日化有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15507, '无纺布制品', '2022-09-22', '湿巾', '朱正清', '15161881989', '20220922', '顾怡青', '扬州海天旅游制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15508, '无纺布制品', '2022-09-22', '湿巾', '潘联顺', '0514-87771828', '20220922', '顾怡青', '扬州完美日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15509, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+39035724010     Fax:+39035741469', '20220922', '郑静', 'CANALAIR SERVICE SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15510, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:31183695695', '20220922', '郑静', 'CORBION PURAC BIOCHEM BV', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15511, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4401405863277    Fax:+4401405861767', '20220922', '郑静', 'CRODA EUROPE LYD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15512, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', '13815281968', '20220922', '郑静', '常熟市双盛无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15513, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', '13776202138', '20220922', '郑静', '常熟市东华无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15514, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', '13961696855', '20220922', '郑静', '张家港市红隆无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15515, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', '18136983080', '20220922', '郑静', '张家港保税区美而德无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15516, '无纺', '2022-09-22', '白色纯涤纶针刺无纺布', '深入沟通中', '13771826358', '20220922', '郑静', '苏州市锋锋无纺制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15517, '纤维', '2022-09-22', '化纤选品9版', '张科长', '18516339157', '20220922', '任海香', '捷恩智无纺材料（常熟）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15518, '纤维', '2022-09-22', '化纤选品9版', '陈越', '13615246456', '20220922', '任海香', '仪征天越达无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15519, '纤维', '2022-09-22', '化纤选品9版', '倪若昕', '13390830171', '20220922', '任海香', '江苏艾文德莱无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15520, '纤维', '2022-09-22', '化纤选品9版', '汪学琴', '15371233498', '20220922', '任海香', '江苏海卓无纺科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15521, '纤维', '2022-09-22', '化纤选品9版', '史张华', '18796503909', '20220922', '任海香', '江苏炫翔无纺布科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15522, '全系列', '2022-09-23', '深圳市登方无纺布制品有限公司', '代应忠', '13418652696', '20220923', '李小龙', '深圳市登方无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15523, '全系列', '2022-09-23', '阳西县威科无纺布制品有限公司', '梁振尤', '13664962232', '20220923', '李小龙', '阳西县威科无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15524, '全系列', '2022-09-23', '佛山市南海稳德福无纺布有限公司', '黄业滔', '13902844738', '20220923', '李小龙', '佛山市南海稳德福无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15525, '全系列', '2022-09-23', '邢台强红无纺布制品有限公司', '云杏芬', '13785956868', '20220923', '李小龙', '邢台强红无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15526, '全系列', '2022-09-23', '仙桃市欣创无纺布制品有限公司', '张伟', '13339713390', '20220923', '李小龙', '仙桃市欣创无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15527, '全系列', '2022-09-23', '武汉达舒舍怡无纺布制品有限公司', '张春林', '13665544778', '20220923', '李小龙', '武汉达舒舍怡无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15528, '全系列', '2022-09-23', '仙桃市福欣无纺布制品有限公司', '吴荣方', '13807226159', '20220923', '李小龙', '仙桃市福欣无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15529, '全系列', '2022-09-23', '常熟市汇创无纺制品有限公司', '仲华', '13962371920', '20220923', '李小龙', '常熟市汇创无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15530, '全系列', '2022-09-23', '常熟市星佳逸无纺制品有限公司', '陈星', '15250349365', '20220923', '李小龙', '常熟市星佳逸无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15531, '会员入驻', '2022-09-23', '无纺会员', '蒋金荣', '13812808298', '20220923', '郁新涛', '常熟市富鸿无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15532, '会员入驻', '2022-09-23', '无纺会员', '丁震', '13901508447', '20220923', '郁新涛', '常州市友恒无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15533, '会员入驻', '2022-09-23', '无纺会员', '张圣来', '13809154803', '20220923', '郁新涛', '泰州市金盛无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15534, '广告', '2022-09-23', '制品广告', '浦长清', '13776202138', '20220923', '郁新涛', '常熟市东华无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15535, '机械工厂', '2022-09-23', '智能工厂', '王勇超', '15506231883', '20220923', '郁新涛', '苏州厚道无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15536, '机械工厂', '2022-09-23', '智能工厂', '江建成', '18965690785', '20220923', '郁新涛', '晋江市博正无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15537, '无纺布制品', '2022-09-23', '湿巾', '黄惠娟', '0510-68835691', '20220923', '顾怡青', '江阴市青龙卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15538, '无纺布制品', '2022-09-23', '湿巾', '辛涛', '0510-88262036', '20220923', '顾怡青', '无锡市凯源家庭用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15539, '无纺布制品', '2022-09-23', '湿巾', '李荣阁', '15050830632', '20220923', '顾怡青', '徐州康尔卫生材料厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15540, '无纺布制品', '2022-09-23', '湿巾', '庄海祥', '0519-86864219', '20220923', '顾怡青', '常州华纳非织造布有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15541, '无纺布制品', '2022-09-23', '湿巾', '陈国平', '0519-82443498', '20220923', '顾怡青', '健尔康医疗科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15542, '无纺布制品', '2022-09-23', '湿巾', '葛宏伟', '0512-66392868', '20220923', '顾怡青', '苏州宝丽洁日化有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15543, '无纺布制品', '2022-09-23', '湿巾', '曾大池', '0512-53451991', '20220923', '顾怡青', '奈森克林（苏州）日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15544, '无纺布制品', '2022-09-23', '湿巾', '易志花', '0512-68293172', '20220923', '顾怡青', '苏州健宇医疗科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15545, '无纺布制品', '2022-09-23', '湿巾', '黄志源', '0512-62832112', '20220923', '顾怡青', '金红叶纸业集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15546, '纤维', '2022-09-23', '化纤选品9版', '翁先生', '13814953898', '20220923', '任海香', '常熟市宇翔无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15547, '纤维', '2022-09-23', '化纤选品9版', '李俊', '13295192981', '20220923', '任海香', '常熟市俊通无纺制品有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15548, '纤维', '2022-09-23', '化纤选品9版', '杨旭', '18605206033', '20220923', '任海香', '扬州市邗江远东无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15549, '纤维', '2022-09-23', '化纤选品9版', '赵经理', '15365726888', '20220923', '任海香', '江苏阜盛滤袋有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15550, '纤维', '2022-09-23', '化纤选品9版', '张林华', '18115368596', '20220923', '任海香', '江阴市嘉华俊纺织有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15551, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4579942200   Fax:+4579942201', '20220923', '郑静', 'FIBERVISIONS A/S', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15552, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+41552255151   Fax:+41552255159', '20220923', '郑静', 'FALU AG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15553, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+3908545531   Fax:+390854460998', '20220923', '郑静', 'FAMECCANICA DATA SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15554, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', '13750815500', '20220923', '郑静', '杭州天琪无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15555, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', '15257179325', '20220923', '郑静', '杭州艾妮美无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15556, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', '13586655170', '20220923', '郑静', '宁波濠宬无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15557, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', '13248999989', '20220923', '郑静', '苍南特豪无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15558, '无纺', '2022-09-23', '白色纯涤纶针刺无纺布', '深入沟通中', '18905736975', '20220923', '郑静', '嘉兴一渡无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15559, '会员入驻', '2022-09-26', '无纺会员', '皮金春', '13773590699', '20220926', '郁新涛', '扬州市邗江金春无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15560, '会员入驻', '2022-09-26', '无纺会员', '李玉洁', '18616863096', '20220926', '郁新涛', '启东清雅无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15561, '会员入驻', '2022-09-26', '无纺会员', '胡桂红', '13861952262', '20220926', '郁新涛', '南通大进发无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15562, '广告', '2022-09-26', '制品广告', '傅红卫', '13961696855', '20220926', '郁新涛', '张家港市红隆无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15563, '机械工厂', '2022-09-26', '智能工厂', '任年土', '13867562830', '20220926', '郁新涛', '绍兴柯桥永灵机械针纺有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15564, '机械工厂', '2022-09-26', '智能工厂', '陈燕华', '13764223127', '20220926', '郁新涛', '启东市耀宸纺织机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15565, '全系列', '2022-09-26', '嘉兴市雅盛莱无纺布有限公司', '周光勇', '13656607266', '20220926', '李小龙', '嘉兴市雅盛莱无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15566, '全系列', '2022-09-26', '浙江法来福无纺布有限公司', '徐炳键', '13456305027', '20220926', '李小龙', '浙江法来福无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15567, '全系列', '2022-09-26', '温州新宇无纺布有限公司', 'Sally', '13957712400', '20220926', '李小龙', '温州新宇无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15568, '全系列', '2022-09-26', '浙江广鸿无纺布有限公司', '谷贤群', '18857721230', '20220926', '李小龙', '浙江广鸿无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15569, '全系列', '2022-09-26', '浙江格润卫普无纺材料有限公司', '吕江勇', '13858910776', '20220926', '李小龙', '浙江格润卫普无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15570, '全系列', '2022-09-26', '苏州艾洁无纺布制品有限公司', '温勇', '13913119858', '20220926', '李小龙', '苏州艾洁无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15571, '全系列', '2022-09-26', '绍兴卡林无纺布科技有限公司', '黄中利', '13484309500', '20220926', '李小龙', '绍兴卡林无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15572, '全系列', '2022-09-26', '常熟市惠成无纺布业有限公司', '施建东', '13814995980', '20220926', '李小龙', '常熟市惠成无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15573, '全系列', '2022-09-26', '无锡市玲琰无纺布有限公司', '黄晓', '13812029950', '20220926', '李小龙', '无锡市玲琰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15574, '全系列', '2022-09-26', '常熟市海虞无纺布有限公司', '陈建良', '13606231335', '20220926', '李小龙', '常熟市海虞无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15575, '纤维', '2022-09-26', '化纤选品10版', '王倩', '13862085122', '20220926', '任海香', '科德宝宝翎无纺布（苏州）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15576, '纤维', '2022-09-26', '化纤选品10版', '庄卫宏', '13962339203', '20220926', '任海香', '常熟市三联无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15577, '纤维', '2022-09-26', '化纤选品10版', '陈敬德', '18662275391', '20220926', '任海香', '合亿无纺布（昆山）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15578, '纤维', '2022-09-26', '化纤选品10版', '郑建均', '13812802787', '20220926', '任海香', '苏州市羽洋无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15579, '纤维', '2022-09-26', '化纤选品10版', '江明光', '13962379158', '20220926', '任海香', '常熟市明光无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15580, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390331617155   Fax:+390331617546', '20220926', '郑静', 'FARE‘ SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15581, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390331617155   Fax:+390331617546', '20220926', '郑静', 'FIBERPARTNER APS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15582, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:917940012800', '20220926', '郑静', 'FIBRE2FASHIONPVT.LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15583, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', '18106860080', '20220926', '郑静', '绍兴爱蓝无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15584, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', '13851418550', '20220926', '郑静', '南京宏泰无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15585, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', '13327881070', '20220926', '郑静', '常州英诺无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15586, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', '13962313285', '20220926', '郑静', '常熟市双晨无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15587, '无纺', '2022-09-26', '白色纯涤纶针刺无纺布', '深入沟通中', '13179476666', '20220926', '郑静', '镇江汇创无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15588, '无纺布制品', '2022-09-26', '湿巾', '赵德友', '0551-65657937', '20220926', '顾怡青', '合肥德易生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15589, '无纺布制品', '2022-09-26', '湿巾', '金劲松', '0551-65319962', '20220926', '顾怡青', '安徽丰乐香料有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15590, '无纺布制品', '2022-09-26', '湿巾', '王德惠', '0551-62331678', '20220926', '顾怡青', '合肥永明服装有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15591, '无纺布制品', '2022-09-26', '湿巾', '王章信', '0551-65396552', '20220926', '顾怡青', '合肥新安医药营销有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15592, '无纺布制品', '2022-09-26', '湿巾', '陈绍辉', '0555-3501260', '20220926', '顾怡青', '马鞍山中粮生物化学有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15593, '无纺布制品', '2022-09-26', '湿巾', '叶红平', '15505618000', '20220926', '顾怡青', '安徽辉克药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15594, '无纺布制品', '2022-09-26', '湿巾', '蔡英传', '0562-6868001', '20220926', '顾怡青', '铜陵洁雅生物科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15595, '无纺布制品', '2022-09-26', '湿巾', '张立海', '0562-2651166', '20220926', '顾怡青', '铜陵市新星航空生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15596, '无纺布制品', '2022-09-27', '湿巾', '李明', '0556-5316606', '20220927', '顾怡青', '安庆明欣实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15597, '无纺布制品', '2022-09-27', '湿巾', '王琨', '18005685618', '20220927', '顾怡青', '安徽省天助纺织科技集团股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15598, '无纺布制品', '2022-09-27', '湿巾', '贾晓方', '13605677356', '20220927', '顾怡青', '太和县太清纺织品原料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15599, '无纺布制品', '2022-09-27', '湿巾', '段绕绕', '0557-4378999', '20220927', '顾怡青', '安徽华微农化股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15600, '无纺布制品', '2022-09-27', '湿巾', '魏星', '0564-8660187', '20220927', '顾怡青', '安徽省华银茶油有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15601, '无纺布制品', '2022-09-27', '湿巾', '黄强', '023-68731316', '20220927', '顾怡青', '重庆华联卫生用品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15602, '无纺布制品', '2022-09-27', '湿巾', '鲁海涛', '023-62822128', '20220927', '顾怡青', '重庆市海洁消毒卫生用品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15603, '无纺布制品', '2022-09-27', '湿巾', '郭水虎', '029-81881096', '20220927', '顾怡青', '陕西太和科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15604, '无纺布制品', '2022-09-27', '湿巾', '寇立龙', '13991122255', '20220927', '顾怡青', '西安华源纸业卫生保健用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15605, '纤维', '2022-09-27', '化纤选品10版', '陈铮珍', '13345947991', '20220927', '任海香', '浙江景程无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15606, '纤维', '2022-09-27', '化纤选品10版', '顾林晓', '15852593198', '20220927', '任海香', '江阴市海月无纺布业有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15607, '纤维', '2022-09-27', '化纤选品10版', '杨海涛', '13921931200', '20220927', '任海香', '扬州博大无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15608, '纤维', '2022-09-27', '化纤选品10版', '方小刚', '13582495396', '20220927', '任海香', '苏州中纺滤材无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15609, '纤维', '2022-09-27', '化纤选品10版', '胡磬', '13901682060', '20220927', '任海香', '普杰无纺布（中国）有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15610, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33472861637   Fax:+33472861695', '20220927', '郑静', 'FIBROLINE FRANCE SARL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15611, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33320493500   Fax:+33320493501', '20220927', '郑静', 'FIVES C/O FIVES DMS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15612, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+39035724243   Fax:+39035726386', '20220927', '郑静', 'FRANA POLIFIBRE SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15613, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+911127352015   Fax:+911127352016', '20220927', '郑静', 'GANESHA ECOSPHERE LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15614, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '18606222941', '20220927', '郑静', '太仓市双健无纺制品有限公司沙溪分公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15615, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13968021268', '20220927', '郑静', '杭州临安百浩无纺制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15616, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '18968028266', '20220927', '郑静', '杭州临安新业无纺制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15617, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13757199618', '20220927', '郑静', '杭州临安海贝无纺制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15618, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13777240838', '20220927', '郑静', '慈溪市佳贝无纺布制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15619, '无纺', '2022-09-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13355848924', '20220927', '郑静', '余姚市驰威无纺制品厂', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15620, '会员入驻', '2022-09-27', '无纺会员', '方月琴', '13601551568', '20220927', '郁新涛', '常熟市宝鼎无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15621, '会员入驻', '2022-09-27', '无纺会员', '钱生林', '15252533188', '20220927', '郁新涛', '广同（仪征）无纺布工业有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15622, '会员入驻', '2022-09-27', '无纺会员', '龚小兵', '13626118048', '20220927', '郁新涛', '扬州市锦程无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15623, '广告', '2022-09-27', '制品广告', '顾骏', '18136983080', '20220927', '郁新涛', '张家港保税区美而德无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15624, '机械工厂', '2022-09-27', '智能工厂', '岳东荣', '13606237597', '20220927', '郁新涛', '常熟市窑镇无纺机械有限责任公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15625, '机械工厂', '2022-09-27', '智能工厂', '冯晨', '13814901017', '20220927', '郁新涛', '常熟市明一无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15626, '全系列', '2022-09-27', '杭州永萌无纺制品有限公司', '周银珍', '13738037681', '20220927', '李小龙', '杭州永萌无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15627, '全系列', '2022-09-27', '常熟市恒鑫无纺制品有限公司', '伍晓丹', '13814932830', '20220927', '李小龙', '常熟市恒鑫无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15628, '全系列', '2022-09-27', '杭州诺邦无纺股份有限公司', '胡巍', '13071802285', '20220927', '李小龙', '杭州诺邦无纺股份有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15629, '全系列', '2022-09-27', '诸暨恒飞无纺科技有限公司', '赵飞钢', '13605800575', '20220927', '李小龙', '诸暨恒飞无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15630, '全系列', '2022-09-27', '苏州美森无纺科技有限公司', '陈忆', '18915504480', '20220927', '李小龙', '苏州美森无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15631, '全系列', '2022-09-27', '南通阳升无纺织物有限公司', '袁平', '13706282500', '20220927', '李小龙', '南通阳升无纺织物有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15632, '全系列', '2022-09-27', '苏州力鼎无纺技术有限公司', '俞雷', '18662626789', '20220927', '李小龙', '苏州力鼎无纺技术有限公司', '内贸', '30万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15633, '全系列', '2022-09-27', '苏州常盛水刺无纺有限公司', '彭抗保', '13862354321', '20220927', '李小龙', '苏州常盛水刺无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15634, '全系列', '2022-09-27', '太仓市富通无纺制造有限公司', '王淑贞', '13853212653', '20220927', '李小龙', '太仓市富通无纺制造有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15635, '全系列', '2022-09-27', '常熟市鑫豪无纺有限公司', '顾忠英', '18915776505', '20220927', '李小龙', '常熟市鑫豪无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15636, '全系列', '2022-09-28', '江阴海翔无纺科技有限公司', '华翔', '13771618715', '20220928', '李小龙', '江阴海翔无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15637, '全系列', '2022-09-28', '常熟市百佳无纺有限公司', '徐阿建', '13913622628', '20220928', '李小龙', '常熟市百佳无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15638, '全系列', '2022-09-28', '无锡克瑞特无纺科技有限公司', '施国章', '13584185555', '20220928', '李小龙', '无锡克瑞特无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15639, '全系列', '2022-09-28', '常熟市陈氏无纺制品有限公司', '陈连锋', '13915627788', '20220928', '李小龙', '常熟市陈氏无纺制品有限公司', '内贸', '30万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15640, '全系列', '2022-09-28', '泉州冠隆无纺科技有限公司', '马占河', '17758728888', '20220928', '李小龙', '泉州冠隆无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15641, '全系列', '2022-09-28', '江阴市中兴无纺布有限公司', '顾晓萍', '13912380011', '20220928', '李小龙', '江阴市中兴无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15642, '全系列', '2022-09-28', '绍兴舒洁雅无纺材料有限公司', '孟玲花', '18758507806', '20220928', '李小龙', '绍兴舒洁雅无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15643, '全系列', '2022-09-28', '杭州申皇无纺布用品有限公司', '孙中杰', '18969015696', '20220928', '李小龙', '杭州申皇无纺布用品有限公司', '内贸', '50万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15644, '全系列', '2022-09-28', '泉州华诺无纺布有限公司', '白海龙', '15905058944', '20220928', '李小龙', '泉州华诺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15645, '全系列', '2022-09-28', '上海豊格无纺布有限公司', '黄丽丽', '15021281864', '20220928', '李小龙', '上海豊格无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15646, '机械工厂', '2022-09-28', '智能工厂', '李臣山', '13505272361', '20220928', '郁新涛', '仪征市新城镇龙河街道1号', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15647, '机械工厂', '2022-09-28', '智能工厂', '王小雨', '15726208617', '20220928', '郁新涛', '山东省青岛市黄岛区王台镇郎中沟村后', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15648, '会员入驻', '2022-09-28', '无纺会员', '王红渊', '13815021979', '20220928', '郁新涛', '常州市戚墅堰鑫源无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15649, '会员入驻', '2022-09-28', '无纺会员', '杨德明', '13906233090', '20220928', '郁新涛', '常熟市新佳无纺布厂（普通合伙）', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15650, '会员入驻', '2022-09-28', '无纺会员', '吉新建', '13812997527', '20220928', '郁新涛', '张家港骏马无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15651, '广告', '2022-09-28', '制品广告', '杨卫宏', '13962688240', '20220928', '郁新涛', '昆山市宏叶无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15652, '纤维', '2022-09-28', '化纤选品10版', '吴京', '13806118699', '20220928', '任海香', '常州市武进江南无纺布厂', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15653, '纤维', '2022-09-28', '化纤选品10版', '许德跃', '13918616788', '20220928', '任海香', '希雅图（上海）无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15654, '纤维', '2022-09-28', '化纤选品10版', '张东林', '13706899735', '20220928', '任海香', '浙江星瑞达无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15655, '纤维', '2022-09-28', '化纤选品10版', '邓钊', '18630969801', '20220928', '任海香', '天津正奇新材料科技有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15656, '纤维', '2022-09-28', '化纤选品10版', '庞新材', '13817398578', '20220928', '任海香', '洁馨（上海）无纺布有限公司', '内贸', '30', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15657, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390373530011   Fax:+390373530164', '20220928', '郑静', 'GDM SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15658, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+911204058400   Fax:+911204250975', '20220928', '郑静', 'GINNI FILAMENTS LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15659, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390593300600   Fax:+39059828208', '20220928', '郑静', 'GIUGNI SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15660, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+911204058400   Fax:+911204250975', '20220928', '郑静', 'GKD-GEBR,KUFFERATH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15661, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '15967532159', '20220928', '郑静', '浙江宝仁（和中）无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15662, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13961696096', '20220928', '郑静', '江阴市广银无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15663, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13806231577', '20220928', '郑静', '苏州威来德无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15664, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13564776478', '20220928', '郑静', '上海会元无纺材料制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15665, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13218210903', '20220928', '郑静', '上海欣洁无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15666, '无纺', '2022-09-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13915245385', '20220928', '郑静', '江阴天佳无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15667, '无纺布制品', '2022-09-28', '湿巾', '郭鑫', '0411-87348881', '20220928', '顾怡青', '大连大鑫卫生护理用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15668, '无纺布制品', '2022-09-28', '湿巾', '谷源明', '0411-62695838', '20220928', '顾怡青', '大连瑞光非织造布集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15669, '无纺布制品', '2022-09-28', '湿巾', '熊小伟', '0411-83787129', '20220928', '顾怡青', '大连雄伟保健品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15670, '无纺布制品', '2022-09-28', '湿巾', '陶娜', '13194269200', '20220928', '顾怡青', '大连瑞洁生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15671, '无纺布制品', '2022-09-28', '湿巾', '鲍津', '0411-87113453', '20220928', '顾怡青', '大连大和木业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15672, '无纺布制品', '2022-09-28', '湿巾', '匡志香', '0411-83787129', '20220928', '顾怡青', '大连雄伟医用卫生品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15673, '无纺布制品', '2022-09-28', '湿巾', '王娜', '0411-89851255', '20220928', '顾怡青', '大连非得本草药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15674, '无纺布制品', '2022-09-28', '湿巾', '谷源明', '0411-62695838', '20220928', '顾怡青', '大连瑞源非织造布有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15675, '无纺布制品', '2022-09-28', '湿巾', '徐海波', '0415-2817733', '20220928', '顾怡青', '丹东欣时代生物医药科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15676, '机械工厂', '2022-09-29', '智能工厂', '陈卫华', '13773082006', '20220929', '郁新涛', '常熟市纽泰格无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15677, '机械工厂', '2022-09-29', '智能工厂', '唐成秀', '13616234628', '20220929', '郁新涛', '常熟市宝翔无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15678, '会员入驻', '2022-09-29', '无纺会员', '简德亮', '13575961295', '20220929', '郁新涛', '兰溪市华塑无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15679, '会员入驻', '2022-09-29', '无纺会员', '薛裕龙', '13806265010', '20220929', '郁新涛', '昆山永安非织造无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15680, '会员入驻', '2022-09-29', '无纺会员', '洪 星 ', '15251095555', '20220929', '郁新涛', '盐城恒天无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15681, '广告', '2022-09-29', '制品广告', '王锋', '13771826358', '20220929', '郁新涛', '苏州市锋锋无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15682, '全系列', '2022-09-29', '浙江欣富无纺布科技有限公司', '陈  嵘', '13805778576', '20220929', '李小龙', '浙江欣富无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15683, '全系列', '2022-09-29', '杭州顺龙无纺科技有限公司', '范福根', '13806513699', '20220929', '李小龙', '杭州顺龙无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15684, '全系列', '2022-09-29', '杭州森润无纺布科技有限公司', '陈兴泉', '15168203186', '20220929', '李小龙', '杭州森润无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15685, '全系列', '2022-09-29', '杭州思进无纺布有限公司', '胡炳年', '15988189328', '20220929', '李小龙', '杭州思进无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15686, '全系列', '2022-09-29', '浙江百联无纺科技有限责任公司', '冯涛', '13805771405', '20220929', '李小龙', '浙江百联无纺科技有限责任公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15687, '全系列', '2022-09-29', '浙江龙游上博无纺科技有限公司', '金刚强', '13968877373', '20220929', '李小龙', '浙江龙游上博无纺科技有限公司', '内贸', '30万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15688, '全系列', '2022-09-29', '江苏朵拉无纺科技有限公司', '刘红曙', '13382298001', '20220929', '李小龙', '江苏朵拉无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15689, '全系列', '2022-09-29', '温州超诚无纺科技有限公司', '陈智超', '18059370313', '20220929', '李小龙', '温州超诚无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15690, '全系列', '2022-09-29', '安徽金春无纺布股份有限公司', '曹松亭', '15855019235', '20220929', '李小龙', '安徽金春无纺布股份有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15691, '全系列', '2022-09-29', '江苏爱琪艺臻品无纺科技有限公司', '宋海琪', '18861717988', '20220929', '李小龙', '江苏爱琪艺臻品无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15692, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+62225225050   Fax:+6222522552', '20220929', '郑静', 'P.T.HASIL DAMAI TEXTILE(HADTEX)', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15693, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+492117970   Fax:+4921179814858', '20220929', '郑静', 'HENKEL AG&CO.KGAA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15694, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+41919605900   Fax:+41919605992', '20220929', '郑静', 'ILAPAK INTERNATIONL SA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15695, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+49944199519   Fax:+49944199568', '20220929', '郑静', 'KELHEIM FIBRES GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15696, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '13962311391', '20220929', '郑静', '常熟市依威无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15697, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '13851220235', '20220929', '郑静', '沭阳县振韩无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15698, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '13806231619', '20220929', '郑静', '常熟市紫艳无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15699, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '18651960164', '20220929', '郑静', '常州市金一翔无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15700, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '13806238991', '20220929', '郑静', '常熟市耀华无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15701, '无纺', '2022-09-29', '白色纯涤纶针刺无纺布', '深入沟通中', '13773066680', '20220929', '郑静', '常熟市金兔无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15702, '无纺布制品', '2022-09-29', '湿巾', '史滨', '13602015058', '20220929', '顾怡青', '天津郁美净集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15703, '无纺布制品', '2022-09-29', '湿巾', '王承来', '15522175178', '20220929', '顾怡青', '天津市赫博鲜中药研究所卫生消毒湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15704, '无纺布制品', '2022-09-29', '湿巾', '林云霞', '13820428906', '20220929', '顾怡青', '天津花王卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15705, '无纺布制品', '2022-09-29', '湿巾', '高福忠', '022-23792302', '20220929', '顾怡青', '天津市依依卫生用品股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15706, '无纺布制品', '2022-09-29', '湿巾', '段家骥', '022-26993852', '20220929', '顾怡青', '天津市艳胜工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15707, '无纺布制品', '2022-09-29', '湿巾', '李凤山', '022-22497771', '20220929', '顾怡青', '天津市娇柔卫生制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15708, '无纺布制品', '2022-09-29', '湿巾', '宁学杰', '15302157333', '20220929', '顾怡青', '天津市恒洁卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15709, '无纺布制品', '2022-09-29', '湿巾', '徐文河', '13902063077', '20220929', '顾怡青', '天津市洁雅妇女卫生保健制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15710, '会员入驻', '2022-09-30', '无纺会员', '戚思齐', '18258117445', '20220930', '郁新涛', '吉安市三江超纤无纺有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15711, '会员入驻', '2022-09-30', '无纺会员', '庞凤肖', '\n18918040385', '20220930', '郁新涛', '上海洁纳无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15712, '会员入驻', '2022-09-30', '无纺会员', '季小英', '\n15821187116', '20220930', '郁新涛', '上海万三无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15713, '广告', '2022-09-30', '制品广告', '周晓梅', '13771589480', '20220930', '郁新涛', '南通迪朗瑞无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15714, '机械工厂', '2022-09-30', '智能工厂', '刘琼霞', '13805989034', '20220930', '郁新涛', '晋江市双鑫针织机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15715, '机械工厂', '2022-09-30', '智能工厂', '李拥军', '13823851339', '20220930', '郁新涛', '梅州市华新无纺布机械制造有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15716, '全系列', '2022-09-30', '江苏蓓露馨医用材料科技有限公司', '杨伟民', '13852663458', '20220930', '李小龙', '江苏蓓露馨医用材料科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15717, '全系列', '2022-09-30', '江苏索富达无纺布有限公司', '王汉祥', '15051311510', '20220930', '李小龙', '江苏索富达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15718, '全系列', '2022-09-30', '宿迁鼎信水刺无纺布有限公司', '凌枫', '13566268686', '20220930', '李小龙', '宿迁鼎信水刺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15719, '全系列', '2022-09-30', '湖南雅洁新材料有限公司', '郭建平', '15197679439', '20220930', '李小龙', '湖南雅洁新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15720, '全系列', '2022-09-30', '浙江永通纺织印染有限公司', '李小芳', '13588581119', '20220930', '李小龙', '浙江永通纺织印染有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15721, '全系列', '2022-09-30', '河南科润康非织造布有限公司', '李波', '13937339068', '20220930', '李小龙', '河南科润康非织造布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15722, '全系列', '2022-09-30', '昆山科立隆非织造布有限公司', '饶玉黔', '13606268829', '20220930', '李小龙', '昆山科立隆非织造布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15723, '全系列', '2022-09-30', '山东锦腾弘达水刺无纺布有限责任公司', '胡修平', '18266019988', '20220930', '李小龙', '山东锦腾弘达水刺无纺布有限责任公司', '内贸', '50万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15724, '全系列', '2022-09-30', '惠州市洪涛无纺布有限公司', '屈洪涛', '15989350912', '20220930', '李小龙', '惠州市洪涛无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15725, '全系列', '2022-09-30', '常熟市森拓非织造布有限公司', '吴嘉祺', '13646238166', '20220930', '李小龙', '常熟市森拓非织造布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15726, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4376727010   Fax:+4376729182644', '20220930', '郑静', 'LENZING AG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15727, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390392246705   Fax:+390392246706', '20220930', '郑静', 'LUKAY NONWOVEN SOLUTIONS SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15728, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4943213050   Fax:+494321305212', '20220930', '郑静', 'OERLIKON NEUMAG ZWEIGNIEDERLASSUNG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15729, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+497915060   Fax:+497915069000', '20220930', '郑静', 'OPTIMA NONWOVENS GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15730, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '13812835615', '20220930', '郑静', '常熟市言诺无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15731, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '13901456098', '20220930', '郑静', '仪征市龙诚无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15732, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '15952595115', '20220930', '郑静', '仪征盛宇无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15733, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '13196485736', '20220930', '郑静', '扬州恒源无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15734, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '18921562206', '20220930', '郑静', '扬中市鸿运无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15735, '无纺', '2022-09-30', '白色纯涤纶针刺无纺布', '深入沟通中', '15949095352', '20220930', '郑静', '仪征天恒无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15736, '无纺布制品', '2022-09-30', '湿巾', '张刚', '022-83719826', '20220930', '顾怡青', '天津鎏虹科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15737, '无纺布制品', '2022-09-30', '湿巾', '林德志', '13170883668', '20220930', '顾怡青', '南昌万家洁卫生制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15738, '无纺布制品', '2022-09-30', '湿巾', '杨自然', '0791-88139328', '20220930', '顾怡青', '江西国桥实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15739, '无纺布制品', '2022-09-30', '湿巾', '熊焕华', '0791-88102525', '20220930', '顾怡青', '南昌科奇高新技术产品实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15740, '无纺布制品', '2022-09-30', '湿巾', '余陈', '0792-2831933', '20220930', '顾怡青', '江西生成卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15741, '无纺布制品', '2022-09-30', '湿巾', '聂金海', '0796-3692398', '20220930', '顾怡青', '江西吉安三力制药有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15742, '无纺布制品', '2022-09-30', '湿巾', '冯永发', '18296599999', '20220930', '顾怡青', '江西吴城实业发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15743, '无纺布制品', '2022-09-30', '湿巾', '杨周', '0871-68100008', '20220930', '顾怡青', '昆明兴亮工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15744, '无纺布制品', '2022-09-30', '湿巾', '甘显堂', '0771-4913175', '20220930', '顾怡青', '广西南宁甘霖工贸有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15745, '无纺布制品', '2022-09-30', '湿巾', '韦飞燕', '0772-3993500', '20220930', '顾怡青', '广西壮族自治区花红药业集团股份公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15746, '会员入驻', '2022-10-08', '无纺会员', '周春林', '\n18217669550', '20221008', '郁新涛', '上海青浦重固喷涂厂无纺布分厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15747, '会员入驻', '2022-10-08', '无纺会员', '陆春根', '\n13003188275', '20221008', '郁新涛', '上海绿春无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15748, '会员入驻', '2022-10-08', '无纺会员', '区锦超', '\n13917364305', '20221008', '郁新涛', '上海腾斐无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15749, '广告', '2022-10-08', '制品广告', '董晓倩', '13750815500', '20221008', '郁新涛', '杭州天琪无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15750, '机械工厂', '2022-10-08', '智能工厂', '曹雨冬', '13915817601', '20221008', '郁新涛', '常州金坛东大机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15751, '机械工厂', '2022-10-08', '智能工厂', '李后楷', '13917144111', '20221008', '郁新涛', '上海泸信轻工机械设备制造有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15752, '全系列', '2022-10-08', '杭州临安华迅水刺布有限公司', '金宝珍', '13968036161', '20221008', '李小龙', '杭州临安华迅水刺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15753, '全系列', '2022-10-08', '徐州金龙桥无纺新材料有限公司', '丁晓丽', '15895219818', '20221008', '李小龙', '徐州金龙桥无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15754, '全系列', '2022-10-08', '安徽智博新材料科技有限公司', '张加宽', '13309693656', '20221008', '李小龙', '安徽智博新材料科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15755, '全系列', '2022-10-08', '浙江洁呈新材料科技股份有限公司', '姚斌', '13968195298', '20221008', '李小龙', '浙江洁呈新材料科技股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15756, '全系列', '2022-10-08', '湖州超友无纺布有限公司', '贾年法', '13968091526', '20221008', '李小龙', '湖州超友无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15757, '全系列', '2022-10-08', '江苏伟创力新材料有限公司', '吴述成', '18015459686', '20221008', '李小龙', '江苏伟创力新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15758, '全系列', '2022-10-08', '江苏艾科普新材料有限公司', '虞夫潮', '13905812900', '20221008', '李小龙', '江苏艾科普新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15759, '全系列', '2022-10-08', '郑州枫林无纺科技有限公司', '郅卫强', '13938282119', '20221008', '李小龙', '郑州枫林无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15760, '全系列', '2022-10-08', '常州全棉乐家医疗用品有限公司', '卢明信', '13776863005', '20221008', '李小龙', '常州全棉乐家医疗用品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15761, '全系列', '2022-10-08', '浙江宏源无纺布有限公司', '朱秀仁', '13575387991', '20221008', '李小龙', '浙江宏源无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15762, '无纺布制品', '2022-10-08', '湿巾', '张耀军', '025-86302826', '20221008', '顾怡青', '南京香城卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15763, '无纺布制品', '2022-10-08', '湿巾', '蒋旭东', '0510-88826666', '20221008', '顾怡青', '无锡波尔医疗科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15764, '无纺布制品', '2022-10-08', '湿巾', '廖学埙', '0516-86998906', '20221008', '顾怡青', '徐州葆月婴儿用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15765, '无纺布制品', '2022-10-08', '湿巾', '周德锋', '13861044221', '20221008', '顾怡青', '常州美帛纺织品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15766, '无纺布制品', '2022-10-08', '湿巾', '陆元清', '13809076090', '20221008', '顾怡青', '常州市梦爽卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15767, '无纺布制品', '2022-10-08', '湿巾', 'KENTARO ISHIKAWA（石川健太郎）', '0512-62837058', '20221008', '顾怡青', '艾姆科技（苏州）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15768, '无纺布制品', '2022-10-08', '湿巾', '徐炳根', '0512-63617680', '20221008', '顾怡青', '苏州东方之宝生物药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15769, '无纺布制品', '2022-10-08', '湿巾', '黄学军', '15950081262', '20221008', '顾怡青', '恩杜罗生物技术（苏州工业园区）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15770, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390415799111   Fax:+390415799244', '20221008', '郑静', 'PIOVAN SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15771, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+334472092929   Fax:+33472092930', '20221008', '郑静', 'PLLYMOUTH FRANCAISE', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15772, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+902124453410   Fax:+902124451993', '20221008', '郑静', 'RENKSAN PLASTIK SUNGER SAN', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15773, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+903423295000   Fax:+903423290970', '20221008', '郑静', 'PITAS KIMYA VE TEKSTIL SAN TIC .A.S.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15774, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13401560767', '20221008', '郑静', '常州市德成无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15775, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13905975005', '20221008', '郑静', '晋江兴泰无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15776, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '15300663768', '20221008', '郑静', '上海剑良无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15777, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13564053636', '20221008', '郑静', '上海明叶无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15778, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '\n18964009123', '20221008', '郑静', '上海丝艺无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15779, '无纺', '2022-10-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13761655105', '20221008', '郑静', '上海景全无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15780, '全系列', '2022-10-09', '杭州华顶环保科技有限公司', '陈超', '13588243120', '20221009', '李小龙', '杭州华顶环保科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15781, '全系列', '2022-10-09', '嘉兴市宏亮纺织有限公司', '洪萍', '15068362302', '20221009', '李小龙', '嘉兴市宏亮纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15782, '全系列', '2022-10-09', '苏州科润织造有限公司', '庄郁峰', '15995551982', '20221009', '李小龙', '苏州科润织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15783, '全系列', '2022-10-09', '慈溪市三北水刺无纺布有限公司', '周彩娟', '13706741018', '20221009', '李小龙', '慈溪市三北水刺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15784, '全系列', '2022-10-09', '绍兴鑫裕纺织品有限公司', '李国兵', '15988211873', '20221009', '李小龙', '绍兴鑫裕纺织品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15785, '全系列', '2022-10-09', '常州坊客无纺布有限公司', '李晓东', '15051933659', '20221009', '李小龙', '常州坊客无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15786, '全系列', '2022-10-09', '绍兴烁盛特种纤维有限公司', '周茂林', '13957581311', '20221009', '李小龙', '绍兴烁盛特种纤维有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15787, '全系列', '2022-10-09', '上海皇贝纤维制品有限公司', '徐友良', '13361910326', '20221009', '李小龙', '上海皇贝纤维制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15788, '全系列', '2022-10-09', '南通新通活性碳纤维有限公司', '陈雷', '13606292970', '20221009', '李小龙', '南通新通活性碳纤维有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15789, '全系列', '2022-10-09', '常熟市飞龙纤维制品有限公司', '周明元', '13801502826', '20221009', '李小龙', '常熟市飞龙纤维制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15790, '会员入驻', '2022-10-09', '上海欣翎无纺布设备制造有限公司', '曹水勇', '\n13003159002', '20221009', '郁新涛', '上海欣翎无纺布设备制造有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15791, '会员入驻', '2022-10-09', '常州瑞美特无纺布有限公司', '沈国平', '13861271228', '20221009', '郁新涛', '常州瑞美特无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15792, '会员入驻', '2022-10-09', '丹阳市华荣无纺布有限公司', '陈华芳', '13852961972', '20221009', '郁新涛', '丹阳市华荣无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15793, '广告', '2022-10-09', '杭州艾妮美无纺制品有限公司', '陈富江', '15257179325', '20221009', '郁新涛', '杭州艾妮美无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15794, '机械工厂', '2022-10-09', '常熟市豪阳无纺机械有限公司', '曹卫权', '13862359680', '20221009', '郁新涛', '常熟市豪阳无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15795, '机械工厂', '2022-10-09', '苏州雅各皮绒机械科技有限公司', '殷惠林', '13862356338', '20221009', '郁新涛', '苏州雅各皮绒机械科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15796, '无纺布制品', '2022-10-09', '湿巾', '沈建清', '13901570611', '20221009', '顾怡青', '常熟市何市星晨纱厂（普通合伙）', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15797, '无纺布制品', '2022-10-09', '湿巾', '陈浩岩', '0513-88501000', '20221009', '顾怡青', '恩倍宠物器具（南通）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15798, '无纺布制品', '2022-10-09', '湿巾', '张华良', '13812831520', '20221009', '顾怡青', '淮安市清河区良华酒店用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15799, '无纺布制品', '2022-10-09', '湿巾', '崔善忠', '18917033058', '20221009', '顾怡青', '上海权炼卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15800, '无纺布制品', '2022-10-09', '湿巾', '何忠', '13482898953', '20221009', '顾怡青', '上海希洛商务咨询有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15801, '无纺布制品', '2022-10-09', '湿巾', '叶剑敏', '13515872273', '20221009', '顾怡青', '上海辉伦婴儿用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15802, '无纺布制品', '2022-10-09', '湿巾', '蔡光耀', '021-57690388', '20221009', '顾怡青', '上海恒耀企业发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15803, '无纺布制品', '2022-10-09', '湿巾', '王金炎', '0573-87960829', '20221009', '顾怡青', '杭州奇美无纺布用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15804, '无纺布制品', '2022-10-09', '湿巾', '罗权', '13958183741', '20221009', '顾怡青', '杭州兮车清洁用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15805, '无纺布', '2022-10-09', '碳粉骨架过滤复合材料', '', '', '20221009', '顾怡青', '', '内贸', '6', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15806, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+902123310000   Fax:+902123310001', '20221009', '郑静', 'ORGANIK KIMYA SAN VE.TIC A.S', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15807, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390331609111   Fax:+390331604646', '20221009', '郑静', 'ORSA N.W.SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15808, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+497915060   Fax:+497915069000', '20221009', '郑静', 'OPTIMA PACKAGING GROUP GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15809, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+92512201951   Fax:+9252822564', '20221009', '郑静', 'SAIF TEXTILE MILLS LIMITED', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15810, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n18930813666', '20221009', '郑静', '上海合洪无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15811, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13801724957', '20221009', '郑静', '上海鼎瑞无纺布制造有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15812, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13045672388', '20221009', '郑静', '上海金昂无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15813, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n18602134485', '20221009', '郑静', '上海创然无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15814, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n18918029898', '20221009', '郑静', '上海沈惠无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15815, '无纺', '2022-10-09', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13818699940', '20221009', '郑静', '上海青阳无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15816, '会员入驻', '2022-10-10', '无纺会员', '黄允如', '\n13918169933', '20221010', '郁新涛', '上海巽宜无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15817, '会员入驻', '2022-10-10', '无纺会员', '朱金', '15050941322', '20221010', '郁新涛', '宿迁市金鸿无纺布袋有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15818, '会员入驻', '2022-10-10', '无纺会员', '顾晓萍', '18915227718', '20221010', '郁新涛', '江阴市鑫茂无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15819, '广告', '2022-10-10', '制品广告', '何东', '13586655170', '20221010', '郁新涛', '宁波濠宬无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15820, '机械工厂', '2022-10-10', '智能工厂', '于红聘', '13653338550', '20221010', '郁新涛', '南宫翔宇家纺机械制造有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15821, '机械工厂', '2022-10-10', '智能工厂', '秦叶丹', '13862344090', '20221010', '郁新涛', '常熟泰丰无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15822, '全系列', '2022-10-10', '常熟市聚格纤维制品有限公司', '钱鸣东', '3862344320', '20221010', '李小龙', '常熟市聚格纤维制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15823, '全系列', '2022-10-10', '常熟市大河纤维有限公司', '崔顺利', '13801569561', '20221010', '李小龙', '常熟市大河纤维有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15824, '全系列', '2022-10-10', '温州锦源合成纤维有限公司', '陈碎芬', '0577-85388810', '20221010', '李小龙', '温州锦源合成纤维有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15825, '全系列', '2022-10-10', '山东宏盛非织造布有限公司', '李栋', '13562528775', '20221010', '李小龙', '山东宏盛非织造布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15826, '全系列', '2022-10-10', '南通新绿叶非织造布有限公司', '王洪云', '0513-85276033', '20221010', '李小龙', '南通新绿叶非织造布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15827, '全系列', '2022-10-10', '江苏丽洋新材料股份有限公司', '尤祥银', '0513-85524796', '20221010', '李小龙', '江苏丽洋新材料股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15828, '全系列', '2022-10-10', '浙江龙游上博无纺科技有限公司', '金刚强', '0570-7020308', '20221010', '李小龙', '浙江龙游上博无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15829, '全系列', '2022-10-10', '浙江百联无纺科技有限责任公司', '陈伟', '13805776030', '20221010', '李小龙', '浙江百联无纺科技有限责任公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15830, '全系列', '2022-10-10', '常熟市振泰水刺布有限公司', '冉士兵', '0512-52580490', '20221010', '李小龙', '常熟市振泰水刺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15831, '全系列', '2022-10-10', '浙江永光无纺布股份有限公司', '张祖峰', '13505731370', '20221010', '李小龙', '浙江永光无纺布股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15832, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33475313800   Fax:+33475317827', '20221010', '郑静', 'SANDVIK HYPERION', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15833, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+41719186666   Fax:+41719186600', '20221010', '郑静', 'SANTEX RIMAR AG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15834, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+972545669707', '20221010', '郑静', 'GREEN POLYMERS LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15835, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+441618779955   Fax:+441618779198', '20221010', '郑静', 'SAPPLICATOR LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15836, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13601986263', '20221010', '郑静', '上海欣树无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15837, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13917872067', '20221010', '郑静', '上海国城无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15838, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '\n13701903443', '20221010', '郑静', '上海纯绅无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15839, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '\n15800359535', '20221010', '郑静', '茸昕无纺布制品（上海）有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15840, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '13812160626', '20221010', '郑静', '江阴市金建无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15841, '无纺', '2022-10-10', '白色纯涤纶针刺无纺布', '深入沟通中', '13801567667', '20221010', '郑静', '张家港市海洲无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15842, '无纺布制品', '2022-10-10', '湿巾', '梅韩成', '13805705145', '20221010', '顾怡青', '杭州大拇指清洁用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15843, '无纺布制品', '2022-10-10', '湿巾', '沈光伟', '0571-61100665', '20221010', '顾怡青', '杭州临安洁诺无纺布制品厂合伙企业（普通合伙）', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15844, '无纺布制品', '2022-10-10', '湿巾', '伍本先', '0571-88148003', '20221010', '顾怡青', '杭州邦林粘合科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15845, '无纺布制品', '2022-10-10', '湿巾', '杨黎明', '0574-63937658', '20221010', '顾怡青', '宁波新天地沐浴用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15846, '无纺布制品', '2022-10-10', '湿巾', '张敏刚', '0573-83255078', '20221010', '顾怡青', '嘉兴市秀洲区舒香无纺布湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15847, '无纺布制品', '2022-10-10', '湿巾', '沈伟明', '13706580057', '20221010', '顾怡青', '嘉善县嘉斯利箱包有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15848, '无纺布制品', '2022-10-10', '湿巾', '马杏花', '13175286478', '20221010', '顾怡青', '绍兴市康洁宝卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15849, '无纺布制品', '2022-10-10', '湿巾', '楼胜利', '15906892530', '20221010', '顾怡青', '义乌市润洁日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15850, '无纺布制品', '2022-10-10', '湿巾', '崔进芝', '0533-8398391', '20221010', '顾怡青', '张店竹林轩香湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15851, '全系列', '2022-10-11', '杭州森润无纺布科技有限公司', '陈越 ', '15168498588', '20221011', '李小龙', '杭州森润无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15852, '全系列', '2022-10-11', '杭州正远新材料科技有限公司', '戚国新', '13905718623', '20221011', '李小龙', '杭州正远新材料科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15853, '全系列', '2022-10-11', '杭州萧山凤凰纺织有限公司', '石成匡', '18058157956', '20221011', '李小龙', '杭州萧山凤凰纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15854, '全系列', '2022-10-11', '安徽金春无纺布股份有限公司', '曹松亭 ', '18705500768', '20221011', '李小龙', '安徽金春无纺布股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15855, '全系列', '2022-10-11', '温州超诚无纺科技有限公司', '陈智超', '15860696845', '20221011', '李小龙', '温州超诚无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15856, '全系列', '2022-10-11', '江苏明晶布业股份有限公司', '蔡明贤 ', '13276128338', '20221011', '李小龙', '江苏明晶布业股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15857, '全系列', '2022-10-11', '江苏朵拉无纺科技有限公司', '刘红曙', '13382298001', '20221011', '李小龙', '江苏朵拉无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15858, '全系列', '2022-10-11', '杭州杭纺科技有限公司', '裘肖坚', '13588761160', '20221011', '李小龙', '杭州杭纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15859, '全系列', '2022-10-11', '江苏思博特纺织科技有限公司', '徐跃飞', '13913258181', '20221011', '李小龙', '江苏思博特纺织科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15860, '全系列', '2022-10-11', '上海枫围无纺布厂有限公司', '沈玉云', '021-57352590 ', '20221011', '李小龙', '上海枫围无纺布厂有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15861, '会员入驻', '2022-10-11', '无纺会员', '王祥林', '13813178610', '20221011', '13813178610', '扬州市同创无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15862, '会员入驻', '2022-10-11', '无纺会员', '晏仲武', '13815803078', '20221011', '13815803078', '无锡市海洋无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15863, '会员入驻', '2022-10-11', '无纺会员', '李天晓', '13914659343', '20221011', '13914659343', '盐城福天无纺布业有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15864, '广告', '2022-10-11', '无纺会员', '王祥林', '13813178610', '20221011', '13813178610', '扬州市同创无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15865, '机械工厂', '2022-10-11', '智能工厂', '邱进鹤', '19826321828', '20221011', '19826321828', '东台鸿瑞无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15866, '机械工厂', '2022-10-11', '智能工厂', '陈智超', '13868837793', '20221011', '13868837793', '温州超诚无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15867, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+441618779955   Fax:+441618779198', '20221011', '郑静', 'SAPPLICATOR LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15868, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+902827581684', '20221011', '郑静', 'SAREKS AMBALAJ SAN VE TIC A.S.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15869, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+492564120   Fax:+49256412420', '20221011', '郑静', 'SAUEESSIG GMBH+CO.KG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15870, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390238006696   Fax:+3902308699', '20221011', '郑静', 'SAVARE’I.C.SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15871, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13706239070', '20221011', '郑静', '常熟市益盛无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15872, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13861060025', '20221011', '郑静', '常州市中大无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15873, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13906237432', '20221011', '郑静', '常熟市中欣无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15874, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13774689986', '20221011', '郑静', '丹阳市金亿来无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15875, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '18015632898', '20221011', '郑静', '常熟市时顺无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15876, '无纺', '2022-10-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13685107337', '20221011', '郑静', '徐州市尚诚无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15877, '无纺布制品', '2022-10-11', '湿巾', '朱礼伟', '13153922880', '20221011', '顾怡青', '莒南县美华卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15878, '无纺布制品', '2022-10-11', '湿巾', '刘学良', '15966351777', '20221011', '顾怡青', '山东艾丝妮乐卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15879, '无纺布制品', '2022-10-11', '湿巾', '张永丽', '15133135995', '20221011', '顾怡青', '石家庄市东方圣帝商贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15880, '无纺布制品', '2022-10-11', '湿巾', '李相亭', '0315-3215255', '20221011', '顾怡青', '唐山市一品净日化厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15881, '无纺布制品', '2022-10-11', '湿巾', '王超权', '0312-7066763', '20221011', '顾怡青', '保定亿佳纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15882, '无纺布制品', '2022-10-11', '湿巾', '常利成', '0371-65338249', '20221011', '顾怡青', '郑州万戈免洗用品工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15883, '无纺布制品', '2022-10-11', '湿巾', '乔亚娟', '13839881523', '20221011', '顾怡青', '三门峡市湖滨区雅洁卫生制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15884, '无纺布制品', '2022-10-11', '湿巾', '陈夏清', '0598-5057798', '20221011', '顾怡青', '三明市康尔佳卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15885, '无纺布制品', '2022-10-11', '湿巾', '黄加走', '13599112213', '20221011', '顾怡青', '泉州市新联卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15886, '无纺布制品', '2022-10-11', '湿巾', '李福官（LEE HOCK KUAN）', '0595-36362000', '20221011', '顾怡青', '百润（中国）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15887, '全系列', '2022-10-12', '江苏奥特隆新材料有限公司', '钱刚', '15252561063', '20221012', '李小龙', '江苏奥特隆新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15888, '全系列', '2022-10-12', '温州烈骏无纺科技有限公司', '黄兆微', '13958943052', '20221012', '李小龙', '温州烈骏无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15889, '全系列', '2022-10-12', '绍兴叶鹰纺化有限公司', '刘秀芳', '15925886580', '20221012', '李小龙', '绍兴叶鹰纺化有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15890, '全系列', '2022-10-12', '浙江华昊新材料有限公司', '林友孝', '13868369532', '20221012', '李小龙', '浙江华昊新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15891, '全系列', '2022-10-12', '浙江省东阳市宣得纺织科技有限公司', '徐珅晨', '18257096622', '20221012', '李小龙', '浙江省东阳市宣得纺织科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15892, '全系列', '2022-10-12', '杭州思进无纺布有限公司', '胡炳年', '13429670299', '20221012', '李小龙', '杭州思进无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15893, '全系列', '2022-10-12', '无锡盈尔纺织品有限公司', '肖春艳', '18762632011', '20221012', '李小龙', '无锡盈尔纺织品有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15894, '全系列', '2022-10-12', '江阴金港无纺布有限公司', '吴原铖', '13701529097', '20221012', '李小龙', '江阴金港无纺布有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15895, '全系列', '2022-10-12', '江阴恒和无纺布制品有限公司', '李明钢', '13706161125', '20221012', '李小龙', '江阴恒和无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15896, '全系列', '2022-10-12', '常熟璟杰无纺制品有限公司', '刘道林', '13812812886', '20221012', '李小龙', '常熟璟杰无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15897, '会员入驻', '2022-10-12', '无纺会员', '汪海鹏', '\n18621881576', '20221012', '郁新涛', '上海震霖无纺布用品有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15898, '会员入驻', '2022-10-12', '无纺会员', '罗晨', '13861369456', '20221012', '郁新涛', '镇江市通达无纺材料有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15899, '会员入驻', '2022-10-12', '无纺会员', '周光勇', '13656607266', '20221012', '郁新涛', '嘉兴市雅盛莱无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15900, '广告', '2022-10-12', '制品广告', '魏自泉', '18905736975', '20221012', '郁新涛', '嘉兴一渡无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15901, '机械工厂', '2022-10-12', '智能工厂', '徐炳键', '13456305027', '20221012', '郁新涛', '浙江法来福无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15902, '机械工厂', '2022-10-12', '智能工厂', '谷贤群', '18857721230', '20221012', '郁新涛', '浙江广鸿无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15903, '无纺布制品', '2022-10-12', '湿巾', '施文博', '0595-85708888', '20221012', '顾怡青', '恒安（中国）卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15904, '无纺布制品', '2022-10-12', '湿巾', '雷颉奕', '027-83413065', '20221012', '顾怡青', '武汉贝思特纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15905, '无纺布制品', '2022-10-12', '湿巾', '纪华', '0713-8815888', '20221012', '顾怡青', '稳健医疗（黄冈）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15906, '无纺布制品', '2022-10-12', '湿巾', '江小明', '0556-6021020', '20221012', '顾怡青', '安徽海锦棉业油脂有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15907, '无纺布制品', '2022-10-12', '湿巾', '胡永胜', '13905613188', '20221012', '顾怡青', '萧县恒泰纺织有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15908, '无纺布制品', '2022-10-12', '湿巾', '陈进生', '15829666659', '20221012', '顾怡青', '陕西浩森医药生物有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15909, '无纺布制品', '2022-10-12', '湿巾', '孙纯红', '029-88225356', '20221012', '顾怡青', '西安亮剑科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15910, '无纺布制品', '2022-10-12', '湿巾', '刘子平', '18991099229', '20221012', '顾怡青', '榆林市大鹏广告装饰有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15911, '无纺布制品', '2022-10-12', '湿巾', 'LIAO MEI SHENG', '13973181394', '20221012', '顾怡青', '长沙市博泰生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15912, '无纺布制品', '2022-10-12', '湿巾', '王之锴', '0411-83291534', '20221012', '顾怡青', '大连良范生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15913, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33479250525   Fax:+33479253207', '20221012', '郑静', 'SCANTECH S.A.S', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15914, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+49615115310', '20221012', '郑静', 'SCHENCK PROCESS EUROPE GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15915, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+497031282129', '20221012', '郑静', 'SCHILL SEILACHER GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15916, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4928459300   Fax:+492845930100', '20221012', '郑静', 'SCHWING FLUID TECHNIK GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15917, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '13382521257', '20221012', '郑静', '常熟市上阳无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15918, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '13372127506', '20221012', '郑静', '常熟市常盛无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15919, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '18962333315', '20221012', '郑静', '苏州市肖鸿运无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15920, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '13961587585', '20221012', '郑静', '无锡市合众无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15921, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '13905256159', '20221012', '郑静', '仪征市双星无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15922, '无纺', '2022-10-12', '白色纯涤纶针刺无纺布', '深入沟通中', '13601572956', '20221012', '郑静', '常熟市诚得利无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15923, '会员入驻', '2022-10-13', '无纺会员', '吕江勇', '13858910776', '20221013', '郁新涛', '浙江格润卫普无纺材料有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15924, '会员入驻', '2022-10-13', '无纺会员', '端春香', '17705147182', '20221013', '郁新涛', '南京市溧水区媛梦无纺布阻燃材料厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15925, '会员入驻', '2022-10-13', '无纺会员', '施建东', '13814995980', '20221013', '郁新涛', '常熟市惠成无纺布业有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15926, '广告', '2022-10-13', '制品广告', '金伟东', '18106860080', '20221013', '郁新涛', '绍兴爱蓝无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15927, '机械工厂', '2022-10-13', '智能工厂', '黄晓', '13812029950', '20221013', '郁新涛', '无锡市玲琰无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15928, '机械工厂', '2022-10-13', '智能工厂', '陈建良', '13606231335', '20221013', '郁新涛', '常熟市海虞无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15929, '全系列', '2022-10-13', '杭州朗至纺织有限公司', '朱建英', '13967153928', '20221013', '李小龙', '杭州朗至纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15930, '全系列', '2022-10-13', '苏州丽笙纺织有限公司', '王燕丽', '15051737373', '20221013', '李小龙', '苏州丽笙纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15931, '全系列', '2022-10-13', '上海意东无纺布制造有限公司', '刘红国', '13917753535', '20221013', '李小龙', '上海意东无纺布制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15932, '全系列', '2022-10-13', '常熟市立新无纺布织造有限公司', '周祥元', '15962286133', '20221013', '李小龙', '常熟市立新无纺布织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15933, '全系列', '2022-10-13', '江苏科来材料科技有限公司', '胡雷振', '13776543719', '20221013', '李小龙', '江苏科来材料科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15934, '全系列', '2022-10-13', '苏州正义无纺制品有限公司', '孙自永', '15962305942', '20221013', '李小龙', '苏州正义无纺制品有限公司', '内贸', '10万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15935, '全系列', '2022-10-13', '常州华纳非织造布有限公司', '庄海祥', '13901505710', '20221013', '李小龙', '常州华纳非织造布有限公司', '内贸', '20万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15936, '全系列', '2022-10-13', '江阴金凤特种纺织品有限公司', '孙亚渊', '13961600182', '20221013', '李小龙', '江阴金凤特种纺织品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15937, '全系列', '2022-10-13', '常熟市新盛无纺制品有限公司', '范福根', '0512-52586283', '20221013', '李小龙', '常熟市新盛无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15938, '全系列', '2022-10-13', '江阴东刘纺织有限公司', '刘红曙', '13301528718', '20221013', '李小龙', '江阴东刘纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15939, '无纺布', '2022-10-13', '纺粘长丝', '储永伟', '', '20221013', '顾怡青', '', '内贸', '6', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15940, '无纺布', '2022-10-13', '蓝色木浆水刺布', 'BUD', '', '20221013', '顾怡青', '', '内贸', '7', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15941, '无纺布制品', '2022-10-13', '湿巾', '蒋立成', '0412-8569623', '20221013', '顾怡青', '鞍山市天赐健康高科技功能水有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15942, '无纺布制品', '2022-10-13', '湿巾', '唐永', '13591557000', '20221013', '顾怡青', '抚顺市利嘉卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15943, '无纺布制品', '2022-10-13', '湿巾', '吴明智', '18970455585', '20221013', '顾怡青', '江西神你药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15944, '无纺布制品', '2022-10-13', '湿巾', '孙小丽', '0795-7163307', '20221013', '顾怡青', '江西安顺堂生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15945, '无纺布制品', '2022-10-13', '湿巾', '王国忠', '13303590114', '20221013', '顾怡青', '运城市心心纸巾有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15946, '无纺布制品', '2022-10-13', '湿巾', '马林', '18943976602', '20221013', '顾怡青', '吉林省水晶之恋卫生用品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15947, '无纺布制品', '2022-10-13', '湿巾', '崔巍', '13756166553', '20221013', '顾怡青', '长春靓姿清洁用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15948, '无纺布制品', '2022-10-13', '湿巾', '李国祥', '15044094406', '20221013', '顾怡青', '长春市洁爽卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15949, '无纺布制品', '2022-10-13', '湿巾', '富丽萍', '18643118042', '20221013', '顾怡青', '长春市绿园区天丽洁面巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15950, '无纺布制品', '2022-10-13', '湿巾', '欧代玲', '18190099999', '20221013', '顾怡青', '长春市茜茜卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15951, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+14147606232   Fax:+14147602841', '20221013', '郑静', 'SELLARS NONWOVENS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15952, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33329610637   Fax:+33329610778', '20221013', '郑静', 'SEMOFLEX SAS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15953, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+492173394860   Fax:+4921733948681', '20221013', '郑静', 'SERV-O-TEC GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15954, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+922132564450   Fax:+922132564448', '20221013', '郑静', 'S. FAZALILAHI &SONS(PVT) LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15955, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13655238259', '20221013', '郑静', '金湖海之缘无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15956, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13306234512', '20221013', '郑静', '常熟市金丰无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15957, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '18906237999', '20221013', '郑静', '常熟市盛创无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15958, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13390826177', '20221013', '郑静', '常熟市锦达无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15959, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '15901969548', '20221013', '郑静', '上海林洁无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15960, '无纺', '2022-10-13', '白色纯涤纶针刺无纺布', '深入沟通中', '13962371920', '20221013', '郑静', '常熟市汇创无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15961, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33391838384   Fax:+33357104277', '20221014', '郑静', 'SGS COURTRAY', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15962, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+97246947856   Fax:+97246949728', '20221014', '郑静', 'SHALAG INDUSTRIES LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15963, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:358290074370', '20221014', '郑静', 'SHARPCELL OY', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15964, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+447783164974   Fax:+441148813444', '20221014', '郑静', 'SHIELD FABRICS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15965, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '15250349365', '20221014', '郑静', '常熟市星佳逸无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15966, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13913119858', '20221014', '郑静', '苏州艾洁无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15967, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13793108333', '20221014', '郑静', '章丘市福园无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15968, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13738037681', '20221014', '郑静', '杭州永萌无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15969, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13814932830', '20221014', '郑静', '常熟市恒鑫无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15970, '无纺', '2022-10-14', '白色纯涤纶针刺无纺布', '深入沟通中', '13915627788', '20221014', '郑静', '常熟市陈氏无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15971, '全系列', '2022-10-14', '宁波市华表纺织品有限公司', '华权表', '13706742710', '20221014', '李小龙', '宁波市华表纺织品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15972, '全系列', '2022-10-14', '浙江绿芳洲无纺科技有限公司', '邹蒙亮', '1361325728', '20221014', '李小龙', '浙江绿芳洲无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15973, '全系列', '2022-10-14', '福建赛昂新材料科技有限公司', '马志俊', '18033999530', '20221014', '李小龙', '福建赛昂新材料科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15974, '全系列', '2022-10-14', '常熟市全申化纤有限公司', '谭志刚', '13063827908', '20221014', '李小龙', '常熟市全申化纤有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15975, '全系列', '2022-10-14', '上海丰格无纺布有限公司', '焦勇', '021-39198766', '20221014', '李小龙', '上海丰格无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15976, '全系列', '2022-10-14', '杭州兴农纺织有限公司', '王亮', '13867120937', '20221014', '李小龙', '杭州兴农纺织有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15977, '全系列', '2022-10-14', '南通华略无纺布制品有限公司', '沈绍波', ' 0513-80108040', '20221014', '李小龙', '南通华略无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15978, '全系列', '2022-10-14', '苏州美森无纺科技有限公司', '韩雪龙', '18952437896', '20221014', '李小龙', '苏州美森无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15979, '全系列', '2022-10-14', '常熟市双龙无纺布有限公司', '张雪明', '0512-52581048', '20221014', '李小龙', '常熟市双龙无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15980, '全系列', '2022-10-14', '安徽金春无纺布股份有限公司', '曹松亭', '18705500768', '20221014', '李小龙', '安徽金春无纺布股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15981, '会员入驻', '2022-10-14', '常熟市旭盛无纺布厂', '俞旭东', '13601553108', '20221014', '郁新涛', '常熟市旭盛无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15982, '会员入驻', '2022-10-14', '杭州诺邦无纺股份有限公司', '胡巍', '13071802285', '20221014', '郁新涛', '杭州诺邦无纺股份有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15983, '会员入驻', '2022-10-14', '诸暨恒飞无纺科技有限公司', '赵飞钢', '13605800575', '20221014', '郁新涛', '诸暨恒飞无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15984, '广告', '2022-10-14', '常州英诺无纺制品有限公司', '汤小方', '13327881070', '20221014', '郁新涛', '常州英诺无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15985, '机械工厂', '2022-10-14', '浙江永光无纺衬业有限公司', '马青燕', '13505731370', '20221014', '郁新涛', '浙江永光无纺衬业有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15986, '机械工厂', '2022-10-14', '苏州美森无纺科技有限公司', '陈忆', '18915504480', '20221014', '郁新涛', '苏州美森无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15987, '无纺布制品', '2022-10-14', '湿巾', '宋丽梅', '15543429777', '20221014', '顾怡青', '吉林瀚绅生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15988, '无纺布制品', '2022-10-14', '湿巾', '王维明', '13894336258', '20221014', '顾怡青', '图们市鸣洁水刺无纺布有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15989, '无纺布制品', '2022-10-14', '湿巾', '赵明福', '15193756777', '20221014', '顾怡青', '酒泉市鑫龙商贸有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15990, '无纺布制品', '2022-10-14', '湿巾', '王喜成', '0971-8243634', '20221014', '顾怡青', '西宁花梦诗纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15991, '无纺布制品', '2022-10-14', '湿巾', '褚健', '020-36031727', '20221014', '顾怡青', '广州楚颜化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15992, '无纺布制品', '2022-10-14', '湿巾', '张化力', '0755-25352671', '20221014', '顾怡青', '深圳市塔妮娜美容健康护理用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15993, '无纺布制品', '2022-10-14', '湿巾', '侯芳', '18038083776', '20221014', '顾怡青', '深圳市泰世科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15994, '无纺布制品', '2022-10-14', '湿巾', '陈福平', '13600154901', '20221014', '顾怡青', '深圳市强达电子科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15995, '无纺布制品', '2022-10-14', '湿巾', '周柱兴', '0757-86360727', '20221014', '顾怡青', '佛山市禅城区康结香巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15996, '无纺布制品', '2022-10-14', '湿巾', '张华标', '13802693921', '20221014', '顾怡青', '中山市标奇家庭用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15997, '无纺布制品', '2022-10-17', '湿巾', '骆建华', '0760-23404300', '20221017', '顾怡青', '中山榄菊日化实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15998, '无纺布制品', '2022-10-17', '湿巾', '陈豪', '010-62651721', '20221017', '顾怡青', '北京欧凯纳斯科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (15999, '无纺布制品', '2022-10-17', '湿巾', '俞燕', '13016856922', '20221017', '顾怡青', '常州市洁顺旅游用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16000, '无纺布制品', '2022-10-17', '湿巾', '杨华', '0512-50135560', '20221017', '顾怡青', '昆山博青生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16001, '无纺布制品', '2022-10-17', '湿巾', '顾政宇', '13901551234', '20221017', '顾怡青', '吴江钱柜大王保险箱有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16002, '无纺布制品', '2022-10-17', '湿巾', '顾滨', '13218222028', '20221017', '顾怡青', '南通市一云湿巾有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16003, '无纺布制品', '2022-10-17', '湿巾', '朱昭帮', '13851066678', '20221017', '顾怡青', '盐城市聚科化工有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16004, '无纺布制品', '2022-10-17', '湿巾', '汤迎忠', '0515-88856001', '20221017', '顾怡青', '盐城方天无纺制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16005, '无纺布制品', '2022-10-17', '湿巾', '王家明', '021-54263400', '20221017', '顾怡青', '上海都洁诗酒店用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16006, '无纺布制品', '2022-10-17', '湿巾', '侯思静', '15901635131', '20221017', '顾怡青', '上海嘉好胶粘制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16007, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33320170025   Fax:+33320936652', '20221017', '郑静', 'SICAD FRANCE', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16008, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+39028266081   Fax:+39028266270', '20221017', '郑静', 'SICAM SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16009, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+420381621111   Fax:+420381621206', '20221017', '郑静', 'SILON  S.R.O', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16010, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+3242522150  Fax:+3242530425', '20221017', '郑静', 'SIOEN FELT&FILTRATION', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16011, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '13962328612', '20221017', '郑静', '常熟市大地无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16012, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '18852439101', '20221017', '郑静', '常熟市峻熙无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16013, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '13073322118', '20221017', '郑静', '常熟市佳佰俪无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16014, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '13584173095', '20221017', '郑静', '江阴凯利无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16015, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '18914045672', '20221017', '郑静', '苏州市佳和无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16016, '无纺', '2022-10-17', '白色纯涤纶针刺无纺布', '深入沟通中', '18968804915', '20221017', '郑静', '温州柔丽洁无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16017, '会员入驻', '2022-10-17', '无纺会员', '袁平', '13706282500', '20221017', '郁新涛', '南通阳升无纺织物有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16018, '会员入驻', '2022-10-17', '无纺会员', '俞雷', '18662626789', '20221017', '郁新涛', '苏州力鼎无纺技术有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16019, '会员入驻', '2022-10-17', '无纺会员', '彭抗保', '13862354321', '20221017', '郁新涛', '苏州常盛水刺无纺有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16020, '广告', '2022-10-17', '制品广告', '张建康', '13962313285', '20221017', '郁新涛', '常熟市双晨无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16021, '机械工厂', '2022-10-17', '智能工厂', '王淑贞', '13853212653', '20221017', '郁新涛', '青岛青锋无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16022, '机械工厂', '2022-10-17', '智能工厂', '钱程 ', '13105510820', '20221017', '郁新涛', '嘉兴市富瑞森水刺无纺有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16023, '全系列', '2022-10-17', '江阴市江海非织造布有限公司', '任贵虎', '15995300259', '20221017', '李小龙', '江阴市江海非织造布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16024, '全系列', '2022-10-17', '宁波格创无纺科技有限公司', '郑平', '13345888717', '20221017', '李小龙', '宁波格创无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16025, '全系列', '2022-10-17', '绍兴纤蓝纺织科技有限公司', '朱文斌', '13806751304', '20221017', '李小龙', '绍兴纤蓝纺织科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16026, '全系列', '2022-10-17', '绍兴比伦纺织有限公司', '何世明', '13705753705', '20221017', '李小龙', '绍兴比伦纺织有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16027, '全系列', '2022-10-17', '浙江赛弘纺织科技有限公司', '周伟军', '0571-82230922', '20221017', '李小龙', '浙江赛弘纺织科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16028, '全系列', '2022-10-17', '杭州萧山航民非织造布有限公司', '朱立刚', '13506717272', '20221017', '李小龙', '杭州萧山航民非织造布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16029, '全系列', '2022-10-17', '浙江弘扬无纺新材料有限公司', '杨永兴', '13605739196', '20221017', '李小龙', '浙江弘扬无纺新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16030, '全系列', '2022-10-17', '昆山勝昱无纺布有限公司', '陈昱君', '0512-57672565', '20221017', '李小龙', '昆山勝昱无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16031, '全系列', '2022-10-17', '常熟市峻熙无纺制品有限公司', '朱国涛', '18962492982', '20221017', '李小龙', '常熟市峻熙无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16032, '全系列', '2022-10-17', '江阴市嘉华俊纺织有限公司', '张林华', '17701515477', '20221017', '李小龙', '江阴市嘉华俊纺织有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16033, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4376729120  Fax:+4376729129', '20221018', '郑静', 'SML MASCHINENGESELLSCHAFT  MBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16034, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+41227611111  Fax:+41227980100', '20221018', '郑静', 'PALEXPO SA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16035, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4353726993118  Fax:+435372699354', '20221018', '郑静', 'SPG PRINTS AUSTRIA GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16036, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+33477900034  Fax:+33477903683', '20221018', '郑静', 'SPOOLEX SAS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16037, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', '0512-52513195', '20221018', '郑静', '江苏蒋巷无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16038, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', '0510-83766682-8010', '20221018', '郑静', '江苏冠中无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16039, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', '0510-85086000', '20221018', '郑静', '致优无纺布（无锡）有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16040, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', '18962310379', '20221018', '郑静', '苏州长晟无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16041, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', '13952928665', '20221018', '郑静', '镇江金菲亚无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16042, '无纺', '2022-10-18', '白色纯涤纶针刺无纺布', '深入沟通中', ' 0572-6501766', '20221018', '郑静', '浙江诚品无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16043, '会员入驻', '2022-10-18', '无纺会员', '顾忠英', '18915776505', '20221019', '郁新涛', '太仓市富通无纺制造有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16044, '会员入驻', '2022-10-18', '无纺会员', '周惠娟', '15850832833', '20221020', '郁新涛', '常熟市鑫豪无纺有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16045, '会员入驻', '2022-10-18', '无纺会员', '徐沪军', '18915652113', '20221021', '郁新涛', '常熟市国凯无纺棉布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16046, '广告', '2022-10-18', '制品广告', '刘胜超', '13179476666', '20221022', '郁新涛', '镇江汇创无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16047, '机械工厂', '2022-10-18', '智能工厂', '华翔', '13771618715', '20221023', '郁新涛', '江阴海翔无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16048, '机械工厂', '2022-10-18', '智能工厂', '俞凤斌', '13506295773', '20221024', '郁新涛', '海门市旺顺无纺棉有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16049, '全系列', '2022-10-18', '盐城鸿图织造有限公司', '殷海霞', '15151034623', '20221018', '李小龙', '盐城鸿图织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16050, '全系列', '2022-10-18', '福建省天连化纤织造有限公司', '李绳章', '0597-6692686', '20221018', '李小龙', '福建省天连化纤织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16051, '全系列', '2022-10-18', '兰溪市一鸣织造有限公司', '戴卫民', '0579-88136636', '20221018', '李小龙', '兰溪市一鸣织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16052, '全系列', '2022-10-18', '福建省建网织造有限责任公司', '王秀聘', '18016605757', '20221018', '李小龙', '福建省建网织造有限责任公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16053, '全系列', '2022-10-18', '南通富发织造有限公司', '郭美', '18306276999', '20221018', '李小龙', '南通富发织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16054, '全系列', '2022-10-18', '石狮市永乐服装织造有限公司', '杜勇捷', '13505949669', '20221018', '李小龙', '石狮市永乐服装织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16055, '全系列', '2022-10-18', '海宁知勉织造有限公司', '詹建青', '13516831058', '20221018', '李小龙', '海宁知勉织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16056, '全系列', '2022-10-18', '浙江亿丽斯织造有限公司', '徐仁良', '0575-84061222', '20221018', '李小龙', '浙江亿丽斯织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16057, '全系列', '2022-10-18', '安徽聚利升织造有限公司', '李霄', '15855892703', '20221018', '李小龙', '安徽聚利升织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16058, '全系列', '2022-10-18', '绍兴县历程织造有限公司', '王爱仙', '13703240768', '20221018', '李小龙', '绍兴县历程织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16059, '无纺布制品', '2022-10-18', '湿巾', '朱藏智', '021-39947036', '20221018', '顾怡青', '上海大晶实业发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16060, '无纺布制品', '2022-10-18', '湿巾', '顾银龙', '13003225731', '20221018', '顾怡青', '上海伟龙卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16061, '无纺布制品', '2022-10-18', '湿巾', '黄赛娥', '021-57690388', '20221018', '顾怡青', '上海捷健生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16062, '无纺布制品', '2022-10-18', '湿巾', '黄海琴', '0571-82232037', '20221018', '顾怡青', '杭州天地人和休闲用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16063, '无纺布制品', '2022-10-18', '湿巾', '董炳忠', '13819157852', '20221018', '顾怡青', '杭州诚燕纺织有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16064, '无纺布制品', '2022-10-18', '湿巾', '陈冠群', '0571-63193918', '20221018', '顾怡青', '杭州富阳高琦香精香料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16065, '无纺布制品', '2022-10-18', '湿巾', '李中居', '0577-64286666', '20221018', '顾怡青', '浙江华昇工艺品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16066, '无纺布制品', '2022-10-18', '湿巾', '李四明', '0575-88600610', '20221018', '顾怡青', '绍兴格美卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16067, '无纺布制品', '2022-10-18', '湿巾', '叶荣旭', '0579-85853008', '20221018', '顾怡青', '浙江佳燕日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16068, '无纺布制品', '2022-10-18', '湿巾', '方宪军', '13065044728', '20221018', '顾怡青', '济南高新开发区恒佳纸品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16069, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4937152740  Fax:+493715274153', '20221019', '郑静', 'SACHSISCHS TEXTILFORSCHUNGSINGSINSTIYUT E.V.(STFI)', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16070, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+462685000 Fax:+462675446', '20221019', '郑静', 'STORA ENSO BIOMATERIALS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16071, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390456661376 Fax:+390456661381', '20221019', '郑静', 'STREMA PACKAGING MACHINERY ITALY', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16072, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+914030512700 Fax:+914030512725', '20221019', '郑静', 'SURAVANSHI SPINNING MILLS LTD-SNOWFLAKES SOLUTIONS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16073, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '15221091118', '20221019', '郑静', '安徽紫谷无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16074, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '17715118375', '20221019', '郑静', '仪征升信无纺织物有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16075, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '18705500768', '20221019', '郑静', '安徽金春无纺布股份有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16076, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13515291289', '20221019', '郑静', '江苏索富达无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16077, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13606696111', '20221019', '郑静', '浙江天纶无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16078, '无纺', '2022-10-19', '白色纯涤纶针刺无纺布', '深入沟通中', '13616239823', '20221019', '郑静', '苏州市鑫红日无纺新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16079, '会员入驻', '2022-10-19', '无纺会员', '徐阿建', '13913622628', '20221019', '郁新涛', '常熟市百佳无纺有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16080, '会员入驻', '2022-10-19', '无纺会员', '施国章', '13584185555', '20221019', '郁新涛', '无锡克瑞特无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16081, '会员入驻', '2022-10-19', '无纺会员', '颜雅萍', '13906229730', '20221019', '郁新涛', '太仓联鑫无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16082, '广告', '2022-10-19', '制品广告', '吴建中', '18606222941', '20221019', '郁新涛', '太仓市双健无纺制品有限公司沙溪分公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16083, '机械工厂', '2022-10-19', '智能工厂', '孟玲花', '18758507806', '20221019', '郁新涛', '绍兴舒洁雅无纺材料有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16084, '机械工厂', '2022-10-19', '智能工厂', '孙中杰', '18969015696', '20221019', '郁新涛', '杭州申皇无纺布用品有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16085, '无纺布制品', '2022-10-19', '湿巾', '王海英', '18669853633', '20221019', '顾怡青', '青岛雪利川卫生制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16086, '无纺布制品', '2022-10-19', '湿巾', '金虎郎（执行董事）', '18553282606', '20221019', '顾怡青', '青岛富虎食品贸易有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16087, '无纺布制品', '2022-10-19', '湿巾', '曹卫山', '15634054319', '20221019', '顾怡青', '山东晨晓纸业科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16088, '无纺布制品', '2022-10-19', '湿巾', '贾令川', '13792325750', '20221019', '顾怡青', '邹城市福满天生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16089, '无纺布制品', '2022-10-19', '湿巾', '刘成荣', '15552964082', '20221019', '顾怡青', '临沂市天安药业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16090, '无纺布制品', '2022-10-19', '湿巾', '王义国', '13605306845', '20221019', '顾怡青', '菏泽开发区兴国工艺术品加工部', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16091, '无纺布制品', '2022-10-19', '湿巾', '张俊清', '0312-7021629', '20221019', '顾怡青', '河北金博士集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16092, '无纺布制品', '2022-10-19', '湿巾', '高红亮', '13603122868', '20221019', '顾怡青', '河北鑫润纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16093, '无纺布制品', '2022-10-19', '湿巾', '曹立新', '0312-7166268', '20221019', '顾怡青', '保定市华立涂布纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16094, '无纺布制品', '2022-10-19', '湿巾', '康建业', '0312-7079138', '20221019', '顾怡青', '保定市华奥纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16095, '全系列', '2022-10-19', '江苏蒋巷无纺科技有限公司', '常德盛', '0512-52513195', '20221019', '李小龙', '江苏蒋巷无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16096, '全系列', '2022-10-19', '杭州诺邦无纺股份有限公司', '任建华', '17614810786', '20221019', '李小龙', '杭州诺邦无纺股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16097, '全系列', '2022-10-19', '安徽金春无纺布股份有限公司', '曹松亭', '18705500768', '20221019', '李小龙', '安徽金春无纺布股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16098, '全系列', '2022-10-19', '苏州长晟无纺科技有限公司', '陆建新', '18962310379', '20221019', '李小龙', '苏州长晟无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16099, '全系列', '2022-10-19', '绍兴柯桥庄洁无纺材料有限公司', '高海根', '13754337718', '20221019', '李小龙', '绍兴柯桥庄洁无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16100, '全系列', '2022-10-19', '常熟市飞龙无纺机械有限公司', '韩雪龙', '13862343747', '20221019', '李小龙', '常熟市飞龙无纺机械有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16101, '全系列', '2022-10-19', '江苏康大无纺有限公司', '孙友林', '13813124855', '20221019', '李小龙', '江苏康大无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16102, '全系列', '2022-10-19', '江苏索富达无纺布有限公司', '王汉祥', '15051311510', '20221019', '李小龙', '江苏索富达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16103, '全系列', '2022-10-19', '苏州市鑫红日无纺新材料有限公司', '薛鹏', '0512-52581958', '20221019', '李小龙', '苏州市鑫红日无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16104, '全系列', '2022-10-19', '杭州创佳无纺制品有限公司', '陈林军', '13868037685', '20221019', '李小龙', '杭州创佳无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16105, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+27315388700  Fax:+27315023157', '20221020', '郑静', 'SPUNCHEM INTERNATIONAL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16106, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+13363309003  Fax:+13363309019', '20221020', '郑静', 'N.R.SPUNTECH INDUSTRIES.INC', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16107, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+4315995503  Fax:+4315995525', '20221020', '郑静', 'STALINGER &CO.,GESELLSCHAFT MBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16108, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:441204855010', '20221020', '郑静', 'STERLING NONWOVENS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16109, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13601008359', '20221020', '郑静', '浙江富立邦无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16110, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13601008359', '20221020', '郑静', '阜宁铁风无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16111, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13868037685/ 13805708186', '20221020', '郑静', '杭州创佳无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16112, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13511722088', '20221020', '郑静', '扬州恒信无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16113, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '13852535341', '20221020', '郑静', '仪征市众威无纺材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16114, '无纺', '2022-10-20', '白色纯涤纶针刺无纺布', '深入沟通中', '15105114987', '20221020', '郑静', '阜宁富豪无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16115, '无纺布制品', '2022-10-20', '湿巾', '李宁', '0312-6169100', '20221020', '顾怡青', '河北紫薇山制药有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16116, '无纺布制品', '2022-10-20', '湿巾', '高进通', '0316-5798858', '20221020', '顾怡青', '廊坊蓝纳生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16117, '无纺布制品', '2022-10-20', '湿巾', '郑佳明', '0595-87203333', '20221020', '顾怡青', '雀氏（福建）实业发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16118, '无纺布制品', '2022-10-20', '湿巾', '陈爱连', '13505099699', '20221020', '顾怡青', '晋江市台洋涂塑用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16119, '无纺布制品', '2022-10-20', '湿巾', '纪志阮', '0595-87205336', '20221020', '顾怡青', '泉州东工机械制造厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16120, '无纺布制品', '2022-10-20', '湿巾', '谢开达', '18960296007', '20221020', '顾怡青', '福建培新机械制造实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16121, '无纺布制品', '2022-10-20', '湿巾', '孙少山', '0596-6662883', '20221020', '顾怡青', '福建欧柏亚日化有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16122, '无纺布制品', '2022-10-20', '湿巾', '谢忠行', '18058459555', '20221020', '顾怡青', '安诺纸业（福建）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16123, '无纺布制品', '2022-10-20', '湿巾', '杨继辉', '027-82319651', '20221020', '顾怡青', '武汉市汉阳区尚美生活用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16124, '无纺布制品', '2022-10-20', '湿巾', '程志昆', '027-83370986', '20221020', '顾怡青', '武汉黄鹤楼香精香料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16125, '会员入驻', '2022-10-20', '无纺会员', '黄丽丽', '15021281864', '黄丽丽', '郁新涛', '上海豊格无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16126, '会员入驻', '2022-10-20', '无纺会员', '陈  嵘', '13805778576', '陈  嵘', '郁新涛', '浙江欣富无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16127, '会员入驻', '2022-10-20', '无纺会员', '范福根', '13806513699', '范福根', '郁新涛', '杭州顺龙无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16128, '广告', '2022-10-20', '制品广告', '赵红', '13968021268', '赵红', '郁新涛', '杭州临安百浩无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16129, '机械工厂', '2022-10-20', '智能工厂', 'J.H.Ziegler GmbH', '18605721757', 'J.H.Ziegler GmbH', '郁新涛', '齐格勒无纺新材(湖州)有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16130, '机械工厂', '2022-10-20', '智能工厂', '陈兴泉', '15168203186', '陈兴泉', '郁新涛', '杭州森润无纺布科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16131, '全系列', '2022-10-20', '扬州恒信无纺制品有限公司', '余俊', '13511722088', '20221020', '李小龙', '扬州恒信无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16132, '全系列', '2022-10-20', '昆山市三羊无纺布有限公司', '朱启良', '15951111151', '20221020', '李小龙', '昆山市三羊无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16133, '全系列', '2022-10-20', '上海层峰无纺布制品有限公司', '胡语燕', '18606811199', '20221020', '李小龙', '上海层峰无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16134, '全系列', '2022-10-20', '江苏万路达无纺布新材料有限公司', '潘高路', '13185235858', '20221020', '李小龙', '江苏万路达无纺布新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16135, '全系列', '2022-10-20', '安徽民辉无纺科技有限公司', '陈忠民', '13968084488', '20221020', '李小龙', '安徽民辉无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16136, '全系列', '2022-10-20', '江苏絮织无纺新材料有限公司', '潘珍婷', '18768380688', '20221020', '李小龙', '江苏絮织无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16137, '全系列', '2022-10-20', '浙江鸿鹏无纺布科技有限公司', '薛继藏', '15158511767', '20221020', '李小龙', '浙江鸿鹏无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16138, '全系列', '2022-10-20', '上海丰格无纺布有限公司', '焦勇', '021-39198766', '20221020', '李小龙', '上海丰格无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16139, '全系列', '2022-10-20', '浙江世钧无纺科技有限公司', '徐云夫', '0579-89013233', '20221020', '李小龙', '浙江世钧无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16140, '全系列', '2022-10-20', '杭州顺龙无纺科技有限公司', '范福根', '13906810583', '20221020', '李小龙', '杭州顺龙无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16141, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+886225925928 Fax:+886225954788', '20221021', '郑静', 'TAIWAN SPUNLACE(GROUP) CO.,LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16142, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:447899998277', '20221021', '郑静', 'TATHAM UK LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16143, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+85231187213 Fax:+85231187234', '20221021', '郑静', 'TECHADHESION SYSTEMS LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16144, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:441472245205', '20221021', '郑静', 'TECHNICAL ABSORBENTS LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16145, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '15951111151', '20221021', '郑静', '昆山市三羊无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16146, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '0527-80301089', '20221021', '郑静', '江苏稳德福无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16147, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '18606811199', '20221021', '郑静', '上海层峰无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16148, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13185235858', '20221021', '郑静', '江苏万路达无纺布新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16149, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13806269097', '20221021', '郑静', '苏州格里无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16150, '无纺', '2022-10-21', '白色纯涤纶针刺无纺布', '深入沟通中', '13566268686', '20221021', '郑静', '宿迁鼎信水刺无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16151, '会员入驻', '2022-10-21', '无纺会员', '胡炳年', '15988189328', '20221021', '郁新涛', '杭州思进无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16152, '会员入驻', '2022-10-21', '无纺会员', '冯涛', '13805771405', '20221021', '郁新涛', '浙江百联无纺科技有限责任公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16153, '会员入驻', '2022-10-21', '无纺会员', '金刚强', '13968877373', '20221021', '郁新涛', '浙江龙游上博无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16154, '广告', '2022-10-21', '制品广告', '张鹏', '18968028266', '20221021', '郁新涛', '杭州临安新业无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16155, '机械工厂', '2022-10-21', '智能工厂', '刘红曙', '13382298001', '20221021', '郁新涛', '江苏朵拉无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16156, '机械工厂', '2022-10-21', '智能工厂', '陈智超', '18059370313', '20221021', '郁新涛', '温州超诚无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16157, '无纺布制品', '2022-10-21', '湿巾', '程岗', '0553-8516886', '20221021', '顾怡青', '芜湖悠派护理用品科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16158, '无纺布制品', '2022-10-21', '湿巾', '许亦南', '0555-6751806', '20221021', '顾怡青', '安徽比伦生活用纸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16159, '无纺布制品', '2022-10-21', '湿巾', '陈东华', '0562-6861675', '20221021', '顾怡青', '铜陵麟安生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16160, '无纺布制品', '2022-10-21', '湿巾', '刘岿岽', '13052780401', '20221021', '顾怡青', '大连维妮美卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16161, '无纺布制品', '2022-10-21', '湿巾', '韩广龙', '0417-5852058', '20221021', '顾怡青', '大石桥市保康酒店用品分装店', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16162, '无纺布制品', '2022-10-21', '湿巾', '张健红', '0796-2222213', '20221021', '顾怡青', '江西人初健康用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16163, '无纺布制品', '2022-10-21', '湿巾', '杜旭军', '0851-85752758', '20221021', '顾怡青', '贵阳市花溪环球卫生制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16164, '无纺布制品', '2022-10-21', '湿巾', '周朋', '15330663226', '20221021', '顾怡青', '四平佳尔生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16165, '无纺布制品', '2022-10-21', '湿巾', '王桂英', '18193109996', '20221021', '顾怡青', '七里河区婴童百货日化用品店', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16166, '无纺布制品', '2022-10-21', '湿巾', '田雅婷', '020-32057560', '20221021', '顾怡青', '广州联庄科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16167, '全系列', '2022-10-21', '安徽德邦无纺布有限公司', '高明东', '18955757585', '20221021', '李小龙', '安徽德邦无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16168, '全系列', '2022-10-21', '江阴市华思诚无纺布有限公司', '潘全志', '15905261976', '20221021', '李小龙', '江阴市华思诚无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16169, '全系列', '2022-10-21', '杭州旦洋无纺科技股份有限公司', '何飞宇', '0571-64138591', '20221021', '李小龙', '杭州旦洋无纺科技股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16170, '全系列', '2022-10-21', '杭州润通无纺科技有限公司', '孙丙华', '13456822589', '20221021', '李小龙', '杭州润通无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16171, '全系列', '2022-10-21', '浙江亮洁无纺材料有限公司', '邱根亮', '13906732127', '20221021', '李小龙', '浙江亮洁无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16172, '全系列', '2022-10-21', '江阴拓普无纺布制品有限公司', '张凯云', ' 0510-86218288', '20221021', '李小龙', '江阴拓普无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16173, '全系列', '2022-10-21', '南通日晨无纺布有限公司', '董记', '18106299396', '20221021', '李小龙', '南通日晨无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16174, '全系列', '2022-10-21', '温州市凌炜无纺布有限公司', '应良高', '13289304567', '20221021', '李小龙', '温州市凌炜无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16175, '全系列', '2022-10-21', '嘉兴市财华熔喷无纺布有限公司', '倪夏英', '18602310133', '20221021', '李小龙', '嘉兴市财华熔喷无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16176, '全系列', '2022-10-21', '福建恒得利无纺布业有限公司', '黄进治', '13599755859', '20221021', '李小龙', '福建恒得利无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16177, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+39015590993 Fax:+39015591145', '20221024', '郑静', 'TECNOMECCANICA BIELLESE SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16178, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel：+390573478011 Fax:+390573478828', '20221024', '郑静', 'TECTEX SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16179, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+34937706060                                      Fax:+34937706062', '20221024', '郑静', 'TEFISA-TELAS Y FABRICADOS NO TEJIDOS SA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16180, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+49403696660                                      Fax:+49403966650', '20221024', '郑静', 'TEIJIN FRONTIER EUROPE GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16181, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '13805256564', '20221024', '郑静', '仪征市振威无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16182, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '13587850658', '20221024', '郑静', '诚佰无纺布股份有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16183, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '18768380688', '20221024', '郑静', '江苏絮织无纺新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16184, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '15358356666', '20221024', '郑静', '柔丽洁（江苏）无纺布业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16185, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '15862366996', '20221024', '郑静', '诚联无纺科技（常熟）有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16186, '无纺', '2022-10-24', '白色纯涤纶针刺无纺布', '深入沟通中', '18200356815', '20221024', '郑静', '浙江鸿鹏无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16187, '全系列', '2022-10-24', '浙江雅宝无纺布制品有限公司', '陆臣省', '13606770358', '20221024', '李小龙', '浙江雅宝无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16188, '全系列', '2022-10-24', '苏州合利汇无纺布有限公司', '沈志良', '0512-63688587', '20221024', '李小龙', '苏州合利汇无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16189, '全系列', '2022-10-24', '昆山洁宏无纺布制品有限公司', '董纹吉', '0512-57498065', '20221024', '李小龙', '昆山洁宏无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16190, '全系列', '2022-10-24', '浙江大洲无纺布有限公司', '林国华', '18358767136', '20221024', '李小龙', '浙江大洲无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16191, '全系列', '2022-10-24', '福建省丝滑顺无纺布有限公司', '孙传志', '18960267799', '20221024', '李小龙', '福建省丝滑顺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16192, '全系列', '2022-10-24', '宁波锦菲无纺布有限公司', '叶正伟', '0574-62162098', '20221024', '李小龙', '宁波锦菲无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16193, '全系列', '2022-10-24', '福建省海涛无纺纤维有限公司', '李永彬', '13960381607', '20221024', '李小龙', '福建省海涛无纺纤维有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16194, '全系列', '2022-10-24', '浙江恒海无纺布有限公司', '周小燕', '13606772515', '20221024', '李小龙', '浙江恒海无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16195, '全系列', '2022-10-24', '浙江弘扬无纺新材料有限公司', '杨永兴', '13605739196', '20221024', '李小龙', '浙江弘扬无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16196, '全系列', '2022-10-24', '江苏雄迁无纺布制品有限公司', '董领弟', '18360665350', '20221024', '李小龙', '江苏雄迁无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16197, '无纺布制品', '2022-10-24', '湿巾', '娄巍', '0755-89630932', '20221024', '顾怡青', '深圳卓润母婴用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16198, '无纺布制品', '2022-10-24', '湿巾', '金海荣', '0769-82109991', '20221024', '顾怡青', '熵基科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16199, '无纺布制品', '2022-10-24', '湿巾', '马兴伟', '13601129443', '20221024', '顾怡青', '北京鑫利宏源包装制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16200, '无纺布制品', '2022-10-24', '湿巾', '吉尔贝特·卡尔巴赫', '010-85910751', '20221024', '顾怡青', '哥鲁巴生物科技（北京）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16201, '无纺布制品', '2022-10-24', '湿巾', '汪五德', '13801309207', '20221024', '顾怡青', '北京创利达纸制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16202, '无纺布制品', '2022-10-24', '湿巾', '陈光', '010-52088811', '20221024', '顾怡青', '唯美度科技（北京）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16203, '无纺布制品', '2022-10-24', '湿巾', '薛清', '13771755017', '20221024', '顾怡青', '苏州市美盛塑业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16204, '无纺布制品', '2022-10-24', '湿巾', '缪军', '13235220602', '20221024', '顾怡青', '南通市港闸区朝阳卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16205, '无纺布制品', '2022-10-24', '湿巾', '张敏', '0514-80258999', '20221024', '顾怡青', '扬州市柳源防滑布有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16206, '无纺布制品', '2022-10-24', '湿巾', '陈飞', '13852706266', '20221024', '顾怡青', '扬州市飞杰旅游用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16207, '会员入驻', '2022-10-24', '无纺会员', '宋海琪', '18861717988', '20221024', '郁新涛', '江苏爱琪艺臻品无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16208, '会员入驻', '2022-10-24', '无纺会员', '张志萍', '18600035837', '20221024', '郁新涛', '浙江东方雨虹科技开发股份有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16209, '会员入驻', '2022-10-24', '无纺会员', '严华荣', '18705820968', '20221024', '郁新涛', '浙江优全护理用品科技股份有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16210, '广告', '2022-10-24', '制品广告', '商林平', '13757199618', '20221024', '郁新涛', '杭州临安海贝无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16211, '机械工厂', '2022-10-24', '智能工厂', '杨伟民', '13852663458', '20221024', '郁新涛', '江苏蓓露馨医用材料科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16212, '机械工厂', '2022-10-24', '智能工厂', '王汉祥', '15051311510', '20221024', '郁新涛', '江苏索富达无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16213, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+390373951311                                      Fax:+390373983059', '20221025', '郑静', 'TEKNOWEB CONVERTING SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16214, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+902124381311                                   Fax:+902124384611', '20221025', '郑静', 'TEKSTIL DUNYASI', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16215, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+499732870                                  Fax:+49973287310', '20221025', '郑静', 'SAURER COMPONENTS GMBH ZWEIGNIEDERLASSUNG MLBURG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16216, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+3903992191                                Fax:+390399219290', '20221025', '郑静', 'TENAX SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16217, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '13505107369', '20221025', '郑静', '江苏正大森源无纺滤料有限责任公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16218, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '18915565579', '20221025', '郑静', '浙江金逸无纺布贸易有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16219, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '0557-3339656', '20221025', '郑静', '宿州市浩维无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16220, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '13524001308', '20221025', '郑静', '上海丰格无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16221, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '13815834933', '20221025', '郑静', '扬州弘扬无纺布织造有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16222, '无纺', '2022-10-25', '白色纯涤纶针刺无纺布', '深入沟通中', '13901628271', '20221025', '郑静', '安庆丰格无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16223, '无纺布制品', '2022-10-25', '湿巾', '范茂哉', '0577-65010577', '20221025', '顾怡青', '瑞安市三鑫包装机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16224, '无纺布制品', '2022-10-25', '湿巾', '洪万青', '15957799265', '20221025', '顾怡青', '上海辉伦婴儿用品有限公司温州分公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16225, '无纺布制品', '2022-10-25', '湿巾', '王艳红', '13018889790', '20221025', '顾怡青', '台州市常乐卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16226, '无纺布制品', '2022-10-25', '湿巾', '王旭', '13808189399', '20221025', '顾怡青', '四川致初心卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16227, '无纺布制品', '2022-10-25', '湿巾', '刘洪杨', '18654938649', '20221025', '顾怡青', '济南市历城区心愿湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16228, '无纺布制品', '2022-10-25', '湿巾', '邵绪霞', '13061222302', '20221025', '顾怡青', '青岛叁鼎卫生制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16229, '无纺布制品', '2022-10-25', '湿巾', '瓦尔特', '0539-2212567', '20221025', '顾怡青', '临沂爱美信家俱有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16230, '无纺布制品', '2022-10-25', '湿巾', '徐西连', '18053911688', '20221025', '顾怡青', '山东顺霸化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16231, '无纺布制品', '2022-10-25', '湿巾', '王贵军', '18605398988', '20221025', '顾怡青', '临沂市华鲁家佳美纸制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16232, '无纺布制品', '2022-10-25', '湿巾', '段志楠', '0539-8520002', '20221025', '顾怡青', '山东欧适乐生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16233, '会员入驻', '2022-10-25', '无纺会员', '王一', '15633252111', '王一', '郁新涛', '河北安润纺织科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16234, '会员入驻', '2022-10-25', '无纺会员', '凌枫', '13566268686', '凌枫', '郁新涛', '宿迁鼎信水刺无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16235, '会员入驻', '2022-10-25', '无纺会员', '马宝英', '18669686610', '马宝英', '郁新涛', '临沂市金绫纺织有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16236, '广告', '2022-10-25', '制品广告', '余振东', '13777240838', '余振东', '郁新涛', '慈溪市佳贝无纺布制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16237, '机械工厂', '2022-10-25', '智能工厂', '李小芳', '13588581119', '李小芳', '郁新涛', '浙江永通纺织印染有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16238, '机械工厂', '2022-10-25', '智能工厂', '李波', '13937339068', '李波', '郁新涛', '河南科润康非织造布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16239, '全系列', '2022-10-25', '义乌市恒翔无纺布有限公司', '成能翔', '0579-85210158', '20221025', '李小龙', '义乌市恒翔无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16240, '全系列', '2022-10-25', '安徽润维无纺布有限公司', '朱广明', '0557-2772700', '20221025', '李小龙', '安徽润维无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16241, '全系列', '2022-10-25', '温州圣恩无纺布有限公司', '王志坚', '18906636636', '20221025', '李小龙', '温州圣恩无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16242, '全系列', '2022-10-25', '江苏朵拉无纺科技有限公司', '刘红曙', '13382298001', '20221025', '李小龙', '江苏朵拉无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16243, '全系列', '2022-10-25', '常熟市金陵无纺布有限公司', '俞江', '13301572115', '20221025', '李小龙', '常熟市金陵无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16244, '全系列', '2022-10-25', '江苏炫翔无纺布科技有限公司', '史张华', '18796503909', '20221025', '李小龙', '江苏炫翔无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16245, '全系列', '2022-10-25', '安徽宏远无纺布业有限公司', '吴祥', '13955188870', '20221025', '李小龙', '安徽宏远无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16246, '全系列', '2022-10-25', '江苏海卓无纺科技有限公司', '汪学勤', '13914633999', '20221025', '李小龙', '江苏海卓无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16247, '全系列', '2022-10-25', '安徽天沛无纺布业有限公司', '王军', '18792030577', '20221025', '李小龙', '安徽天沛无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16248, '全系列', '2022-10-25', '江苏艾文德莱无纺布有限公司', '倪若昕', '13815009490', '20221025', '李小龙', '江苏艾文德莱无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16249, '全系列', '2022-10-26', '桐乡市友恒无纺科技股份有限公司', '薄兴根', '0573-88663598', '20221026', '李小龙', '桐乡市友恒无纺科技股份有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16250, '全系列', '2022-10-26', '昆山优致洁无纺布材料有限公司', '杨靖刚', '13814827153', '20221026', '李小龙', '昆山优致洁无纺布材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16251, '全系列', '2022-10-26', '辉宏（福建）无纺布集团有限公司', '黄倩', '13960287769', '20221026', '李小龙', '辉宏（福建）无纺布集团有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16252, '全系列', '2022-10-26', '安徽亿帆无纺布制品有限公司', '操磊', '18005535159', '20221026', '李小龙', '安徽亿帆无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16253, '全系列', '2022-10-26', '上海盈兹无纺布有限公司', '胡俊杰', '021-57358082', '20221026', '李小龙', '上海盈兹无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16254, '全系列', '2022-10-26', '江苏申达无纺新材料有限公司', '王俊', '13901766668', '20221026', '李小龙', '江苏申达无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16255, '全系列', '2022-10-26', '盐城市皓瑞水刺无纺布有限公司', '王志宏', '13851325158', '20221026', '李小龙', '盐城市皓瑞水刺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16256, '全系列', '2022-10-26', '温州市仟亿无纺布有限公司', '吴家枢', '15854209801', '20221026', '李小龙', '温州市仟亿无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16257, '全系列', '2022-10-26', '河南荣晟无纺制品有限公司', '王统举', '15036617509', '20221026', '李小龙', '河南荣晟无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16258, '全系列', '2022-10-26', '江苏伟利达无纺布制品有限公司', '傅建利', '13776461670', '20221026', '李小龙', '江苏伟利达无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16259, '全系列', '2022-10-26', '河北志晟信息技术股份有限公司矿业大屏项目', '邓路蓬', '18730663556', '20221026', '李小龙', '河北志晟信息技术股份有限公司', '内贸', '60万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16260, '会员入驻', '2022-10-26', '无纺会员', '饶玉黔', '13606268829', '20221026', '郁新涛', '昆山科立隆非织造布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16261, '会员入驻', '2022-10-26', '无纺会员', '吴嘉祺', '13646238166', '20221026', '郁新涛', '常熟市森拓非织造布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16262, '会员入驻', '2022-10-26', '无纺会员', '金宝珍', '13968036161', '20221026', '郁新涛', '杭州临安华迅水刺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16263, '广告', '2022-10-26', '制品广告', '鲁燕飞', '13355848924', '20221026', '郁新涛', '余姚市驰威无纺制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16264, '机械工厂', '2022-10-26', '智能工厂', '丁晓丽', '15895219818', '20221026', '郁新涛', '徐州金龙桥无纺新材料有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16265, '机械工厂', '2022-10-26', '智能工厂', '刘杰', '13320228836', '20221026', '郁新涛', '宜宾美康无纺新材料有限责任公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16266, '无纺布制品', '2022-10-26', '湿巾', '杜云肖', '0311-85191906', '20221026', '顾怡青', '河北氏氏美卫生用品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16267, '无纺布制品', '2022-10-26', '湿巾', '司玉洪', '0319-3821999', '20221026', '顾怡青', '邢台市桥东洁鑫餐具清洗消毒配送站', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16268, '无纺布制品', '2022-10-26', '湿巾', '路畅', '13933226880', '20221026', '顾怡青', '保定八木化纤有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16269, '无纺布制品', '2022-10-26', '湿巾', '杨志会', '0312-5572818', '20221026', '顾怡青', '保定市满城区瑞丰纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16270, '无纺布制品', '2022-10-26', '湿巾', '解岗', '0318-8071000', '20221026', '顾怡青', '衡水亿康消毒餐具有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16271, '无纺布制品', '2022-10-26', '湿巾', '张振宇', '15037951067', '20221026', '顾怡青', '河南鑫康福生物工程有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16272, '无纺布制品', '2022-10-26', '湿巾', '朱艳军', '0373-5456777', '20221026', '顾怡青', '新乡市申氏卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16273, '无纺布制品', '2022-10-26', '湿巾', '孔振英', '0393-4613056', '20221026', '顾怡青', '濮阳市润洁生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16274, '无纺布制品', '2022-10-26', '湿巾', '周巍锋', '13353875464', '20221026', '顾怡青', '驻马店市晨钟生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16275, '无纺布制品', '2022-10-26', '湿巾', '邹清伟', '13055748861', '20221026', '顾怡青', '福州恒恩程工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16276, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+39035715911                                   Fax:+39035715999', '20221026', '郑静', 'TESSITURE PIETRO RADICI  SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16277, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+39035670444                                  Fax:+39035670450', '20221026', '郑静', 'TESTA GROUP SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16278, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+39057248041                                  Fax:+3905724804360', '20221026', '郑静', 'TEXSUS SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16279, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+33477916390                             Fax:+33477916391', '20221026', '郑静', 'TEXTI SONICS SAS', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16280, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '15922348236', '20221026', '郑静', '欣盛（浙江）无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16281, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '18968089352', '20221026', '郑静', '浙江戴乐无纺新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16282, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '13921296168', '20221026', '郑静', '无锡优佳无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16283, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '15168498588', '20221026', '郑静', '杭州森润无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16284, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '0573-87966778', '20221026', '郑静', '海宁市宏源无纺布业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16285, '无纺', '2022-10-26', '白色纯涤纶针刺无纺布', '深入沟通中', '18861250277', '20221026', '郑静', '浙江世钧无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16286, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+34965590412                                Fax:+34965592403', '20221027', '郑静', 'TEXTISOL S.L.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16287, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+302109875042                           Fax:+302109875040', '20221027', '郑静', 'THRACENONWOVENS&GEOSYNTHETICS S.A.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16288, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+886225580516                           Fax:+886225527330', '20221027', '郑静', 'TAIWAN NONWOVEN FABRICS INDUSTRY ASS.(TNFIA)', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16289, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+82232791233                                  Fax:+82232791415', '20221027', '郑静', 'TORAY ADVANCED MATERIALS KOREA INC', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16290, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13906202964', '20221027', '郑静', '维顺（中国）无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16291, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '\n\n15161606632', '20221027', '郑静', '江苏爱琪艺臻品无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16292, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '15751618876', '20221027', '郑静', '江苏森源无纺滤料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16293, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13801562813', '20221027', '郑静', '张家港骏马无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16294, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13905256159', '20221027', '郑静', '仪征市双星无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16295, '无纺', '2022-10-27', '白色纯涤纶针刺无纺布', '深入沟通中', '13906810583', '20221027', '郑静', '杭州顺龙无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16296, '无纺布', '2022-10-27', '白色木浆水刺布', '丁莉', '15068520492', '20221027', '顾怡青', '绍兴乐洁氏生活用品有限公司', '内贸', '6', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16297, '无纺布制品', '2022-10-27', '湿巾', '邱（石羡）珠', '13400784156', '20221027', '顾怡青', '厦门金泰生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16298, '无纺布制品', '2022-10-27', '湿巾', '吕孙经', '13489249666', '20221027', '顾怡青', '泉州尧盛纸品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16299, '无纺布制品', '2022-10-27', '湿巾', '陈慧红', '15396632533', '20221027', '顾怡青', '泉州创达实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16300, '无纺布制品', '2022-10-27', '湿巾', '周慢玉', '13407294988', '20221027', '顾怡青', '湖北雅致卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16301, '无纺布制品', '2022-10-27', '湿巾', '郑磊', '0551-65689008', '20221027', '顾怡青', '安徽汉邦医疗用品集团有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16302, '无纺布制品', '2022-10-27', '湿巾', '李修朋', '0558-8218086', '20221027', '顾怡青', '安徽鑫露达医疗用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16303, '无纺布制品', '2022-10-27', '湿巾', '何荣', '029-36388356', '20221027', '顾怡青', '陕西洁康日用保健品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16304, '无纺布制品', '2022-10-27', '湿巾', '傅金煽', '13787221339', '20221027', '顾怡青', '长沙丰之裕纸业有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16305, '无纺布制品', '2022-10-27', '湿巾', '倪素芬', '0417-2122861', '20221027', '顾怡青', '大石桥市明月纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16306, '无纺布制品', '2022-10-27', '湿巾', '王勇', '13065258282', '20221027', '顾怡青', '盘锦市大洼区香菲餐巾纸厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16307, '会员入驻', '2022-10-27', '无纺会员', '朱秀仁', '13575387991', '20221027', '郁新涛', '浙江宏源无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16308, '会员入驻', '2022-10-27', '无纺会员', '洪萍', '15068362302', '20221027', '郁新涛', '嘉兴市宏亮纺织有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16309, '会员入驻', '2022-10-27', '无纺会员', '朱中赏', '13116881810', '20221027', '郁新涛', '浦江县时创卫材科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16310, '广告', '2022-10-27', '制品广告', '夏远福', '15067723355', '20221027', '郁新涛', '浙江开杰无纺布有限公司制袋车间', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16311, '机械工厂', '2022-10-27', '智能工厂', '周彩娟', '13706741018', '20221027', '郁新涛', '慈溪市三北水刺无纺布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16312, '机械工厂', '2022-10-27', '智能工厂', '李国兵', '15988211873', '20221027', '郁新涛', '绍兴鑫裕纺织品有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16313, '全系列', '2022-10-27', '浙江鑫恒无纺布有限公司', '郑仰芳', '13958780288', '20221027', '李小龙', '浙江鑫恒无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16314, '全系列', '2022-10-27', '浙江贵祥无纺布有限公司', '朱贵平', '13511250228', '20221027', '李小龙', '浙江贵祥无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16315, '全系列', '2022-10-27', '苏州市森鸿无纺布有限公司', '孙仁宏', '13338021088', '20221027', '李小龙', '苏州市森鸿无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16316, '全系列', '2022-10-27', '河北轩邦无纺布有限公司', '李景朋', '13469851930', '20221027', '李小龙', '河北轩邦无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16317, '全系列', '2022-10-27', '智程无纺布（江苏）有限公司', '张义珍', '17712891988', '20221027', '李小龙', '智程无纺布（江苏）有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16318, '全系列', '2022-10-27', '温州缦纱无纺布有限公司', '程鹏', '13757872150', '20221027', '李小龙', '温州缦纱无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16319, '全系列', '2022-10-27', '安新县鹏达无纺织物有限公司', '马志磊', '13784967777', '20221027', '李小龙', '安新县鹏达无纺织物有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16320, '全系列', '2022-10-27', '泉州市百丝达无纺布有限公司', '杨胜利', '13675917234', '20221027', '李小龙', '泉州市百丝达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16321, '全系列', '2022-10-27', '苏州市雅各无纺滤材有限公司', '龙生', '13906233480', '20221027', '李小龙', '苏州市雅各无纺滤材有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16322, '全系列', '2022-10-27', '合肥高贝斯无纺布制品有限公司', '高明', '13856996613', '20221027', '李小龙', '合肥高贝斯无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16323, '无纺布制品', '2022-10-28', '湿巾', '刘涛', '13821060731', '20221028', '顾怡青', '天津木兰巾纸制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16324, '无纺布制品', '2022-10-28', '湿巾', '刘端翔', '15970489776', '20221028', '顾怡青', '南昌市欣荣纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16325, '无纺布制品', '2022-10-28', '湿巾', '赵孝龙', '0796-8405639', '20221028', '顾怡青', '吉安市三江超纤无纺有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16326, '无纺布制品', '2022-10-28', '湿巾', '张豆豆', '13756661458', '20221028', '顾怡青', '长春市铭泽纸业有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16327, '无纺布制品', '2022-10-28', '湿巾', '高洁', '13351118360', '20221028', '顾怡青', '哈尔滨市三和佳美科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16328, '无纺布制品', '2022-10-28', '湿巾', '段炼', '13684744158', '20221028', '顾怡青', '托克托县宏达纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16329, '无纺布制品', '2022-10-28', '湿巾', '曹红兵', '15095332734', '20221028', '顾怡青', '兰州飞燕商贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16330, '无纺布制品', '2022-10-28', '湿巾', '张军辉', '13993495568', '20221028', '顾怡青', '庆阳市鹤原印务有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16331, '无纺布制品', '2022-10-28', '湿巾', '叶大侨', '13808829501', '20221028', '顾怡青', '广州市申泰卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16332, '无纺布制品', '2022-10-28', '湿巾', '马广飞', '020-66856099', '20221028', '顾怡青', '广州五羊化妆品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16333, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+39059909331                      Fax:+39059909922', '20221028', '郑静', 'TRASCAR  SPA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16334, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+49823496882222                                 Fax:+49823496885342', '20221028', '郑静', 'TREVIRA GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16335, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+49705368101                                 Fax:+4970537359', '20221028', '郑静', 'TRUTZSCHLER CARD CLOTHING GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16336, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+390445576110                                 Fax:+390445576109', '20221028', '郑静', 'UGOLINI SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16337, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13915257193', '20221028', '郑静', '江阴市华思诚无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16338, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '0571-64138591', '20221028', '郑静', '杭州旦洋无纺科技股份有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16339, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13815600816', '20221028', '郑静', '连云港盛德无纺布业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16340, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13456822589', '20221028', '郑静', '杭州润通无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16341, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '13906732127', '20221028', '郑静', '浙江亮洁无纺材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16342, '无纺', '2022-10-28', '白色纯涤纶针刺无纺布', '深入沟通中', '135 8506 6101 ', '20221028', '郑静', '江阴拓普无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16343, '会员入驻', '2022-10-28', '无纺会员', '管宁章', '13905786307', '20221028', '郁新涛', '遂昌玄乐炭复合材料有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16344, '会员入驻', '2022-10-28', '无纺会员', '李晓东', '15051933659', '20221028', '郁新涛', '常州坊客无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16345, '会员入驻', '2022-10-28', '无纺会员', '浦慧敏', '17826169276', '20221028', '郁新涛', '海门市卓维纺织品有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16346, '广告', '2022-10-28', '制品广告', '包全审', '13646547414', '20221028', '郁新涛', '苍南全诚无纺布制品厂', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16347, '机械工厂', '2022-10-28', '智能工厂', '王洪云', '13328090918', '20221028', '郁新涛', '南通新绿叶非织造布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16348, '机械工厂', '2022-10-28', '智能工厂', '金刚强', '18955013918', '20221028', '郁新涛', '浙江龙游上博无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16349, '全系列', '2022-10-28', '江阴恒和无纺布制品有限公司', '李明钢', '13706161125', '20221028', '李小龙', '江阴恒和无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16350, '全系列', '2022-10-28', '河南九州无纺布制品有限公司', '付丽娜', '13854161325', '20221028', '李小龙', '河南九州无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16351, '全系列', '2022-10-28', '南通国宏无纺布有限公司', '温建敏', '15806159825', '20221028', '李小龙', '南通国宏无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16352, '全系列', '2022-10-28', '南通豪杰无纺布有限公司', '张兴华', '13773779898', '20221028', '李小龙', '南通豪杰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16353, '全系列', '2022-10-28', '嘉兴友轩无纺布有限公司', '王利强', '0573-88482916', '20221028', '李小龙', '嘉兴友轩无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16354, '全系列', '2022-10-28', '安徽安景瑞无纺布制品有限公司', '刘娴', '15255695221', '20221028', '李小龙', '安徽安景瑞无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16355, '全系列', '2022-10-28', '扬州市联合无纺布材料厂', '孙福文', '15862878506', '20221028', '李小龙', '扬州市联合无纺布材料厂', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16356, '全系列', '2022-10-28', '常熟市建泰无纺制品有限公司', '周亚刚', '13901578793', '20221028', '李小龙', '常熟市建泰无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16357, '全系列', '2022-10-28', '南通鸿康无纺布有限公司', '刘海兵', '15962806298', '20221028', '李小龙', '南通鸿康无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16358, '全系列', '2022-10-28', '浙江晨阳无纺布科技有限公司', '沈光伟', '15925665008', '20221028', '李小龙', '浙江晨阳无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16359, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+390575720726                              Fax:+390575721796', '20221031', '郑静', 'ULTRA SYSTEM SRL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16360, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+358204140101                            Fax:+358204143404', '20221031', '郑静', 'UPM-KYMMENE CORPORATION ,RAUMACELL', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16361, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+85227246078                             Fax:+85223698779', '20221031', '郑静', 'U.S PACIFIC NONWOVENS INDUSTRY LTD.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16362, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+34948321585                                Fax:+34948326584', '20221031', '郑静', 'VALCO MELETON S.L.U.', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16363, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '18106299396', '20221031', '郑静', '南通日晨无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16364, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '18358766611', '20221031', '郑静', '温州市凌炜无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16365, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '15355220008', '20221031', '郑静', '嘉兴市财华熔喷无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16366, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '13606770358', '20221031', '郑静', '浙江雅宝无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16367, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '13390861888', '20221031', '郑静', '苏州合利汇无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16368, '无纺', '2022-10-31', '白色纯涤纶针刺无纺布', '深入沟通中', '18613181761', '20221031', '郑静', '昆山洁宏无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16369, '无纺布制品', '2022-10-31', '湿巾', '赵贵宣', '18126791078', '20221031', '顾怡青', '广州贝诺生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16370, '无纺布制品', '2022-10-31', '湿巾', '陈霞', '0755-29671072', '20221031', '顾怡青', '深圳市格朗电器有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16371, '无纺布制品', '2022-10-31', '湿巾', '曾燕文', '13428786733', '20221031', '顾怡青', '深圳市荆江纸制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16372, '无纺布制品', '2022-10-31', '湿巾', '李媛媛', '13923773242', '20221031', '顾怡青', '深圳市合芯通信技术有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16373, '无纺布制品', '2022-10-31', '湿巾', '藤井宏祐', '0769-85358605', '20221031', '顾怡青', '莎罗雅（东莞）清洁用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16374, '无纺布制品', '2022-10-31', '湿巾', '李文秀', '010-64830788', '20221031', '顾怡青', '北京建元天地环保科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16375, '无纺布制品', '2022-10-31', '湿巾', '王卫', '025-83305050', '20221031', '顾怡青', '南京巨鲨显示科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16376, '无纺布制品', '2022-10-31', '湿巾', '李永生', '18761954577', '20221031', '顾怡青', '苏州逸云卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16377, '无纺布制品', '2022-10-31', '湿巾', '陈斌', '0517-86989806', '20221031', '顾怡青', '江苏宝姿实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16378, '无纺布制品', '2022-10-31', '湿巾', '吴叶青', '021-22072666', '20221031', '顾怡青', '上海渊泉集币收藏品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16379, '会员入驻', '2022-10-31', '无纺会员', '冉士兵', '18838967916', '', '郁新涛', '常熟市振泰水刺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16380, '会员入驻', '2022-10-31', '无纺会员', '陈越', '15259988829', '', '郁新涛', '杭州森润无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16381, '会员入驻', '2022-10-31', '无纺会员', '胡小龙', '15816656063', '', '郁新涛', '南通通州江华纺织有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16382, '广告', '2022-10-31', '制品广告', '李建平', '18368896005', '', '郁新涛', '嘉兴飞翔医用新材料科技有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16383, '机械工厂', '2022-10-31', '智能工厂', '石成匡', '15336899694', '', '郁新涛', '杭州萧山凤凰纺织有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16384, '机械工厂', '2022-10-31', '智能工厂', '曹松亭', '13390727777', '', '郁新涛', '安徽金春无纺布股份有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16385, '全系列', '2022-10-31', '浙江钜源无纺布有限公司', '应文虎', '13806558288', '20221031', '李小龙', '浙江钜源无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16386, '全系列', '2022-10-31', '浙江旺远无纺布有限公司', '蔡宝旺', '13868368999', '20221031', '李小龙', '浙江旺远无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16387, '全系列', '2022-10-31', '扬州步积成无纺布有限公司', '蒋建军', '15806148982', '20221031', '李小龙', '扬州步积成无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16388, '全系列', '2022-10-31', '福建省洲楷无纺布科技有限公司', '陈家利', '13801519793', '20221031', '李小龙', '福建省洲楷无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16389, '全系列', '2022-10-31', '仙桃市良卓无纺布制品有限公司', '刘霞', '13773770098', '20221031', '李小龙', '仙桃市良卓无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16390, '全系列', '2022-10-31', '杭州申皇无纺布用品有限公司', '余寿法', '0571-86339816', '20221031', '李小龙', '杭州申皇无纺布用品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16391, '全系列', '2022-10-31', '慈溪市中帆无纺制品有限公司', '丁金达', '0574-63525111', '20221031', '李小龙', '慈溪市中帆无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16392, '全系列', '2022-10-31', '宁波炜业无纺布技术有限公司', '赵庙良', '0574-88099688', '20221031', '李小龙', '宁波炜业无纺布技术有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16393, '全系列', '2022-10-31', '河南维妮香无纺科技有限公司', '李元森', '13670987212', '20221031', '李小龙', '河南维妮香无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16394, '全系列', '2022-10-31', '浙江保禄无纺布科技有限公司', '黄通拼', '15923096298', '20221031', '李小龙', '浙江保禄无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16395, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:12075715702', '20221101', '郑静', 'VALMET INC', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16396, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+97289960880                          Fax:+97289960881', '20221101', '郑静', 'VAPORJET LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16397, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+34937583298                          Fax:+34937583286', '20221101', '郑静', 'VELCRO EUROPE SA', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16398, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+31578679111                         Fax:+31578621317', '20221101', '郑静', 'VIM HOLLAND BV', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16399, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '13587854527', '20221101', '郑静', '浙江大洲无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16400, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '0539-2701666', '20221101', '郑静', '宁波锦菲无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16401, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '15345129132', '20221101', '郑静', '常熟市中意无纺制造有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16402, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '0512-68251586', '20221101', '郑静', '科德宝.宝翎无纺布（苏州）有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16403, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '13815803078', '20221101', '郑静', '扬州五洋无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16404, '无纺', '2022-11-01', '白色纯涤纶针刺无纺布', '深入沟通中', '13606772515', '20221101', '郑静', '浙江恒海无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16405, '会员入驻', '2022-11-01', '无纺会员', '裘肖坚', '13764705616', '20221101', '郁新涛', '杭州杭纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16406, '会员入驻', '2022-11-01', '无纺会员', '徐跃飞', '17715387217', '20221101', '郁新涛', '江苏思博特纺织科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16407, '会员入驻', '2022-11-01', '无纺会员', '沈玉云', '15005892222', '20221101', '郁新涛', '上海枫围无纺布厂有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16408, '广告', '2022-11-01', '制品广告', '宋海琪', '15021627929', '20221101', '郁新涛', '江苏爱琪艺臻品无纺科技有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16409, '机械工厂', '2022-11-01', '智能工厂', '刘仁才', '13906289364', '20221101', '郁新涛', '常熟市振泰不织布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16410, '机械工厂', '2022-11-01', '智能工厂', '赵孝龙', '13345202983', '20221101', '郁新涛', '三江超纤无纺有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16411, '全系列', '2022-11-01', '浙江金亿乐无纺布科技有限公司', '金海琴', '0571-57181303', '20221101', '李小龙', '浙江金亿乐无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16412, '全系列', '2022-11-01', '扬州荣伟无纺布有限公司', '陈凤珠', '13852799756', '20221101', '李小龙', '扬州荣伟无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16413, '全系列', '2022-11-01', '苏州侨盛无纺制品有限公司', '陈建明', '13906226623', '20221101', '李小龙', '苏州侨盛无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16414, '全系列', '2022-11-01', '郑州帑润无纺科技有限公司', '薄芝奎', '17320107675', '20221101', '李小龙', '郑州帑润无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16415, '全系列', '2022-11-01', '上海凯通无纺布制造有限公司', '高剑峰', '13311725569', '20221101', '李小龙', '上海凯通无纺布制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16416, '全系列', '2022-11-01', '杭州思进无纺布有限公司', '胡炳年', '13606644938', '20221101', '李小龙', '杭州思进无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16417, '全系列', '2022-11-01', '浙江广得利无纺布有限公司', '薛永来', '15968715577', '20221101', '李小龙', '浙江广得利无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16418, '全系列', '2022-11-01', '徐州金龙桥无纺新材料有限公司', '丁晓丽', '15895219818', '20221101', '李小龙', '徐州金龙桥无纺新材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16419, '全系列', '2022-11-01', '杭州优咔无纺制品有限公司', '陈培根', '17320200875', '20221101', '李小龙', '杭州优咔无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16420, '全系列', '2022-11-01', '江苏睿鲲无纺布有限公司', '黄平国', '13883743018', '20221101', '李小龙', '江苏睿鲲无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16421, '无纺布制品', '2022-11-01', '湿巾', 'PARMAR NILESH UMESHCHANDRA', '021-57669436', '20221101', '顾怡青', '沁心（上海）卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16422, '无纺布制品', '2022-11-01', '湿巾', '胡国聪', '0574-63703190', '20221101', '顾怡青', '慈溪市舒乐洁卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16423, '无纺布制品', '2022-11-01', '湿巾', '池星红', '0577-58806707', '20221101', '顾怡青', '温州市川洋妇婴用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16424, '无纺布制品', '2022-11-01', '湿巾', '梁静', '13456396879', '20221101', '顾怡青', '海盐县云锋特种机械厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16425, '无纺布制品', '2022-11-01', '湿巾', '王志英', '13325737566', '20221101', '顾怡青', '嘉兴市知明机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16426, '无纺布制品', '2022-11-01', '湿巾', '黄建国', '13906724889', '20221101', '顾怡青', '湖州光博生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16427, '无纺布制品', '2022-11-01', '湿巾', '唐地源', '0531-83511076', '20221101', '顾怡青', '奇妙科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16428, '无纺布制品', '2022-11-01', '湿巾', '车德美', '0532-84682886', '20221101', '顾怡青', '青岛非凡包装机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16429, '无纺布制品', '2022-11-01', '湿巾', '姚运娜', '15953228889', '20221101', '顾怡青', '青岛市城阳区海民杰商行', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16430, '无纺布制品', '2022-11-01', '湿巾', '刘雪峰', '13220527585', '20221101', '顾怡青', '东营市东营区特佳洁湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16431, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:+49644188603                          Fax:+49644185718', '20221102', '郑静', 'WAL TER UHL TECHNISCHE MIKROSKOPIE GMBH& CO.KG', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16432, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:88673553611                                Fax:88673582091', '20221102', '郑静', 'WEB-PRO CORPORATION', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16433, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:912266136000  Fax:912224908020', '20221102', '郑静', 'WELSPUN INDIA LTD', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16434, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:492631840  Fax:49263121112', '20221102', '郑静', 'WINKLER +DUNNEBIER GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16435, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '18955663632', '20221102', '郑静', '浙江弘扬无纺新材料有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16436, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '13615246456', '20221102', '郑静', '仪征天越达无纺制品有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16437, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '13832276100', '20221102', '郑静', '连云港钰晟无纺布制品有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16438, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '15227020999', '20221102', '郑静', '江苏雄迁无纺布制品有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16439, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '18269863313', '20221102', '郑静', '六安尚荣无纺布制品有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16440, '无纺', '2022-11-02', '白色纯涤纶针刺无纺布', '深入沟通中', '15357096818', '20221102', '郑静', '桐城市超然无纺布包装制品有限公司', '外贸', '0', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16441, '无纺布制品', '2022-11-02', '湿巾', '邢玉红', '15726056166', '20221102', '顾怡青', '潍坊雨洁消毒用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16442, '无纺布制品', '2022-11-02', '湿巾', '张富保', '0310-8568862', '20221102', '顾怡青', '邯郸市凯琳卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16443, '无纺布制品', '2022-11-02', '湿巾', '李彦永', '18631236888', '20221102', '顾怡青', '保定市满城区金铭达纸制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16444, '无纺布制品', '2022-11-02', '湿巾', '赵金亮', '13503174935', '20221102', '顾怡青', '东光县鑫淼湿巾厂', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16445, '无纺布制品', '2022-11-02', '湿巾', '王利杰', '13069534626', '20221102', '顾怡青', '许昌市城乡一体化示范区优洁纸制品配送处', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16446, '无纺布制品', '2022-11-02', '湿巾', '王桂华', '0370-5152222', '20221102', '顾怡青', '永城市好理想卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16447, '无纺布制品', '2022-11-02', '湿巾', '桂银太', '0592-7111718', '20221102', '顾怡青', '厦门创业人环保科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16448, '无纺布制品', '2022-11-02', '湿巾', '陈智晓', '0594-3569625', '20221102', '顾怡青', '福建亿发护理用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16449, '无纺布制品', '2022-11-02', '湿巾', '温泉', '0551-63533416', '20221102', '顾怡青', '安徽时代漫游文化传媒股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:50', 'admin', '2022-11-16 22:14:50');
INSERT INTO `fnc_ledger` VALUES (16450, '无纺布制品', '2022-11-02', '湿巾', '李东霖', '0556-6123428', '20221102', '顾怡青', '安徽顺彤包装材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16451, '广告', '2022-11-02', '制品广告', '何金清', '13961662602', '20221102', '郁新涛', '江苏金秋弹性织物有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16452, '会员入驻', '2022-11-02', '无纺会员', '谭国清', '13605734796', '20221102', '郁新涛', '常熟市亿美达无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16453, '会员入驻', '2022-11-02', '无纺会员', '仇树林', '13953100605', '20221102', '郁新涛', '江苏树林无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16454, '会员入驻', '2022-11-02', '无纺会员', '何苏义', '15201484736', '20221102', '郁新涛', '恒天嘉华非织造有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16455, '机械工厂', '2022-11-02', '智能工厂', '董栋', '13801103832', '20221102', '郁新涛', '杭州临安华宏无纺布制品有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16456, '机械工厂', '2022-11-02', '智能工厂', '钱鸣东', '13916132667', '20221102', '郁新涛', '常熟市聚格纤维制品有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16457, '全系列', '2022-11-02', '江苏博盾环保无纺布有限公司', '马显斌', '15885286888', '20221102', '李小龙', '江苏博盾环保无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16458, '全系列', '2022-11-02', '常熟金和无纺机械科技有限公司', '王永祥', '13862365888', '20221102', '李小龙', '常熟金和无纺机械科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16459, '全系列', '2022-11-02', '杭州超友无纺布有限公司', '贾年法', '13968091526', '20221102', '李小龙', '杭州超友无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16460, '全系列', '2022-11-02', '绍兴柯桥天圣无纺有限公司', '沈伟峰', '13588573691', '20221102', '李小龙', '绍兴柯桥天圣无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16461, '全系列', '2022-11-02', '江苏欧杰无纺布设备有限公司', '庞伟峰', '18136582658', '20221102', '李小龙', '江苏欧杰无纺布设备有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16462, '全系列', '2022-11-02', '郑州腾隆无纺布有限公司', '臧邦军', '18236958929', '20221102', '李小龙', '郑州腾隆无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16463, '全系列', '2022-11-02', '江苏怀静无纺布包装袋有限公司', '王怀孝', '13815495505', '20221102', '李小龙', '江苏怀静无纺布包装袋有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16464, '全系列', '2022-11-02', '浙江梦轩无纺布科技有限公司', '余本龙', '13009999109', '20221102', '李小龙', '浙江梦轩无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16465, '全系列', '2022-11-02', '扬州顺彩无纺制品有限公司', '罗永金', '13801447051', '20221102', '李小龙', '扬州顺彩无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16466, '全系列', '2022-11-02', '海阳市适尔无纺布制品有限公司', '姜辉', '18905352156', '20221102', '李小龙', '绍兴柯桥天圣无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16467, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:4346338480  Fax:434633848283', '20221103', '郑静', 'ZIMMER MASCHINENBAU GMBH', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16468, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', 'Tel:81663407117  Fax:81663404182', '20221103', '郑静', 'ZUIKO COROORATION', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16469, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '631-730-2200', '20221103', '郑静', 'The Hain Celestial Group , Inc.', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16470, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '562-869-1918', '20221103', '郑静', 'Ralph Lauren Shop', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16471, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '0579-85218882', '20221103', '郑静', '义乌市恒翔无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16472, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '0557-3339882', '20221103', '郑静', '安徽润维无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16473, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '15950735699', '20221103', '郑静', '连云港柏兴无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16474, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '18906636636', '20221103', '郑静', '温州圣恩无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16475, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '13382298001', '20221103', '郑静', '江苏朵拉无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16476, '无纺', '2022-11-03', '白色纯涤纶针刺无纺布', '深入沟通中', '13301572115', '20221103', '郑静', '常熟市金陵无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16477, '无纺布制品', '2022-11-03', '湿巾', '梅杰', '13083335559', '20221103', '顾怡青', '安徽凤阳雅洁棉签有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16478, '无纺布制品', '2022-11-03', '湿巾', '周杨青', '0558-2627700', '20221103', '顾怡青', '阜阳市阳阳卫生科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16479, '无纺布制品', '2022-11-03', '湿巾', '杨科', '0558-7190003', '20221103', '顾怡青', '安徽乐天饮品有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16480, '无纺布制品', '2022-11-03', '湿巾', '刚旭明', '18941180970', '20221103', '顾怡青', '大连英超卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16481, '无纺布制品', '2022-11-03', '湿巾', '姜树春', '13464260777', '20221103', '顾怡青', '朝阳艾达卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16482, '无纺布制品', '2022-11-03', '湿巾', '段家广', '022-26993852', '20221103', '顾怡青', '天津凯利恩科技发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16483, '无纺布制品', '2022-11-03', '湿巾', '赵勇', '13769131120', '20221103', '顾怡青', '云南滇贵实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16484, '无纺布制品', '2022-11-03', '湿巾', '员欣', '17503463698', '20221103', '顾怡青', '太原市万柏林区鑫同纸品厂', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16485, '无纺布制品', '2022-11-03', '湿巾', '朱洪波', '13354302027', '20221103', '顾怡青', '长春市巨昌纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16486, '无纺布制品', '2022-11-03', '湿巾', '高士琼', '13897580039', '20221103', '顾怡青', '西宁城东青青纸业包装厂', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16487, '会员入驻', '2022-11-03', '无纺会员', '范福根', '13757830666', '', '郁新涛', '杭州顺龙无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16488, '会员入驻', '2022-11-03', '无纺会员', '陈生香', '18257096622', '', '郁新涛', '苏州康思惠纤维科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16489, '会员入驻', '2022-11-03', '无纺会员', '陈启途', '18596209888', '', '郁新涛', '浙江好材好非织造布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16490, '广告', '2022-11-03', '制品广告', '刘道林', '13567119449', '', '郁新涛', '常熟璟杰无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16491, '机械工厂', '2022-11-03', '智能工厂', '吴嘉祺', '18857609616', '', '郁新涛', '常熟市森拓非织造布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16492, '机械工厂', '2022-11-03', '智能工厂', '沈旭初', '13365636546', '', '郁新涛', '太仓市梓怡纺织有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16493, '全系列', '2022-11-03', '江苏拓川无纺布有限公司', '季方', '13921666623', '20221103', '李小龙', '江苏拓川无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16494, '全系列', '2022-11-03', '江苏泰富无纺布有限公司', '薛翔', '17312920000', '20221103', '李小龙', '江苏泰富无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16495, '全系列', '2022-11-03', '义乌市古月无纺布有限公司', '楼斯蒂', '15967959789', '20221103', '李小龙', '义乌市古月无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16496, '全系列', '2022-11-03', '江苏港姿束无纺布有限公司', '陈玲静', '18652700711', '20221103', '李小龙', '江苏港姿束无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16497, '全系列', '2022-11-03', '浙江天天向上无纺布科技有限公司', '陈鹏', '13706566395', '20221103', '李小龙', '浙江天天向上无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16498, '全系列', '2022-11-03', '河南全棉工坊无纺科技有限公司', '周海', '13938591480', '20221103', '李小龙', '河南全棉工坊无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16499, '全系列', '2022-11-03', '江苏茗绿无纺布用品有限公司', '嵇翠萍', '15152329252', '20221103', '李小龙', '江苏茗绿无纺布用品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16500, '全系列', '2022-11-03', '江苏博昌无纺制品有限公司', '周恒', '15351521255', '20221103', '李小龙', '江苏博昌无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16501, '全系列', '2022-11-03', '浙江禾博士无纺布科技有限公司', '谭正莲', '15988508205', '20221103', '李小龙', '浙江禾博士无纺布科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16502, '全系列', '2022-11-03', '杭州临安中正无纺制品有限公司', '王政', '13750863850', '20221103', '李小龙', '杭州临安中正无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16503, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '860-646-1233', '20221104', '郑静', 'Lydall, Inc.', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16504, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '651-293-2092', '20221104', '郑静', 'Ecolab Inc. ', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16505, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '800-633-5463-', '20221104', '郑静', 'Medline Industries Inc', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16506, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '18796503909', '20221104', '郑静', '江苏炫翔无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16507, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '0551-65862623', '20221104', '郑静', '安徽宏远无纺布业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16508, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '15855099580', '20221104', '郑静', '凤阳洁宏无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16509, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '15371233498', '20221104', '郑静', '江苏海卓无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16510, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '18792030577', '20221104', '郑静', '安徽天沛无纺布业有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16511, '无纺', '2022-11-04', '白色纯涤纶针刺无纺布', '深入沟通中', '13815009490', '20221104', '郑静', '江苏艾文德莱无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16512, '会员入驻', '2022-11-04', '常熟市双龙无纺布有限公司', '张雪明', '13901574578', '20221104', '郁新涛', '常熟市双龙无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16513, '会员入驻', '2022-11-04', '苏州美森无纺科技有限公司', '韩雪龙', '18952437896', '20221104', '郁新涛', '苏州美森无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16514, '会员入驻', '2022-11-04', '惠千都（杭州）无纺布科技有限公司', '赵丹丹', '13216813893', '20221104', '郁新涛', '惠千都（杭州）无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16515, '广告', '2022-11-04', '苏州正义无纺制品有限公司', '孙自永', '18861052553', '20221104', '郁新涛', '苏州正义无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16516, '机械工厂', '2022-11-04', '常州华纳非织造布有限公司', '庄海祥', '15026582580', '20221104', '郁新涛', '常州华纳非织造布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16517, '机械工厂', '2022-11-04', '邵阳纺织机械有限责任公司', '刘序焱', '13811324568', '20221104', '郁新涛', '邵阳纺织机械有限责任公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16518, '全系列', '2022-11-04', '扬州市同创无纺布有限公司', '王祥林', '13912270274', '20221104', '李小龙', '扬州市同创无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16519, '全系列', '2022-11-04', '江苏高科无纺布有限公司', '江贤娒', '19851766262', '20221104', '李小龙', '江苏高科无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16520, '全系列', '2022-11-04', '武汉鑫宝华无纺布有限公司', '左峰', '18651957677', '20221104', '李小龙', '武汉鑫宝华无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16521, '全系列', '2022-11-04', '新乐市鑫淼无纺制品有限公司', '温朋飞', '13933059182', '20221104', '李小龙', '新乐市鑫淼无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16522, '全系列', '2022-11-04', '温州协兴无纺布有限公司', '李守珠', '13388586269', '20221104', '李小龙', '温州协兴无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16523, '全系列', '2022-11-04', '绍兴市柯桥区银鑫无纺有限公司', '曹传来', '13806740880', '20221104', '李小龙', '绍兴市柯桥区银鑫无纺有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16524, '全系列', '2022-11-04', '上海六鑫无纺材料有限公司', '张驰', '13661975346', '20221104', '李小龙', '上海六鑫无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16525, '全系列', '2022-11-04', '四川渝西无纺布有限公司', '胡代理', '13808230719', '20221104', '李小龙', '四川渝西无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16526, '全系列', '2022-11-04', '临沂市丰凯无纺布有限公司', '刘兴振', '13805491878', '20221104', '李小龙', '临沂市丰凯无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16527, '全系列', '2022-11-04', '常熟市亿美达无纺科技有限公司', '谭国清', '13806240987', '20221104', '李小龙', '常熟市亿美达无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16528, '无纺布制品', '2022-11-07', '湿巾', '廖英', '13518917888', '20221107', '顾怡青', '拉萨市木可工贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16529, '无纺布制品', '2022-11-07', '湿巾', '赵志华', '020-89681274', '20221107', '顾怡青', '广州市科林森普洁净用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16530, '无纺布制品', '2022-11-07', '湿巾', '薛金庭', '020-39218309', '20221107', '顾怡青', '广州市文德泰科生物技术有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16531, '无纺布制品', '2022-11-07', '湿巾', '李建全', '0755-28138888', '20221107', '顾怡青', '深圳全棉时代科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16532, '无纺布制品', '2022-11-07', '湿巾', '欧国军', '0755-89474066', '20221107', '顾怡青', '深圳市拓维模型技术有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16533, '无纺布制品', '2022-11-07', '湿巾', '朱新田', '0755-84087373', '20221107', '顾怡青', '心丽卫生用品（深圳）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16534, '无纺布制品', '2022-11-07', '湿巾', '李冠玮', '0755-29786661', '20221107', '顾怡青', '深圳市麦凯莱科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16535, '无纺布制品', '2022-11-07', '湿巾', '李东波', '15586999555', '20221107', '顾怡青', '深圳市东波包装制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16536, '无纺布制品', '2022-11-07', '湿巾', '李清木', '0756-3878378', '20221107', '顾怡青', '珠海市椿田机械科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16537, '无纺布制品', '2022-11-07', '湿巾', '朱云', '0756-3916820', '20221107', '顾怡青', '珠海市健朗生活用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16538, '全系列', '2022-11-07', '南通大奔无纺布有限公司', '施兵', '13814733073', '20221107', '李小龙', '南通大奔无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16539, '全系列', '2022-11-07', '杭州美可巾无纺制品有限公司', '孙丙国', '0571-63583977', '20221107', '李小龙', '杭州美可巾无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16540, '全系列', '2022-11-07', '山东华唐无纺布有限公司', '徐知颖', '13954960068', '20221107', '李小龙', '山东华唐无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16541, '全系列', '2022-11-07', '河南永堂无纺布有限公司', '李永堂', '15837827156', '20221107', '李小龙', '河南永堂无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16542, '全系列', '2022-11-07', '安徽坤强无纺布有限公司', '梁昌强', '15551660558', '20221107', '李小龙', '安徽坤强无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16543, '全系列', '2022-11-07', '嘉兴市新美达无纺布有限公司', '陈海华', '0573-83038226', '20221107', '李小龙', '嘉兴市新美达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16544, '全系列', '2022-11-07', '常熟市新力无纺设备有限公司', '周永良', '13801577196', '20221107', '李小龙', '常熟市新力无纺设备有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16545, '全系列', '2022-11-07', '常熟市苏扬无纺制品有限公司', '蒋静雯', '13814900728', '20221107', '李小龙', '常熟市苏扬无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16546, '全系列', '2022-11-07', '无锡市鸿庆无纺布有限公司', '谈正杰', '13961547721', '20221107', '李小龙', '无锡市鸿庆无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16547, '全系列', '2022-11-07', '常熟市飞创无纺制品有限公司', '王慧', '18896608550', '20221107', '李小龙', '常熟市飞创无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16548, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '440-943-4200', '20221107', '郑静', 'LUBRIZOL ADVANCED MATERIAL INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16549, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '276-632-0159', '20221107', '郑静', 'DRAKE EXTRUSION INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16550, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '336-751-5007', '20221107', '郑静', 'AVGOL AMERICA INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16551, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '212-536-1390-', '20221107', '郑静', 'CIT GROUP INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16552, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13814827153', '20221107', '郑静', '昆山优致洁无纺布材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16553, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '021-57358082', '20221107', '郑静', '上海盈兹无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16554, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13901766668', '20221107', '郑静', '江苏申达无纺新材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16555, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '0577-86729088', '20221107', '郑静', '温州市仟亿无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16556, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '0564-3616553', '20221107', '郑静', '安徽尚德无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16557, '无纺', '2022-11-07', '白色纯涤纶针刺无纺布', '深入沟通中', '13584825591', '20221107', '郑静', '富福昊无纺布（苏州）股份有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16558, '会员入驻', '2022-11-07', '无纺会员', '谭志刚', '13179627878', '20221107', '郁新涛', '常熟市全申化纤有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16559, '会员入驻', '2022-11-07', '无纺会员', '肖春艳', '17368787586', '20221107', '郁新涛', '无锡盈尔纺织品有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16560, '会员入驻', '2022-11-07', '无纺会员', '邹蒙亮', '15382392869', '20221107', '郁新涛', '浙江绿芳洲无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16561, '广告', '2022-11-07', '制品广告', '范福根', '13306237341', '20221107', '郁新涛', '常熟市新盛无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16562, '机械工厂', '2022-11-07', '智能工厂', '王亮', '13588169365', '20221107', '郁新涛', '杭州兴农纺织有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16563, '机械工厂', '2022-11-07', '智能工厂', '余俊', '13511722088', '20221107', '郁新涛', '扬州恒信无纺制品有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16564, '会员入驻', '2022-11-08', '无纺会员', '任贵虎', '13606168965', '20221108', '郁新涛', '江阴市江海非织造布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16565, '会员入驻', '2022-11-08', '无纺会员', '朱文斌', '15824305806', '20221108', '郁新涛', '绍兴纤蓝纺织科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16566, '会员入驻', '2022-11-08', '无纺会员', '周伟军', '13819545875', '20221108', '郁新涛', '浙江赛弘纺织科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16567, '广告', '2022-11-08', '制品广告', '张东胜', '15252538446', '20221108', '郁新涛', '扬州鼎诺无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16568, '机械工厂', '2022-11-08', '智能工厂', '朱立刚', '15988176288', '20221108', '郁新涛', '杭州萧山航民非织造布有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16569, '机械工厂', '2022-11-08', '智能工厂', '杨永兴', '18161339201', '20221108', '郁新涛', '浙江弘扬无纺新材料有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16570, '全系列', '2022-11-08', '江阴市中兴无纺布有限公司', '顾晓萍', '18915227718', '20221108', '李小龙', '江阴市中兴无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16571, '全系列', '2022-11-08', '海宁华诚达无纺布有限公司', '徐玲逸', '13506734210', '20221108', '李小龙', '海宁华诚达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16572, '全系列', '2022-11-08', '金华美能无纺布有限公司', '王如坚', '13605820202', '20221108', '李小龙', '金华美能无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16573, '全系列', '2022-11-08', '扬州恒源无纺制品有限公司', '周建设', '13196485736', '20221108', '李小龙', '扬州恒源无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16574, '全系列', '2022-11-08', '莱芜三元无纺制品有限公司', '刘延河', '15863402220', '20221108', '李小龙', '莱芜三元无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16575, '全系列', '2022-11-08', '浙江永佳无纺织品有限公司', '徐剑林', '0576-85960076', '20221108', '李小龙', '浙江永佳无纺织品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16576, '全系列', '2022-11-08', '温州艳鹏无纺布技术有限公司', '高艳鹏', '13566215056', '20221108', '李小龙', '温州艳鹏无纺布技术有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16577, '全系列', '2022-11-08', '浦江鑫泰无纺布有限公司', '柳金财', '15355341286', '20221108', '李小龙', '浦江鑫泰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16578, '全系列', '2022-11-08', '江阴金港无纺布有限公司', '吴原铖', '13013613695', '20221108', '李小龙', '江阴金港无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16579, '全系列', '2022-11-08', '无锡市正龙无纺布有限公司', '邓志杰', '0510-83235678', '20221108', '李小龙', '无锡市正龙无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16580, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '614-986-2495', '20221108', '郑静', 'MOMENTIVE PERFORMANCE MATERIALS INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16581, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '562-869-1918', '20221108', '郑静', 'RALPH LAUREN SHOP', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16582, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '201-316-9200', '20221108', '郑静', 'LONZA GROUP LTD', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16583, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '910-509-4400', '20221108', '郑静', 'CHEMTEX INTERNATIONAL INC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16584, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13806271811', '20221108', '郑静', '如东丽景无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16585, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '18505569490', '20221108', '郑静', '安徽亿帆无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16586, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13776461670', '20221108', '郑静', '江苏伟利达无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16587, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13511250228', '20221108', '郑静', '浙江贵祥无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16588, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '13338021088', '20221108', '郑静', '苏州市森鸿无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16589, '无纺', '2022-11-08', '白色纯涤纶针刺无纺布', '深入沟通中', '17712891988', '20221108', '郑静', '智程无纺布（江苏）有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16590, '无纺布制品', '2022-11-08', '湿巾', '宋勇', '13692028163', '20221108', '顾怡青', '上海碧丽化妆品有限公司汕头分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16591, '无纺布制品', '2022-11-08', '湿巾', '邓景衡', '0757-86238822', '20221108', '顾怡青', '广东景兴健康护理实业股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16592, '无纺布制品', '2022-11-08', '湿巾', '张健', '0750-6168691', '20221108', '顾怡青', '维达纸业（中国）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16593, '无纺布制品', '2022-11-08', '湿巾', '张健', '0750-6168573', '20221108', '顾怡青', '维达商贸有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16594, '无纺布制品', '2022-11-08', '湿巾', '林戊填', '0769-82856209', '20221108', '顾怡青', '东莞市星灏日用制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16595, '无纺布制品', '2022-11-08', '湿巾', '宋银波', '010-58220818-608', '20221108', '顾怡青', '维达商贸有限公司北京分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16596, '无纺布制品', '2022-11-08', '湿巾', '杜运建', '18901051165', '20221108', '顾怡青', '西藏坎巴嘎布卫生用品有限公司北京分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16597, '无纺布制品', '2022-11-08', '湿巾', '刘俊', '025-84462216', '20221108', '顾怡青', '维达商贸有限公司南京分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16598, '无纺布制品', '2022-11-08', '湿巾', '许春艳', '025-52153308', '20221108', '顾怡青', '南京麦思德餐饮管理有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16599, '无纺布制品', '2022-11-08', '湿巾', '周剑峰', '0519-89185959', '20221108', '顾怡青', '贝亲母婴用品（常州）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16600, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '202-624-2895', '20221109', '郑静', 'International Paper Company', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16601, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '801-584-5700', '20221109', '郑静', 'Huntsman Corporation', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16602, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '781-622-1000', '20221109', '郑静', 'Thermo Fisher Scientific Inc.', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16603, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '336-332-3400', '20221109', '郑静', 'Vf Jeanswear Limited Partnership', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16604, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '13355881226', '20221109', '郑静', '浙江鑫恒无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16605, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '0571-86878136', '20221109', '郑静', '杭州欧德无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16606, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '19941574446', '20221109', '郑静', '阜宁宏风无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16607, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '13676566161', '20221109', '郑静', '浙江长盈无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16608, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', ' 0512-52558998', '20221109', '郑静', '苏州柯鑫无纺制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16609, '无纺', '2022-11-09', '白色纯涤纶针刺无纺布', '深入沟通中', '0512-57498058', '20221109', '郑静', '昆山洁之宏无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16610, '无纺布制品', '2022-11-09', '湿巾', '吴洁誉', '0512-68582880', '20221109', '顾怡青', '苏州市顺浩塑业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16611, '无纺布制品', '2022-11-09', '湿巾', '邓开传', '13601540156', '20221109', '顾怡青', '苏州祯洁卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16612, '无纺布制品', '2022-11-09', '湿巾', '胡义刚', '13283974158', '20221109', '顾怡青', '吴江市盛泽镇欣达酒店用品行', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16613, '无纺布制品', '2022-11-09', '湿巾', '虞胜椿', '0512-36802011', '20221109', '顾怡青', '江苏盛纺纳米材料科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16614, '无纺布制品', '2022-11-09', '湿巾', '袁洪飞', '0513-69933003', '20221109', '顾怡青', '海门江海建设投资有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16615, '无纺布制品', '2022-11-09', '湿巾', '郑宏春', '15861975858', '20221109', '顾怡青', '盐城天盛卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16616, '无纺布制品', '2022-11-09', '湿巾', '朱冲', '13407553202', '20221109', '顾怡青', '泗洪县天平卫生纸制品厂', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16617, '无纺布制品', '2022-11-09', '湿巾', '姜松勇', '021-65119881', '20221109', '顾怡青', '米界（上海）实业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16618, '无纺布制品', '2022-11-09', '湿巾', '郭菊芳', '0571-81007889', '20221109', '顾怡青', '浙江瑞邦日化有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16619, '无纺布制品', '2022-11-09', '湿巾', '董炳忠', '0571-89182331', '20221109', '顾怡青', '杭州诚燕纺织有限公司第一分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16620, '会员入驻', '2022-11-09', '无纺会员', '李春福', '13962208767', '20221109', '郁新涛', '张家港市润扬无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16621, '会员入驻', '2022-11-09', '无纺会员', '殷丽江', '13812803222', '20221109', '郁新涛', '常熟市百利德不织布有限公司 ', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16622, '会员入驻', '2022-11-09', '无纺会员', '张林华', '18115368596', '20221109', '郁新涛', ' 江阴市嘉华俊纺织有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16623, '广告', '2022-11-09', '制品广告', '张国健', '15868317773', '20221109', '郁新涛', '嘉兴金旭医用科技有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16624, '机械工厂', '2022-11-09', '智能工厂', '殷丽江', '13812803222', '20221109', '郁新涛', '常熟市百利德不织布有限公司 ', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16625, '机械工厂', '2022-11-09', '智能工厂', '张林华', '18115368596', '20221109', '郁新涛', ' 江阴市嘉华俊纺织有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16626, '全系列', '2022-11-09', '安徽鸿祥无纺布包装有限公司', '徐尚吉', '15855673818', '20221109', '李小龙', '安徽鸿祥无纺布包装有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16627, '全系列', '2022-11-09', '杭州临安中正无纺制品有限公司', '王政', '13750863850', '20221109', '李小龙', '杭州临安中正无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16628, '全系列', '2022-11-09', '淮安荣达无纺布制品有限公司', '何继文', '17312802849', '20221109', '李小龙', '淮安荣达无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16629, '全系列', '2022-11-09', '郑州锦澳无纺布有限公司', '杨伟来', '15238396655', '20221109', '李小龙', '郑州锦澳无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16630, '全系列', '2022-11-09', '安新县胜创达无纺织物制造有限公司', '刘海星', '15027826555', '20221109', '李小龙', '安新县胜创达无纺织物制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16631, '全系列', '2022-11-09', '四川力王无纺制品科技有限公司', '陈勇', '15883801499', '20221109', '李小龙', '四川力王无纺制品科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16632, '全系列', '2022-11-09', '扬州市洁王无纺布有限公司', '姚金安', '13305279442', '20221109', '李小龙', '扬州市洁王无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16633, '全系列', '2022-11-09', '宜兴市鑫隆无纺材料有限公司', '贾迎军', '13584221288', '20221109', '李小龙', '宜兴市鑫隆无纺材料有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16634, '全系列', '2022-11-09', '江阴市光大无纺布业有限公司', '承惠兴', '13901524253', '20221109', '李小龙', '江阴市光大无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16635, '全系列', '2022-11-09', '常熟市立新无纺布织造有限公司', '周祥元', '15962286133', '20221109', '李小龙', '常熟市立新无纺布织造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16636, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '919-678-2323-', '20221110', '郑静', 'Cotton Incorporated', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16637, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '713-934-7429', '20221110', '郑静', 'Spectra Contract Flooring', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16638, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '212-536-1930', '20221110', '郑静', 'Cit Group Credit Finance Inc', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16639, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '845-365-9500', '20221110', '郑静', 'Daikin America Inc', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16640, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '15921096856', '20221110', '郑静', '镇江龙斌无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16641, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '18755012551', '20221110', '郑静', '安徽金恒昌无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16642, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '15052770999', '20221110', '郑静', '江苏鑫美达无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16643, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '13788919648', '20221110', '郑静', '上海际飞无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16644, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '18120936550', '20221110', '郑静', '浙江众一无纺布科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16645, '无纺', '2022-11-10', '白色纯涤纶针刺无纺布', '深入沟通中', '0579-87400988', '20221110', '郑静', '浙江格润卫普无纺材料有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16646, '全系列', '2022-11-10', '浙江宏源无纺布有限公司', '朱秀仁', '13575387991', '20221110', '李小龙', '浙江宏源无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16647, '全系列', '2022-11-10', '浙江尚品无纺布有限公司', '陈宝良', '13606897765', '20221110', '李小龙', '浙江尚品无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16648, '全系列', '2022-11-10', '浙江天润无纺布有限公司', '傅真亚', '15924210099', '20221110', '李小龙', '浙江天润无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16649, '全系列', '2022-11-10', '浙江伟恒无纺布有限公司', '倪志荣', '15967769911', '20221110', '李小龙', '浙江伟恒无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16650, '全系列', '2022-11-10', '江阴市广效无纺布业有限公司', '龚建明', '13812100759', '20221110', '李小龙', '江阴市广效无纺布业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16651, '全系列', '2022-11-10', '福建省创美无纺布制品有限公司', '丁棋', '13959793782', '20221110', '李小龙', '福建省创美无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16652, '全系列', '2022-11-10', '杭州余杭欣美无纺布制品有限公司', '李建立', '13968088345', '20221110', '李小龙', '杭州余杭欣美无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16653, '全系列', '2022-11-10', '合肥睿森无纺布制品有限公司', '张丽', '18655184014', '20221110', '李小龙', '合肥睿森无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16654, '全系列', '2022-11-10', '江阴河海无纺布制品有限公司', '孔慕蓉', '13921256952', '20221110', '李小龙', '江阴河海无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16655, '全系列', '2022-11-10', '南通瑞柏无纺科技有限公司', '楼金善', '15106282888', '20221110', '李小龙', '南通瑞柏无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16656, '会员入驻', '2022-11-10', '无纺会员', '刘平', '13326152073', '20221110', '郁新涛', '长兴润兴无纺布厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16657, '会员入驻', '2022-11-10', '无纺会员', '刘爱民', '13705827708', '20221110', '郁新涛', '长兴广仁无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16658, '会员入驻', '2022-11-10', '无纺会员', '陈智超', '15961618569', '20221110', '郁新涛', '温州超诚无纺科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16659, '广告', '2022-11-10', '制品广告', '刘永辉', '18630252988', '20221110', '郁新涛', '雄县家进无纺布制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16660, '机械工厂', '2022-11-10', '智能工厂', '方炳惠', '15052770099', '20221110', '郁新涛', '义乌市恒达织带有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16661, '机械工厂', '2022-11-10', '智能工厂', '范娟', '17751550007', '20221110', '郁新涛', '江苏大欣织带有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16662, '无纺布制品', '2022-11-10', '湿巾', '宣洪富', '0571-88656965', '20221110', '顾怡青', '杭州富格医疗器械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16663, '无纺布制品', '2022-11-10', '湿巾', '朱灵峰', '0574-27901818', '20221110', '顾怡青', '宁波赛柯国际贸易有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16664, '无纺布制品', '2022-11-10', '湿巾', '朱云锋', '13758484883', '20221110', '顾怡青', '温州海航机械有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16665, '无纺布制品', '2022-11-10', '湿巾', '张家勇', '13666756272', '20221110', '顾怡青', '桐乡市铭嘉纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16666, '无纺布制品', '2022-11-10', '湿巾', '卢旺', '0575-85587025', '20221110', '顾怡青', '浙江三禾纳米科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16667, '无纺布制品', '2022-11-10', '湿巾', '陈玲玉', '13600599573', '20221110', '顾怡青', '浙江宝加生物科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16668, '无纺布制品', '2022-11-10', '湿巾', '吴先华', '13867233071', '20221110', '顾怡青', '舟山市定海春雨酒店卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16669, '无纺布制品', '2022-11-10', '湿巾', '陈元', '028-86762942-801', '20221110', '顾怡青', '维达商贸有限公司成都分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16670, '无纺布制品', '2022-11-10', '湿巾', '史成玉', '0531-83328202', '20221110', '顾怡青', '山东省润荷卫生材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16671, '无纺布制品', '2022-11-10', '湿巾', '刘俊', '0531-86077306', '20221110', '顾怡青', '维达商贸有限公司济南分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16672, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '832-532-7674', '20221111', '郑静', 'MEDLINE INDUSTRIES HOLDINGS. L.P', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16673, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '562-869-1918', '20221111', '郑静', 'RALPH LAUREN SHOP', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16674, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '530-365-3311', '20221111', '郑静', 'VOOORWOOD CO', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16675, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '614-225-4000', '20221111', '郑静', 'HEXION LIC', '外贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16676, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '0577-67650083', '20221111', '郑静', '温州超诚无纺科技有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16677, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13218104729', '20221111', '郑静', '苏州艾兴无纺布制品有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16678, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '0576-88529118', '20221111', '郑静', '浙江优科无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16679, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '0577-86558837', '20221111', '郑静', '温州缦纱无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16680, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13331247666', '20221111', '郑静', '安新县鹏达无纺织物有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16681, '无纺', '2022-11-11', '白色纯涤纶针刺无纺布', '深入沟通中', '13365791783', '20221111', '郑静', '安徽省锦盛无纺布有限公司', '内贸', '0', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16682, '无纺布制品', '2022-11-11', '湿巾', '刘方毅', '0533-6298788', '20221111', '顾怡青', '英科医疗科技股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16683, '无纺布制品', '2022-11-11', '湿巾', '张杰', '0631-6600672', '20221111', '顾怡青', '乳山市永康药店', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16684, '无纺布制品', '2022-11-11', '湿巾', '葛静思', '13932208168', '20221111', '顾怡青', '保定市碧柔卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16685, '无纺布制品', '2022-11-11', '湿巾', '张胜利', '13831263786', '20221111', '顾怡青', '保定市金叶纸制品厂（普通合伙）', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16686, '无纺布制品', '2022-11-11', '湿巾', '苟福国', '13111600188', '20221111', '顾怡青', '保定市富国纸业有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16687, '无纺布制品', '2022-11-11', '湿巾', '崔雷明', '13290689999', '20221111', '顾怡青', '保定市和晟卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16688, '无纺布制品', '2022-11-11', '湿巾', '邝金瑞', '0371-85961552', '20221111', '顾怡青', '郑州吉尔康消毒制品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16689, '无纺布制品', '2022-11-11', '湿巾', '马海', '0373-6668169', '20221111', '顾怡青', '新乡市先丰医药新材料有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16690, '无纺布制品', '2022-11-11', '湿巾', '钟春红', '13939305941', '20221111', '顾怡青', '范县新区春红夫妻用品店', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16691, '无纺布制品', '2022-11-11', '湿巾', '江仰班', '0592-6155333', '20221111', '顾怡青', '厦门悠度休闲用品股份有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16692, '会员入驻', '2022-11-11', '无纺会员', '严华荣', '18676881638', '', '郁新涛', '浙江金三发无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16693, '会员入驻', '2022-11-11', '无纺会员', '何苏义', '15201484736', '', '郁新涛', '恒天嘉华非织造有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16694, '会员入驻', '2022-11-11', '无纺会员', '黄列旗', '15988809668', '', '郁新涛', '开平启帆织造有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16695, '广告', '2022-11-11', '制品广告', '何金清', '13961662602', '', '郁新涛', '江苏金秋弹性织物有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16696, '机械工厂', '2022-11-11', '智能工厂', '杨永兴', '13665110281', '', '郁新涛', '浙江弘扬无纺新材料有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16697, '机械工厂', '2022-11-11', '智能工厂', '范福根', '13757830666', '', '郁新涛', '杭州顺龙无纺科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16698, '全系列', '2022-11-11', '郑州市聚丰无纺布有限公司', '冯建敏', '13938292127', '20221111', '李小龙', '郑州市聚丰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16699, '全系列', '2022-11-11', '安徽久久无纺制品有限公司', '曹宗玖', '13505642857', '20221111', '李小龙', '安徽久久无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16700, '全系列', '2022-11-11', '长沙斯威尼无纺布有限公司', '晏仲文', '18952735111', '20221111', '李小龙', '长沙斯威尼无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16701, '全系列', '2022-11-11', '温州锦祥无纺科技有限公司', '陈正佑', '18958805878', '20221111', '李小龙', '温州锦祥无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16702, '全系列', '2022-11-11', '青岛华翱无纺科技有限公司', '丁雪华', '13793277150', '20221111', '李小龙', '青岛华翱无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16703, '全系列', '2022-11-11', '三门峡华胜无纺布制品有限公司', '何丽琴', '15239815001', '20221111', '李小龙', '三门峡华胜无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16704, '全系列', '2022-11-11', '泉州晶牌无纺布包装袋有限公司', '钟奕峰', '13559590456', '20221111', '李小龙', '泉州晶牌无纺布包装袋有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16705, '全系列', '2022-11-11', '湖北鑫之源无纺制品有限公司', '郑军', '18971601678', '20221111', '李小龙', '湖北鑫之源无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16706, '全系列', '2022-11-11', '江西通城无纺制造有限公司', '戴世登', '17370505755', '20221111', '李小龙', '江西通城无纺制造有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16707, '全系列', '2022-11-11', '芜湖市融亿达无纺布有限公司', '熊泽金', '13696757671', '20221111', '李小龙', '芜湖市融亿达无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16708, '全系列', '2022-11-14', '杭州富阳康美无纺制品有限公司', '袁明祥', '13806519819', '20221114', '李小龙', '杭州富阳康美无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16709, '全系列', '2022-11-14', '温州福平无纺布制品有限公司', '梁平', '15657753699', '20221114', '李小龙', '温州福平无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16710, '全系列', '2022-11-14', '安徽铭鼎无纺科技有限公司 ', '吴万尧', '18655826866', '20221114', '李小龙', '安徽铭鼎无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16711, '全系列', '2022-11-14', '徐州春润无纺布有限公司', '张琦', '18036376889', '20221114', '李小龙', '徐州春润无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16712, '全系列', '2022-11-14', '常州菲纺无纺布有限公司', '夏梦', '18261153654', '20221114', '李小龙', '常州菲纺无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16713, '全系列', '2022-11-14', '苏州尤尼佳无纺布制品有限公司', '王妍珏', '17625604999', '20221114', '李小龙', '苏州尤尼佳无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16714, '全系列', '2022-11-14', '金华市康元无纺布有限责任公司', '章诚', '13566747799', '20221114', '李小龙', '金华市康元无纺布有限责任公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16715, '全系列', '2022-11-14', '泉州市信盈无纺布有限公司', '丁秀群', '18859550617', '20221114', '李小龙', '泉州市信盈无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16716, '全系列', '2022-11-14', '安徽天可无纺布有限公司', '徐海霞', '18355675392', '20221114', '李小龙', '安徽天可无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16717, '全系列', '2022-11-14', '常熟箐予无纺科技有限公司', '王保宏', '13776236337', '20221114', '李小龙', '常熟箐予无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16718, '无纺布制品', '2022-11-14', '湿巾', '苏延年', '18050809127', '20221114', '顾怡青', '泉州市丰泽金汉妇幼卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16719, '无纺布制品', '2022-11-14', '湿巾', '施振麟', '13805954738', '20221114', '顾怡青', '晋江市创煌服饰织造有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16720, '无纺布制品', '2022-11-14', '湿巾', '邱宗阳', '13905954900', '20221114', '顾怡青', '泉州市大自然卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16721, '无纺布制品', '2022-11-14', '湿巾', '傅少飞', '0595-22461618', '20221114', '顾怡青', '泉州创达进出口有限责任公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16722, '无纺布制品', '2022-11-14', '湿巾', '黄向荣', '13506091592', '20221114', '顾怡青', '泉州市三巨网络科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16723, '无纺布制品', '2022-11-14', '湿巾', '朱梦龙', '027-83336219', '20221114', '顾怡青', '维达商贸有限公司武汉分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16724, '无纺布制品', '2022-11-14', '湿巾', '汪虎臣', '027-83258266', '20221114', '顾怡青', '武汉茶花女卫生用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16725, '无纺布制品', '2022-11-14', '湿巾', '段卫国', '17730145195', '20221114', '顾怡青', '安徽金环宾馆酒店配套用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16726, '无纺布制品', '2022-11-14', '湿巾', '汪建国', '13605548149', '20221114', '顾怡青', '淮南市雅芙卫生用品厂', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16727, '无纺布制品', '2022-11-14', '湿巾', '焦勇', '15256829888', '20221114', '顾怡青', '安徽舒源妇幼用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16728, '广告', '2022-11-14', '制品广告', '顾林虎', '13656196298', '', '郁新涛', '江阴市海月无纺布业有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16729, '机械工厂', '2022-11-14', '智能工厂', '王怀孝', '13815495505', '', '郁新涛', '江苏怀静无纺布包装袋有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16730, '机械工厂', '2022-11-14', '智能工厂', '王永祥', '13862365888', '', '郁新涛', '常熟金和无纺机械科技有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16731, '会员入驻', '2022-11-14', '无纺会员', '顾晓萍', '13912380011', '', '郁新涛', '江阴市中兴无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16732, '会员入驻', '2022-11-14', '无纺会员', 'Sally', '13957712400', '', '郁新涛', '温州新宇无纺布有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16733, '会员入驻', '2022-11-14', '无纺会员', '林大再', '18221753230', '', '郁新涛', '上海奔泰无纺布加工厂', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16734, '无纺布制品', '2022-11-15', '湿巾', '王爱珍', '0566-2241286', '20221115', '顾怡青', '池州市丽华环保科技有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16735, '无纺布制品', '2022-11-15', '湿巾', '方丽霞', '0563-8602771', '20221115', '顾怡青', '旌德县万方日用品有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16736, '无纺布制品', '2022-11-15', '湿巾', '林庆华', '023-85111883', '20221115', '顾怡青', '维尔美纸业（重庆）有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16737, '无纺布制品', '2022-11-15', '湿巾', '陆毅', '029-87628313', '20221115', '顾怡青', '维达商贸有限公司西安分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16738, '无纺布制品', '2022-11-15', '湿巾', '郭凌云', '0730-8271516', '20221115', '顾怡青', '岳阳新华达制药有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16739, '无纺布制品', '2022-11-15', '湿巾', '赵俊杰', '024-25933799', '20221115', '顾怡青', '沈阳鑫博航贸易有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16740, '无纺布制品', '2022-11-15', '湿巾', '曹希璐', '0415-6150486', '20221115', '顾怡青', '丹东瑞嘉发展有限公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16741, '无纺布制品', '2022-11-15', '湿巾', '岳立斌', '13840711658', '20221115', '顾怡青', '盖州市昌盛酒店餐饮用品分装店', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16742, '无纺布制品', '2022-11-15', '湿巾', '郭纯宇', '13464854600', '20221115', '顾怡青', '阜新市细河区鑫宇生活用品商行', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16743, '无纺布制品', '2022-11-15', '湿巾', '宋银波', '022-81403652', '20221115', '顾怡青', '维达商贸有限公司天津分公司', '内贸', '5', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16744, '会员入驻', '2022-11-15', '无纺会员', '王志宏', '13851325158', '王志宏', '郁新涛', '盐城市皓瑞水刺无纺布有限公司 ', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16745, '会员入驻', '2022-11-15', '无纺会员', '黄中利', '13484309500', '黄中利', '郁新涛', '绍兴卡林无纺布科技有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16746, '会员入驻', '2022-11-15', '无纺会员', '朱昭元', '13955740969', '朱昭元', '郁新涛', '宝聚无纺布科技（宿州）有限公司', '服务', '0.37万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16747, '广告', '2022-11-15', '制品广告', '方惠中', '13626760508', '方惠中', '郁新涛', '嘉善永联无纺制品有限公司', '服务', '0.6万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16748, '机械工厂', '2022-11-15', '智能工厂', '相恒宇', '13605128909', '相恒宇', '郁新涛', '连云港恒宇无纺机械有限公司', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16749, '机械工厂', '2022-11-15', '智能工厂', '吴培珍', '15559136788', '吴培珍', '郁新涛', '福建省泉州市晋江市灵源街道大布林社区灵智路223号A区', '内贸', '300万元', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16750, '全系列', '2022-11-15', '青州市祥泰无纺布有限公司', '张金学', '13791657113', '20221115', '李小龙', '青州市祥泰无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16751, '全系列', '2022-11-15', '石家庄兴怡无纺布有限公司', '李倩男', '18803214545', '20221115', '李小龙', '石家庄兴怡无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16752, '全系列', '2022-11-15', '河北景昌无纺布有限公司', '郭建军', '15200040081', '20221115', '李小龙', '河北景昌无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16753, '全系列', '2022-11-15', '河南诺必行无纺布制品有限公司', '沈留辉', '13673876199', '20221115', '李小龙', '河南诺必行无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16754, '全系列', '2022-11-15', '安徽东德无纺工业有限公司', '王伟', '13758291891', '20221115', '李小龙', '安徽东德无纺工业有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16755, '全系列', '2022-11-15', '苏州厚道无纺机械有限公司', '王勇超', '15506231883', '20221115', '李小龙', '苏州厚道无纺机械有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16756, '全系列', '2022-11-15', '常熟奥特博思无纺科技有限公司', '王应蕊', '15062495681', '20221115', '李小龙', '常熟奥特博思无纺科技有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16757, '全系列', '2022-11-15', '杭州耀恒无纺制品有限公司', '孙国东', '15888808686', '20221115', '李小龙', '杭州耀恒无纺制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16758, '全系列', '2022-11-15', '山东品派无纺布制品有限公司', '孙凌云', '13361520666', '20221115', '李小龙', '山东品派无纺布制品有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');
INSERT INTO `fnc_ledger` VALUES (16759, '全系列', '2022-11-15', '泉州瑞尔无纺布有限公司', '陈燕瑞', '13905058650', '20221115', '李小龙', '泉州瑞尔无纺布有限公司', '内贸', '0万', 'admin', '2022-11-16 22:14:51', 'admin', '2022-11-16 22:14:51');

-- ----------------------------
-- Table structure for fnc_subject_type
-- ----------------------------
DROP TABLE IF EXISTS `fnc_subject_type`;
CREATE TABLE `fnc_subject_type`  (
  `subject_type_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '科目类别id',
  `parent_id` bigint(20) NULL DEFAULT 0 COMMENT '上级id',
  `subject_type_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科目类别名称',
  `order_num` int(4) NULL DEFAULT NULL COMMENT '显示顺序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `delete_status` int(4) NULL DEFAULT NULL COMMENT '是否删除',
  PRIMARY KEY (`subject_type_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '科目类别' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of fnc_subject_type
-- ----------------------------
INSERT INTO `fnc_subject_type` VALUES (1, 0, '3', 3, 'admin', '2022-11-17 14:06:27', 'admin', '2022-11-17 14:06:27', 2);
INSERT INTO `fnc_subject_type` VALUES (2, 0, '1-1', 1, 'admin', '2022-11-17 16:49:38', 'admin', '2022-11-17 16:49:38', 2);
INSERT INTO `fnc_subject_type` VALUES (3, 0, '3', 3, 'admin', '2022-11-17 17:00:41', 'admin', '2022-11-17 17:00:41', NULL);
INSERT INTO `fnc_subject_type` VALUES (4, 0, '资产', 2, 'admin', '2022-11-17 17:12:03', 'admin', '2022-11-18 08:50:44', 1);
INSERT INTO `fnc_subject_type` VALUES (5, 0, '负债', 2, 'admin', '2022-11-18 08:50:52', 'admin', '2022-11-18 08:50:52', 1);
INSERT INTO `fnc_subject_type` VALUES (6, 4, '流动资产', NULL, 'admin', '2022-11-18 08:51:06', 'admin', '2022-11-18 08:51:06', 1);
INSERT INTO `fnc_subject_type` VALUES (7, 4, '非流动资产', NULL, 'admin', '2022-11-18 08:51:17', 'admin', '2022-11-18 08:51:17', 1);
INSERT INTO `fnc_subject_type` VALUES (8, 5, '流动负债', NULL, 'admin', '2022-11-18 08:51:28', 'admin', '2022-11-18 08:51:28', 1);

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES (18, 'fnc_company', '记账公司表', NULL, NULL, 'FncCompany', 'crud', 'com.ruoyi.system', 'system', 'company', '记账公司', 'ruoyi', '0', '/', NULL, 'admin', '2022-11-16 11:35:57', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (19, 'fnc_ledger', '项目台账', NULL, NULL, 'FncLedger', 'crud', 'com.ruoyi.finance', 'finance', 'ledger', '项目台账', 'ruoyi', '0', '/', '{}', 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:41:51', NULL);
INSERT INTO `gen_table` VALUES (20, 'fnc_subject_type', '科目类别', NULL, NULL, 'FncSubjectType', 'crud', 'com.ruoyi.system', 'system', 'subjectType', '科目类别', 'jlf', '0', '/', '{}', 'admin', '2022-11-17 10:37:45', '', '2022-11-17 10:39:33', NULL);

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 211 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES (174, '18', 'company_id', '记账公司id', 'bigint(20)', 'Long', 'companyId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (175, '18', 'company_name', '记账公司名称', 'varchar(50)', 'String', 'companyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (176, '18', 'license_no', '营业执照号', 'varchar(50)', 'String', 'licenseNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (177, '18', 'company_address', '公司地址', 'varchar(100)', 'String', 'companyAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (178, '18', 'contact_information', '联系方式', 'varchar(50)', 'String', 'contactInformation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (179, '18', 'bank_deposit', '开户行', 'varchar(100)', 'String', 'bankDeposit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (180, '18', 'bank_account_name', '银行账户名称', 'varchar(100)', 'String', 'bankAccountName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (181, '18', 'bank_account', '银行账户', 'varchar(100)', 'String', 'bankAccount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (182, '18', 'create_by', '创建人', 'varchar(255)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (183, '18', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (184, '18', 'update_by', '更新人', 'varchar(255)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (185, '18', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2022-11-16 11:35:57', '', '2022-11-17 10:59:46');
INSERT INTO `gen_table_column` VALUES (186, '19', 'ledger_id', '项目台账id', 'bigint(50)', 'Long', 'ledgerId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (187, '19', 'project_type', '分类', 'varchar(20)', 'String', 'projectType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (188, '19', 'date', '日期', 'date', 'Date', 'date', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 3, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (189, '19', 'project_name', '项目中/英文名称', 'varchar(40)', 'String', 'projectName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (190, '19', 'charge', '项目负责人', 'varchar(20)', 'String', 'charge', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (191, '19', 'charge_phone', '负责人电话', 'varchar(20)', 'String', 'chargePhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (192, '19', 'inquiry_no', '询单编号', 'varchar(30)', 'String', 'inquiryNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (193, '19', 'customer_manager', '客户经理', 'varchar(20)', 'String', 'customerManager', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (194, '19', 'customer_company', '客户单位', 'varchar(50)', 'String', 'customerCompany', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (195, '19', 'business_type', '业务性质', 'varchar(10)', 'String', 'businessType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 10, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (196, '19', 'sale_evaluation', '销售额评估', 'varchar(60)', 'String', 'saleEvaluation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (198, '19', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (199, '19', 'update_by', '更新人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (200, '19', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2022-11-16 14:39:19', '', '2022-11-16 14:59:43');
INSERT INTO `gen_table_column` VALUES (201, '19', 'create_by', '创建人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, '', '2022-11-16 14:59:43', '', NULL);
INSERT INTO `gen_table_column` VALUES (202, '20', 'subject_type_id', '科目类别id', 'bigint(20)', 'Long', 'subjectTypeId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (203, '20', 'parent_id', '上级id', 'bigint(20)', 'Long', 'parentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (204, '20', 'subject_type_name', '科目类别名称', 'varchar(50)', 'String', 'subjectTypeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (205, '20', 'order_num', '显示顺序', 'int(4)', 'Integer', 'orderNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (206, '20', 'create_by', '创建人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (207, '20', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (208, '20', 'update_by', '更新人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (209, '20', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2022-11-17 10:37:45', '', '2022-11-17 14:05:37');
INSERT INTO `gen_table_column` VALUES (210, '20', 'delete_status', '是否删除', 'int(4)', 'Integer', 'deleteStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, '', '2022-11-17 14:05:37', '', NULL);

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config`  (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 100 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '参数配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'admin', '2022-11-16 09:26:25', '', NULL, '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2022-11-16 09:26:25', '', NULL, '初始化密码 123456');
INSERT INTO `sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2022-11-16 09:26:25', '', NULL, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` VALUES (4, '账号自助-验证码开关', 'sys.account.captchaEnabled', 'true', 'Y', 'admin', '2022-11-16 09:26:25', '', NULL, '是否开启验证码功能（true开启，false关闭）');
INSERT INTO `sys_config` VALUES (5, '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'Y', 'admin', '2022-11-16 09:26:25', '', NULL, '是否开启注册用户功能（true开启，false关闭）');

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept`  (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) NULL DEFAULT 0 COMMENT '父部门id',
  `ancestors` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) NULL DEFAULT 0 COMMENT '显示顺序',
  `leader` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 201 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '部门表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES (100, 0, '0', '若依科技', 0, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (101, 100, '0,100', '深圳总公司', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (102, 100, '0,100', '长沙分公司', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (103, 101, '0,100,101', '研发部门', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (104, 101, '0,100,101', '市场部门', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (105, 101, '0,100,101', '测试部门', 3, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (106, 101, '0,100,101', '财务部门', 4, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (107, 101, '0,100,101', '运维部门', 5, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (108, 102, '0,100,102', '市场部门', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (109, 102, '0,100,102', '财务部门', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL);
INSERT INTO `sys_dept` VALUES (200, 103, '0,100,101,103', 'test', 3, 'test', NULL, NULL, '0', '0', 'admin', '2022-11-17 15:04:56', '', NULL);

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data`  (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) NULL DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 102 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '字典数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
INSERT INTO `sys_dict_data` VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '性别男');
INSERT INTO `sys_dict_data` VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '性别女');
INSERT INTO `sys_dict_data` VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '性别未知');
INSERT INTO `sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '显示菜单');
INSERT INTO `sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '隐藏菜单');
INSERT INTO `sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '默认分组');
INSERT INTO `sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '系统分组');
INSERT INTO `sys_dict_data` VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '系统默认是');
INSERT INTO `sys_dict_data` VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '系统默认否');
INSERT INTO `sys_dict_data` VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '通知');
INSERT INTO `sys_dict_data` VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '公告');
INSERT INTO `sys_dict_data` VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '关闭状态');
INSERT INTO `sys_dict_data` VALUES (18, 99, '其他', '0', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '其他操作');
INSERT INTO `sys_dict_data` VALUES (19, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '新增操作');
INSERT INTO `sys_dict_data` VALUES (20, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '修改操作');
INSERT INTO `sys_dict_data` VALUES (21, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '删除操作');
INSERT INTO `sys_dict_data` VALUES (22, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '授权操作');
INSERT INTO `sys_dict_data` VALUES (23, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '导出操作');
INSERT INTO `sys_dict_data` VALUES (24, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '导入操作');
INSERT INTO `sys_dict_data` VALUES (25, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '强退操作');
INSERT INTO `sys_dict_data` VALUES (26, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '生成操作');
INSERT INTO `sys_dict_data` VALUES (27, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '清空操作');
INSERT INTO `sys_dict_data` VALUES (28, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (29, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (100, 1, '全系列', 'AllSeries', 'fns_ledger_type', NULL, 'default', 'N', '0', 'admin', '2022-11-16 15:04:12', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (101, 1, '纤维', 'Fibre', 'fns_ledger_type', NULL, 'default', 'N', '0', 'admin', '2022-11-16 15:04:42', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type`  (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE INDEX `dict_type`(`dict_type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 101 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
INSERT INTO `sys_dict_type` VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '用户性别列表');
INSERT INTO `sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '菜单状态列表');
INSERT INTO `sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '系统开关列表');
INSERT INTO `sys_dict_type` VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '任务状态列表');
INSERT INTO `sys_dict_type` VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '任务分组列表');
INSERT INTO `sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '系统是否列表');
INSERT INTO `sys_dict_type` VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '通知类型列表');
INSERT INTO `sys_dict_type` VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '通知状态列表');
INSERT INTO `sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '操作类型列表');
INSERT INTO `sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '登录状态列表');
INSERT INTO `sys_dict_type` VALUES (100, '台账分类', 'fns_ledger_type', '0', 'admin', '2022-11-16 15:01:59', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job`  (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 100 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '定时任务调度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job
-- ----------------------------
INSERT INTO `sys_job` VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_job` VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_job` VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '1', '1', 'admin', '2022-11-16 09:26:25', '', NULL, '');

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log`  (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志信息',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '异常信息',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '定时任务调度日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor`  (
  `info_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作系统',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '提示消息',
  `login_time` datetime(0) NULL DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 134 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统访问记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------
INSERT INTO `sys_logininfor` VALUES (100, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 09:32:30');
INSERT INTO `sys_logininfor` VALUES (101, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-16 09:54:46');
INSERT INTO `sys_logininfor` VALUES (102, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 09:54:50');
INSERT INTO `sys_logininfor` VALUES (103, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-16 10:57:22');
INSERT INTO `sys_logininfor` VALUES (104, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 10:57:26');
INSERT INTO `sys_logininfor` VALUES (105, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-16 10:58:55');
INSERT INTO `sys_logininfor` VALUES (106, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 10:58:58');
INSERT INTO `sys_logininfor` VALUES (107, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '1', '验证码错误', '2022-11-16 13:02:47');
INSERT INTO `sys_logininfor` VALUES (108, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 13:02:52');
INSERT INTO `sys_logininfor` VALUES (109, 'ry', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 13:11:43');
INSERT INTO `sys_logininfor` VALUES (110, 'ry', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-16 13:29:56');
INSERT INTO `sys_logininfor` VALUES (111, 'ry', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 13:30:07');
INSERT INTO `sys_logininfor` VALUES (112, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 14:32:39');
INSERT INTO `sys_logininfor` VALUES (113, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 15:43:37');
INSERT INTO `sys_logininfor` VALUES (114, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 13:14:59');
INSERT INTO `sys_logininfor` VALUES (115, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-16 13:17:01');
INSERT INTO `sys_logininfor` VALUES (116, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-16 13:17:07');
INSERT INTO `sys_logininfor` VALUES (117, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 09:09:28');
INSERT INTO `sys_logininfor` VALUES (118, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 09:58:40');
INSERT INTO `sys_logininfor` VALUES (119, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '1', '验证码错误', '2022-11-17 11:52:07');
INSERT INTO `sys_logininfor` VALUES (120, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 11:52:10');
INSERT INTO `sys_logininfor` VALUES (121, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-17 11:57:52');
INSERT INTO `sys_logininfor` VALUES (122, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 11:59:07');
INSERT INTO `sys_logininfor` VALUES (123, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-17 12:00:30');
INSERT INTO `sys_logininfor` VALUES (124, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 12:00:34');
INSERT INTO `sys_logininfor` VALUES (125, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 13:55:52');
INSERT INTO `sys_logininfor` VALUES (126, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '1', '验证码错误', '2022-11-17 15:57:38');
INSERT INTO `sys_logininfor` VALUES (127, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '1', '验证码错误', '2022-11-17 15:57:43');
INSERT INTO `sys_logininfor` VALUES (128, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-17 15:57:48');
INSERT INTO `sys_logininfor` VALUES (129, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-18 08:48:02');
INSERT INTO `sys_logininfor` VALUES (130, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '退出成功', '2022-11-18 09:10:13');
INSERT INTO `sys_logininfor` VALUES (131, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-18 09:10:19');
INSERT INTO `sys_logininfor` VALUES (132, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-18 10:09:33');
INSERT INTO `sys_logininfor` VALUES (133, 'admin', '127.0.0.1', '内网IP', 'Chrome 10', 'Windows 10', '0', '登录成功', '2022-11-18 14:50:31');

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu`  (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(20) NULL DEFAULT 0 COMMENT '父菜单ID',
  `order_num` int(4) NULL DEFAULT 0 COMMENT '显示顺序',
  `path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组件路径',
  `query` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路由参数',
  `is_frame` int(1) NULL DEFAULT 1 COMMENT '是否为外链（0是 1否）',
  `is_cache` int(1) NULL DEFAULT 0 COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2022 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '菜单权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES (1, '系统管理', 0, 1, 'system', NULL, '', 1, 0, 'M', '0', '0', '', 'system', 'admin', '2022-11-16 09:26:25', '', NULL, '系统管理目录');
INSERT INTO `sys_menu` VALUES (2, '系统监控', 0, 2, 'monitor', NULL, '', 1, 0, 'M', '0', '0', '', 'monitor', 'admin', '2022-11-16 09:26:25', '', NULL, '系统监控目录');
INSERT INTO `sys_menu` VALUES (3, '系统工具', 0, 3, 'tool', NULL, '', 1, 0, 'M', '0', '0', '', 'tool', 'admin', '2022-11-16 09:26:25', '', NULL, '系统工具目录');
INSERT INTO `sys_menu` VALUES (100, '用户管理', 1, 1, 'user', 'system/user/index', '', 1, 0, 'C', '0', '0', 'system:user:list', 'user', 'admin', '2022-11-16 09:26:25', '', NULL, '用户管理菜单');
INSERT INTO `sys_menu` VALUES (101, '角色管理', 1, 2, 'role', 'system/role/index', '', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2022-11-16 09:26:25', '', NULL, '角色管理菜单');
INSERT INTO `sys_menu` VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', '', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'admin', '2022-11-16 09:26:25', '', NULL, '菜单管理菜单');
INSERT INTO `sys_menu` VALUES (103, '部门管理', 1, 4, 'dept', 'system/dept/index', '', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2022-11-16 09:26:25', '', NULL, '部门管理菜单');
INSERT INTO `sys_menu` VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', '', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'admin', '2022-11-16 09:26:25', '', NULL, '岗位管理菜单');
INSERT INTO `sys_menu` VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', '', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2022-11-16 09:26:25', '', NULL, '字典管理菜单');
INSERT INTO `sys_menu` VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', '', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2022-11-16 09:26:25', '', NULL, '参数设置菜单');
INSERT INTO `sys_menu` VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', '', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2022-11-16 09:26:25', '', NULL, '通知公告菜单');
INSERT INTO `sys_menu` VALUES (108, '日志管理', 1, 9, 'log', '', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2022-11-16 09:26:25', '', NULL, '日志管理菜单');
INSERT INTO `sys_menu` VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', '', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2022-11-16 09:26:25', '', NULL, '在线用户菜单');
INSERT INTO `sys_menu` VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', '', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2022-11-16 09:26:25', '', NULL, '定时任务菜单');
INSERT INTO `sys_menu` VALUES (111, '数据监控', 2, 3, 'druid', 'monitor/druid/index', '', 1, 0, 'C', '0', '0', 'monitor:druid:list', 'druid', 'admin', '2022-11-16 09:26:25', '', NULL, '数据监控菜单');
INSERT INTO `sys_menu` VALUES (112, '服务监控', 2, 4, 'server', 'monitor/server/index', '', 1, 0, 'C', '0', '0', 'monitor:server:list', 'server', 'admin', '2022-11-16 09:26:25', '', NULL, '服务监控菜单');
INSERT INTO `sys_menu` VALUES (113, '缓存监控', 2, 5, 'cache', 'monitor/cache/index', '', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis', 'admin', '2022-11-16 09:26:25', '', NULL, '缓存监控菜单');
INSERT INTO `sys_menu` VALUES (114, '缓存列表', 2, 6, 'cacheList', 'monitor/cache/list', '', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis-list', 'admin', '2022-11-16 09:26:25', '', NULL, '缓存列表菜单');
INSERT INTO `sys_menu` VALUES (115, '表单构建', 3, 1, 'build', 'tool/build/index', '', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2022-11-16 09:26:25', '', NULL, '表单构建菜单');
INSERT INTO `sys_menu` VALUES (116, '代码生成', 3, 2, 'gen', 'tool/gen/index', '', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2022-11-16 09:26:25', '', NULL, '代码生成菜单');
INSERT INTO `sys_menu` VALUES (117, '系统接口', 3, 3, 'swagger', 'tool/swagger/index', '', 1, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2022-11-16 09:26:25', '', NULL, '系统接口菜单');
INSERT INTO `sys_menu` VALUES (500, '操作日志', 108, 1, 'operlog', 'monitor/operlog/index', '', 1, 0, 'C', '0', '0', 'monitor:operlog:list', 'form', 'admin', '2022-11-16 09:26:25', '', NULL, '操作日志菜单');
INSERT INTO `sys_menu` VALUES (501, '登录日志', 108, 2, 'logininfor', 'monitor/logininfor/index', '', 1, 0, 'C', '0', '0', 'monitor:logininfor:list', 'logininfor', 'admin', '2022-11-16 09:26:25', '', NULL, '登录日志菜单');
INSERT INTO `sys_menu` VALUES (1000, '用户查询', 100, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1001, '用户新增', 100, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1002, '用户修改', 100, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1003, '用户删除', 100, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1004, '用户导出', 100, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1005, '用户导入', 100, 6, '', '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1006, '重置密码', 100, 7, '', '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1007, '角色查询', 101, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1008, '角色新增', 101, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1009, '角色修改', 101, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1010, '角色删除', 101, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1011, '角色导出', 101, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1012, '菜单查询', 102, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1013, '菜单新增', 102, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1014, '菜单修改', 102, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1015, '菜单删除', 102, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1016, '部门查询', 103, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1017, '部门新增', 103, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1018, '部门修改', 103, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1019, '部门删除', 103, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1020, '岗位查询', 104, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1021, '岗位新增', 104, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1022, '岗位修改', 104, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1023, '岗位删除', 104, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1024, '岗位导出', 104, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1025, '字典查询', 105, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1026, '字典新增', 105, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1027, '字典修改', 105, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1028, '字典删除', 105, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1029, '字典导出', 105, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1030, '参数查询', 106, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1031, '参数新增', 106, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1032, '参数修改', 106, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1033, '参数删除', 106, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1034, '参数导出', 106, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1035, '公告查询', 107, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1036, '公告新增', 107, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1037, '公告修改', 107, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1038, '公告删除', 107, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1039, '操作查询', 500, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1040, '操作删除', 500, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1041, '日志导出', 500, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1042, '登录查询', 501, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1043, '登录删除', 501, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1044, '日志导出', 501, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1045, '账户解锁', 501, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:unlock', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1046, '在线查询', 109, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1047, '批量强退', 109, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1048, '单条强退', 109, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1049, '任务查询', 110, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1050, '任务新增', 110, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1051, '任务修改', 110, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1052, '任务删除', 110, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1053, '状态修改', 110, 5, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1054, '任务导出', 110, 6, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1055, '生成查询', 116, 1, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1056, '生成修改', 116, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1057, '生成删除', 116, 3, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1058, '导入代码', 116, 4, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1059, '预览代码', 116, 5, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1060, '生成代码', 116, 6, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2000, '财务管理', 0, 2, 'finance', NULL, NULL, 1, 0, 'M', '0', '0', '', 'money', 'admin', '2022-11-16 09:53:35', 'admin', '2022-11-16 09:53:56', '');
INSERT INTO `sys_menu` VALUES (2001, '记账公司管理', 2000, 1, 'company', 'finance/company/index', NULL, 1, 0, 'C', '0', '0', 'finance:company:list', 'tree', 'admin', '2022-11-16 10:55:11', 'admin', '2022-11-16 13:17:16', '');
INSERT INTO `sys_menu` VALUES (2002, '记账公司删除', 2001, 1, '', NULL, NULL, 1, 0, 'F', '0', '0', 'finance:company:remove', '#', 'admin', '2022-11-16 13:13:42', 'admin', '2022-11-16 13:14:49', '');
INSERT INTO `sys_menu` VALUES (2003, '记账公司新增', 2001, 2, '', NULL, NULL, 1, 0, 'F', '0', '0', 'finance:company:add', '#', 'admin', '2022-11-16 13:14:22', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2004, '记账公司修改', 2001, 3, '', NULL, NULL, 1, 0, 'F', '0', '0', 'finance:company:edit', '#', 'admin', '2022-11-16 13:15:08', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2005, '记账公司查询', 2001, 4, '', NULL, NULL, 1, 0, 'F', '0', '0', 'finance:company:query', '#', 'admin', '2022-11-16 13:15:50', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2007, '项目台账', 2000, 1, 'ledger', 'finance/ledger/index', NULL, 1, 0, 'C', '0', '0', 'finance:ledger:list', '#', 'admin', '2022-11-16 14:50:50', '', NULL, '项目台账菜单');
INSERT INTO `sys_menu` VALUES (2008, '项目台账查询', 2007, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:ledger:query', '#', 'admin', '2022-11-16 14:51:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2009, '项目台账新增', 2007, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:ledger:add', '#', 'admin', '2022-11-16 14:51:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2010, '项目台账修改', 2007, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:ledger:edit', '#', 'admin', '2022-11-16 14:51:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2011, '项目台账删除', 2007, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:ledger:remove', '#', 'admin', '2022-11-16 14:51:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2012, '项目台账导出', 2007, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:ledger:export', '#', 'admin', '2022-11-16 14:51:16', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2013, '项目台账导入', 2007, 6, '', NULL, NULL, 1, 0, 'F', '0', '0', 'finance:ledger:import', '#', 'admin', '2022-11-16 15:44:33', 'admin', '2022-11-16 15:44:51', '');
INSERT INTO `sys_menu` VALUES (2014, '记账科目管理', 2000, 2, 'subject', NULL, NULL, 1, 0, 'M', '0', '0', '', 'job', 'admin', '2022-11-17 09:31:02', 'admin', '2022-11-17 12:02:38', '');
INSERT INTO `sys_menu` VALUES (2015, '科目类别', 2014, 1, 'subjecttype', 'finance/subjecttype/index', NULL, 1, 0, 'C', '0', '0', 'finance:subjectType:list', '#', 'admin', '2022-11-17 11:56:57', 'admin', '2022-11-17 12:03:17', '科目类别菜单');
INSERT INTO `sys_menu` VALUES (2016, '科目类别查询', 2015, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:subjectType:query', '#', 'admin', '2022-11-17 11:56:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2017, '科目类别新增', 2015, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:subjectType:add', '#', 'admin', '2022-11-17 11:56:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2018, '科目类别修改', 2015, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:subjectType:edit', '#', 'admin', '2022-11-17 11:56:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2019, '科目类别删除', 2015, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:subjectType:remove', '#', 'admin', '2022-11-17 11:56:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2020, '科目类别导出', 2015, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'finance:subjectType:export', '#', 'admin', '2022-11-17 11:56:57', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2021, '发票通知管理', 2000, 2, 'invoice', 'finance/invoice/index', NULL, 1, 0, 'C', '0', '0', 'invoice', 'button', 'admin', '2022-11-18 08:49:45', 'admin', '2022-11-18 08:50:04', '');

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice`  (
  `notice_id` int(4) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '公告标题',
  `notice_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob NULL COMMENT '公告内容',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '通知公告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_notice
-- ----------------------------
INSERT INTO `sys_notice` VALUES (1, '温馨提醒：2018-07-01 若依新版本发布啦', '2', 0xE696B0E78988E69CACE58685E5AEB9, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '管理员');
INSERT INTO `sys_notice` VALUES (2, '维护通知：2018-07-01 若依系统凌晨维护', '1', 0xE7BBB4E68AA4E58685E5AEB9, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '管理员');

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log`  (
  `oper_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '模块标题',
  `business_type` int(2) NULL DEFAULT 0 COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '请求方式',
  `operator_type` int(1) NULL DEFAULT 0 COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '返回参数',
  `status` int(1) NULL DEFAULT 0 COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime(0) NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`oper_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 197 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '操作日志记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------
INSERT INTO `sys_oper_log` VALUES (100, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"icon\":\"money\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"财务管理\",\"menuType\":\"M\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"path\":\"33\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 09:53:35');
INSERT INTO `sys_oper_log` VALUES (101, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-11-16 09:53:35\",\"icon\":\"money\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2000,\"menuName\":\"财务管理\",\"menuType\":\"M\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"path\":\"finance\",\"perms\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 09:53:56');
INSERT INTO `sys_oper_log` VALUES (102, '代码生成', 6, 'com.ruoyi.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', '\"sys_user_role,sys_logininfor,sys_job_log,sys_user_post,sys_job,sys_user,sys_dict_type,sys_role_menu,sys_dict_data,sys_role_dept\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:29:29');
INSERT INTO `sys_oper_log` VALUES (103, '代码生成', 6, 'com.ruoyi.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', '\"sys_dept,sys_role,sys_config,sys_post,sys_oper_log,sys_notice,sys_menu\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:29:37');
INSERT INTO `sys_oper_log` VALUES (104, '代码生成', 3, 'com.ruoyi.generator.controller.GenController.remove()', 'DELETE', 1, 'admin', NULL, '/tool/gen/17', '127.0.0.1', '内网IP', '{tableIds=17}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:29:44');
INSERT INTO `sys_oper_log` VALUES (105, '代码生成', 3, 'com.ruoyi.generator.controller.GenController.remove()', 'DELETE', 1, 'admin', NULL, '/tool/gen/11,12,13,14,15,16', '127.0.0.1', '内网IP', '{tableIds=11,12,13,14,15,16}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:29:50');
INSERT INTO `sys_oper_log` VALUES (106, '代码生成', 3, 'com.ruoyi.generator.controller.GenController.remove()', 'DELETE', 1, 'admin', NULL, '/tool/gen/1,2,3,4,5,6,7,8,9,10', '127.0.0.1', '内网IP', '{tableIds=1,2,3,4,5,6,7,8,9,10}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:29:53');
INSERT INTO `sys_oper_log` VALUES (107, '菜单管理', 3, 'com.ruoyi.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":601}', 0, NULL, '2022-11-16 10:47:57');
INSERT INTO `sys_oper_log` VALUES (108, '菜单管理', 3, 'com.ruoyi.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":601}', 0, NULL, '2022-11-16 10:48:49');
INSERT INTO `sys_oper_log` VALUES (109, '菜单管理', 3, 'com.ruoyi.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:50:05');
INSERT INTO `sys_oper_log` VALUES (110, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"/finance/company/index\",\"createBy\":\"admin\",\"icon\":\"people\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账公司管理\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2000,\"path\":\"company\",\"perms\":\"finance:company:list\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:55:11');
INSERT INTO `sys_oper_log` VALUES (111, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"admin\":false,\"createTime\":\"2022-11-16 09:26:25\",\"dataScope\":\"2\",\"delFlag\":\"0\",\"deptCheckStrictly\":true,\"flag\":false,\"menuCheckStrictly\":true,\"menuIds\":[1,100,1000,1001,1002,1003,1004,1005,1006,101,1007,1008,1009,1010,1011,102,1012,1013,1014,1015,103,1016,1017,1018,1019,104,1020,1021,1022,1023,1024,105,1025,1026,1027,1028,1029,106,1030,1031,1032,1033,1034,107,1035,1036,1037,1038,108,500,1039,1040,1041,501,1042,1043,1044,1045,2,109,1046,1047,1048,110,1049,1050,1051,1052,1053,1054,111,112,113,114,2000,2001,3,115,116,1055,1056,1057,1058,1059,1060,117],\"params\":{},\"remark\":\"普通角色\",\"roleId\":2,\"roleKey\":\"common\",\"roleName\":\"普通角色\",\"roleSort\":\"2\",\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 10:58:34');
INSERT INTO `sys_oper_log` VALUES (112, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/company/index\",\"createTime\":\"2022-11-16 10:55:11\",\"icon\":\"people\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2001,\"menuName\":\"记账公司管理\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2000,\"path\":\"company\",\"perms\":\"finance:company:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 11:08:08');
INSERT INTO `sys_oper_log` VALUES (113, '代码生成', 6, 'com.ruoyi.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', '\"fnc_company\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 11:35:57');
INSERT INTO `sys_oper_log` VALUES (114, '代码生成', 8, 'com.ruoyi.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-11-16 11:36:53');
INSERT INTO `sys_oper_log` VALUES (115, '记账公司', 1, 'com.ruoyi.web.controller.finance.FncCompanyController.add()', 'POST', 1, 'admin', NULL, '/finance/company', '127.0.0.1', '内网IP', '{\"bankAccount\":\"121919257910601\",\"bankAccountName\":\"上海让雷智能科技有限公司\",\"bankDeposit\":\"招商银行上海分行上海浦东大道支行\",\"companyAddress\":\"上海市青浦区诸光路1588弄虹桥世界中心 L2B-503\\t\",\"companyName\":\"上海让雷智能科技有限公司\",\"contactInformation\":\"021-61833518\",\"createTime\":\"2022-11-16 13:05:52.873\",\"licenseNo\":\"91310115MA1H77UR33\",\"params\":{}}', NULL, 1, '\r\n### Error updating database.  Cause: java.sql.SQLException: Field \'company_id\' doesn\'t have a default value\r\n### The error may exist in file [C:\\Users\\RL-047\\Desktop\\ruoyi\\RuoYi-Vue\\ruoyi-system\\target\\classes\\mapper\\finance\\FncCompanyMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.FncCompanyMapper.insertFncCompany-Inline\r\n### The error occurred while setting parameters\r\n### SQL: insert into fnc_company          ( company_name,             license_no,             company_address,             contact_information,             bank_deposit,             bank_account_name,             bank_account,                          create_time )           values ( ?,             ?,             ?,             ?,             ?,             ?,             ?,                          ? )\r\n### Cause: java.sql.SQLException: Field \'company_id\' doesn\'t have a default value\n; Field \'company_id\' doesn\'t have a default value; nested exception is java.sql.SQLException: Field \'company_id\' doesn\'t have a default value', '2022-11-16 13:05:52');
INSERT INTO `sys_oper_log` VALUES (116, '记账公司', 1, 'com.ruoyi.web.controller.finance.FncCompanyController.add()', 'POST', 1, 'admin', NULL, '/finance/company', '127.0.0.1', '内网IP', '{\"bankAccount\":\"121919257910601\",\"bankAccountName\":\"上海让雷智能科技有限公司\",\"bankDeposit\":\"招商银行上海分行上海浦东大道支行\",\"companyAddress\":\"上海市青浦区诸光路1588弄虹桥世界中心 L2B-503\\t\",\"companyName\":\"上海让雷智能科技有限公司\",\"contactInformation\":\"021-61833518\",\"createTime\":\"2022-11-16 13:06:31.578\",\"licenseNo\":\"91310115MA1H77UR33\",\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:06:31');
INSERT INTO `sys_oper_log` VALUES (117, '记账公司', 1, 'com.ruoyi.web.controller.finance.FncCompanyController.add()', 'POST', 1, 'admin', NULL, '/finance/company', '127.0.0.1', '内网IP', '{\"bankAccount\":\"121910934210603\",\"bankAccountName\":\"上海缔荣纺织品有限公司\",\"bankDeposit\":\"招商银行股份有限公司上海金桥支行\",\"companyAddress\":\"上海市嘉定区菊园新区环城路2222号1幢JT10046室\",\"companyName\":\"上海缔荣纺织科技有限公司\",\"contactInformation\":\"021-61833518\",\"createTime\":\"2022-11-16 13:07:24.891\",\"licenseNo\":\"913101165665512158\",\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:07:24');
INSERT INTO `sys_oper_log` VALUES (118, '用户管理', 2, 'com.ruoyi.web.controller.system.SysUserController.resetPwd()', 'PUT', 1, 'admin', NULL, '/system/user/resetPwd', '127.0.0.1', '内网IP', '{\"admin\":false,\"params\":{},\"updateBy\":\"admin\",\"userId\":2}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:11:12');
INSERT INTO `sys_oper_log` VALUES (119, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账公司删除\",\"menuType\":\"F\",\"orderNum\":1,\"params\":{},\"parentId\":2001,\"perms\":\"finance:company:delete\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:13:42');
INSERT INTO `sys_oper_log` VALUES (120, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账公司新增\",\"menuType\":\"F\",\"orderNum\":1,\"params\":{},\"parentId\":2001,\"perms\":\"finance:company:add\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:14:22');
INSERT INTO `sys_oper_log` VALUES (121, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-11-16 13:13:42\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2002,\"menuName\":\"记账公司删除\",\"menuType\":\"F\",\"orderNum\":1,\"params\":{},\"parentId\":2001,\"path\":\"\",\"perms\":\"finance:company:remove\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:14:49');
INSERT INTO `sys_oper_log` VALUES (122, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账公司修改\",\"menuType\":\"F\",\"orderNum\":3,\"params\":{},\"parentId\":2001,\"perms\":\"finance:company:edit\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:15:08');
INSERT INTO `sys_oper_log` VALUES (123, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账公司查询\",\"menuType\":\"F\",\"orderNum\":4,\"params\":{},\"parentId\":2001,\"perms\":\"finance:company:query\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:15:50');
INSERT INTO `sys_oper_log` VALUES (124, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"admin\":false,\"createTime\":\"2022-11-16 09:26:25\",\"dataScope\":\"2\",\"delFlag\":\"0\",\"deptCheckStrictly\":true,\"flag\":false,\"menuCheckStrictly\":true,\"menuIds\":[2000,2001,1,100,1000,1001,1002,1003,1004,1005,1006,101,1007,1008,1009,1010,1011,102,1012,1013,1014,1015,103,1016,1017,1018,1019,104,1020,1021,1022,1023,1024,105,1025,1026,1027,1028,1029,106,1030,1031,1032,1033,1034,107,1035,1036,1037,1038,108,500,1039,1040,1041,501,1042,1043,1044,1045,2,109,1046,1047,1048,110,1049,1050,1051,1052,1053,1054,111,112,113,114,2003,2004,2005,3,115,116,1055,1056,1057,1058,1059,1060,117],\"params\":{},\"remark\":\"普通角色\",\"roleId\":2,\"roleKey\":\"common\",\"roleName\":\"普通角色\",\"roleSort\":\"2\",\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:16:11');
INSERT INTO `sys_oper_log` VALUES (125, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/company/index\",\"createTime\":\"2022-11-16 10:55:11\",\"icon\":\"tree\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2001,\"menuName\":\"记账公司管理\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2000,\"path\":\"company\",\"perms\":\"finance:company:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:17:16');
INSERT INTO `sys_oper_log` VALUES (126, '用户头像', 2, 'com.ruoyi.web.controller.system.SysProfileController.avatar()', 'POST', 1, 'admin', NULL, '/system/user/profile/avatar', '127.0.0.1', '内网IP', '', '{\"msg\":\"操作成功\",\"imgUrl\":\"/profile/avatar/2022/11/16/blob_20221116131804A001.png\",\"code\":200}', 0, NULL, '2022-11-16 13:18:04');
INSERT INTO `sys_oper_log` VALUES (127, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"admin\":false,\"createTime\":\"2022-11-16 09:26:25\",\"dataScope\":\"2\",\"delFlag\":\"0\",\"deptCheckStrictly\":true,\"flag\":false,\"menuCheckStrictly\":true,\"menuIds\":[2000,2001,1,100,1000,1001,1002,1003,1004,1005,1006,101,1007,1008,1009,1010,1011,102,1012,1013,1014,1015,103,1016,1017,1018,1019,104,1020,1021,1022,1023,1024,105,1025,1026,1027,1028,1029,106,1030,1031,1032,1033,1034,107,1035,1036,1037,1038,108,500,1039,1040,1041,501,1042,1043,1044,1045,2,109,1046,1047,1048,110,1049,1050,1051,1052,1053,1054,111,112,113,114,2003,2005,3,115,116,1055,1056,1057,1058,1059,1060,117],\"params\":{},\"remark\":\"普通角色\",\"roleId\":2,\"roleKey\":\"common\",\"roleName\":\"普通角色\",\"roleSort\":\"2\",\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:26:30');
INSERT INTO `sys_oper_log` VALUES (128, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"admin\":false,\"createTime\":\"2022-11-16 09:26:25\",\"dataScope\":\"2\",\"delFlag\":\"0\",\"deptCheckStrictly\":true,\"flag\":false,\"menuCheckStrictly\":true,\"menuIds\":[2000,2001,1,100,1000,1001,1002,1003,1004,1005,1006,101,1007,1008,1009,1010,1011,102,1012,1013,1014,1015,103,1016,1017,1018,1019,104,1020,1021,1022,1023,1024,105,1025,1026,1027,1028,1029,106,1030,1031,1032,1033,1034,107,1035,1036,1037,1038,108,500,1039,1040,1041,501,1042,1043,1044,1045,2,109,1046,1047,1048,110,1049,1050,1051,1052,1053,1054,111,112,113,114,2003,2004,2005,3,115,116,1055,1056,1057,1058,1059,1060,117],\"params\":{},\"remark\":\"普通角色\",\"roleId\":2,\"roleKey\":\"common\",\"roleName\":\"普通角色\",\"roleSort\":\"2\",\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:26:46');
INSERT INTO `sys_oper_log` VALUES (129, '记账公司', 2, 'com.ruoyi.web.controller.finance.FncCompanyController.edit()', 'PUT', 1, 'ry', NULL, '/finance/company', '127.0.0.1', '内网IP', '{\"bankAccount\":\"121919257910601\",\"bankAccountName\":\"上海让雷智能科技有限公司\",\"bankDeposit\":\"招商银行上海分行上海浦东大道支行\",\"companyAddress\":\"上海市青浦区诸光路1588弄虹桥世界中心 L2B-503\\t\",\"companyId\":1,\"companyName\":\"上海让雷智能科技有限公司\",\"contactInformation\":\"021-61833518\",\"createTime\":\"2022-11-16 13:06:32\",\"licenseNo\":\"91310115MA1H77UR33\",\"params\":{},\"updateTime\":\"2022-11-16 13:30:19.772\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:30:19');
INSERT INTO `sys_oper_log` VALUES (130, '记账公司', 5, 'com.ruoyi.web.controller.finance.FncCompanyController.export()', 'POST', 1, 'admin', NULL, '/finance/company/export', '127.0.0.1', '内网IP', '{\"params\":{}}', NULL, 0, NULL, '2022-11-16 13:45:16');
INSERT INTO `sys_oper_log` VALUES (131, '记账公司', 5, 'com.ruoyi.web.controller.finance.FncCompanyController.export()', 'POST', 1, 'admin', NULL, '/finance/company/export', '127.0.0.1', '内网IP', '{\"params\":{}}', NULL, 0, NULL, '2022-11-16 13:47:01');
INSERT INTO `sys_oper_log` VALUES (132, '记账公司', 5, 'com.ruoyi.web.controller.finance.FncCompanyController.export()', 'POST', 1, 'admin', NULL, '/finance/company/export', '127.0.0.1', '内网IP', '{\"params\":{}}', NULL, 0, NULL, '2022-11-16 13:47:21');
INSERT INTO `sys_oper_log` VALUES (133, '角色管理', 5, 'com.ruoyi.web.controller.system.SysRoleController.export()', 'POST', 1, 'admin', NULL, '/system/role/export', '127.0.0.1', '内网IP', '{\"admin\":false,\"deptCheckStrictly\":false,\"flag\":false,\"menuCheckStrictly\":false,\"params\":{\"dataScope\":\"\"}}', NULL, 0, NULL, '2022-11-16 13:54:13');
INSERT INTO `sys_oper_log` VALUES (134, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"3\",\"createBy\":\"admin\",\"icon\":\"log\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"项目台账管理\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":2001,\"path\":\"2\",\"perms\":\"的\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:34:35');
INSERT INTO `sys_oper_log` VALUES (135, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"3\",\"createTime\":\"2022-11-16 14:34:35\",\"icon\":\"log\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2006,\"menuName\":\"项目台账管理\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":2000,\"path\":\"2\",\"perms\":\"的\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:34:51');
INSERT INTO `sys_oper_log` VALUES (136, '代码生成', 6, 'com.ruoyi.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', '\"fnc_ledger\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:39:19');
INSERT INTO `sys_oper_log` VALUES (137, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"ledger\",\"className\":\"FncLedger\",\"columns\":[{\"capJavaField\":\"LedgerId\",\"columnComment\":\"项目台账id\",\"columnId\":186,\"columnName\":\"ledger_id\",\"columnType\":\"bigint(50)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"ledgerId\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"ProjectType\",\"columnComment\":\"分类\",\"columnId\":187,\"columnName\":\"project_type\",\"columnType\":\"varchar(20)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"select\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"projectType\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Date\",\"columnComment\":\"日期\",\"columnId\":188,\"columnName\":\"date\",\"columnType\":\"date\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"datetime\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"date\",\"javaType\":\"Date\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"ProjectName\",\"columnComment\":\"项目中/英文名称\",\"columnId\":189,\"columnName\":\"project_name\",\"columnType\":\"varchar(40)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"projectName\",\"javaType\":\"String\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:40:12');
INSERT INTO `sys_oper_log` VALUES (138, '代码生成', 8, 'com.ruoyi.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-11-16 14:40:16');
INSERT INTO `sys_oper_log` VALUES (139, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"ledger\",\"className\":\"FncLedger\",\"columns\":[{\"capJavaField\":\"LedgerId\",\"columnComment\":\"项目台账id\",\"columnId\":186,\"columnName\":\"ledger_id\",\"columnType\":\"bigint(50)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"ledgerId\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"updateTime\":\"2022-11-16 14:40:12\",\"usableColumn\":false},{\"capJavaField\":\"ProjectType\",\"columnComment\":\"分类\",\"columnId\":187,\"columnName\":\"project_type\",\"columnType\":\"varchar(20)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"select\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"projectType\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"updateTime\":\"2022-11-16 14:40:12\",\"usableColumn\":false},{\"capJavaField\":\"Date\",\"columnComment\":\"日期\",\"columnId\":188,\"columnName\":\"date\",\"columnType\":\"date\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"datetime\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"date\",\"javaType\":\"Date\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":19,\"updateBy\":\"\",\"updateTime\":\"2022-11-16 14:40:12\",\"usableColumn\":false},{\"capJavaField\":\"ProjectName\",\"columnComment\":\"项目中/英文名称\",\"columnId\":189,\"columnName\":\"project_name\",\"columnType\":\"varchar(40)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-16 14:39:19\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncremen', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:41:51');
INSERT INTO `sys_oper_log` VALUES (140, '代码生成', 8, 'com.ruoyi.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-11-16 14:41:53');
INSERT INTO `sys_oper_log` VALUES (141, '项目台账', 1, 'com.ruoyi.web.controller.finance.FncLedgerController.add()', 'POST', 1, 'admin', NULL, '/finance/ledger', '127.0.0.1', '内网IP', '{\"charge\":\"余敏\",\"chargePhone\":\"13902957449\",\"createTime\":\"2022-11-16 14:55:03.131\",\"customerCompany\":\"金旭环保制品（深圳）有限公司\",\"customerManager\":\"李小龙\",\"date\":\"2022-11-16 00:00:00\",\"inquiryNo\":\"20211229\",\"params\":{},\"projectName\":\"金旭环保水刺全自动棉柔巾智能工厂项目\",\"saleEvaluation\":\"金旭环保制品（深圳）有限公司\"}', NULL, 1, '\r\n### Error updating database.  Cause: java.sql.SQLException: Field \'ledger_id\' doesn\'t have a default value\r\n### The error may exist in file [C:\\Users\\RL-047\\Desktop\\ruoyi\\RuoYi-Vue\\ruoyi-system\\target\\classes\\mapper\\finance\\FncLedgerMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.FncLedgerMapper.insertFncLedger-Inline\r\n### The error occurred while setting parameters\r\n### SQL: insert into fnc_ledger          ( date,             project_name,             charge,             charge_phone,             inquiry_no,             customer_manager,             customer_company,                          sale_evaluation,                          create_time )           values ( ?,             ?,             ?,             ?,             ?,             ?,             ?,                          ?,                          ? )\r\n### Cause: java.sql.SQLException: Field \'ledger_id\' doesn\'t have a default value\n; Field \'ledger_id\' doesn\'t have a default value; nested exception is java.sql.SQLException: Field \'ledger_id\' doesn\'t have a default value', '2022-11-16 14:55:03');
INSERT INTO `sys_oper_log` VALUES (142, '项目台账', 1, 'com.ruoyi.web.controller.finance.FncLedgerController.add()', 'POST', 1, 'admin', NULL, '/finance/ledger', '127.0.0.1', '内网IP', '{\"charge\":\"余敏\",\"chargePhone\":\"13902957449\",\"createTime\":\"2022-11-16 14:55:10.771\",\"customerCompany\":\"金旭环保制品（深圳）有限公司\",\"customerManager\":\"李小龙\",\"date\":\"2022-11-16 00:00:00\",\"inquiryNo\":\"20211229\",\"params\":{},\"projectName\":\"金旭环保水刺全自动棉柔巾智能工厂项目\",\"saleEvaluation\":\"金旭环保制品（深圳）有限公司\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:55:10');
INSERT INTO `sys_oper_log` VALUES (143, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.synchDb()', 'GET', 1, 'admin', NULL, '/tool/gen/synchDb/fnc_ledger', '127.0.0.1', '内网IP', '{tableName=fnc_ledger}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:59:43');
INSERT INTO `sys_oper_log` VALUES (144, '字典类型', 1, 'com.ruoyi.web.controller.system.SysDictTypeController.add()', 'POST', 1, 'admin', NULL, '/system/dict/type', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictName\":\"台账分类\",\"dictType\":\"fns_ledger_type\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:01:59');
INSERT INTO `sys_oper_log` VALUES (145, '字典数据', 1, 'com.ruoyi.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"default\":false,\"dictLabel\":\"全系列\",\"dictSort\":1,\"dictType\":\"fns_ledger_type\",\"dictValue\":\"AllSeries\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:04:12');
INSERT INTO `sys_oper_log` VALUES (146, '字典数据', 1, 'com.ruoyi.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"default\":false,\"dictLabel\":\"纤维\",\"dictSort\":1,\"dictType\":\"fns_ledger_type\",\"dictValue\":\"Fibre\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:04:42');
INSERT INTO `sys_oper_log` VALUES (147, '项目台账', 2, 'com.ruoyi.web.controller.finance.FncLedgerController.edit()', 'PUT', 1, 'admin', NULL, '/finance/ledger', '127.0.0.1', '内网IP', '{\"businessType\":\"外贸\",\"charge\":\"余敏\",\"chargePhone\":\"13902957449\",\"createTime\":\"2022-11-16 14:55:11\",\"customerCompany\":\"金旭环保制品（深圳）有限公司\",\"customerManager\":\"李小龙\",\"date\":\"2022-11-16 00:00:00\",\"inquiryNo\":\"20211229\",\"ledgerId\":1,\"params\":{},\"projectName\":\"金旭环保水刺全自动棉柔巾智能工厂项目\",\"projectType\":\"全分类\",\"saleEvaluation\":\"金旭环保制品（深圳）有限公司\",\"updateTime\":\"2022-11-16 15:16:57.537\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:16:57');
INSERT INTO `sys_oper_log` VALUES (148, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"项目台账导入\",\"menuType\":\"F\",\"orderNum\":6,\"params\":{},\"parentId\":2008,\"perms\":\"finance:ledger:import\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:44:33');
INSERT INTO `sys_oper_log` VALUES (149, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-11-16 15:44:33\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2013,\"menuName\":\"项目台账导入\",\"menuType\":\"F\",\"orderNum\":6,\"params\":{},\"parentId\":2007,\"path\":\"\",\"perms\":\"finance:ledger:import\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 15:44:51');
INSERT INTO `sys_oper_log` VALUES (150, '项目台账', 5, 'com.ruoyi.web.controller.finance.FncLedgerController.export()', 'POST', 1, 'admin', NULL, '/finance/ledger/export', '127.0.0.1', '内网IP', '{\"params\":{}}', NULL, 0, NULL, '2022-11-16 13:21:37');
INSERT INTO `sys_oper_log` VALUES (151, '用户管理', 6, 'com.ruoyi.web.controller.system.SysUserController.importData()', 'POST', 1, 'admin', NULL, '/system/user/importData', '127.0.0.1', '内网IP', 'true', NULL, 1, '', '2022-11-16 13:25:44');
INSERT INTO `sys_oper_log` VALUES (152, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, '', '2022-11-16 13:27:26');
INSERT INTO `sys_oper_log` VALUES (153, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1\n; bad SQL grammar []; nested exception is java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1', '2022-11-16 13:33:03');
INSERT INTO `sys_oper_log` VALUES (154, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1\n; bad SQL grammar []; nested exception is java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1', '2022-11-16 13:34:00');
INSERT INTO `sys_oper_log` VALUES (155, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1\n; bad SQL grammar []; nested exception is java.sql.BatchUpdateException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'\' at line 1', '2022-11-16 13:35:46');
INSERT INTO `sys_oper_log` VALUES (156, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error updating database.  Cause: java.lang.IllegalStateException: Type handler was null on parameter mapping for property \'params\'. It was either not specified and/or could not be found for the javaType (java.util.Map) : jdbcType (null) combination.\r\n### The error may exist in com/ruoyi/system/mapper/FncLedgerMapper.java (best guess)\r\n### The error may involve com.ruoyi.system.mapper.FncLedgerMapper.insert\r\n### The error occurred while executing an update\r\n### Cause: java.lang.IllegalStateException: Type handler was null on parameter mapping for property \'params\'. It was either not specified and/or could not be found for the javaType (java.util.Map) : jdbcType (null) combination.', '2022-11-16 13:45:00');
INSERT INTO `sys_oper_log` VALUES (157, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error updating database.  Cause: java.lang.IllegalStateException: Type handler was null on parameter mapping for property \'params\'. It was either not specified and/or could not be found for the javaType (java.util.Map) : jdbcType (null) combination.\r\n### The error may exist in com/ruoyi/system/mapper/FncLedgerMapper.java (best guess)\r\n### The error may involve com.ruoyi.system.mapper.FncLedgerMapper.insert\r\n### The error occurred while executing an update\r\n### Cause: java.lang.IllegalStateException: Type handler was null on parameter mapping for property \'params\'. It was either not specified and/or could not be found for the javaType (java.util.Map) : jdbcType (null) combination.', '2022-11-16 13:47:24');
INSERT INTO `sys_oper_log` VALUES (158, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge_phone\' at row 1\n; Data truncation: Data too long for column \'charge_phone\' at row 1; nested exception is java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge_phone\' at row 1', '2022-11-16 13:51:53');
INSERT INTO `sys_oper_log` VALUES (159, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge_phone\' at row 1\n; Data truncation: Data too long for column \'charge_phone\' at row 1; nested exception is java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge_phone\' at row 1', '2022-11-16 13:52:56');
INSERT INTO `sys_oper_log` VALUES (160, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: Data truncation: Data too long for column \'customer_company\' at row 1\n; Data truncation: Data too long for column \'customer_company\' at row 1; nested exception is java.sql.BatchUpdateException: Data truncation: Data too long for column \'customer_company\' at row 1', '2022-11-16 13:53:45');
INSERT INTO `sys_oper_log` VALUES (161, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, '', '2022-11-16 13:54:30');
INSERT INTO `sys_oper_log` VALUES (162, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: Data truncation: Data too long for column \'project_name\' at row 1\n; Data truncation: Data too long for column \'project_name\' at row 1; nested exception is java.sql.BatchUpdateException: Data truncation: Data too long for column \'project_name\' at row 1', '2022-11-16 13:55:31');
INSERT INTO `sys_oper_log` VALUES (163, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', NULL, 1, 'com.ruoyi.system.mapper.FncLedgerMapper.insert (batch index #1) failed. Cause: java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge\' at row 1\n; Data truncation: Data too long for column \'charge\' at row 1; nested exception is java.sql.BatchUpdateException: Data truncation: Data too long for column \'charge\' at row 1', '2022-11-16 13:56:55');
INSERT INTO `sys_oper_log` VALUES (164, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 13:57:20');
INSERT INTO `sys_oper_log` VALUES (165, '项目台账', 5, 'com.ruoyi.web.controller.finance.FncLedgerController.export()', 'POST', 1, 'admin', NULL, '/finance/ledger/export', '127.0.0.1', '内网IP', '{\"params\":{}}', NULL, 0, NULL, '2022-11-16 13:58:28');
INSERT INTO `sys_oper_log` VALUES (166, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:01:02');
INSERT INTO `sys_oper_log` VALUES (167, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:09:28');
INSERT INTO `sys_oper_log` VALUES (168, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:11:05');
INSERT INTO `sys_oper_log` VALUES (169, '项目台账', 6, 'com.ruoyi.web.controller.finance.FncLedgerController.importData()', 'POST', 1, 'admin', NULL, '/finance/ledger/import', '127.0.0.1', '内网IP', 'false', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-16 14:14:51');
INSERT INTO `sys_oper_log` VALUES (170, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createBy\":\"admin\",\"icon\":\"job\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"记账科目管理\",\"menuType\":\"M\",\"orderNum\":2,\"params\":{},\"parentId\":2000,\"path\":\"subject\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 09:31:02');
INSERT INTO `sys_oper_log` VALUES (171, '代码生成', 6, 'com.ruoyi.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', '\"fnc_subject_type\"', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 10:37:45');
INSERT INTO `sys_oper_log` VALUES (172, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"subjectType\",\"className\":\"FncSubjectType\",\"columns\":[{\"capJavaField\":\"SubjectTypeId\",\"columnComment\":\"科目类别id\",\"columnId\":202,\"columnName\":\"subject_type_id\",\"columnType\":\"bigint(20)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-17 10:37:45\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":true,\"insert\":true,\"isIncrement\":\"1\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"subjectTypeId\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":20,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"ParentId\",\"columnComment\":\"上级id\",\"columnId\":203,\"columnName\":\"parent_id\",\"columnType\":\"bigint(20)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-17 10:37:45\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"0\",\"isRequired\":\"1\",\"javaField\":\"parentId\",\"javaType\":\"Long\",\"list\":true,\"params\":{},\"pk\":false,\"query\":false,\"queryType\":\"EQ\",\"required\":true,\"sort\":2,\"superColumn\":true,\"tableId\":20,\"updateBy\":\"\",\"usableColumn\":true},{\"capJavaField\":\"SubjectTypeName\",\"columnComment\":\"科目类别名称\",\"columnId\":204,\"columnName\":\"subject_type_name\",\"columnType\":\"varchar(50)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-17 10:37:45\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"subjectTypeName\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"LIKE\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":20,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"OrderNum\",\"columnComment\":\"显示顺序\",\"columnId\":205,\"columnName\":\"order_num\",\"columnType\":\"int(4)\",\"createBy\":\"admin\",\"createTime\":\"2022-11-17 10:37:45\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 10:39:33');
INSERT INTO `sys_oper_log` VALUES (173, '代码生成', 8, 'com.ruoyi.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-11-17 10:47:20');
INSERT INTO `sys_oper_log` VALUES (174, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.synchDb()', 'GET', 1, 'admin', NULL, '/tool/gen/synchDb/fnc_company', '127.0.0.1', '内网IP', '{tableName=fnc_company}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 10:59:46');
INSERT INTO `sys_oper_log` VALUES (175, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.synchDb()', 'GET', 1, 'admin', NULL, '/tool/gen/synchDb/fnc_subject_type', '127.0.0.1', '内网IP', '{tableName=fnc_subject_type}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 11:00:08');
INSERT INTO `sys_oper_log` VALUES (176, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/subjectype/index\",\"createTime\":\"2022-11-17 11:56:57\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2015,\"menuName\":\"科目类别\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2014,\"path\":\"subjectType\",\"perms\":\"finance:subjectType:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 11:59:37');
INSERT INTO `sys_oper_log` VALUES (177, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/subjectype/index\",\"createTime\":\"2022-11-17 11:56:57\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2015,\"menuName\":\"科目类别\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2014,\"path\":\"subjectType\",\"perms\":\"finance:subjectType:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 12:00:27');
INSERT INTO `sys_oper_log` VALUES (178, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/subjectype/index\",\"createTime\":\"2022-11-17 11:56:57\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2015,\"menuName\":\"科目类别\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2014,\"path\":\"subjecttype\",\"perms\":\"finance:subjectType:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 12:01:27');
INSERT INTO `sys_oper_log` VALUES (179, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-11-17 09:31:02\",\"icon\":\"job\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2014,\"menuName\":\"记账科目管理\",\"menuType\":\"M\",\"orderNum\":2,\"params\":{},\"parentId\":2000,\"path\":\"subject\",\"perms\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 12:02:38');
INSERT INTO `sys_oper_log` VALUES (180, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/subjecttype/index\",\"createTime\":\"2022-11-17 11:56:57\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2015,\"menuName\":\"科目类别\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":2014,\"path\":\"subjecttype\",\"perms\":\"finance:subjectType:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 12:03:17');
INSERT INTO `sys_oper_log` VALUES (181, '代码生成', 2, 'com.ruoyi.generator.controller.GenController.synchDb()', 'GET', 1, 'admin', NULL, '/tool/gen/synchDb/fnc_subject_type', '127.0.0.1', '内网IP', '{tableName=fnc_subject_type}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 14:05:37');
INSERT INTO `sys_oper_log` VALUES (182, '科目类别', 1, 'com.ruoyi.system.controller.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-17T14:06:27.204+08:00\",\"deleteStatus\":1,\"orderNum\":3,\"params\":{},\"parentId\":0,\"subjectTypeName\":\"3\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-17T14:06:27.204+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 14:06:27');
INSERT INTO `sys_oper_log` VALUES (183, '科目类别', 3, 'com.ruoyi.system.controller.FncSubjectTypeController.remove()', 'GET', 1, 'admin', NULL, '/finance/subjectType/remove/1', '127.0.0.1', '内网IP', '{subjectTypeIds=1}', '{\"msg\":\"操作失败\",\"code\":500}', 0, NULL, '2022-11-17 14:08:20');
INSERT INTO `sys_oper_log` VALUES (184, '科目类别', 3, 'com.ruoyi.system.controller.FncSubjectTypeController.remove()', 'GET', 1, 'admin', NULL, '/finance/subjectType/remove/1', '127.0.0.1', '内网IP', '{subjectTypeIds=1}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 14:10:13');
INSERT INTO `sys_oper_log` VALUES (185, '部门管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'admin', NULL, '/system/dept', '127.0.0.1', '内网IP', '{\"ancestors\":\"0,100,101,103\",\"children\":[],\"createBy\":\"admin\",\"deptName\":\"test\",\"leader\":\"test\",\"orderNum\":3,\"params\":{},\"parentId\":103,\"phone\":\"\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 15:04:56');
INSERT INTO `sys_oper_log` VALUES (186, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-17T16:49:37.577+08:00\",\"deleteStatus\":1,\"orderNum\":1,\"params\":{},\"parentId\":0,\"subjectTypeId\":2,\"subjectTypeName\":\"1-1\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-17T16:49:37.577+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 16:49:37');
INSERT INTO `sys_oper_log` VALUES (187, '科目类别', 3, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.remove()', 'GET', 1, 'admin', NULL, '/finance/subjectType/remove/2', '127.0.0.1', '内网IP', '{subjectTypeIds=2}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 17:00:36');
INSERT INTO `sys_oper_log` VALUES (188, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-17T17:00:41.1+08:00\",\"deleteStatus\":1,\"orderNum\":3,\"params\":{},\"parentId\":0,\"subjectTypeId\":3,\"subjectTypeName\":\"3\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-17T17:00:41.1+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 17:00:41');
INSERT INTO `sys_oper_log` VALUES (189, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-17T17:12:03.451+08:00\",\"deleteStatus\":1,\"orderNum\":2,\"params\":{},\"parentId\":0,\"subjectTypeId\":4,\"subjectTypeName\":\"1-2\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-17T17:12:03.451+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-17 17:12:03');
INSERT INTO `sys_oper_log` VALUES (190, '菜单管理', 1, 'com.ruoyi.web.controller.system.SysMenuController.add()', 'POST', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"1\",\"createBy\":\"admin\",\"icon\":\"button\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuName\":\"发票通知管理\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":2000,\"path\":\"1\",\"perms\":\"\",\"query\":\"\",\"status\":\"0\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:49:45');
INSERT INTO `sys_oper_log` VALUES (191, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"finance/invoice/index\",\"createTime\":\"2022-11-18 08:49:45\",\"icon\":\"button\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2021,\"menuName\":\"发票通知管理\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":2000,\"path\":\"invoice\",\"perms\":\"invoice\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:50:04');
INSERT INTO `sys_oper_log` VALUES (192, '科目类别', 2, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.edit()', 'POST', 1, 'admin', NULL, '/finance/subjectType/edit', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-17 17:12:03\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"subjectTypeId\":4,\"subjectTypeName\":\"资产\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-18T08:50:43.993+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:50:44');
INSERT INTO `sys_oper_log` VALUES (193, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-18T08:50:51.98+08:00\",\"deleteStatus\":1,\"orderNum\":2,\"params\":{},\"parentId\":0,\"subjectTypeId\":5,\"subjectTypeName\":\"负债\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-18T08:50:51.98+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:50:52');
INSERT INTO `sys_oper_log` VALUES (194, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-18T08:51:05.605+08:00\",\"deleteStatus\":1,\"params\":{},\"parentId\":4,\"subjectTypeId\":6,\"subjectTypeName\":\"流动资产\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-18T08:51:05.605+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:51:05');
INSERT INTO `sys_oper_log` VALUES (195, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-18T08:51:16.855+08:00\",\"deleteStatus\":1,\"params\":{},\"parentId\":4,\"subjectTypeId\":7,\"subjectTypeName\":\"非流动资产\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-18T08:51:16.855+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:51:16');
INSERT INTO `sys_oper_log` VALUES (196, '科目类别', 1, 'com.ruoyi.web.controller.finance.FncSubjectTypeController.add()', 'POST', 1, 'admin', NULL, '/finance/subjectType/add', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-11-18T08:51:28.003+08:00\",\"deleteStatus\":1,\"params\":{},\"parentId\":5,\"subjectTypeId\":8,\"subjectTypeName\":\"流动负债\",\"updateBy\":\"admin\",\"updateTime\":\"2022-11-18T08:51:28.003+08:00\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-11-18 08:51:28');

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post`  (
  `post_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '岗位名称',
  `post_sort` int(4) NOT NULL COMMENT '显示顺序',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '岗位信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_post
-- ----------------------------
INSERT INTO `sys_post` VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_post` VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_post` VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '');
INSERT INTO `sys_post` VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2022-11-16 09:26:25', '', NULL, '');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(4) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '部门树选择项是否关联显示',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 100 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2022-11-16 09:26:25', '', NULL, '超级管理员');
INSERT INTO `sys_role` VALUES (2, '普通角色', 'common', 2, '2', 1, 1, '0', '0', 'admin', '2022-11-16 09:26:25', 'admin', '2022-11-16 13:26:46', '普通角色');

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept`  (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(20) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`, `dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色和部门关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_dept
-- ----------------------------
INSERT INTO `sys_role_dept` VALUES (2, 100);
INSERT INTO `sys_role_dept` VALUES (2, 101);
INSERT INTO `sys_role_dept` VALUES (2, 105);

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu`  (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色和菜单关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES (2, 1);
INSERT INTO `sys_role_menu` VALUES (2, 2);
INSERT INTO `sys_role_menu` VALUES (2, 3);
INSERT INTO `sys_role_menu` VALUES (2, 100);
INSERT INTO `sys_role_menu` VALUES (2, 101);
INSERT INTO `sys_role_menu` VALUES (2, 102);
INSERT INTO `sys_role_menu` VALUES (2, 103);
INSERT INTO `sys_role_menu` VALUES (2, 104);
INSERT INTO `sys_role_menu` VALUES (2, 105);
INSERT INTO `sys_role_menu` VALUES (2, 106);
INSERT INTO `sys_role_menu` VALUES (2, 107);
INSERT INTO `sys_role_menu` VALUES (2, 108);
INSERT INTO `sys_role_menu` VALUES (2, 109);
INSERT INTO `sys_role_menu` VALUES (2, 110);
INSERT INTO `sys_role_menu` VALUES (2, 111);
INSERT INTO `sys_role_menu` VALUES (2, 112);
INSERT INTO `sys_role_menu` VALUES (2, 113);
INSERT INTO `sys_role_menu` VALUES (2, 114);
INSERT INTO `sys_role_menu` VALUES (2, 115);
INSERT INTO `sys_role_menu` VALUES (2, 116);
INSERT INTO `sys_role_menu` VALUES (2, 117);
INSERT INTO `sys_role_menu` VALUES (2, 500);
INSERT INTO `sys_role_menu` VALUES (2, 501);
INSERT INTO `sys_role_menu` VALUES (2, 1000);
INSERT INTO `sys_role_menu` VALUES (2, 1001);
INSERT INTO `sys_role_menu` VALUES (2, 1002);
INSERT INTO `sys_role_menu` VALUES (2, 1003);
INSERT INTO `sys_role_menu` VALUES (2, 1004);
INSERT INTO `sys_role_menu` VALUES (2, 1005);
INSERT INTO `sys_role_menu` VALUES (2, 1006);
INSERT INTO `sys_role_menu` VALUES (2, 1007);
INSERT INTO `sys_role_menu` VALUES (2, 1008);
INSERT INTO `sys_role_menu` VALUES (2, 1009);
INSERT INTO `sys_role_menu` VALUES (2, 1010);
INSERT INTO `sys_role_menu` VALUES (2, 1011);
INSERT INTO `sys_role_menu` VALUES (2, 1012);
INSERT INTO `sys_role_menu` VALUES (2, 1013);
INSERT INTO `sys_role_menu` VALUES (2, 1014);
INSERT INTO `sys_role_menu` VALUES (2, 1015);
INSERT INTO `sys_role_menu` VALUES (2, 1016);
INSERT INTO `sys_role_menu` VALUES (2, 1017);
INSERT INTO `sys_role_menu` VALUES (2, 1018);
INSERT INTO `sys_role_menu` VALUES (2, 1019);
INSERT INTO `sys_role_menu` VALUES (2, 1020);
INSERT INTO `sys_role_menu` VALUES (2, 1021);
INSERT INTO `sys_role_menu` VALUES (2, 1022);
INSERT INTO `sys_role_menu` VALUES (2, 1023);
INSERT INTO `sys_role_menu` VALUES (2, 1024);
INSERT INTO `sys_role_menu` VALUES (2, 1025);
INSERT INTO `sys_role_menu` VALUES (2, 1026);
INSERT INTO `sys_role_menu` VALUES (2, 1027);
INSERT INTO `sys_role_menu` VALUES (2, 1028);
INSERT INTO `sys_role_menu` VALUES (2, 1029);
INSERT INTO `sys_role_menu` VALUES (2, 1030);
INSERT INTO `sys_role_menu` VALUES (2, 1031);
INSERT INTO `sys_role_menu` VALUES (2, 1032);
INSERT INTO `sys_role_menu` VALUES (2, 1033);
INSERT INTO `sys_role_menu` VALUES (2, 1034);
INSERT INTO `sys_role_menu` VALUES (2, 1035);
INSERT INTO `sys_role_menu` VALUES (2, 1036);
INSERT INTO `sys_role_menu` VALUES (2, 1037);
INSERT INTO `sys_role_menu` VALUES (2, 1038);
INSERT INTO `sys_role_menu` VALUES (2, 1039);
INSERT INTO `sys_role_menu` VALUES (2, 1040);
INSERT INTO `sys_role_menu` VALUES (2, 1041);
INSERT INTO `sys_role_menu` VALUES (2, 1042);
INSERT INTO `sys_role_menu` VALUES (2, 1043);
INSERT INTO `sys_role_menu` VALUES (2, 1044);
INSERT INTO `sys_role_menu` VALUES (2, 1045);
INSERT INTO `sys_role_menu` VALUES (2, 1046);
INSERT INTO `sys_role_menu` VALUES (2, 1047);
INSERT INTO `sys_role_menu` VALUES (2, 1048);
INSERT INTO `sys_role_menu` VALUES (2, 1049);
INSERT INTO `sys_role_menu` VALUES (2, 1050);
INSERT INTO `sys_role_menu` VALUES (2, 1051);
INSERT INTO `sys_role_menu` VALUES (2, 1052);
INSERT INTO `sys_role_menu` VALUES (2, 1053);
INSERT INTO `sys_role_menu` VALUES (2, 1054);
INSERT INTO `sys_role_menu` VALUES (2, 1055);
INSERT INTO `sys_role_menu` VALUES (2, 1056);
INSERT INTO `sys_role_menu` VALUES (2, 1057);
INSERT INTO `sys_role_menu` VALUES (2, 1058);
INSERT INTO `sys_role_menu` VALUES (2, 1059);
INSERT INTO `sys_role_menu` VALUES (2, 1060);
INSERT INTO `sys_role_menu` VALUES (2, 2000);
INSERT INTO `sys_role_menu` VALUES (2, 2001);
INSERT INTO `sys_role_menu` VALUES (2, 2003);
INSERT INTO `sys_role_menu` VALUES (2, 2004);
INSERT INTO `sys_role_menu` VALUES (2, 2005);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(20) NULL DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '手机号码',
  `sex` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '密码',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime(0) NULL DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 100 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 103, 'admin', '若依', '00', 'ry@163.com', '15888888888', '1', '/profile/avatar/2022/11/16/blob_20221116131804A001.png', '$2a$10$7JB720yubVSZvUI0rEqK/.VqGOZTH.ulu33dHOiBE8ByOhJIrdAu2', '0', '0', '127.0.0.1', '2022-11-18 14:50:31', 'admin', '2022-11-16 09:26:25', '', '2022-11-18 14:50:31', '管理员');
INSERT INTO `sys_user` VALUES (2, 105, 'ry', '若依', '00', 'ry@qq.com', '15666666666', '1', '', '$2a$10$72XZlIXBNHqFzVMZlzMp7etQzpbmlM22MW1VWNw5q..el.zHjYtT6', '0', '0', '127.0.0.1', '2022-11-16 13:30:08', 'admin', '2022-11-16 09:26:25', 'admin', '2022-11-16 13:30:07', '测试员');

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post`  (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `post_id` bigint(20) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`, `post_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户与岗位关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
INSERT INTO `sys_user_post` VALUES (1, 1);
INSERT INTO `sys_user_post` VALUES (2, 2);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户和角色关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES (1, 1);
INSERT INTO `sys_user_role` VALUES (2, 2);

SET FOREIGN_KEY_CHECKS = 1;
