import request from '@/utils/request'

// 查询科目类别列表
export function listSubjectType(query) {
  return request({
    url: '/finance/subjectType/list',
    method: 'get',
    params: query
  })
}
// 查询上级科目类别列表（排除节点）
export function listExcludeChild(id) {
  return request({
    url: '/finance/subjectType/list/exclude/' + id,
    method: 'get'
  })
}

// 查询科目类别所有列表
export function listAllSubjectType(query) {
  return request({
    url: '/finance/subjectType/listAll',
    method: 'get',
    params: query
  })
}

// 查询科目类别详细
export function getSubjectType(subjectTypeId) {
  return request({
    url: '/finance/subjectType/getInfo/' + subjectTypeId,
    method: 'get'
  })
}

// 新增科目类别
export function addSubjectType(data) {
  return request({
    url: '/finance/subjectType/add',
    method: 'post',
    data: data
  })
}

// 修改科目类别
export function updateSubjectType(data) {
  return request({
    url: '/finance/subjectType/edit',
    method: 'post',
    data: data
  })
}

// 删除科目类别
export function delSubjectType(subjectTypeId) {
  return request({
    url: '/finance/subjectType/remove/' + subjectTypeId,
    method: 'get'
  })
}
