import request from '@/utils/request'

// 查询项目台账列表
export function listLedger(query) {
  return request({
    url: '/finance/ledger/list',
    method: 'get',
    params: query
  })
}

// 查询项目台账详细
export function getLedger(ledgerId) {
  return request({
    url: '/finance/ledger/' + ledgerId,
    method: 'get'
  })
}

// 新增项目台账
export function addLedger(data) {
  return request({
    url: '/finance/ledger',
    method: 'post',
    data: data
  })
}

// 修改项目台账
export function updateLedger(data) {
  return request({
    url: '/finance/ledger',
    method: 'put',
    data: data
  })
}

// 删除项目台账
export function delLedger(ledgerId) {
  return request({
    url: '/finance/ledger/' + ledgerId,
    method: 'delete'
  })
}
