import request from '@/utils/request'

// 查询记账公司列表
export function listCompany(query) {
  return request({
    url: '/finance/company/list',
    method: 'get',
    params: query
  })
}

// 查询记账公司详细
export function getCompany(companyId) {
  return request({
    url: '/finance/company/' + companyId,
    method: 'get'
  })
}

// 新增记账公司
export function addCompany(data) {
  return request({
    url: '/finance/company',
    method: 'post',
    data: data
  })
}

// 修改记账公司
export function updateCompany(data) {
  return request({
    url: '/finance/company',
    method: 'put',
    data: data
  })
}

// 删除记账公司
export function delCompany(companyId) {
  return request({
    url: '/finance/company/' + companyId,
    method: 'delete'
  })
}
