package com.ruoyi.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.system.domain.FncSubjectType;
import com.ruoyi.system.domain.vo.FncSubjectTypeVo;
import com.ruoyi.system.mapper.FncSubjectTypeMapper;
import com.ruoyi.system.service.IFncSubjectTypeService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 科目类别Service业务层处理
 *
 * @author jlf
 * @date 2022-11-17
 */
@Service
public class FncSubjectTypeServiceImpl extends ServiceImpl<FncSubjectTypeMapper, FncSubjectType> implements IFncSubjectTypeService {

    @Override
    public TableDataInfo<FncSubjectTypeVo> queryList(FncSubjectTypeVo entity) {
        return PageUtils.buildDataInfo(this.baseMapper.queryList(PageUtils.buildPage(), entity));
    }

    @Override
    public List<FncSubjectTypeVo> queryAll(FncSubjectTypeVo entity) {
        return this.baseMapper.queryList(entity);
    }

    @Override
    public FncSubjectTypeVo queryById(Long subjectTypeId) {
        return this.baseMapper.queryById(subjectTypeId);
    }
}
