package com.ruoyi.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.FncLedger;
import com.ruoyi.system.mapper.FncLedgerMapper;
import com.ruoyi.system.service.IFncLedgerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目台账Service业务层处理
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
@Service
public class FncLedgerServiceImpl extends ServiceImpl<FncLedgerMapper,FncLedger> implements IFncLedgerService {
//
    @Autowired
    private FncLedgerMapper fncLedgerMapper;

    /**
     * 查询项目台账
     * 
     * @param ledgerId 项目台账主键
     * @return 项目台账
     */
    @Override
    public FncLedger selectFncLedgerByLedgerId(Long ledgerId)
    {
        return fncLedgerMapper.selectFncLedgerByLedgerId(ledgerId);
    }

    /**
     * 查询项目台账列表
     * 
     * @param fncLedger 项目台账
     * @return 项目台账
     */
    @Override
    public List<FncLedger> selectFncLedgerList(FncLedger fncLedger)
    {
        return fncLedgerMapper.selectFncLedgerList(fncLedger);
    }

    /**
     * 新增项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    @Override
    public int insertFncLedger(FncLedger fncLedger)
    {
        fncLedger.setCreateTime(DateUtils.getNowDate());
        return fncLedgerMapper.insertFncLedger(fncLedger);
    }

    /**
     * 修改项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    @Override
    public int updateFncLedger(FncLedger fncLedger)
    {
        fncLedger.setUpdateTime(DateUtils.getNowDate());
        return fncLedgerMapper.updateFncLedger(fncLedger);
    }

    /**
     * 批量删除项目台账
     * 
     * @param ledgerIds 需要删除的项目台账主键
     * @return 结果
     */
    @Override
    public int deleteFncLedgerByLedgerIds(Long[] ledgerIds)
    {
        return fncLedgerMapper.deleteFncLedgerByLedgerIds(ledgerIds);
    }

    /**
     * 删除项目台账信息
     * 
     * @param ledgerId 项目台账主键
     * @return 结果
     */
    @Override
    public int deleteFncLedgerByLedgerId(Long ledgerId)
    {
        return fncLedgerMapper.deleteFncLedgerByLedgerId(ledgerId);
    }


}
