package com.ruoyi.system.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.system.mapper.FncCompanyMapper;
import com.ruoyi.system.domain.FncCompany;
import com.ruoyi.system.service.IFncCompanyService;

/**
 * 记账公司Service业务层处理
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
@Service
public class FncCompanyServiceImpl implements IFncCompanyService 
{
    @Autowired
    private FncCompanyMapper fncCompanyMapper;

    /**
     * 查询记账公司
     * 
     * @param companyId 记账公司主键
     * @return 记账公司
     */
    @Override
    public FncCompany selectFncCompanyByCompanyId(Long companyId)
    {
        return fncCompanyMapper.selectFncCompanyByCompanyId(companyId);
    }

    /**
     * 查询记账公司列表
     * 
     * @param fncCompany 记账公司
     * @return 记账公司
     */
    @Override
    public List<FncCompany> selectFncCompanyList(FncCompany fncCompany)
    {
        return fncCompanyMapper.selectFncCompanyList(fncCompany);
    }

    /**
     * 新增记账公司
     * 
     * @param fncCompany 记账公司
     * @return 结果
     */
    @Override
    public int insertFncCompany(FncCompany fncCompany)
    {
        fncCompany.setCreateTime(DateUtils.getNowDate());
        return fncCompanyMapper.insertFncCompany(fncCompany);
    }

    /**
     * 修改记账公司
     * 
     * @param fncCompany 记账公司
     * @return 结果
     */
    @Override
    public int updateFncCompany(FncCompany fncCompany)
    {
        fncCompany.setUpdateTime(DateUtils.getNowDate());
        return fncCompanyMapper.updateFncCompany(fncCompany);
    }

    /**
     * 批量删除记账公司
     * 
     * @param companyIds 需要删除的记账公司主键
     * @return 结果
     */
    @Override
    public int deleteFncCompanyByCompanyIds(Long[] companyIds)
    {
        return fncCompanyMapper.deleteFncCompanyByCompanyIds(companyIds);
    }

    /**
     * 删除记账公司信息
     * 
     * @param companyId 记账公司主键
     * @return 结果
     */
    @Override
    public int deleteFncCompanyByCompanyId(Long companyId)
    {
        return fncCompanyMapper.deleteFncCompanyByCompanyId(companyId);
    }
}
