package com.ruoyi.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.system.domain.FncLedger;

import java.util.List;

/**
 * 项目台账Service接口
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
public interface IFncLedgerService extends IService<FncLedger>
{
    /**
     * 查询项目台账
     * 
     * @param ledgerId 项目台账主键
     * @return 项目台账
     */
    public FncLedger selectFncLedgerByLedgerId(Long ledgerId);

    /**
     * 查询项目台账列表
     * 
     * @param fncLedger 项目台账
     * @return 项目台账集合
     */
    public List<FncLedger> selectFncLedgerList(FncLedger fncLedger);

    /**
     * 新增项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    public int insertFncLedger(FncLedger fncLedger);

    /**
     * 修改项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    public int updateFncLedger(FncLedger fncLedger);

    /**
     * 批量删除项目台账
     * 
     * @param ledgerIds 需要删除的项目台账主键集合
     * @return 结果
     */
    public int deleteFncLedgerByLedgerIds(Long[] ledgerIds);

    /**
     * 删除项目台账信息
     * 
     * @param ledgerId 项目台账主键
     * @return 结果
     */
    public int deleteFncLedgerByLedgerId(Long ledgerId);
}
