package com.ruoyi.system.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.system.domain.FncLedger;

/**
 * 项目台账Mapper接口
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
public interface FncLedgerMapper extends BaseMapper<FncLedger>
{
    /**
     * 查询项目台账
     * 
     * @param ledgerId 项目台账主键
     * @return 项目台账
     */
    public FncLedger selectFncLedgerByLedgerId(Long ledgerId);

    /**
     * 查询项目台账列表
     * 
     * @param fncLedger 项目台账
     * @return 项目台账集合
     */
    public List<FncLedger> selectFncLedgerList(FncLedger fncLedger);

    /**
     * 新增项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    public int insertFncLedger(FncLedger fncLedger);

    /**
     * 修改项目台账
     * 
     * @param fncLedger 项目台账
     * @return 结果
     */
    public int updateFncLedger(FncLedger fncLedger);

    /**
     * 删除项目台账
     * 
     * @param ledgerId 项目台账主键
     * @return 结果
     */
    public int deleteFncLedgerByLedgerId(Long ledgerId);

    /**
     * 批量删除项目台账
     * 
     * @param ledgerIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteFncLedgerByLedgerIds(Long[] ledgerIds);
}
