package com.ruoyi.system.mapper;

import java.util.List;
import com.ruoyi.system.domain.FncCompany;

/**
 * 记账公司Mapper接口
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
public interface FncCompanyMapper 
{
    /**
     * 查询记账公司
     * 
     * @param companyId 记账公司主键
     * @return 记账公司
     */
    public FncCompany selectFncCompanyByCompanyId(Long companyId);

    /**
     * 查询记账公司列表
     * 
     * @param fncCompany 记账公司
     * @return 记账公司集合
     */
    public List<FncCompany> selectFncCompanyList(FncCompany fncCompany);

    /**
     * 新增记账公司
     * 
     * @param fncCompany 记账公司
     * @return 结果
     */
    public int insertFncCompany(FncCompany fncCompany);

    /**
     * 修改记账公司
     * 
     * @param fncCompany 记账公司
     * @return 结果
     */
    public int updateFncCompany(FncCompany fncCompany);

    /**
     * 删除记账公司
     * 
     * @param companyId 记账公司主键
     * @return 结果
     */
    public int deleteFncCompanyByCompanyId(Long companyId);

    /**
     * 批量删除记账公司
     * 
     * @param companyIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteFncCompanyByCompanyIds(Long[] companyIds);
}
