package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.*;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 科目类别对象 fnc_subject_type
 *
 * @author jlf
 * @date 2022-11-17
 */
@Data
@Accessors(chain = true)
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class FncSubjectType extends BaseEntity {

    /**
     * 科目类别id
     */
    @TableId( value = "subject_type_id", type = IdType.AUTO)
    private Long subjectTypeId;

    /**
     * 上级id
     */
    @Excel(name = "上级id")
    private Long parentId;

    /**
     * 科目类别名称
     */
    @Excel(name = "科目类别名称")
    private String subjectTypeName;

    /**
     * 显示顺序
     */
    @Excel(name = "显示顺序")
    private Integer orderNum;


//    @TableLogic(value = "1",delval = "2")
    @TableField(fill = FieldFill.INSERT)
    private Integer deleteStatus;

}
