package com.ruoyi.system.domain;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 项目台账对象 fnc_ledger
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
@TableName("fnc_ledger")
public class FncLedger extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 项目台账id */
    private Long ledgerId;

    /** 分类 */
    @Excel(name = "分类")
    private String projectType;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyyMMdd")
    private Date date;

    /** 项目中/英文名称 */
    @Excel(name = "项目中/英文名称")
    private String projectName;

    /** 项目负责人 */
    @Excel(name = "项目负责人")
    private String charge;

    /** 负责人电话 */
    @Excel(name = "负责人电话")
    private String chargePhone;

    /** 询单编号 */
    @Excel(name = "询单编号")
    private String inquiryNo;

    /** 客户经理 */
    @Excel(name = "客户经理")
    private String customerManager;

    /** 客户单位 */
    @Excel(name = "客户单位")
    private String customerCompany;

    /** 业务性质 */
    @Excel(name = "业务性质")
    private String businessType;

    /** 项目销售额评估 */
    @Excel(name = "项目销售额评估")
    private String saleEvaluation;

    public void setLedgerId(Long ledgerId) 
    {
        this.ledgerId = ledgerId;
    }

    public Long getLedgerId() 
    {
        return ledgerId;
    }
    public void setProjectType(String projectType) 
    {
        this.projectType = projectType;
    }

    public String getProjectType() 
    {
        return projectType;
    }
    public void setDate(Date date) 
    {
        this.date = date;
    }

    public Date getDate() 
    {
        return date;
    }
    public void setProjectName(String projectName) 
    {
        this.projectName = projectName;
    }

    public String getProjectName() 
    {
        return projectName;
    }
    public void setCharge(String charge) 
    {
        this.charge = charge;
    }

    public String getCharge() 
    {
        return charge;
    }
    public void setChargePhone(String chargePhone) 
    {
        this.chargePhone = chargePhone;
    }

    public String getChargePhone() 
    {
        return chargePhone;
    }
    public void setInquiryNo(String inquiryNo) 
    {
        this.inquiryNo = inquiryNo;
    }

    public String getInquiryNo() 
    {
        return inquiryNo;
    }
    public void setCustomerManager(String customerManager) 
    {
        this.customerManager = customerManager;
    }

    public String getCustomerManager() 
    {
        return customerManager;
    }
    public void setCustomerCompany(String customerCompany) 
    {
        this.customerCompany = customerCompany;
    }

    public String getCustomerCompany() 
    {
        return customerCompany;
    }
    public void setBusinessType(String businessType) 
    {
        this.businessType = businessType;
    }

    public String getBusinessType() 
    {
        return businessType;
    }
    public void setSaleEvaluation(String saleEvaluation) 
    {
        this.saleEvaluation = saleEvaluation;
    }

    public String getSaleEvaluation() 
    {
        return saleEvaluation;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("ledgerId", getLedgerId())
            .append("projectType", getProjectType())
            .append("date", getDate())
            .append("projectName", getProjectName())
            .append("charge", getCharge())
            .append("chargePhone", getChargePhone())
            .append("inquiryNo", getInquiryNo())
            .append("customerManager", getCustomerManager())
            .append("customerCompany", getCustomerCompany())
            .append("businessType", getBusinessType())
            .append("saleEvaluation", getSaleEvaluation())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
