package com.ruoyi.web.controller.finance;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.ServletUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.token.TokenService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.FncLedger;
import com.ruoyi.system.service.IFncLedgerService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 项目台账Controller
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
@RestController
@RequestMapping("/finance/ledger")
public class FncLedgerController extends BaseController
{
    @Autowired
    private IFncLedgerService fncLedgerService;


    /**
     * 查询项目台账列表
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:list')")
    @GetMapping("/list")
    public TableDataInfo list(FncLedger fncLedger)
    {
        startPage();
        List<FncLedger> list = fncLedgerService.selectFncLedgerList(fncLedger);
        return getDataTable(list);
    }

    /**
     * 导出项目台账列表
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:export')")
    @Log(title = "项目台账", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, FncLedger fncLedger)
    {
        List<FncLedger> list = fncLedgerService.selectFncLedgerList(fncLedger);
        ExcelUtil<FncLedger> util = new ExcelUtil<FncLedger>(FncLedger.class);
        util.exportExcel(response, list, "项目台账数据");
    }

    /**
     * 获取项目台账详细信息
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:query')")
    @GetMapping(value = "/{ledgerId}")
    public AjaxResult getInfo(@PathVariable("ledgerId") Long ledgerId)
    {
        return success(fncLedgerService.selectFncLedgerByLedgerId(ledgerId));
    }

    /**
     * 新增项目台账
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:add')")
    @Log(title = "项目台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FncLedger fncLedger)
    {
        return toAjax(fncLedgerService.insertFncLedger(fncLedger));
    }

    /**
     * 修改项目台账
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:edit')")
    @Log(title = "项目台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody FncLedger fncLedger)
    {
        return toAjax(fncLedgerService.updateFncLedger(fncLedger));
    }

    /**
     * 删除项目台账
     */
    @PreAuthorize("@ss.hasPermi('finance:ledger:remove')")
    @Log(title = "项目台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ledgerIds}")
    public AjaxResult remove(@PathVariable Long[] ledgerIds)
    {
        return toAjax(fncLedgerService.deleteFncLedgerByLedgerIds(ledgerIds));
    }

    @Log(title = "项目台账", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<FncLedger> util = new ExcelUtil<FncLedger>(FncLedger.class);
        List<FncLedger> list = util.importExcel(file.getInputStream(),4);

        return toAjax(fncLedgerService.saveBatch(list));

    }

}
