package com.ruoyi.web.controller.finance;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.FncCompany;
import com.ruoyi.system.service.IFncCompanyService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 记账公司Controller
 * 
 * @author ruoyi
 * @date 2022-11-16
 */
@RestController
@RequestMapping("/finance/company")
public class FncCompanyController extends BaseController
{
    @Autowired
    private IFncCompanyService fncCompanyService;

    /**
     * 查询记账公司列表
     */
    @PreAuthorize("@ss.hasPermi('finance:company:list')")
    @GetMapping("/list")
    public TableDataInfo list(FncCompany fncCompany)
    {
        startPage();
        List<FncCompany> list = fncCompanyService.selectFncCompanyList(fncCompany);
        return getDataTable(list);
    }

    /**
     * 导出记账公司列表
     */
    @PreAuthorize("@ss.hasPermi('finance:company:export')")
    @Log(title = "记账公司", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, FncCompany fncCompany)
    {
        List<FncCompany> list = fncCompanyService.selectFncCompanyList(fncCompany);
        ExcelUtil<FncCompany> util = new ExcelUtil<FncCompany>(FncCompany.class);
        util.exportExcel(response, list, "记账公司数据");
    }

    /**
     * 获取记账公司详细信息
     */
    @PreAuthorize("@ss.hasPermi('finance:company:query')")
    @GetMapping(value = "/{companyId}")
    public AjaxResult getInfo(@PathVariable("companyId") Long companyId)
    {
        return success(fncCompanyService.selectFncCompanyByCompanyId(companyId));
    }

    /**
     * 新增记账公司
     */
    @PreAuthorize("@ss.hasPermi('finance:company:add')")
    @Log(title = "记账公司", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FncCompany fncCompany)
    {

        fncCompany.setCreateBy(getUsername());
        return toAjax(fncCompanyService.insertFncCompany(fncCompany));
    }

    /**
     * 修改记账公司
     */
    @PreAuthorize("@ss.hasPermi('finance:company:edit')")
    @Log(title = "记账公司", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody FncCompany fncCompany)
    {
        fncCompany.setUpdateBy(getUsername());
        return toAjax(fncCompanyService.updateFncCompany(fncCompany));
    }

    /**
     * 删除记账公司
     */
    @PreAuthorize("@ss.hasPermi('finance:company:remove')")
    @Log(title = "记账公司", businessType = BusinessType.DELETE)
	@DeleteMapping("/{companyIds}")
    public AjaxResult remove(@PathVariable Long[] companyIds)
    {
        return toAjax(fncCompanyService.deleteFncCompanyByCompanyIds(companyIds));
    }
}
