package com.jeethink.crm.mapper;

import com.jeethink.crm.domain.WmsProduct;
import com.jeethink.crm.domain.WmsProductAttribute;

import java.util.List;

/***
 * 产品属性
 */
public interface WmsProductAttributeMapper {


    /***
     * 新增产品属性
     * @param productAttribute
     * @return
     */
    public int insertWmsProductAttribute(WmsProductAttribute productAttribute);


    /***
     * 删除产品属性
     * @param attributeId
     * @return
     */
    public int deleteWmsProductAttributeById(Long attributeId);


    /***
     * 批量删除属性
     * @param attributeIds
     * @return
     */
    public int deleteWmsProductAttributeByIds(String[] attributeIds);




    /***
     * 删除产品属性
     * @param prodId
     * @return
     */
    public int deleteWmsProductAttributeByProdId(Long prodId);

    /***
     * 查询产品属性
     * @param prodId
     * @return
     */
    public List<WmsProductAttribute> selectWmsProductAttributeByProdId(Long prodId);
}
