package com.jeethink.web.controller.crm;

import com.jeethink.common.core.controller.BaseController;
import com.jeethink.crm.domain.CrmOrderPrice;

import java.math.BigDecimal;
import java.math.RoundingMode;

/***
 * 抽象计算类
 */
public abstract class AbstractCalculateController  extends BaseController {


    /***
     * 计算总重量
     * @param crmOrderPrice
     */
    protected void   calculateTotalWeight(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getWeight()
                && null !=crmOrderPrice.getTotalQuantity()){
            crmOrderPrice.setTotalWeight(crmOrderPrice.getWeight().multiply(new BigDecimal(crmOrderPrice.getTotalQuantity())).setScale(6,RoundingMode.UP));
            crmOrderPrice.setContWeight(crmOrderPrice.getTotalWeight());
        }
    }


    /***
     * 货款总计
     * @param crmOrderPrice
     */
    protected void   calculateTotalPaymentGoods(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getPrice()
                && null !=crmOrderPrice.getContWeight()){
            crmOrderPrice.setTotalPaymentGoods(crmOrderPrice.getPrice().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 货款增值税
     * @param crmOrderPrice
     */
    protected void   calculateAddedTax(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getTotalPaymentGoods()){
            crmOrderPrice.setAddedTax(crmOrderPrice.getTotalPaymentGoods()
                    .divide(new BigDecimal("1.13"),6, RoundingMode.UP).multiply(new BigDecimal("0.13")).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 运输增值税
     * @param crmOrderPrice
     */
    protected void   calculateTransportAddedTax(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getFreight()){
            crmOrderPrice.setTransportAddedTax(crmOrderPrice.getFreight().divide(new BigDecimal("0.87"),6, RoundingMode.UP).subtract(crmOrderPrice.getFreight()).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 毛利增值税
     * @param crmOrderPrice
     */
    protected void   calculateProfitAddedTax(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getProfit()){
            crmOrderPrice.setProfitAddedTax(crmOrderPrice.getProfit().divide(new BigDecimal("1.13"),6, RoundingMode.UP).multiply(new BigDecimal("0.13")).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 开票金额
     * @param crmOrderPrice
     */
    protected void   calculateInvoiceAmount(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getPrice()
                && null !=crmOrderPrice.getContWeight()){
            crmOrderPrice.setInvoiceAmount(crmOrderPrice.getPrice().multiply(crmOrderPrice.getTotalWeight()).setScale(6,RoundingMode.UP));
        }
    }



    /***
     * 末税总值
     * @param crmOrderPrice
     */
    protected void   calculateTaxRebates(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getInvoiceAmount()){
            crmOrderPrice.setTaxRebates(crmOrderPrice.getInvoiceAmount().divide(new BigDecimal("1.13"),6, RoundingMode.UP).multiply(new BigDecimal("0.13")).setScale(6,RoundingMode.UP));
        }
    }



    /***
     * 末税总值
     * @param crmOrderPrice
     */
    protected void   calculateTotalEndTax(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getInvoiceAmount()){
            crmOrderPrice.setTotalEndTax(crmOrderPrice.getInvoiceAmount().divide(new BigDecimal("1.13"),6, RoundingMode.UP).setScale(6,RoundingMode.UP));
        }
    }



    /***
     * FOB $/kg
     * @param crmOrderPrice
     */
    protected void   calculateFob(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getExchRate()
                && null != crmOrderPrice.getTotalWeight()){
            BigDecimal totalBig = crmOrderPrice.getTotalEndTax().add(crmOrderPrice.getFreight()).add(crmOrderPrice.getTransportAddedTax());
            crmOrderPrice.setFob(totalBig.divide(crmOrderPrice.getExchRate(),6, RoundingMode.UP).divide(crmOrderPrice.getTotalWeight(),6, RoundingMode.UP).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobFive(crmOrderPrice.getFob().multiply(new BigDecimal("1.05")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobTen(crmOrderPrice.getFob().multiply(new BigDecimal("1.1")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobFifteen(crmOrderPrice.getFob().multiply(new BigDecimal("1.15")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobTwenty(crmOrderPrice.getFob().multiply(new BigDecimal("1.2")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobTwentyFive(crmOrderPrice.getFob().multiply(new BigDecimal("1.25")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobThirty(crmOrderPrice.getFob().multiply(new BigDecimal("1.3")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setFobThirtyFive(crmOrderPrice.getFob().multiply(new BigDecimal("1.35")).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 美金价值
     * @param crmOrderPrice
     */
    protected void   calculateDollarVal(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getFob()
                && null != crmOrderPrice.getContWeight()){
            crmOrderPrice.setDollarVal(crmOrderPrice.getFob().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValFive(crmOrderPrice.getFobFive().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValTen(crmOrderPrice.getFobTen().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValFifteen(crmOrderPrice.getFobFifteen().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValTwenty(crmOrderPrice.getFobTwenty().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValTwentyFive(crmOrderPrice.getFobTwentyFive().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValThirty(crmOrderPrice.getFobThirty().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setDollarValThirtyFive(crmOrderPrice.getFobThirtyFive().multiply(crmOrderPrice.getContWeight()).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 毛利
     * @param crmOrderPrice
     */
    protected void   calculateProfit(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getExchRate()
                && null != crmOrderPrice.getDollarVal()){
            crmOrderPrice.setProfit(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarVal()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).multiply(BigDecimal.ZERO).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitFive(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValFive()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitTen(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValTen()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitFifteen(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValFifteen()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitTwenty(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValTwenty()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitTwentyFive(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValTwentyFive()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitThirty(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValThirty()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
            crmOrderPrice.setProfitThirtyFive(crmOrderPrice.getExchRate().multiply(crmOrderPrice.getDollarValThirtyFive()).add(crmOrderPrice.getTaxRebates())
                    .subtract(crmOrderPrice.getTotalPaymentGoods()).subtract(crmOrderPrice.getFreight())
                    .subtract(crmOrderPrice.getTransportAddedTax()).setScale(6,RoundingMode.UP));
        }
    }



    /***
     * 管理费
     * @param crmOrderPrice
     */
    protected void   calculateManagFee(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getProfit()){
            crmOrderPrice.setManagFee(crmOrderPrice.getProfit().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeFive(crmOrderPrice.getProfitFive().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeTen(crmOrderPrice.getProfitTen().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeFifteen(crmOrderPrice.getProfitFifteen().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeTwenty(crmOrderPrice.getProfitTwenty().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeTwentyFive(crmOrderPrice.getProfitTwentyFive().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeThirty(crmOrderPrice.getProfitThirty().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setManagFeeThirtyFive(crmOrderPrice.getProfitThirtyFive().multiply(new BigDecimal("0.4")).setScale(6,RoundingMode.UP));
        }
    }


    /***
     * 净利
     * @param crmOrderPrice
     */
    protected void   calculateNetProfit(CrmOrderPrice crmOrderPrice){
        if(null != crmOrderPrice.getProfit()){
            crmOrderPrice.setNetProfit(crmOrderPrice.getProfit().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitFive(crmOrderPrice.getProfitFive().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitTen(crmOrderPrice.getProfitTen().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitFifteen(crmOrderPrice.getProfitFifteen().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitTwenty(crmOrderPrice.getProfitTwenty().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitTwentyFive(crmOrderPrice.getProfitTwentyFive().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitThirty(crmOrderPrice.getProfitThirty().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
            crmOrderPrice.setNetProfitThirtyFive(crmOrderPrice.getProfitThirtyFive().multiply(new BigDecimal("0.6")).setScale(6,RoundingMode.UP));
        }
    }

}
