package com.jeethink.crm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.jeethink.common.annotation.Excel;
import com.jeethink.common.annotation.Excel.Type;
import com.jeethink.common.core.domain.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户报价单对象 crm_order_price
 * 
 * @author jeethink
 * @date 2020-04-03
 */
public class CrmOrderPrice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 订单ID */
    private Long orderId;

    /** 订单编码 */
    private String orderCode;

    /** 客户id */
    private Long customerId; 
    
    @Excel(name = "所属客户", targetAttr = "customerName", type = Type.EXPORT)
    private CrmCustomer customer;

    /** 订单名称/主题 */
    @Excel(name = "订单名称/主题")
    private String orderName;

    // 产品描述
    @Excel(name = "产品描述")
    private  String   productDesc;

    /** 总价(单子合计价格) */
    private BigDecimal totalPrice;
    
    /** 总成本 */
    private BigDecimal costPrice;



    // 运费
    @Excel(name = "运费")
    private BigDecimal  freight;



    // 币种
    @Excel(name = "币种")
    private String  currency;

    /** 报价时间 */
    @Excel(name = "报价时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date prcieDate;

    /** 报价人 */
    @Excel(name = "报价人")
    private String prcieBy;

    /** 报价j截止时间 */
    @Excel(name = "报价截止时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date prcieEndDate;

    /** 订单时间 */
    @Excel(name = "订单时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date orderDate;

    /** 订单状态（保留） */
    @Excel(name = "订单状态", readConverterExp = "保=留")
    private String orderStatus;

    /** 图片 */
    private String picture;
    
    /** 原负责人(login_name) */
    @Excel(name = "原负责人(login_name)")
    private String sourceBelongTo;

    /** 负责人(login_name) */
    @Excel(name = "负责人(login_name)")
    private String belongTo;

    /** 转交时间 */
    @Excel(name = "转交时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date trasferDate;

    /** 转交人(login_name) */
    @Excel(name = "转交人(login_name)")
    private String trasferTo;

    /** 删除标识 */
    private String delFlag;

    /** 扩展文本框 */
    private String extInput1;

    /** 扩展文本框 */
    private String extInput2;

    /** 扩展文本框 */
    private String extInput3;

    /** 扩展文本框 */
    private String extInput4;

    /** 扩展文本框 */
    private String extInput5;

    /** 扩展下拉框 */
    private String extOrderPriceSelect1;

    /** 扩展下拉框 */
    private String extOrderPriceSelect2;

    /** 扩展下拉框 */
    private String extOrderPriceSelect3;

    /** 扩展下拉框 */
    private String extOrderPriceSelect4;

    /** 扩展下拉框 */
    private String extOrderPriceSelect5;

    /** 扩展数字框 */
    private Long extNumber1;

    /** 扩展数字框 */
    private Long extNumber2;

    /** 扩展数字框 */
    private Long extNumber3;

    /** 扩展数字框 */
    private Long extNumber4;

    /** 扩展数字框 */
    private Long extNumber5;

    /** 扩展日期 */
    private Date extDate1;

    /** 扩展日期 */
    private Date extDate2;

    /** 扩展日期 */
    private Date extDate3;

    /** 扩展日期 */
    private Date extDate4;

    /** 扩展日期 */
    private Date extDate5;

    /** 扩展备注 */
    private String extMemo1;



    // 单价
    @Excel(name = "单价")
    private BigDecimal  price;

    // 重量
    @Excel(name = "重量")
    private BigDecimal weight;

    // 总数量
    @Excel(name = "总数量")
    private Integer  totalQuantity;



    // 总重量
    @Excel(name = "总重量")
    private BigDecimal  totalWeight;


    // 装柜标准
    @Excel(name = "装柜标准")
    private String  contStand;



    // 装柜重量  kg
    @Excel(name = "装柜重量(kg)")
    private BigDecimal  contWeight;


    // 货款总计
    @Excel(name = "货款总计")
    private BigDecimal  totalPaymentGoods;


    // 货款增值税
    @Excel(name = "货款增值税")
    private BigDecimal  addedTax;



    // 运输增值税
    @Excel(name = "运输增值税")
    private BigDecimal  transportAddedTax;



    // 毛利增值税
    @Excel(name = "毛利增值税")
    private BigDecimal  profitAddedTax;



    // 退税
    @Excel(name = "退税")
    private BigDecimal  taxRebates;



    // 开票金额
    @Excel(name = "开票金额")
    private BigDecimal  invoiceAmount;



    // 末税总值
    @Excel(name = "末税总值")
    private BigDecimal  totalEndTax;


    // 税率
    @Excel(name = "税率")
    private BigDecimal  exchRate;


    // FOB $/kg
    @Excel(name = "FOB $/kg")
    private BigDecimal  fob;



    // 美金价值
    @Excel(name = "美金价值")
    private BigDecimal  dollarVal;



    // 毛利
    @Excel(name = "毛利")
    private BigDecimal  profit;

    // 管理费
    @Excel(name = "管理费")
    private BigDecimal  managFee;


    // 净利
    @Excel(name = "净利")
    private BigDecimal  netProfit;




    // FOB $/kg
    @Excel(name = "FOB $/kg(5%)")
    private BigDecimal  fobFive;



    // 美金价值
    @Excel(name = "美金价值(5%)")
    private BigDecimal  dollarValFive;



    // 毛利
    @Excel(name = "毛利(5%)")
    private BigDecimal  profitFive;

    // 管理费
    @Excel(name = "管理费(5%)")
    private BigDecimal  managFeeFive;


    // 净利
    @Excel(name = "净利(5%)")
    private BigDecimal  netProfitFive;



    // FOB $/kg
    @Excel(name = "FOB $/kg(10%)")
    private BigDecimal  fobTen;



    // 美金价值
    @Excel(name = "FOB $/kg(10%)")
    private BigDecimal  dollarValTen;



    // 毛利
    @Excel(name = "FOB $/kg(10%)")
    private BigDecimal  profitTen;

    // 管理费
    @Excel(name = "FOB $/kg(10%)")
    private BigDecimal  managFeeTen;


    // 净利
    @Excel(name = "FOB $/kg(10%)")
    private BigDecimal  netProfitTen;




    // FOB $/kg
    @Excel(name = "FOB $/kg(15%)")
    private BigDecimal  fobFifteen;



    // 美金价值
    @Excel(name = "美金价值(10%)")
    private BigDecimal  dollarValFifteen;



    // 毛利
    @Excel(name = "毛利(15%)")
    private BigDecimal  profitFifteen;

    // 管理费
    @Excel(name = "管理费(15%)")
    private BigDecimal  managFeeFifteen;


    // 净利
    @Excel(name = "净利(10%)")
    private BigDecimal  netProfitFifteen;




    // FOB $/kg
    @Excel(name = "FOB $/kg(20%)")
    private BigDecimal  fobTwenty;



    // 美金价值
    @Excel(name = "美金价值(20%)")
    private BigDecimal  dollarValTwenty;



    // 毛利
    @Excel(name = "毛利(20%)")
    private BigDecimal  profitTwenty;

    // 管理费
    @Excel(name = "管理费(20%)")
    private BigDecimal  managFeeTwenty;


    // 净利
    @Excel(name = "净利(20%)")
    private BigDecimal  netProfitTwenty;



    // FOB $/kg
    @Excel(name = "FOB $/kg(25%)")
    private BigDecimal  fobTwentyFive;



    // 美金价值
    @Excel(name = "美金价值(25%)")
    private BigDecimal  dollarValTwentyFive;



    // 毛利
    @Excel(name = "毛利(25%)")
    private BigDecimal  profitTwentyFive;

    // 管理费
    @Excel(name = "管理费(25%)")
    private BigDecimal  managFeeTwentyFive;


    // 净利
    @Excel(name = "净利(25%)")
    private BigDecimal  netProfitTwentyFive;



    // FOB $/kg
    @Excel(name = "FOB $/kg(30%)")
    private BigDecimal  fobThirty;



    // 美金价值
    @Excel(name = "美金价值(30%)")
    private BigDecimal  dollarValThirty;



    // 毛利
    @Excel(name = "毛利(30%)")
    private BigDecimal  profitThirty;

    // 管理费
    @Excel(name = "管理费(30%)")
    private BigDecimal  managFeeThirty;


    // 净利
    @Excel(name = "净利(30%)")
    private BigDecimal  netProfitThirty;


    // FOB $/kg
    @Excel(name = "FOB $/kg(35%)")
    private BigDecimal  fobThirtyFive;



    // 美金价值
    @Excel(name = "美金价值(35%)")
    private BigDecimal  dollarValThirtyFive;



    // 毛利
    @Excel(name = "毛利(35%)")
    private BigDecimal  profitThirtyFive;

    // 管理费
    @Excel(name = "管理费(35%)")
    private BigDecimal  managFeeThirtyFive;


    // 净利
    @Excel(name = "净利(35%)")
    private BigDecimal  netProfitThirtyFive;




    public void setOrderId(Long orderId) 
    {
        this.orderId = orderId;
    }

    public Long getOrderId() 
    {
        return orderId;
    }
    public void setOrderCode(String orderCode) 
    {
        this.orderCode = orderCode;
    }

    public String getOrderCode() 
    {
        return orderCode;
    }
    public void setCustomerId(Long customerId) 
    {
        this.customerId = customerId;
    }

    public Long getCustomerId() 
    {
        return customerId;
    }
    
    public CrmCustomer getCustomer() {
		return customer;
	}

	public void setCustomer(CrmCustomer customer) {
		this.customer = customer;
	}

	public void setOrderName(String orderName) 
    {
        this.orderName = orderName;
    }

    public String getOrderName() 
    {
        return orderName;
    }
    public void setTotalPrice(BigDecimal totalPrice)
    {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getTotalPrice()
    {
        return totalPrice;
    }
    
    
    public BigDecimal getCostPrice() {
		return costPrice;
	}

	public void setCostPrice(BigDecimal costPrice) {
		this.costPrice = costPrice;
	}

	public void setPrcieDate(Date prcieDate) 
    {
        this.prcieDate = prcieDate;
    }

    public Date getPrcieDate() 
    {
        return prcieDate;
    }
    public void setPrcieBy(String prcieBy) 
    {
        this.prcieBy = prcieBy;
    }

    public String getPrcieBy() 
    {
        return prcieBy;
    }
    public void setPrcieEndDate(Date prcieEndDate) 
    {
        this.prcieEndDate = prcieEndDate;
    }

    public Date getPrcieEndDate() 
    {
        return prcieEndDate;
    }
    public void setOrderDate(Date orderDate) 
    {
        this.orderDate = orderDate;
    }

    public Date getOrderDate() 
    {
        return orderDate;
    }
    public void setOrderStatus(String orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }
    public void setPicture(String picture) 
    {
        this.picture = picture;
    }

    public String getPicture() 
    {
        return picture;
    }    
    
    public String getSourceBelongTo() {
		return sourceBelongTo;
	}

	public void setSourceBelongTo(String sourceBelongTo) {
		this.sourceBelongTo = sourceBelongTo;
	}

	public String getBelongTo() {
		return belongTo;
	}

	public void setBelongTo(String belongTo) {
		this.belongTo = belongTo;
	}

	public Date getTrasferDate() {
		return trasferDate;
	}

	public void setTrasferDate(Date trasferDate) {
		this.trasferDate = trasferDate;
	}

	public String getTrasferTo() {
		return trasferTo;
	}

	public void setTrasferTo(String trasferTo) {
		this.trasferTo = trasferTo;
	}

	public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }
    public void setExtInput1(String extInput1) 
    {
        this.extInput1 = extInput1;
    }

    public String getExtInput1() 
    {
        return extInput1;
    }
    public void setExtInput2(String extInput2) 
    {
        this.extInput2 = extInput2;
    }

    public String getExtInput2() 
    {
        return extInput2;
    }
    public void setExtInput3(String extInput3) 
    {
        this.extInput3 = extInput3;
    }

    public String getExtInput3() 
    {
        return extInput3;
    }
    public void setExtInput4(String extInput4) 
    {
        this.extInput4 = extInput4;
    }

    public String getExtInput4() 
    {
        return extInput4;
    }
    public void setExtInput5(String extInput5) 
    {
        this.extInput5 = extInput5;
    }

    public String getExtInput5() 
    {
        return extInput5;
    }
    public void setExtOrderPriceSelect1(String extOrderPriceSelect1) 
    {
        this.extOrderPriceSelect1 = extOrderPriceSelect1;
    }

    public String getExtOrderPriceSelect1() 
    {
        return extOrderPriceSelect1;
    }
    public void setExtOrderPriceSelect2(String extOrderPriceSelect2) 
    {
        this.extOrderPriceSelect2 = extOrderPriceSelect2;
    }

    public String getExtOrderPriceSelect2() 
    {
        return extOrderPriceSelect2;
    }
    public void setExtOrderPriceSelect3(String extOrderPriceSelect3) 
    {
        this.extOrderPriceSelect3 = extOrderPriceSelect3;
    }

    public String getExtOrderPriceSelect3() 
    {
        return extOrderPriceSelect3;
    }
    public void setExtOrderPriceSelect4(String extOrderPriceSelect4) 
    {
        this.extOrderPriceSelect4 = extOrderPriceSelect4;
    }

    public String getExtOrderPriceSelect4() 
    {
        return extOrderPriceSelect4;
    }
    public void setExtOrderPriceSelect5(String extOrderPriceSelect5) 
    {
        this.extOrderPriceSelect5 = extOrderPriceSelect5;
    }

    public String getExtOrderPriceSelect5() 
    {
        return extOrderPriceSelect5;
    }
    public void setExtNumber1(Long extNumber1) 
    {
        this.extNumber1 = extNumber1;
    }

    public Long getExtNumber1() 
    {
        return extNumber1;
    }
    public void setExtNumber2(Long extNumber2) 
    {
        this.extNumber2 = extNumber2;
    }

    public Long getExtNumber2() 
    {
        return extNumber2;
    }
    public void setExtNumber3(Long extNumber3) 
    {
        this.extNumber3 = extNumber3;
    }

    public Long getExtNumber3() 
    {
        return extNumber3;
    }
    public void setExtNumber4(Long extNumber4) 
    {
        this.extNumber4 = extNumber4;
    }

    public Long getExtNumber4() 
    {
        return extNumber4;
    }
    public void setExtNumber5(Long extNumber5) 
    {
        this.extNumber5 = extNumber5;
    }

    public Long getExtNumber5() 
    {
        return extNumber5;
    }
    public void setExtDate1(Date extDate1) 
    {
        this.extDate1 = extDate1;
    }

    public Date getExtDate1() 
    {
        return extDate1;
    }
    public void setExtDate2(Date extDate2) 
    {
        this.extDate2 = extDate2;
    }

    public Date getExtDate2() 
    {
        return extDate2;
    }
    public void setExtDate3(Date extDate3) 
    {
        this.extDate3 = extDate3;
    }

    public Date getExtDate3() 
    {
        return extDate3;
    }
    public void setExtDate4(Date extDate4) 
    {
        this.extDate4 = extDate4;
    }

    public Date getExtDate4() 
    {
        return extDate4;
    }
    public void setExtDate5(Date extDate5) 
    {
        this.extDate5 = extDate5;
    }

    public Date getExtDate5() 
    {
        return extDate5;
    }
    public void setExtMemo1(String extMemo1) 
    {
        this.extMemo1 = extMemo1;
    }

    public String getExtMemo1() 
    {
        return extMemo1;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }


    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }


    public String getContStand() {
        return contStand;
    }

    public void setContStand(String contStand) {
        this.contStand = contStand;
    }

    public BigDecimal getContWeight() {
        return contWeight;
    }

    public void setContWeight(BigDecimal contWeight) {
        this.contWeight = contWeight;
    }

    public BigDecimal getTotalPaymentGoods() {
        return totalPaymentGoods;
    }

    public void setTotalPaymentGoods(BigDecimal totalPaymentGoods) {
        this.totalPaymentGoods = totalPaymentGoods;
    }

    public BigDecimal getAddedTax() {
        return addedTax;
    }

    public void setAddedTax(BigDecimal addedTax) {
        this.addedTax = addedTax;
    }

    public BigDecimal getTransportAddedTax() {
        return transportAddedTax;
    }

    public void setTransportAddedTax(BigDecimal transportAddedTax) {
        this.transportAddedTax = transportAddedTax;
    }

    public BigDecimal getProfitAddedTax() {
        return profitAddedTax;
    }

    public void setProfitAddedTax(BigDecimal profitAddedTax) {
        this.profitAddedTax = profitAddedTax;
    }

    public BigDecimal getTaxRebates() {
        return taxRebates;
    }

    public void setTaxRebates(BigDecimal taxRebates) {
        this.taxRebates = taxRebates;
    }

    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public BigDecimal getTotalEndTax() {
        return totalEndTax;
    }

    public void setTotalEndTax(BigDecimal totalEndTax) {
        this.totalEndTax = totalEndTax;
    }

    public BigDecimal getExchRate() {
        return exchRate;
    }

    public void setExchRate(BigDecimal exchRate) {
        this.exchRate = exchRate;
    }

    public BigDecimal getFob() {
        return fob;
    }

    public void setFob(BigDecimal fob) {
        this.fob = fob;
    }

    public BigDecimal getDollarVal() {
        return dollarVal;
    }

    public void setDollarVal(BigDecimal dollarVal) {
        this.dollarVal = dollarVal;
    }

    public BigDecimal getProfit() {
        return profit;
    }

    public void setProfit(BigDecimal profit) {
        this.profit = profit;
    }

    public BigDecimal getManagFee() {
        return managFee;
    }

    public void setManagFee(BigDecimal managFee) {
        this.managFee = managFee;
    }

    public BigDecimal getNetProfit() {
        return netProfit;
    }

    public void setNetProfit(BigDecimal netProfit) {
        this.netProfit = netProfit;
    }


    public String getProductDesc() {
        return productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }


    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }


    public BigDecimal getFobFive() {
        return fobFive;
    }

    public void setFobFive(BigDecimal fobFive) {
        this.fobFive = fobFive;
    }

    public BigDecimal getDollarValFive() {
        return dollarValFive;
    }

    public void setDollarValFive(BigDecimal dollarValFive) {
        this.dollarValFive = dollarValFive;
    }

    public BigDecimal getProfitFive() {
        return profitFive;
    }

    public void setProfitFive(BigDecimal profitFive) {
        this.profitFive = profitFive;
    }

    public BigDecimal getManagFeeFive() {
        return managFeeFive;
    }

    public void setManagFeeFive(BigDecimal managFeeFive) {
        this.managFeeFive = managFeeFive;
    }

    public BigDecimal getNetProfitFive() {
        return netProfitFive;
    }

    public void setNetProfitFive(BigDecimal netProfitFive) {
        this.netProfitFive = netProfitFive;
    }

    public BigDecimal getFobTen() {
        return fobTen;
    }

    public void setFobTen(BigDecimal fobTen) {
        this.fobTen = fobTen;
    }

    public BigDecimal getDollarValTen() {
        return dollarValTen;
    }

    public void setDollarValTen(BigDecimal dollarValTen) {
        this.dollarValTen = dollarValTen;
    }

    public BigDecimal getProfitTen() {
        return profitTen;
    }

    public void setProfitTen(BigDecimal profitTen) {
        this.profitTen = profitTen;
    }

    public BigDecimal getManagFeeTen() {
        return managFeeTen;
    }

    public void setManagFeeTen(BigDecimal managFeeTen) {
        this.managFeeTen = managFeeTen;
    }

    public BigDecimal getNetProfitTen() {
        return netProfitTen;
    }

    public void setNetProfitTen(BigDecimal netProfitTen) {
        this.netProfitTen = netProfitTen;
    }

    public BigDecimal getFobFifteen() {
        return fobFifteen;
    }

    public void setFobFifteen(BigDecimal fobFifteen) {
        this.fobFifteen = fobFifteen;
    }

    public BigDecimal getDollarValFifteen() {
        return dollarValFifteen;
    }

    public void setDollarValFifteen(BigDecimal dollarValFifteen) {
        this.dollarValFifteen = dollarValFifteen;
    }

    public BigDecimal getProfitFifteen() {
        return profitFifteen;
    }

    public void setProfitFifteen(BigDecimal profitFifteen) {
        this.profitFifteen = profitFifteen;
    }

    public BigDecimal getManagFeeFifteen() {
        return managFeeFifteen;
    }

    public void setManagFeeFifteen(BigDecimal managFeeFifteen) {
        this.managFeeFifteen = managFeeFifteen;
    }

    public BigDecimal getNetProfitFifteen() {
        return netProfitFifteen;
    }

    public void setNetProfitFifteen(BigDecimal netProfitFifteen) {
        this.netProfitFifteen = netProfitFifteen;
    }

    public BigDecimal getFobTwenty() {
        return fobTwenty;
    }

    public void setFobTwenty(BigDecimal fobTwenty) {
        this.fobTwenty = fobTwenty;
    }

    public BigDecimal getDollarValTwenty() {
        return dollarValTwenty;
    }

    public void setDollarValTwenty(BigDecimal dollarValTwenty) {
        this.dollarValTwenty = dollarValTwenty;
    }

    public BigDecimal getProfitTwenty() {
        return profitTwenty;
    }

    public void setProfitTwenty(BigDecimal profitTwenty) {
        this.profitTwenty = profitTwenty;
    }

    public BigDecimal getManagFeeTwenty() {
        return managFeeTwenty;
    }

    public void setManagFeeTwenty(BigDecimal managFeeTwenty) {
        this.managFeeTwenty = managFeeTwenty;
    }

    public BigDecimal getManagFeeTwentyFive() {
        return managFeeTwentyFive;
    }

    public void setManagFeeTwentyFive(BigDecimal managFeeTwentyFive) {
        this.managFeeTwentyFive = managFeeTwentyFive;
    }

    public BigDecimal getManagFeeThirty() {
        return managFeeThirty;
    }

    public void setManagFeeThirty(BigDecimal managFeeThirty) {
        this.managFeeThirty = managFeeThirty;
    }

    public BigDecimal getManagFeeThirtyFive() {
        return managFeeThirtyFive;
    }

    public void setManagFeeThirtyFive(BigDecimal managFeeThirtyFive) {
        this.managFeeThirtyFive = managFeeThirtyFive;
    }

    public BigDecimal getNetProfitTwenty() {
        return netProfitTwenty;
    }

    public void setNetProfitTwenty(BigDecimal netProfitTwenty) {
        this.netProfitTwenty = netProfitTwenty;
    }

    public BigDecimal getFobTwentyFive() {
        return fobTwentyFive;
    }

    public void setFobTwentyFive(BigDecimal fobTwentyFive) {
        this.fobTwentyFive = fobTwentyFive;
    }

    public BigDecimal getDollarValTwentyFive() {
        return dollarValTwentyFive;
    }

    public void setDollarValTwentyFive(BigDecimal dollarValTwentyFive) {
        this.dollarValTwentyFive = dollarValTwentyFive;
    }

    public BigDecimal getProfitTwentyFive() {
        return profitTwentyFive;
    }

    public void setProfitTwentyFive(BigDecimal profitTwentyFive) {
        this.profitTwentyFive = profitTwentyFive;
    }



    public BigDecimal getNetProfitTwentyFive() {
        return netProfitTwentyFive;
    }

    public void setNetProfitTwentyFive(BigDecimal netProfitTwentyFive) {
        this.netProfitTwentyFive = netProfitTwentyFive;
    }

    public BigDecimal getFobThirty() {
        return fobThirty;
    }

    public void setFobThirty(BigDecimal fobThirty) {
        this.fobThirty = fobThirty;
    }

    public BigDecimal getDollarValThirty() {
        return dollarValThirty;
    }

    public void setDollarValThirty(BigDecimal dollarValThirty) {
        this.dollarValThirty = dollarValThirty;
    }

    public BigDecimal getProfitThirty() {
        return profitThirty;
    }

    public void setProfitThirty(BigDecimal profitThirty) {
        this.profitThirty = profitThirty;
    }


    public BigDecimal getNetProfitThirty() {
        return netProfitThirty;
    }

    public void setNetProfitThirty(BigDecimal netProfitThirty) {
        this.netProfitThirty = netProfitThirty;
    }

    public BigDecimal getFobThirtyFive() {
        return fobThirtyFive;
    }

    public void setFobThirtyFive(BigDecimal fobThirtyFive) {
        this.fobThirtyFive = fobThirtyFive;
    }

    public BigDecimal getDollarValThirtyFive() {
        return dollarValThirtyFive;
    }

    public void setDollarValThirtyFive(BigDecimal dollarValThirtyFive) {
        this.dollarValThirtyFive = dollarValThirtyFive;
    }

    public BigDecimal getProfitThirtyFive() {
        return profitThirtyFive;
    }

    public void setProfitThirtyFive(BigDecimal profitThirtyFive) {
        this.profitThirtyFive = profitThirtyFive;
    }



    public BigDecimal getNetProfitThirtyFive() {
        return netProfitThirtyFive;
    }

    public void setNetProfitThirtyFive(BigDecimal netProfitThirtyFive) {
        this.netProfitThirtyFive = netProfitThirtyFive;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("orderId", getOrderId())
            .append("orderCode", getOrderCode())
            .append("customerId", getCustomerId())
            .append("orderName", getOrderName())
            .append("totalPrice", getTotalPrice())
            .append("costPrice", getCostPrice())
            .append("prcieDate", getPrcieDate())
            .append("prcieBy", getPrcieBy())
            .append("prcieEndDate", getPrcieEndDate())
            .append("orderDate", getOrderDate())
            .append("orderStatus", getOrderStatus())
            .append("picture", getPicture())
            .append("sourceBelongTo", getSourceBelongTo())
            .append("belongTo", getBelongTo())
            .append("trasferDate", getTrasferDate())
            .append("trasferTo", getTrasferTo())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("extInput1", getExtInput1())
            .append("extInput2", getExtInput2())
            .append("extInput3", getExtInput3())
            .append("extInput4", getExtInput4())
            .append("extInput5", getExtInput5())
            .append("extOrderPriceSelect1", getExtOrderPriceSelect1())
            .append("extOrderPriceSelect2", getExtOrderPriceSelect2())
            .append("extOrderPriceSelect3", getExtOrderPriceSelect3())
            .append("extOrderPriceSelect4", getExtOrderPriceSelect4())
            .append("extOrderPriceSelect5", getExtOrderPriceSelect5())
            .append("extNumber1", getExtNumber1())
            .append("extNumber2", getExtNumber2())
            .append("extNumber3", getExtNumber3())
            .append("extNumber4", getExtNumber4())
            .append("extNumber5", getExtNumber5())
            .append("extDate1", getExtDate1())
            .append("extDate2", getExtDate2())
            .append("extDate3", getExtDate3())
            .append("extDate4", getExtDate4())
            .append("extDate5", getExtDate5())
            .append("extMemo1", getExtMemo1())
            .toString();
    }
}
